/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ItemSelectableTracker
implements ItemListener {
    private ItemSelectable item;
    protected Component[] components;
    protected ItemSelectableTracker[] trackers;
    private boolean sameEnabledState;

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents) {
        this(selectableItem, dependentComponents, null, true);
    }

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, ItemSelectableTracker[] dependentTrackers) {
        this(selectableItem, dependentComponents, dependentTrackers, true);
    }

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, boolean sameEnabledState) {
        this(selectableItem, dependentComponents, null, sameEnabledState);
    }

    private ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, ItemSelectableTracker[] dependentTrackers, boolean sameEnabledState) {
        this.item = selectableItem;
        this.components = dependentComponents;
        this.trackers = dependentTrackers;
        this.sameEnabledState = sameEnabledState;
        selectableItem.addItemListener(this);
        Object[] selectedObjects = this.item.getSelectedObjects();
        boolean isSelected = selectedObjects != null;
        this.updateItemState(isSelected);
    }

    public final void itemStateChanged(ItemEvent event) {
        ItemSelectable selectableItem = event.getItemSelectable();
        if (selectableItem == this.item) {
            int selected = event.getStateChange();
            boolean isSelected = selected == 1;
            this.updateItemState(isSelected);
        }
    }

    private void updateItemState(boolean isSelected) {
        boolean newState = this.sameEnabledState ? isSelected : isSelected ^ true;
        int numComponents = this.components == null ? 0 : this.components.length;
        int i = 0;
        while (i < numComponents) {
            Component component = this.components[i];
            if (component != null) {
                component.setEnabled(newState);
            }
            ++i;
        }
        int numTrackers = this.trackers == null ? 0 : this.trackers.length;
        int i2 = 0;
        while (i2 < numTrackers) {
            Object[] selectedObjects;
            ItemSelectableTracker tracker = this.trackers[i2];
            ItemSelectable childSelectable = tracker.item;
            if (childSelectable instanceof Component) {
                ((Component)((Object)childSelectable)).setEnabled(newState);
            }
            boolean isChildSelected = (selectedObjects = childSelectable.getSelectedObjects()) != null && newState;
            tracker.updateItemState(isChildSelected);
            ++i2;
        }
        if (isSelected) {
            this.itemSelected(this.item);
        } else {
            this.itemDeselected(this.item);
        }
    }

    protected void itemSelected(ItemSelectable item) {
    }

    protected void itemDeselected(ItemSelectable item) {
    }
}

