/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.feedback.FeedbackManager;

public final class GlobalMouseDispatcher
implements AWTEventListener {
    private ArrayList _listeners;
    private static GlobalMouseDispatcher INSTANCE;

    private void $init$() {
        this._listeners = new ArrayList(5);
    }

    private GlobalMouseDispatcher() {
        this.$init$();
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(this, 16);
    }

    public static synchronized GlobalMouseDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalMouseDispatcher();
        }
        return INSTANCE;
    }

    public void addMouseListener(MouseListener l) {
        this._listeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this._listeners.remove(l);
    }

    public void eventDispatched(AWTEvent event) {
        Point pt;
        MouseEvent e = (MouseEvent)event;
        Component src = e.getComponent();
        Component deeper = this.getDeepestComponent(src, pt = new Point(e.getPoint()));
        if (deeper != src) {
            e = new MouseEvent(deeper, e.getID(), e.getWhen(), e.getModifiers(), pt.x, pt.y, e.getClickCount(), e.isPopupTrigger());
        }
        MouseListener[] listeners = new MouseListener[this._listeners.size()];
        this._listeners.toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            MouseListener l = listeners[i];
            if (l != null) {
                try {
                    switch (e.getID()) {
                        case 500: {
                            l.mouseClicked(e);
                            break;
                        }
                        case 504: {
                            l.mouseEntered(e);
                            break;
                        }
                        case 505: {
                            l.mouseExited(e);
                            break;
                        }
                        case 501: {
                            l.mousePressed(e);
                            break;
                        }
                        case 502: {
                            l.mouseReleased(e);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    1 runnable = new 1(this, ex);
                    SwingUtilities.invokeLater(runnable);
                }
            }
            ++i;
        }
    }

    private Component getDeepestComponent(Component src, Point pt) {
        while (src instanceof Container) {
            Container parent = (Container)src;
            Component sub = parent.getComponentAt(pt);
            if (sub == src || sub == null) break;
            SwingUtilities.convertPoint(src, pt, sub);
            src = sub;
        }
        return src;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Exception v$ex;
        final /* synthetic */ GlobalMouseDispatcher this$0;

        public void run() {
            FeedbackManager.reportException(this.v$ex);
        }

        public 1(GlobalMouseDispatcher globalMouseDispatcher, Exception exception) {
            this.v$ex = exception;
            this.this$0 = globalMouseDispatcher;
        }
    }
}

