/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultListTableModel
extends AbstractTableModel
implements Serializable {
    protected ArrayList dataList;
    protected ArrayList columnIdentifiers;
    private boolean _isEditable;

    private void $init$() {
        this._isEditable = true;
    }

    public DefaultListTableModel() {
        this((List)null, 0);
    }

    public DefaultListTableModel(int numRows, int numColumns) {
        this.$init$();
        ArrayList names = new ArrayList(numColumns);
        DefaultListTableModel.ensureCapacityHelper(names, numColumns);
        this.setColumnIdentifiers(names);
        this.dataList = new ArrayList();
        this.setNumRows(numRows);
    }

    public DefaultListTableModel(List columnNames, int numRows) {
        this.$init$();
        this.setColumnIdentifiers(columnNames);
        this.dataList = new ArrayList();
        this.setNumRows(numRows);
    }

    public DefaultListTableModel(Object[] columnNames, int numRows) {
        this(DefaultListTableModel.convertToList(columnNames), numRows);
    }

    public DefaultListTableModel(List data, List columnNames) {
        this.$init$();
        this.setDataList(data, columnNames);
    }

    public DefaultListTableModel(Object[][] data, Object[] columnNames) {
        this.$init$();
        this.setDataList(data, columnNames);
    }

    public List getDataList() {
        return this.dataList;
    }

    public void setDataList(List newData, List columnNames) {
        if (newData == null) {
            throw new IllegalArgumentException("setDataList() - Null parameter");
        }
        this.dataList = new ArrayList(0);
        this.setColumnIdentifiers(columnNames);
        this.dataList.addAll(newData);
        this.newRowsAdded(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
    }

    public void setDataList(Object[][] newData, Object[] columnNames) {
        this.setDataList(DefaultListTableModel.convertToList(newData), DefaultListTableModel.convertToList(columnNames));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent event) {
        int start = event.getFirstRow();
        int end = event.getLastRow();
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = this.getRowCount() - 1;
        }
        int i = start;
        while (i < end) {
            List dl = (List)this.dataList.get(i);
            DefaultListTableModel.ensureCapacityHelper(dl, this.getColumnCount());
            ++i;
        }
        this.fireTableChanged(event);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setColumnIdentifiers(List newIdentifiers) {
        this.columnIdentifiers = new ArrayList();
        if (newIdentifiers != null) {
            this.columnIdentifiers.clear();
            this.columnIdentifiers.addAll(newIdentifiers);
        }
        this.fireTableStructureChanged();
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        this.setColumnIdentifiers(DefaultListTableModel.convertToList(newIdentifiers));
    }

    public void setNumRows(int newSize) {
        if (newSize < 0 || newSize == this.getRowCount()) {
            return;
        }
        int oldNumRows = this.getRowCount();
        if (newSize <= this.getRowCount()) {
            DefaultListTableModel.ensureCapacityHelper(this.dataList, newSize);
            this.fireTableRowsDeleted(this.getRowCount(), oldNumRows - 1);
        } else {
            int columnCount = this.getColumnCount();
            while (this.getRowCount() < newSize) {
                ArrayList newRow = new ArrayList(columnCount);
                DefaultListTableModel.ensureCapacityHelper(newRow, columnCount);
                this.dataList.add(newRow);
            }
            this.fireTableRowsInserted(oldNumRows, this.getRowCount() - 1);
        }
    }

    public void setRowCount(int rowCount) {
        this.setNumRows(rowCount);
    }

    public void setColumnCount(int columnCount) {
        int r = 0;
        while (r < this.getRowCount()) {
            ArrayList row = (ArrayList)this.dataList.get(r);
            DefaultListTableModel.ensureCapacityHelper(row, columnCount);
            ++r;
        }
        DefaultListTableModel.ensureCapacityHelper(this.columnIdentifiers, columnCount);
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (List)null);
    }

    public void addColumn(Object columnName, List columnData) {
        if (columnName == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        this.columnIdentifiers.add(columnName);
        int index = 0;
        Iterator enumeration = this.dataList.iterator();
        while (enumeration.hasNext()) {
            Object value = columnData != null && index < columnData.size() ? (Object)columnData.get(index) : null;
            ((List)enumeration.next()).add(value);
            ++index;
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName, Object[] columnData) {
        this.addColumn(columnName, DefaultListTableModel.convertToList(columnData));
    }

    public void addRow(List rowData) {
        if (rowData == null) {
            rowData = new ArrayList(this.getColumnCount());
        } else {
            DefaultListTableModel.ensureCapacityHelper(rowData, this.getColumnCount());
        }
        this.dataList.add(rowData);
        this.newRowsAdded(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
    }

    public void addRow(Object[] rowData) {
        this.addRow(DefaultListTableModel.convertToList(rowData));
    }

    public void insertRow(int row, List rowData) {
        if (rowData == null) {
            rowData = new ArrayList(this.getColumnCount());
        } else {
            DefaultListTableModel.ensureCapacityHelper(rowData, this.getColumnCount());
        }
        this.dataList.add(row, rowData);
        this.newRowsAdded(new TableModelEvent(this, row, row, -1, 1));
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, DefaultListTableModel.convertToList(rowData));
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        if (startIndex < 0 || startIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (startIndex <= toIndex && toIndex <= endIndex) {
            return;
        }
        boolean shift = toIndex < startIndex;
        int i = startIndex;
        while (i <= endIndex) {
            Object aRow = this.dataList.get(i);
            this.dataList.remove(i);
            this.dataList.add(toIndex, aRow);
            if (shift) {
                ++toIndex;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.dataList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public int getRowCount() {
        return this.dataList.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        if (this.columnIdentifiers == null || this.columnIdentifiers.size() <= column) {
            return super.getColumnName(column);
        }
        Object id = this.columnIdentifiers.get(column);
        if (id == null) {
            return super.getColumnName(column);
        }
        return id.toString();
    }

    public boolean isCellEditable(int row, int column) {
        return this._isEditable;
    }

    public void setEditable(boolean isEditable) {
        this._isEditable = isEditable;
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public Object getValueAt(int row, int column) {
        List rowList = (List)this.dataList.get(row);
        return rowList.get(column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        List rowList = (List)this.dataList.get(row);
        rowList.set(column, aValue);
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    protected static List convertToList(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        ArrayList<Object> v = new ArrayList<Object>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.add(anArray[i]);
            ++i;
        }
        return v;
    }

    protected static List convertToList(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        ArrayList<List> v = new ArrayList<List>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.add(DefaultListTableModel.convertToList(anArray[i]));
            ++i;
        }
        return v;
    }

    private static void ensureCapacityHelper(List list, int newMinSize) {
    }
}

