/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class ButtonsLayoutManager
implements LayoutManager2,
SwingConstants {
    public static final boolean DIRECTION_RTL = true;
    public static final boolean DIRECTION_LTR = false;
    private static int DEFAULTGAP = 0;
    private int _nGap;
    private ArrayList _buttons;
    private int _nOrient;
    private boolean _rtl;
    private Rectangle _rSpaceLeft;

    private void $init$() {
        this._nGap = DEFAULTGAP;
        this._buttons = new ArrayList(2);
        this._nOrient = 0;
        this._rtl = true;
        this._rSpaceLeft = new Rectangle();
    }

    public ButtonsLayoutManager() {
        this(0);
    }

    public ButtonsLayoutManager(int nGap) {
        this.$init$();
        this.setGap(nGap);
    }

    public void setGap(int nGap) {
        this._nGap = nGap;
    }

    public int getGap() {
        return this._nGap;
    }

    public void setDirection(boolean rtl) {
        this._rtl = rtl;
    }

    public boolean getDirection() {
        return this._rtl;
    }

    public Rectangle getSpaceLeft() {
        return this._rSpaceLeft;
    }

    public void setOrientation(int nOrient) {
        this._nOrient = nOrient;
    }

    public int getOrientation() {
        return this._nOrient;
    }

    private Dimension getOrientedDimension(int nWidth, int nHeight) {
        if (this._nOrient == 1) {
            return new Dimension(nHeight, nWidth);
        }
        return new Dimension(nWidth, nHeight);
    }

    public final int getButtonCount() {
        return this._buttons.size();
    }

    public final Component getButton(int i) {
        Component button = i >= 0 && i < this._buttons.size() ? (Component)this._buttons.get(i) : null;
        return button;
    }

    protected final void addButton(Component c, int nConstraint) {
        int i = this._buttons.size();
        while (i < nConstraint) {
            this._buttons.add(null);
            ++i;
        }
        this._buttons.add(nConstraint, c);
    }

    protected final void removeButton(int nConstraint) {
        if (nConstraint >= 0 && nConstraint < this._buttons.size()) {
            this._buttons.remove(nConstraint);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        Integer constraint = new Integer(name);
        this.addLayoutComponent(comp, constraint);
    }

    public void removeLayoutComponent(Component comp) {
        this._buttons.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        int nWidth = 0;
        int nHeight = 0;
        int n = this._buttons.size();
        int i = n - 1;
        while (i >= 0) {
            JComponent c = (JComponent)this._buttons.get(i);
            if (c != null && c.isVisible()) {
                Dimension dc = c.getPreferredSize();
                if (this._nOrient == 1) {
                    nHeight += dc.height + this._nGap;
                    if (dc.width > nWidth) {
                        nWidth = dc.width;
                    }
                } else {
                    nWidth += dc.width + this._nGap;
                    if (dc.height > nHeight) {
                        nHeight = dc.height;
                    }
                }
            }
            --i;
        }
        return new Dimension(nWidth, nHeight);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Dimension dParent = parent.getSize();
        this.layoutContainer(parent, dParent);
    }

    protected int layoutContainer(Container parent, Dimension dParent) {
        int n = this._buttons.size();
        int i = 0;
        this._rSpaceLeft.setBounds(0, 0, dParent.width, dParent.height);
        if (this._nOrient == 1) {
            int nxPos = dParent.width / 2;
            int nyPos = 0;
            i = 0;
            while (i < n) {
                JComponent c = (JComponent)this._buttons.get(i);
                if (c != null && c.isVisible()) {
                    Dimension dc = c.getPreferredSize();
                    if (nyPos + dc.height > dParent.height) break;
                    c.setBounds(nxPos - dc.width / 2, nyPos, dc.width, dc.height);
                    nyPos += dc.height + this._nGap;
                }
                ++i;
            }
            this._rSpaceLeft.y = nyPos;
            this._rSpaceLeft.height = dParent.height - nyPos;
        } else if (this._rtl) {
            int nxPos = dParent.width;
            int nyPos = dParent.height / 2;
            i = 0;
            while (i < n) {
                JComponent c = (JComponent)this._buttons.get(i);
                if (c != null && c.isVisible()) {
                    Dimension dc = c.getPreferredSize();
                    if (nxPos - dc.width < 0) break;
                    c.setBounds(nxPos - dc.width, nyPos - dc.height / 2, dc.width, dc.height);
                    nxPos -= dc.width + this._nGap;
                }
                ++i;
            }
            this._rSpaceLeft.width = nxPos;
        } else {
            int nxPos = 0;
            int nyPos = dParent.height / 2;
            i = 0;
            while (i < n) {
                JComponent c = (JComponent)this._buttons.get(i);
                if (c != null && c.isVisible()) {
                    Dimension dc = c.getPreferredSize();
                    if (nxPos + dc.width > dParent.width) break;
                    c.setBounds(nxPos, nyPos - dc.height / 2, dc.width, dc.height);
                    nxPos += dc.width + this._nGap;
                }
                ++i;
            }
            this._rSpaceLeft.x = nxPos;
            this._rSpaceLeft.width = dParent.width - nxPos;
        }
        int nHide = i;
        while (nHide < n) {
            JComponent c = (JComponent)this._buttons.get(nHide);
            if (c != null) {
                c.setBounds(0, 0, 0, 0);
            }
            ++nHide;
        }
        if (parent instanceof JComponent) {
            JComponent jcParent = (JComponent)parent;
            jcParent.repaint();
        }
        return i;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Integer)) {
            throw new IllegalArgumentException("ButtonsLayoutManager must be used with Integer constraints");
        }
        int nConstraint = (Integer)constraints;
        this.addButton(comp, nConstraint);
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 1.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

