/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class ButtonKeyController
extends AbstractAction {
    private static final KeyStroke KEY_UP = KeyStroke.getKeyStroke(38, 0);
    private static final KeyStroke KEY_LEFT = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke KEY_DOWN = KeyStroke.getKeyStroke(40, 0);
    private static final KeyStroke KEY_RIGHT = KeyStroke.getKeyStroke(39, 0);
    private AbstractButton[] _buttons;
    private int _direction;
    private static final String UP_ACTION_KEY = "UP";
    private static final String DOWN_ACTION_KEY = "DOWN";

    protected ButtonKeyController(AbstractButton[] buttons, int direction) {
        this._direction = direction;
        this._buttons = buttons;
    }

    public static void attach(AbstractButton ... buttons) {
        ButtonKeyController upAction = new ButtonKeyController(buttons, -1);
        ButtonKeyController downAction = new ButtonKeyController(buttons, 1);
        ButtonKeyController.attach(upAction, downAction, buttons);
    }

    public void actionPerformed(ActionEvent e) {
        int pos = this.getActivedButton(this._buttons);
        int newPos = pos == -1 ? 0 : pos + this._direction;
        int newSel = newPos >= 0 ? newPos % this._buttons.length : this._buttons.length - 1;
        AbstractButton button = this._buttons[newSel];
        this.setActiveButton(button);
    }

    protected static void attach(ButtonKeyController upAction, ButtonKeyController downAction, AbstractButton[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            AbstractButton button = buttons[i];
            InputMap inputMap = button.getInputMap(0);
            inputMap.put(KEY_UP, UP_ACTION_KEY);
            inputMap.put(KEY_LEFT, UP_ACTION_KEY);
            inputMap.put(KEY_DOWN, DOWN_ACTION_KEY);
            inputMap.put(KEY_RIGHT, DOWN_ACTION_KEY);
            ActionMap actionMap = button.getActionMap();
            actionMap.put(UP_ACTION_KEY, upAction);
            actionMap.put(DOWN_ACTION_KEY, downAction);
            ++i;
        }
    }

    protected int getActivedButton(AbstractButton[] buttons) {
        int i = 0;
        while (i < this._buttons.length) {
            AbstractButton button = this._buttons[i];
            if (button.hasFocus()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setActiveButton(AbstractButton button) {
        button.requestFocus();
    }
}

