/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controls.ChangeAdaptor;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuManager {
    private final MenuListener _menuListener;
    final ContainerListener _containerListener;
    private final L _listener;
    private static final int LAST_POSITION = -1;
    private static final String ALPHA_SORT_SECTION_KEY = "alpha-sort-sections";
    private static final String SORT_MENU_KEY = "menu-is-sorted";
    private static final String MENU_CLIENT_PROPERTY = "oide.menu.id";
    private final List<MenuFilter> _menuFilters;
    private MenuFilter _globalFilter;
    private static final InitialContext _ic;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._menuListener = new PrivateMenuListener(null);
        this._containerListener = new PrivateContainerListener(null);
        this._listener = new L(null);
        this._menuFilters = new ArrayList<MenuFilter>();
    }

    MenuManager() {
        this.$init$();
    }

    public void addMenuFilter(MenuFilter menuFilter) {
        if (menuFilter == null) {
            throw new NullPointerException("menuFilter is null");
        }
        this._menuFilters.add(menuFilter);
    }

    public void removeMenuFilter(MenuFilter menuFilter) {
        this._menuFilters.remove(menuFilter);
    }

    static {
        $assertionsDisabled = MenuManager.class.desiredAssertionStatus() ^ true;
        _ic = Names.newInitialContext();
    }

    public final void applyGlobalFilter(MenuFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter is null");
        }
        if (filter != this._globalFilter) {
            if (this._globalFilter != null) {
                this.clearGlobalFilter();
            }
            if (!$assertionsDisabled && this._globalFilter != null) {
                throw new AssertionError();
            }
            this._globalFilter = filter;
            this.applyGlobalFilterImpl(filter);
        }
    }

    protected void applyGlobalFilterImpl(MenuFilter filter) {
    }

    public final void clearGlobalFilter() {
        if (this._globalFilter != null) {
            this._globalFilter = null;
        }
        this.clearGlobalFilterImpl();
    }

    protected void clearGlobalFilterImpl() {
    }

    MenuFilter getGlobalFilter() {
        return this._globalFilter;
    }

    public static final void setMenuId(JMenu menu, String id) {
        menu.putClientProperty(MENU_CLIENT_PROPERTY, id);
    }

    public static final String getMenuId(JMenu menu) {
        return (String)menu.getClientProperty(MENU_CLIENT_PROPERTY);
    }

    protected final boolean isMenuComponentAccepted(Component component) {
        return MenuManager.isMenuComponentAccepted(component, this._menuFilters);
    }

    protected static final boolean isMenuComponentAccepted(Component component, Collection<MenuFilter> filters) {
        if (component == null) {
            return false;
        }
        for (MenuFilter filter : filters) {
            if (filter.accept(component)) continue;
            return false;
        }
        return true;
    }

    public static final JMenu getJMenu(String id) {
        return (JMenu)Names.lookup((javax.naming.Context)_ic, (String)MenuManager.menuKey(id));
    }

    public static final void putJMenu(String id, JMenu menu) {
        String menuKey = MenuManager.menuKey(id);
        if (menu == null) {
            Names.unbind((javax.naming.Context)_ic, (String)menuKey);
        } else {
            MenuManager.setMenuId(menu, id);
            Names.bind((javax.naming.Context)_ic, (String)menuKey, (Object)menu);
        }
    }

    private static String menuKey(String id) {
        return "env/menus/" + id;
    }

    public JMenu createMenu(String caption, Integer mnemonic) {
        return this.createMenu(caption, mnemonic, Float.MAX_VALUE);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight) {
        return this.createMenu(caption, mnemonic, weight, Float.MAX_VALUE);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight, float addinSectionId) {
        return this.createMenu(caption, mnemonic, weight, Float.MAX_VALUE, addinSectionId);
    }

    private JMenu createMenu(String caption, Integer mnemonic, float weight, float sectionId, float addinSectionId) {
        JMenu menu = new JMenu(caption);
        if (mnemonic != null) {
            int vk = mnemonic;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            menu.setMnemonic(vk);
        }
        this.setWeight(menu, weight, "menu-weight");
        this.setWeight(menu, sectionId, "menu-section-id");
        this.setWeight(menu, addinSectionId, "menu-addin-section-id");
        this.addMenuManagerAsListener(menu);
        return menu;
    }

    public JMenu createSubMenu(String caption, Integer mnemonic) {
        return this.createSubMenu(caption, mnemonic, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight) {
        return this.createSubMenu(caption, mnemonic, weight, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight, float sectionId) {
        return this.createMenu(caption, mnemonic, weight, sectionId, Float.MAX_VALUE);
    }

    public JMenuItem createMenuItem(ToggleAction action) {
        return this.createMenuItem(action, Float.MAX_VALUE);
    }

    public JMenuItem createMenuItem(ToggleAction action, float menuWeight) {
        if (action == null) {
            return null;
        }
        JMenuItem menuItem = action.isRadio() ? new RadioMenuItem(action) : (action.isToggle() ? new ToggleMenuItem(action) : new MenuItem(action));
        if (menuWeight != Float.MAX_VALUE) {
            menuItem.putClientProperty("menu-weight", new Float(menuWeight));
        } else {
            menuItem.putClientProperty("menu-weight", new Float(action.getMenuWeight()));
        }
        if (action instanceof IdeAction) {
            MenuManager.refreshMenuItem(menuItem);
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            InnerChangeAdaptor changeListener = new InnerChangeAdaptor(menuItem, keyStrokeOptions);
            keyStrokeOptions.addChangeListener(changeListener);
        }
        return menuItem;
    }

    public void add(Component child) {
        this.add(child, Float.MAX_VALUE);
    }

    public void add(Component child, float sectionId) {
        Container gui;
        if (this.isMenuComponentAccepted(child) && (gui = this.getGUI(true)) != null) {
            this.setWeight(child, sectionId, "menu-section-id");
            if (gui instanceof JMenuBar) {
                this.addToMenubar((JMenuBar)gui, child);
            } else {
                gui.add(child);
            }
            this.addMenuManagerAsListener(child);
        }
    }

    public void add(Component child, JMenu parent) {
        this.add(child, parent, Float.MAX_VALUE);
    }

    public void add(Component child, JMenu parent, float sectionId) {
        if (child == null) {
            throw new NullPointerException("child is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (this.isMenuComponentAccepted(child)) {
            Float menuWeight;
            if (sectionId == Float.MAX_VALUE && (menuWeight = (Float)parent.getClientProperty("menu-addin-section-id")) != null) {
                sectionId = menuWeight.floatValue();
            }
            this.setWeight(child, sectionId, "menu-section-id");
            parent.add(child);
            this.addMenuManagerAsListener(child);
        }
    }

    public void remove(Component child) {
        Container gui;
        if (child != null && (gui = this.getGUI(false)) != null) {
            gui.remove(child);
            this.adjustSeparators(gui);
            this.removeMenuManagerAsListener(child);
        }
    }

    public void remove(Component child, JMenu parent) {
        int index;
        if (child != null && parent != null && (index = this.getIndexOfChild(parent, child)) != -1) {
            parent.remove(index);
            this.removeMenuManagerAsListener(child);
        }
    }

    public abstract Container getGUI(boolean var1);

    public int getIndexOfChild(Container parent, Component child) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        if (parent == null || child == null) {
            return -1;
        }
        int count = parent.getComponentCount();
        Component[] components = parent.getComponents();
        int i = 0;
        while (i < count) {
            Component component = components[i];
            if (component == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndexOfCommandId(Container parent, int commandId) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        if (parent == null) {
            return -1;
        }
        int count = parent.getComponentCount();
        Component[] components = parent.getComponents();
        int i = 0;
        while (i < count) {
            JComponent component = (JComponent)components[i];
            IdeAction action = this._getIdeAction(component);
            if (action != null && action.getCommandId() == commandId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Component getChildById(Container parent, int commandId) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        if (parent == null) {
            return null;
        }
        int count = parent.getComponentCount();
        Component[] components = parent.getComponents();
        int i = 0;
        while (i < count) {
            JComponent component = (JComponent)components[i];
            IdeAction action = this._getIdeAction(component);
            if (action != null && action.getCommandId() == commandId) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public void sortSectionByName(JMenu menu, float sectionID) {
        Float f;
        ArrayList<Float> l = (ArrayList<Float>)menu.getClientProperty(ALPHA_SORT_SECTION_KEY);
        if (l == null) {
            l = new ArrayList<Float>(1);
        }
        if (!l.contains(f = new Float(sectionID))) {
            l.add(f);
        }
        menu.putClientProperty(ALPHA_SORT_SECTION_KEY, l);
    }

    public void removeMenuManagerMenuListener(JMenu menu) {
        if (menu != null) {
            menu.removeMenuListener(this._listener);
        }
    }

    protected void setWeight(Component component, float weight, String weightId) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent item = (JComponent)component;
        if (weight != Float.MAX_VALUE) {
            item.putClientProperty(weightId, new Float(weight));
        } else {
            Float menuWeight = (Float)item.getClientProperty(weightId);
            if (menuWeight == null || menuWeight.floatValue() == Float.MAX_VALUE) {
                item.putClientProperty(weightId, new Float(weight));
            }
        }
    }

    private IdeAction _getIdeAction(Component c) {
        AbstractButton button;
        Action action;
        if (c instanceof AbstractButton && (action = (button = (AbstractButton)c).getAction()) != null && action instanceof IdeAction) {
            return (IdeAction)action;
        }
        return null;
    }

    private static void updateMenuItems(JMenu menu, EventObject event) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(menu.getPopupMenu());
        View activeView = Ide.getMainWindow().getLastActiveView();
        Context context = activeView != null ? activeView.getContext(event) : Context.newIdeContext();
        int count = menu.getItemCount();
        int i = 0;
        while (i < count) {
            MenuManager.updateMenuItemAction(menu.getItem(i), context);
            ++i;
        }
    }

    static void updatePopupMenuItems(JPopupMenu menu, Context context) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(menu);
        MenuElement[] items = menu.getSubElements();
        if (items != null) {
            int count = items.length;
            int i = 0;
            while (i < count) {
                MenuElement item = items[i];
                if (item instanceof JMenuItem) {
                    MenuManager.updateMenuItemAction((JMenuItem)item, context);
                }
                ++i;
            }
        }
    }

    private static void workaroundExpandingSwingJPopupMenuBug(JComponent jcomp) {
        jcomp.putClientProperty("maxTextWidth", null);
        jcomp.putClientProperty("maxAccWidth", null);
    }

    private static void updateMenuItemAction(JMenuItem item, Context context) {
        Action swingAction;
        if (item != null && (swingAction = item.getAction()) instanceof IdeAction) {
            IdeAction ideAction = (IdeAction)swingAction;
            ideAction.updateAction(context);
        }
    }

    private static void refreshMenuItem(JMenuItem menuItem) {
        KeyStroke ksOld;
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        IdeAction action = (IdeAction)menuItem.getAction();
        KeyStroke accelerator = null;
        if (action != null) {
            HashMap localKeyMaps;
            int nCmdID = action.getCommandId();
            KeyStrokeMap ksm = kso.getGlobalKeyMap();
            accelerator = KeyUtil.getBestAccelerator(ksm, nCmdID);
            if (accelerator == null && (localKeyMaps = kso.getLocalKeyMaps()) != null) {
                Iterator iterator = localKeyMaps.values().iterator();
                while (accelerator == null && iterator.hasNext()) {
                    KeyStrokeMap localKeyMap = (KeyStrokeMap)iterator.next();
                    accelerator = KeyUtil.getBestAccelerator(localKeyMap, nCmdID);
                }
            }
        }
        if ((ksOld = menuItem.getAccelerator()) == null) {
            if (accelerator != null) {
                menuItem.setAccelerator(accelerator);
                MenuManager.updateAccessibleMenuName(menuItem, accelerator);
            }
        } else if (!ksOld.equals(accelerator)) {
            menuItem.setAccelerator(null);
            MenuManager.updateAccessibleMenuName(menuItem, accelerator);
            if (accelerator != null) {
                menuItem.setAccelerator(accelerator);
                MenuManager.updateAccessibleMenuName(menuItem, accelerator);
            }
        }
    }

    private static void updateAccessibleMenuName(JMenuItem menuItem, KeyStroke ks) {
        String text = menuItem.getText();
        if (text != null && ks != null) {
            StringBuffer buf = new StringBuffer(text.trim());
            String mods = KeyEvent.getKeyModifiersText(ks.getModifiers());
            String key = KeyEvent.getKeyText(ks.getKeyCode());
            if (mods.length() > 0) {
                buf.append(mods);
                if (key.length() > 0) {
                    buf.append("+");
                    buf.append(key);
                }
            } else if (key.length() > 0) {
                buf.append(key);
            }
            menuItem.getAccessibleContext().setAccessibleName(buf.toString());
        }
    }

    private void adjustSeparators(Container menu) {
        if (menu.getComponentCount() < 2) {
            return;
        }
        boolean validateContainer = false;
        boolean foundSeparator = false;
        Component[] menuItems = menu.getComponents();
        int i = menuItems.length - 1;
        while (i >= 0) {
            boolean sep = menuItems[i] instanceof JSeparator;
            if (foundSeparator && sep) {
                menu.remove(menuItems[i]);
                validateContainer = true;
            }
            foundSeparator = sep;
            --i;
        }
        if (validateContainer) {
            menu.validate();
        }
    }

    private void addToMenubar(JMenuBar menubar, Component child) {
        if (menubar.getComponentCount() == 0) {
            menubar.add(child);
            menubar.validate();
            return;
        }
        JComponent item = (JComponent)child;
        Float weight = (Float)item.getClientProperty("menu-weight");
        if (weight == null) {
            weight = new Float(Float.MAX_VALUE);
        }
        Component[] children = menubar.getComponents();
        int i = 0;
        while (i < children.length) {
            int weightCompare;
            if (children[i] == child) {
                return;
            }
            JComponent nextItem = (JComponent)children[i];
            Float nextItemWeight = (Float)nextItem.getClientProperty("menu-weight");
            int n = weightCompare = nextItemWeight != null ? weight.compareTo(nextItemWeight) : 1;
            if (weightCompare < 0) {
                menubar.add(child, i);
                menubar.validate();
                return;
            }
            ++i;
        }
        menubar.add(child);
        menubar.validate();
    }

    public void sortContainer(Container container) {
        if (container == null) {
            return;
        }
        HashMap data = new HashMap();
        Component[] children = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof JSeparator) && children[i] instanceof JComponent) {
                ArrayList<JComponent> list;
                JComponent item = (JComponent)children[i];
                Float f = (Float)item.getClientProperty("menu-section-id");
                if (f == null) {
                    f = new Float(Float.MAX_VALUE);
                }
                if ((list = (ArrayList<JComponent>)data.get(f)) == null) {
                    list = new ArrayList<JComponent>();
                    data.put(f, list);
                }
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
            ++i;
        }
        container.removeAll();
        ArrayList sectionIds = new ArrayList(data.keySet());
        if (sectionIds.size() > 1) {
            Collections.sort(sectionIds);
        }
        ArrayList alphaSortSections = container instanceof JMenu ? (ArrayList)((JMenu)container).getClientProperty(ALPHA_SORT_SECTION_KEY) : null;
        MenuWeightComparator comparator = new MenuWeightComparator(alphaSortSections);
        boolean useSeparators = !(container instanceof JMenuBar);
        int counter = 0;
        int size = sectionIds.size();
        Component last = null;
        for (Float id : sectionIds) {
            ArrayList commandList = (ArrayList)data.get(id);
            if (commandList.size() > 1) {
                Collections.sort(commandList, comparator);
            }
            for (Component command : commandList) {
                if (command == null || command instanceof JSeparator) continue;
                container.add(command);
                last = command;
            }
            if (!useSeparators || ++counter == size || last == null) continue;
            container.add(new JPopupMenu.Separator());
        }
        container.validate();
    }

    private void addMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            MenuListener[] listeners = (MenuListener[])menu.getListeners(MenuListener.class);
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == this._listener) {
                    return;
                }
                ++i;
            }
            menu.addMenuListener(this._listener);
            menu.getPopupMenu().addContainerListener(this._listener);
        }
    }

    private void removeMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            menu.removeMenuListener(this._listener);
            menu.getPopupMenu().removeContainerListener(this._listener);
        }
    }

    public final String getId(Component menuComponent) {
        JMenuItem menuItem;
        Action action;
        if (menuComponent == null) {
            throw new NullPointerException("menuComponent is null");
        }
        if (menuComponent instanceof JMenu) {
            return MenuManager.getMenuId((JMenu)menuComponent);
        }
        if (menuComponent instanceof JMenuItem && (action = (menuItem = (JMenuItem)menuComponent).getAction()) instanceof IdeAction) {
            IdeAction ideAction = (IdeAction)action;
            int intId = ideAction.getCommandId();
            return Ide.findCmdName(intId);
        }
        return "";
    }

    static void maS$refreshMenuItem(JMenuItem jMenuItem) {
        MenuManager.refreshMenuItem(jMenuItem);
    }

    static void maS$updateMenuItems(JMenu jMenu, EventObject eventObject) {
        MenuManager.updateMenuItems(jMenu, eventObject);
    }

    static MenuListener ra$_menuListener(MenuManager menuManager) {
        return menuManager._menuListener;
    }

    private static final class InnerChangeAdaptor
    extends ChangeAdaptor {
        public InnerChangeAdaptor(AbstractButton adaptee, ChangeEventSource action) {
            super(adaptee, action);
        }

        protected void _stateChanged(ChangeEvent e) {
            JMenuItem menuItem = (JMenuItem)this.getAdaptee();
            MenuManager.maS$refreshMenuItem(menuItem);
        }
    }

    private final class PrivateMenuListener
    implements MenuListener {
        public final void menuSelected(MenuEvent e) {
            MenuManager.maS$updateMenuItems((JMenu)e.getSource(), e);
        }

        public final void menuDeselected(MenuEvent e) {
        }

        public final void menuCanceled(MenuEvent e) {
        }

        private PrivateMenuListener() {
        }

        PrivateMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PrivateContainerListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            if (child instanceof JMenu) {
                this.addListenersToTree(((JMenu)child).getPopupMenu());
            }
        }

        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            if (child instanceof JMenu) {
                this.removeListenersFromTree(((JMenu)child).getPopupMenu());
            }
        }

        private void addListenersToTree(JPopupMenu root) {
            JMenu menu = (JMenu)root.getInvoker();
            if (menu != null) {
                menu.addMenuListener(MenuManager.ra$_menuListener(MenuManager.this));
                root.addContainerListener(this);
            }
            Component[] components = root.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof JMenu) {
                    this.addListenersToTree(((JMenu)components[i]).getPopupMenu());
                }
                ++i;
            }
        }

        private void removeListenersFromTree(JPopupMenu root) {
            JMenu menu = (JMenu)root.getInvoker();
            if (menu != null) {
                menu.removeMenuListener(MenuManager.ra$_menuListener(MenuManager.this));
                root.removeContainerListener(this);
            }
            Component[] components = root.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof JMenu) {
                    this.removeListenersFromTree(((JMenu)components[i]).getPopupMenu());
                }
                ++i;
            }
        }

        private PrivateContainerListener() {
        }

        PrivateContainerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements ContainerListener,
    MenuListener {
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            if (!Boolean.TRUE.equals(menu.getClientProperty(MenuManager.SORT_MENU_KEY))) {
                MenuManager.this.sortContainer(menu);
                menu.putClientProperty(MenuManager.SORT_MENU_KEY, Boolean.TRUE);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void componentAdded(ContainerEvent e) {
            JPopupMenu popupMenu = (JPopupMenu)e.getSource();
            JMenu menu = (JMenu)popupMenu.getInvoker();
            menu.putClientProperty(MenuManager.SORT_MENU_KEY, null);
        }

        public void componentRemoved(ContainerEvent e) {
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

