/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import javax.swing.Icon;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.Project;
import oracle.ide.resource.IdeArb;
import oracle.javatools.icons.OracleIcons;

public final class IdeActions {
    private static IdeAction findOrCreateAction(int cmdID, String cmdStr, String label, String actionCategory, Integer labelMnemonic, Icon icon, Object data, boolean enabled) {
        String cmd = AddinManager.getAddinManager().getCommand(cmdID, cmdStr);
        IdeAction action = IdeAction.get(cmdID, cmd, label, actionCategory, labelMnemonic, null, null, data, enabled);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        return action;
    }

    public static IdeAction getFileOpenAction() {
        return IdeActions.findOrCreateAction(9, "oracle.ide.cmd.OpenCommand", IdeArb.getString(228), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(463), OracleIcons.getIcon((String)"open.png"), null, true);
    }

    public static IdeAction getFileCloseAction() {
        return IdeActions.findOrCreateAction(48, "oracle.ide.cmd.CloseNodeCommand", IdeArb.getString(26), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(433), null, null, true);
    }

    public static IdeAction getFileCloseAllAction() {
        return IdeActions.findOrCreateAction(39, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(246), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(278), null, null, true);
    }

    public static IdeAction getFileSaveAction() {
        return IdeActions.findOrCreateAction(11, "oracle.ide.cmd.SaveCommand", IdeArb.getString(85), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(35), OracleIcons.getIcon((String)"filesave.png"), null, false);
    }

    public static IdeAction getFileSaveAsAction() {
        return IdeActions.findOrCreateAction(12, "oracle.ide.cmd.SaveAsCommand", IdeArb.getString(478), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(328), null, null, false);
    }

    public static IdeAction getFileSaveAllAction() {
        return IdeActions.findOrCreateAction(13, "oracle.ide.cmd.SaveAllCommand", IdeArb.getString(445), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(335), OracleIcons.getIcon((String)"saveall.png"), null, true);
    }

    public static IdeAction getFileRenameAction() {
        return IdeActions.findOrCreateAction(14, "oracle.ide.cmd.RenameCommand", IdeArb.getString(323), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(38), null, null, false);
    }

    public static IdeAction getFileRevertAction() {
        return IdeActions.findOrCreateAction(52, "oracle.ide.cmd.RevertNodeCommand", IdeArb.getString(342), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(164), null, null, false);
    }

    public static IdeAction getFileRemoveFromIDEAction() {
        return IdeActions.findOrCreateAction(21, "oracle.ide.cmd.RemoveFileCommand", IdeArb.getString(428), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(332), OracleIcons.getIcon((String)"remove_file.png"), null, false);
    }

    public static IdeAction getFileRemoveFromDiskAction() {
        IdeAction removeFromDiskAction = IdeActions.findOrCreateAction(47, "oracle.ide.cmd.RemoveFromDiskCommand", IdeArb.getString(391), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(256), OracleIcons.getIcon((String)"delete.png"), null, false);
        if (removeFromDiskAction.getLabelUpdater() == null) {
            removeFromDiskAction.setLabelUpdater(new 1());
        }
        return removeFromDiskAction;
    }

    public static IdeAction getFileExitAction() {
        return IdeActions.findOrCreateAction(4, "oracle.ide.cmd.ExitCommand", IdeArb.getString(329), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(158), null, Ide.getMainWindow(), true);
    }

    public static IdeAction getFileReloadNodesAction() {
        return IdeActions.findOrCreateAction(72, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(205), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger(318), null, null, true);
    }

    public static IdeAction getEditUndoAction() {
        String undoMenuLabel = IdeArb.format(469, "");
        IdeAction action = IdeActions.findOrCreateAction(5, "oracle.ide.cmd.UndoCommand", undoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(105), OracleIcons.getIcon((String)"undo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", undoMenuLabel);
        return action;
    }

    public static IdeAction getEditRedoAction() {
        String redoMenuLabel = IdeArb.format(371, "");
        IdeAction action = IdeActions.findOrCreateAction(6, "oracle.ide.cmd.RedoCommand", redoMenuLabel, IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(398), OracleIcons.getIcon((String)"redo.png"), CommandProcessor.getInstance(), false);
        action.putValue("NoCtxName", redoMenuLabel);
        return action;
    }

    public static IdeAction getEditCutAction() {
        return IdeActions.findOrCreateAction(17, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(257), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(119), OracleIcons.getIcon((String)"cut.png"), null, false);
    }

    public static IdeAction getEditCopyAction() {
        return IdeActions.findOrCreateAction(18, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(154), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(1), OracleIcons.getIcon((String)"copy.png"), null, false);
    }

    public static IdeAction getEditCopyPathAction() {
        return IdeActions.findOrCreateAction(77, "oracle.ide.cmd.CopyPath", IdeArb.getString(28), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(341), null, null, false);
    }

    public static IdeAction getEditPasteAction() {
        return IdeActions.findOrCreateAction(19, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(159), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(298), OracleIcons.getIcon((String)"paste.png"), null, false);
    }

    public static IdeAction getEditExtendedPasteAction() {
        return IdeActions.findOrCreateAction(78, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(67), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(439), null, null, false);
    }

    public static IdeAction getEditDeleteAction() {
        return IdeActions.findOrCreateAction(20, null, IdeArb.getString(361), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(225), OracleIcons.getIcon((String)"delete.png"), null, false);
    }

    public static IdeAction getEditSelectAllAction() {
        return IdeActions.findOrCreateAction(22, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(144), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(304), null, null, false);
    }

    public static IdeAction getEditPropertiesAction() {
        return IdeActions.findOrCreateAction(56, null, IdeArb.getString(452), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(101), OracleIcons.getIcon((String)"properties.png"), null, false);
    }

    public static IdeAction getEditDuplicateSelectionAction() {
        IdeAction action = IdeActions.findOrCreateAction(82, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(425), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(89), null, null, true);
        return action;
    }

    public static IdeAction getEditSelectWrapAction() {
        IdeAction action = IdeActions.findOrCreateAction(81, "oracle.ide.cmd.SelectWrapCommand", IdeArb.getString(188), IdeMainWindow.ACTION_CATEGORY_EDIT, IdeArb.getInteger(437), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        action.setState(true);
        return action;
    }

    public static IdeAction getViewNewViewAction() {
        return IdeActions.findOrCreateAction(67, null, IdeArb.getString(93), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(182), OracleIcons.getIcon((String)"navigator.png"), null, false);
    }

    public static IdeAction getViewFreezeAction() {
        IdeAction action = IdeActions.findOrCreateAction(68, null, IdeArb.getString(78), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(117), OracleIcons.getIcon((String)"pin.png"), null, false);
        action.putValue("Check", Boolean.TRUE);
        action.putValue("State", Boolean.FALSE);
        return action;
    }

    public static IdeAction getViewMainToolbarAction() {
        IdeAction action = IdeActions.findOrCreateAction(36, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(155), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(171), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        return action;
    }

    public static IdeAction getViewStatusBarAction() {
        IdeAction action = IdeActions.findOrCreateAction(69, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(295), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(466), null, null, true);
        action.putValue("Check", Boolean.TRUE);
        return action;
    }

    public static IdeAction getViewRefreshAction() {
        return IdeActions.findOrCreateAction(51, null, IdeArb.getString(270), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(55), OracleIcons.getIcon((String)"refresh.png"), null, false);
    }

    public static IdeAction getSearchFindAction() {
        return IdeActions.findOrCreateAction(23, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(220), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(179), OracleIcons.getIcon((String)"find.png"), null, false);
    }

    public static IdeAction getSearchFindNextAction() {
        return IdeActions.findOrCreateAction(25, "oracle.ide.cmd.SearchAgainCommand", IdeArb.getString(31), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(106), null, null, false);
    }

    public static IdeAction getSearchFindPreviousAction() {
        return IdeActions.findOrCreateAction(53, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(306), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(324), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindForwardAction() {
        return IdeActions.findOrCreateAction(26, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(359), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(245), null, null, false);
    }

    public static IdeAction getSearchIncrementalFindBackwardAction() {
        return IdeActions.findOrCreateAction(27, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(317), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(459), null, null, false);
    }

    public static IdeAction getSearchReplaceAction() {
        return IdeActions.findOrCreateAction(24, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(280), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(40), null, null, false);
    }

    public static IdeAction getSearchFindInFilesAction() {
        return IdeActions.findOrCreateAction(28, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(476), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(311), OracleIcons.getIcon((String)"search_sourcepath.png"), null, false);
    }

    public static IdeAction getReplaceInFilesAction() {
        return IdeActions.findOrCreateAction(76, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(42), IdeMainWindow.ACTION_CATEGORY_SEARCH, IdeArb.getInteger(432), OracleIcons.getIcon((String)"search_sourcepath.png"), null, false);
    }

    public static IdeAction getNavigateGoToLineAction() {
        return IdeActions.findOrCreateAction(29, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(48), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(380), null, null, false);
    }

    public static IdeAction getNavigateGoToClassAction() {
        return IdeActions.findOrCreateAction(32, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(34), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(426), null, null, true);
    }

    public static IdeAction getNavigateGoToNextMessageAction() {
        return IdeActions.findOrCreateAction(30, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(457), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(134), OracleIcons.getIcon((String)"next_message.png"), null, false);
    }

    public static IdeAction getNavigateGoToPreviousMessageAction() {
        return IdeActions.findOrCreateAction(31, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(77), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(417), OracleIcons.getIcon((String)"previous_message.png"), null, false);
    }

    public static IdeAction getToolsProjectPropertiesAction() {
        return IdeActions.findOrCreateAction(35, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(393), IdeMainWindow.ACTION_CATEGORY_TOOLS, IdeArb.getInteger(22), OracleIcons.getIcon((String)"settings.png"), null, false);
    }

    public static IdeAction getToolsDefaultProjectPropertiesAction() {
        return IdeActions.findOrCreateAction(37, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(185), IdeMainWindow.ACTION_CATEGORY_TOOLS, IdeArb.getInteger(51), null, null, false);
    }

    public static IdeAction getToolsPreferencesAction() {
        return IdeActions.findOrCreateAction(38, "oracle.ide.cmd.IdeSettingsCommand", IdeArb.getString(266), IdeMainWindow.ACTION_CATEGORY_TOOLS, IdeArb.getInteger(235), null, null, true);
    }

    public static IdeAction getHelpAboutAction() {
        return IdeActions.findOrCreateAction(79, "oracle.ide.cmd.AboutCommand", IdeArb.getString(244), IdeMainWindow.ACTION_CATEGORY_HELP, IdeArb.getInteger(148), null, null, true);
    }

    public static IdeAction getGoToDeclarationAction() {
        return IdeActions.findOrCreateAction(Ide.findOrCreateCmdID("ojjb.BrowseSymbol"), null, IdeArb.getString(404), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, IdeArb.getInteger(83), null, null, true);
    }

    static final class 1
    implements LabelUpdater {
        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.getLabelForCurrentElement(context);
        }

        public void setEnabledFormat(String format) {
        }

        public void setDisabledFormat(String format) {
        }

        private String getLabelForCurrentElement(Context context) {
            if (context.getElement() instanceof Project) {
                return IdeArb.getString(312);
            }
            return IdeArb.getString(391);
        }
    }
}

