/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ActionLogger;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeAction
extends ToggleAction {
    private final ArrayList<Controller> _controllers;
    private String _command;
    private int _commandId;
    private LabelUpdater _labelUpdater;
    private String _name;
    public static final String INVOKED_FROM = "invokedFrom";
    static final String EVENT_SOURCE = "eventSource";
    public static final String ORIGINAL_ACTION_NAME = "oracle.id.IdeAction.NAME";
    private static boolean _handlerInProgress;
    private static final Logger LOG;
    public static final String LAST_TOOLTIP_SUFFIX = "last-tooltip-suffix";
    public static final String CONTROLLER_HANDLING_UPDATE = "controller-handling-update";
    public static final boolean DEBUG;

    private void $init$() {
        this._controllers = new ArrayList(1);
    }

    protected IdeAction() {
        super(null, null);
        this.$init$();
        if (!"oracle.ideimpl.jsr198.JSR198Action".equals(this.getClass().getName())) {
            throw new UnsupportedOperationException();
        }
    }

    private IdeAction(String name, Icon icon) {
        super(name, icon);
        this.$init$();
    }

    private IdeAction(IdeAction action) {
        super(action);
        this.$init$();
        this._command = action._command;
        this._commandId = action._commandId;
    }

    private IdeAction(String name, ResourceBundle bundle, String key) {
        super(name, bundle, key);
        this.$init$();
    }

    private IdeAction(String name, ArrayResourceBundle bundle, int key) {
        super(name, bundle, key);
        this.$init$();
    }

    public static IdeAction get(int cmdId, String cmdClass, String name) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, null, null, null, null, null, -1, null, true);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction get(int cmdId, String cmdClass, String name, ArrayResourceBundle bundle, int key) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, null, null, null, (ResourceBundle)bundle, null, key, null, true);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, Icon icon, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, icon, null, null, -1, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction getEnabled(int cmdId, String name) {
        return IdeAction.get(cmdId, null, name, null, null, null, null, true);
    }

    public static IdeAction getEnabled(int cmdId, String name, String category) {
        return IdeAction.get(cmdId, null, name, category, null, null, null, true);
    }

    public static IdeAction getEnabled(int cmdId, String name, Icon icon) {
        return IdeAction.get(cmdId, null, name, null, null, icon, null, true);
    }

    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, ArrayResourceBundle bundle, int key, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, null, (ResourceBundle)bundle, null, key, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction get(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, ResourceBundle bundle, String key, Object data, boolean enabled) {
        Integer id;
        ActionMap ideActionMap = Ide.getIdeActionMap();
        IdeAction action = (IdeAction)ideActionMap.get(id = Integer.valueOf(cmdId));
        if (action != null) {
            return action;
        }
        action = IdeAction.create(cmdId, cmdClass, name, sCategory, mnemonic, null, bundle, key != null ? key : "", -1, data, enabled);
        ideActionMap.put(id, action);
        return action;
    }

    public static IdeAction getEnabled(int cmdId, String name, ResourceBundle bundle) {
        return IdeAction.get(cmdId, null, name, null, null, bundle, null, null, true);
    }

    public static IdeAction get(int cmdId) {
        return IdeAction.get(cmdId, (String)null, (Integer)null);
    }

    public static IdeAction get(int cmdId, String name, Integer mnemonic) {
        IdeAction action = IdeAction.get(cmdId, null, name);
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        return action;
    }

    public static IdeAction find(int cmdId) {
        if (Ide.isRunning()) {
            return (IdeAction)Ide.getIdeActionMap().get(cmdId);
        }
        return null;
    }

    public static IdeAction find(String commandName) {
        IdeAction ret = null;
        Integer cmdID = Ide.findCmdID(commandName);
        if (cmdID != null) {
            ret = IdeAction.find(cmdID);
        }
        return ret;
    }

    public static void remove(int cmdId) {
        Ide.getIdeActionMap().remove(cmdId);
    }

    public static IdeAction[] findGroup(String groupName) {
        ActionMap actionMap = Ide.getIdeActionMap();
        Object[] keys = actionMap.allKeys();
        if (keys == null || keys.length == 0) {
            return null;
        }
        TreeMap<Object, IdeAction> group = new TreeMap<Object, IdeAction>();
        int i = 0;
        while (i < keys.length) {
            IdeAction action;
            String buttonGroup;
            Object key = keys[i];
            Action value = actionMap.get(key);
            if (value instanceof IdeAction && (buttonGroup = (String)(action = (IdeAction)value).getValue("RadioGroupName")) != null && buttonGroup.equals(groupName)) {
                group.put(key, action);
            }
            ++i;
        }
        return group.size() > 0 ? group.values().toArray(new IdeAction[group.size()]) : null;
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        this.actionPerformedImpl(event);
    }

    public final void performAction() throws Exception {
        this.performAction(this.getView().getContext());
    }

    public final void performAction(Context context) throws Exception {
        block16: {
            boolean alreadyInProgress;
            block15: {
                ActionLogger.logActionPerformed(context, this);
                alreadyInProgress = IdeAction.handlerStarting();
                FeedbackManager.addFeedback("Performing action " + this.getValue("Name"), context);
                if (DEBUG) {
                    System.out.println("Performing action " + this.getValue("Name"));
                }
                ControllerIterator iter = new ControllerIterator(null);
                while (iter.hasNext()) {
                    Controller controller = iter.next();
                    try {
                        if (!controller.handleEvent(this, context)) continue;
                        if (DEBUG) {
                            System.out.println("Action handled by " + controller.getClass().getName());
                        }
                        IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
                        return;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        FeedbackManager.reportException("Exception while performing action " + this.getValue("Name"), t);
                    }
                }
                if (!DEBUG) break block15;
                System.out.println("No Controller handled action " + this.getValue("Name") + " -- checking CommandProcessor...");
            }
            CommandProcessor cp = CommandProcessor.getInstance();
            Command cmd = CommandProcessor.createCommand(this.getCommand(), context);
            if (cmd != null) {
                if (DEBUG) {
                    System.out.println("Invoking Command class " + cmd.getClass().getName());
                }
                cp.invoke(cmd);
            } else if (DEBUG) {
                System.out.println("No Command class for " + this.getValue("Name") + "!!");
            }
            break block16;
            finally {
                IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
            }
        }
    }

    public final void updateAction() {
        this.updateAction(this.getView().getContext());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void updateAction(Context context) {
        if (DEBUG) {
            this.putValue(CONTROLLER_HANDLING_UPDATE, null);
        }
        PerformanceLogger logger = PerformanceLogger.get();
        String LOGGER_ID = EventQueue.isDispatchThread() ? "IdeAction.updateAction" : "IdeAction.updateAction";
        ControllerIterator i = new ControllerIterator(null);
        while (i.hasNext()) {
            Controller controller;
            block10: {
                block11: {
                    controller = i.next();
                    logger.startTiming(LOGGER_ID);
                    boolean handled = controller.update(this, context);
                    if (!handled) break block10;
                    this.updateLabel(context);
                    if (!DEBUG) break block11;
                    this.appendToToolTip(controller);
                }
                logger.stopTiming(LOGGER_ID, 10, "Updated controller {0}", new Object[]{controller});
                try {
                    return;
                }
                catch (ThreadDeath td) {
                    try {
                        throw td;
                        catch (Throwable t) {
                            FeedbackManager.reportException("Exception while updating action " + this.getValue("Name"), t);
                        }
                    }
                    catch (Throwable throwable) {
                        logger.stopTiming(LOGGER_ID, 10, "Updated controller {0}", new Object[]{controller});
                        throw throwable;
                    }
                }
            }
            logger.stopTiming(LOGGER_ID, 10, "Updated controller {0}", new Object[]{controller});
        }
        this.updateLabel(context);
        if (DEBUG && this._controllers.size() == 1) {
            this.appendToToolTip(this._controllers.get(0));
        }
    }

    public void setLabelUpdater(LabelUpdater labelUpdater) {
        this._labelUpdater = labelUpdater;
    }

    public LabelUpdater getLabelUpdater() {
        return this._labelUpdater;
    }

    private void updateLabel(Context context) {
        if (this._labelUpdater != null) {
            if (this._name == null) {
                this._name = (String)super.getValue("Name");
                this.putValue(ORIGINAL_ACTION_NAME, this._name);
            }
            String oldLabel = (String)super.getValue("Name");
            String newLabel = null;
            newLabel = this.isEnabled() ? this._labelUpdater.labelWhenEnabled(context, this, this._name) : this._labelUpdater.labelWhenDisabled(context, this, this._name);
            if (newLabel != null && !newLabel.equals(oldLabel)) {
                this.putValue("Name", newLabel);
            }
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name" && this._labelUpdater != null) {
            this.updateLabel(this.getView().getContext());
        }
        return super.getValue(key);
    }

    private void appendToToolTip(Controller controller) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        String explicitHandler = (String)this.getValue(CONTROLLER_HANDLING_UPDATE);
        buf.append(explicitHandler != null ? explicitHandler : controller.getClass().getName());
        buf.append("]");
        String suffix = buf.toString();
        String lastSuffix = (String)this.getValue(LAST_TOOLTIP_SUFFIX);
        String updateStr = (String)this.getValue("ShortDescription");
        if (updateStr == null) {
            updateStr = "";
        }
        if (lastSuffix != null) {
            updateStr = updateStr.replace(lastSuffix, "");
        }
        this.putValue(LAST_TOOLTIP_SUFFIX, suffix);
        updateStr = updateStr + suffix;
        this.putValue("ShortDescription", updateStr);
    }

    public final void addController(Controller controller) {
        if (controller != null && !this._controllers.contains(controller)) {
            this._controllers.add(0, controller);
        }
    }

    public static void addController(int actionID, Controller controller) {
        IdeAction action = IdeAction.find(actionID);
        if (action != null) {
            action.addController(controller);
        }
    }

    public final void removeController(Controller controller) {
        if (controller != null) {
            this._controllers.remove(controller);
        }
    }

    public static void removeController(int actionID, Controller controller) {
        IdeAction action = IdeAction.find(actionID);
        if (action != null) {
            action.removeController(controller);
        }
    }

    public final String getCommand() {
        return this._command;
    }

    public final void setCommand(String command) {
        this._command = command;
    }

    public final void setCommandId(int commandId) {
        this._commandId = commandId;
    }

    public final int getCommandId() {
        return this._commandId;
    }

    public final void putValueDirectly(String key, Object value) {
        super.putValue(key, value);
    }

    public static IdeAction newLocalAction(int cmdId, View view) {
        IdeAction globalAction = IdeAction.find(cmdId);
        if (globalAction != null) {
            return globalAction.newLocalAction(view);
        }
        return null;
    }

    public IdeAction newLocalAction(View view) {
        return new Local(this, view);
    }

    public final boolean isLocalAction() {
        return this.getClass() == Local.class;
    }

    View getView() {
        return Ide.getMainWindow().getLastActiveView();
    }

    ArrayList<Controller> getControllers() {
        return (ArrayList)this.getControllersDirectly().clone();
    }

    final ArrayList<Controller> getControllersDirectly() {
        return this._controllers;
    }

    final void actionPerformedImpl(ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            try {
                IdeAction.freezeKeyboard(true);
                Context context = null;
                if (event.getSource() instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)event.getSource();
                    context = ContextMenu.getContext(item, event);
                    ContextMenu.clearContext(item);
                }
                if (context == null) {
                    context = this.getView().getContext(event);
                }
                this.putValue(EVENT_SOURCE, event.getSource());
                this.performAction(context);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception peforming action", e);
            }
        }
        finally {
            IdeAction.freezeKeyboard(false);
            this.putValue(EVENT_SOURCE, null);
        }
    }

    static synchronized boolean handlerStarting() {
        boolean oldValue = _handlerInProgress;
        _handlerInProgress = true;
        return oldValue;
    }

    public static synchronized boolean isHandlerInProgress() {
        return _handlerInProgress;
    }

    static synchronized void handlerFinished(boolean alreadyInProgress, int updateSource) {
        try {
            if (!alreadyInProgress) {
                IdeMainWindow.updateVisibleActions(updateSource);
                _handlerInProgress = false;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static IdeAction create(int cmdId, String cmdClass, String name, String sCategory, Integer mnemonic, Icon icon, ResourceBundle bundle, String strKey, int intKey, Object data, boolean enabled) {
        IdeAction action = icon != null ? new IdeAction(name, icon) : (strKey != null ? new IdeAction(name, bundle, strKey) : new IdeAction(name, (ArrayResourceBundle)bundle, intKey));
        action._commandId = cmdId;
        action._command = cmdClass;
        if (sCategory != null) {
            action.putValue("Category", sCategory);
        }
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        if (data != null) {
            action.putValue("UserData", data);
        }
        action.setEnabled(enabled);
        return action;
    }

    static {
        LOG = Logger.getLogger(IdeAction.class.getName());
        DEBUG = Boolean.getBoolean("ide.IdeAction.debug");
    }

    IdeAction(IdeAction ideAction, 1 var2_2) {
        this(ideAction);
    }

    private final class ControllerIterator {
        private final ArrayList<Controller> _actionControllers;
        private final Iterator<Controller> _actionControllersIter;
        private boolean _triedActionViewController;
        private int _i;
        private List _controllerStack;
        private boolean _triedIdeController;
        private Controller _curController;

        private void $init$() {
            this._actionControllers = IdeAction.this.getControllers();
            this._actionControllersIter = this._actionControllers.iterator();
        }

        boolean hasNext() {
            this.tryNext();
            return this._curController != null;
        }

        Controller next() {
            this.tryNext();
            Controller controller = this._curController;
            this._curController = null;
            return controller;
        }

        private void tryNext() {
            if (this._curController == null) {
                this._curController = this.nextImpl();
            }
        }

        private Controller nextImpl() {
            if (this._actionControllersIter.hasNext()) {
                return this._actionControllersIter.next();
            }
            View view = IdeAction.this.getView();
            if (!this._triedActionViewController) {
                Controller controller;
                this._triedActionViewController = true;
                if (view != null && (controller = view.getController()) != null) {
                    return controller;
                }
            }
            if (this._controllerStack == null) {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                IdeMainWindow.ControllerContext controllerContext = mainWindow.getControllerContext();
                this._controllerStack = controllerContext.getControllerProviders(view);
            }
            int controllerStackSize = this._controllerStack.size();
            while (this._i < controllerStackSize) {
                ControllerProvider controllerProvider;
                Controller controller;
                if ((controller = (controllerProvider = (ControllerProvider)this._controllerStack.get(this._i++)).getController()) == null) continue;
                return controller;
            }
            if (!this._triedIdeController) {
                this._triedIdeController = true;
                return Ide.getIdeController();
            }
            return null;
        }

        private ControllerIterator() {
            this.$init$();
        }

        ControllerIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Local
    extends IdeAction {
        private final IdeAction _action;
        private final View _view;

        Local(IdeAction action, View view) {
            super(action, null);
            this._action = action;
            this._view = view;
            this.setEnabled(action.isEnabled());
        }

        @Override
        public Object getValue(String key) {
            Object value = super.getValue(key);
            if (value == null) {
                value = this._action.getValue(key);
            }
            return value;
        }

        @Override
        public void putValue(String key, Object value) {
            this.putValueDirectly(key, value);
            if (this._action != null) {
                this._action.putValue(key, value);
            }
        }

        @Override
        public IdeAction newLocalAction(View view) {
            return new Local(this._action, view);
        }

        @Override
        final View getView() {
            return this._view != null ? this._view : super.getView();
        }

        @Override
        final ArrayList<Controller> getControllers() {
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            controllers.addAll(this.getControllersDirectly());
            if (this._action != null) {
                controllers.addAll(this._action.getControllersDirectly());
            }
            return controllers;
        }
    }

    public final class 1 {
    }
}

