/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.javaxide.Util;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.HashStructure;

public final class ContextMenuListenersHook
extends HashStructureHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "context-menu-listeners");
    private final Map<String, ContextMenuListener> _listeners;
    protected static final Logger LOGGER = Logger.getLogger(ContextMenuListenersHook.class.getName());

    private void $init$() {
        this._listeners = new HashMap<String, ContextMenuListener>();
    }

    ContextMenuListenersHook() {
        this.$init$();
    }

    public ContextMenuListener getListener(String siteId) {
        ContextMenuListener listener = this._listeners.get(siteId);
        if (listener == null) {
            listener = this.buildListenerForSite(siteId);
            this._listeners.put(siteId, listener);
        }
        return listener;
    }

    private ContextMenuListener buildListenerForSite(String siteId) {
        LazyContextMenuListener listener = new LazyContextMenuListener(null);
        HashStructure hs = this.getHashStructure();
        List sites = hs.getAsList("site");
        if (sites != null) {
            for (HashStructure hsSite : sites) {
                List listeners;
                String idref = hsSite.getString("idref");
                if (!idref.contains(siteId) || (listeners = hsSite.getAsList("listener-class")) == null) continue;
                for (HashStructure hsListener : listeners) {
                    LazyClassAdapter lca = LazyClassAdapter.getInstance(hsListener);
                    listener.add(lca.getMetaClass("#text"));
                }
            }
        }
        return listener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyContextMenuListener
    implements ContextMenuListener {
        private Collection<MetaClass> _metaListeners;
        private Collection<ContextMenuListener> _listenerInstances;

        private void $init$() {
            this._metaListeners = new ArrayList<MetaClass>();
            this._listenerInstances = new ArrayList<ContextMenuListener>();
        }

        public void add(MetaClass listener) {
            this._metaListeners.add(listener);
        }

        private Collection<ContextMenuListener> getListeners() {
            if (!this._metaListeners.isEmpty()) {
                PerformanceLogger logger = PerformanceLogger.get();
                for (MetaClass mc : this._metaListeners) {
                    long start = System.nanoTime();
                    try {
                        ContextMenuListener listener = Util.createInstance(mc, ContextMenuListener.class);
                        if (listener == null) continue;
                        this._listenerInstances.add(listener);
                    }
                    finally {
                        logger.log("createLazyContextMenuListener", mc.getClassName(), System.nanoTime() - start);
                    }
                }
                this._metaListeners.clear();
            }
            return this._listenerInstances;
        }

        @Override
        public void menuWillShow(ContextMenu contextMenu) {
            PerformanceLogger logger = PerformanceLogger.get();
            for (ContextMenuListener l : this.getListeners()) {
                long time = System.nanoTime();
                try {
                    try {
                        l.menuWillShow(contextMenu);
                    }
                    catch (RuntimeException re) {
                        LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                    }
                }
                finally {
                    logger.log("ContextMenuListener.menuWillShow", l.getClass().getName(), System.nanoTime() - time);
                }
            }
        }

        @Override
        public void menuWillHide(ContextMenu contextMenu) {
            for (ContextMenuListener l : this.getListeners()) {
                try {
                    l.menuWillHide(contextMenu);
                }
                catch (RuntimeException re) {
                    LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean handleDefaultAction(Context context) {
            PerformanceLogger logger = PerformanceLogger.get();
            for (ContextMenuListener l : this.getListeners()) {
                long time = System.nanoTime();
                try {
                    boolean result = l.handleDefaultAction(context);
                    if (!result) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (RuntimeException re) {
                    LOGGER.log(Level.SEVERE, "Exception in lazy context menu listener", re);
                }
                finally {
                    logger.log("ContextMenuListener.handleDefaultAction", l.getClass().getName(), System.nanoTime() - time);
                }
            }
            return false;
        }

        private LazyContextMenuListener() {
            this.$init$();
        }

        LazyContextMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

