/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.util.Pair;

public final class ContextMenu
extends MenuManager {
    private static final String CONTEXTMENU_CONTEXT = "ContextMenuContext";
    private static final String PERFKEY_MENUWILLSHOW = "oracle.ide.ContextMenu.callMenuWillShow";
    private final List<Pair<Class, ContextMenuListener>> listeners;
    private Context currentContext;
    private JPopupMenu popup;
    private MnemonicSolver mnemonicSolver;
    private final List<MenuFilter> filters;
    private Throwable menuWillShowException;

    private void $init$() {
        this.listeners = new CopyOnWriteArrayList<Pair<Class, ContextMenuListener>>();
        this.filters = new CopyOnWriteArrayList<MenuFilter>();
        this.menuWillShowException = null;
    }

    public ContextMenu() {
        this.$init$();
    }

    public ContextMenu(MnemonicSolver solver) {
        this.$init$();
        this.mnemonicSolver = solver;
    }

    public void add(Component child) {
        this.add(child, Float.MAX_VALUE);
    }

    public void add(Component child, float sectionId) {
        this.add(child, sectionId, false);
    }

    public void add(Component child, float sectionId, boolean fixed) {
        if (Ide.getMenubar().getGlobalFilter() != null && !Ide.getMenubar().getGlobalFilter().accept(child)) {
            return;
        }
        super.add(child, sectionId);
        this.addToSolver(child, fixed);
    }

    public void addContextMenuListener(ContextMenuListener l) {
        this.addContextMenuListener(l, null);
    }

    public void addContextMenuListener(ContextMenuListener l, Class cls) {
        if (l == null) {
            return;
        }
        this.listeners.add((Pair<Class, ContextMenuListener>)new Pair((Object)cls, (Object)l));
    }

    public void removeContextMenuListener(ContextMenuListener l) {
        if (l == null) {
            return;
        }
        ArrayList<Pair<Class, ContextMenuListener>> listenersToRemove = new ArrayList<Pair<Class, ContextMenuListener>>();
        for (Pair<Class, ContextMenuListener> listener : this.listeners) {
            if ((ContextMenuListener)listener.getSecond() != l) continue;
            listenersToRemove.add(listener);
        }
        this.listeners.removeAll(listenersToRemove);
    }

    public synchronized Container getGUI(boolean create) {
        if (this.popup == null && create) {
            this.popup = new JPopupMenu();
            this.popup.putClientProperty("menu-addin-section-id", new Float(MenuConstants.SECTION_ADDITIONAL_CTXT_MENU));
            this.popup.addContainerListener(this._containerListener);
            this.popup.addPopupMenuListener(new 1());
        }
        return this.popup;
    }

    public int getMenuCount() {
        return this.getGUI(true).getComponentCount();
    }

    public void removeAll() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
    }

    public final void show(Context context) {
        EventObject eventObject = context.getEvent();
        MouseEvent event = (MouseEvent)eventObject;
        this.prepareShow(context);
        if (this.popup.getComponentCount() == 0) {
            return;
        }
        Component popupParent = (Component)event.getSource();
        Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)this.popup, (MouseEvent)event);
        this.popup.show(popupParent, showPoint.x, showPoint.y);
    }

    public final void prepareShow(Context context) {
        this.currentContext = new Context(context);
        this.getGUI(true);
        this.removeAll();
        this.callMenuWillShow();
        MenuManager.updatePopupMenuItems(this.popup, this.currentContext);
        this.popup.putClientProperty(CONTEXTMENU_CONTEXT, this.currentContext);
    }

    private void applyFilters(JPopupMenu popup) {
        if (!this.filters.isEmpty()) {
            this.applyFiltersImpl(popup);
        }
    }

    private void applyFiltersImpl(Container container) {
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        int i = 0;
        while (i < container.getComponentCount()) {
            Component component = container.getComponent(i);
            if (ContextMenu.isMenuComponentAccepted(component, this.filters)) {
                if (component instanceof Container && ((Container)component).getComponentCount() > 0) {
                    this.applyFiltersImpl((Container)component);
                }
            } else {
                componentsToRemove.add(component);
            }
            ++i;
        }
        for (Component component : componentsToRemove) {
            container.remove(component);
        }
    }

    public final Context getContext() {
        return this.currentContext;
    }

    static Context getContext(JMenuItem menuItem, EventObject e) {
        Context ctx = null;
        Container item = menuItem;
        while (item != null) {
            if (item instanceof JPopupMenu || item instanceof JMenuBar) {
                JComponent menu = item;
                ctx = (Context)menu.getClientProperty(CONTEXTMENU_CONTEXT);
                if (ctx == null) break;
                ctx.setEvent(e);
                break;
            }
            item = item.getParent();
        }
        return ctx;
    }

    static void clearContext(JMenuItem menuItem) {
        Container item = menuItem;
        while (item != null) {
            if (item instanceof JPopupMenu || item instanceof JMenuBar) {
                JComponent menu = item;
                menu.putClientProperty(CONTEXTMENU_CONTEXT, null);
                break;
            }
            item = item.getParent();
        }
    }

    public void addSeparator() {
        int cnt = this.popup.getComponentCount();
        if (cnt > 0 && this.popup.getComponent(cnt - 1) instanceof JPopupMenu.Separator) {
            return;
        }
        this.popup.add(new JPopupMenu.Separator());
    }

    public boolean fireDefaultAction(Context context) {
        Element ctxElem = ContextMenu.getContextElement(context);
        Class ctxClass = ContextMenu.getElementDataClass(ctxElem);
        for (Pair<Class, ContextMenuListener> listenerHolder : this.listeners) {
            ContextMenuListener listener = (ContextMenuListener)listenerHolder.getSecond();
            Class cls = (Class)listenerHolder.getFirst();
            if (cls != null && (context == null || ctxElem == null || cls != ctxClass)) continue;
            long time = System.nanoTime();
            boolean handled = listener.handleDefaultAction(context);
            PerformanceLogger.get().log("ContextMenuListener.handleDefaultAction", listener.getClass().getName(), System.nanoTime() - time);
            if (!handled) continue;
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_ACTION_PERFORMED);
            return true;
        }
        return false;
    }

    public MnemonicSolver getMnemonicSolver() {
        return this.mnemonicSolver;
    }

    public static Element unwrapDecoratedElement(Element elem) {
        if (elem != null) {
            int decorationLevel = 0;
            while (elem.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT) && decorationLevel++ < 15) {
                Object data = elem.getData();
                if (data == elem || !(data instanceof Element)) break;
                elem = (Element)data;
            }
        }
        return elem;
    }

    private static final Element getContextElement(Context context) {
        if (context != null) {
            Element elem = context.getElement();
            return ContextMenu.unwrapDecoratedElement(elem);
        }
        return null;
    }

    private static final Class getElementDataClass(Element elem) {
        Object data;
        if (elem != null && (data = elem.getData()) != null) {
            return data.getClass();
        }
        return null;
    }

    private static final Class getContextElementClass(Context context) {
        Element elem = ContextMenu.getContextElement(context);
        return ContextMenu.getElementDataClass(elem);
    }

    private void callMenuWillShow() {
        this.menuWillShowException = null;
        Class ctxClass = ContextMenu.getContextElementClass(this.currentContext);
        this.clearMnemonics();
        for (Pair<Class, ContextMenuListener> holder : this.listeners) {
            Class cls = (Class)holder.getFirst();
            if (cls != null && (ctxClass == null || !cls.isAssignableFrom(ctxClass))) continue;
            ContextMenuListener listener = (ContextMenuListener)holder.getSecond();
            this.invokeMenuWillShow(listener);
        }
        this.applyFilters(this.popup);
        this.solveMnemonics();
        this.sortContainer(this.popup);
    }

    private void clearMnemonics() {
        if (this.mnemonicSolver != null) {
            this.mnemonicSolver.clear();
        }
    }

    private void solveMnemonics() {
        if (!this.listeners.isEmpty() && this.mnemonicSolver != null) {
            this.mnemonicSolver.solve();
        }
    }

    private void invokeMenuWillShow(ContextMenuListener listener) {
        try {
            long time = System.nanoTime();
            listener.menuWillShow(this);
            PerformanceLogger.get().log("ContextMenuListener.menuWillShow", listener.getClass().getName(), System.nanoTime() - time);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.menuWillShowException = t;
        }
    }

    private void callMenuWillHide() {
        this.reportMenuWillShowException();
        Class ctxClass = ContextMenu.getContextElementClass(this.currentContext);
        for (Pair<Class, ContextMenuListener> holder : this.listeners) {
            Class cls = (Class)holder.getFirst();
            ContextMenuListener listener = null;
            if (cls == null || ctxClass != null && cls.isAssignableFrom(ctxClass)) {
                this.invokeMenuWillHide((ContextMenuListener)holder.getSecond());
            }
            listener = (ContextMenuListener)holder.getSecond();
        }
    }

    private void reportMenuWillShowException() {
        if (this.menuWillShowException == null) {
            return;
        }
        FeedbackManager.reportException(this.menuWillShowException);
        this.menuWillShowException = null;
    }

    private void invokeMenuWillHide(ContextMenuListener listener) {
        try {
            long time = System.nanoTime();
            listener.menuWillHide(this);
            PerformanceLogger.get().log("ContextMenuListener.menuWillHide", listener.getClass().getName(), System.nanoTime() - time);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            FeedbackManager.reportException(t);
        }
    }

    private void addToSolver(Component component, boolean fixed) {
        if (this.mnemonicSolver == null) {
            return;
        }
        this.mnemonicSolver.addMenuLabel(component, fixed);
    }

    public final void addMenuFilter(MenuFilter menuFilter) {
        if (menuFilter == null) {
            throw new NullPointerException("menuFilter is null");
        }
        if (!this.filters.contains(menuFilter)) {
            this.filters.add(menuFilter);
        }
    }

    public final void removeMenuFilter(MenuFilter menuFilter) {
        this.filters.remove(menuFilter);
    }

    static void mav$callMenuWillHide(ContextMenu contextMenu) {
        contextMenu.callMenuWillHide();
    }

    static void wa$currentContext(ContextMenu contextMenu, Context context) {
        contextMenu.currentContext = context;
    }

    final class 1
    implements PopupMenuListener {
        public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ContextMenu.mav$callMenuWillHide(ContextMenu.this);
            ContextMenu.wa$currentContext(ContextMenu.this, null);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public final void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

