/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.HistoryGeneratingCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.resource.IdeArb;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

public final class CommandProcessor
implements Observer {
    private static final boolean DIAGNOSTICS_TO_CONSOLE = false;
    private Map _undoStacks;
    private MasterStack _masterStack;
    private int _batchLevel;
    private Thread _batchThread;
    private boolean _aborted;
    private BatchCommand _batchCommand;
    private static final CommandProcessor _INSTANCE = new CommandProcessor();
    private static final int _COMPOUND_COMMAND_ID = Ide.findOrCreateCmdID(CompoundCommand.class.getName());
    private static final int _COMMAND_PART_ID = Ide.findOrCreateCmdID(CommandPart.class.getName());

    private void $init$() {
        this._undoStacks = new HashMap();
        this._masterStack = new MasterStack(null);
        this._batchThread = null;
    }

    public static CommandProcessor getInstance() {
        return _INSTANCE;
    }

    private CommandProcessor() {
        this.$init$();
        EnvironOptions environOptions = EnvironOptions.getInstance(Preferences.getPreferences());
        environOptions.addChangeListener(new 1());
        this.whenUndoStackChanges(environOptions);
    }

    private void diagnostic(String message) {
        if (FeedbackManager.isOn()) {
            FeedbackManager.addFeedback(message);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int invoke(Command cmd) throws Exception {
        Context context = cmd.getContext();
        boolean alreadyInProgress = IdeAction.handlerStarting();
        if (FeedbackManager.isOn()) {
            String commandName = cmd.getName();
            if (commandName == null) {
                commandName = cmd.getClass().getName();
            }
            FeedbackManager.addFeedback("Invoking command: " + commandName, context);
        }
        try {
            int status;
            switch (cmd.getType()) {
                case 0: {
                    UndoStack stack = this.getUndoStack(context);
                    if (stack != null) {
                        boolean affectedNodes;
                        if (cmd instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        }
                        if (this._batchLevel == 0) {
                            status = this._masterStack.doit(cmd, stack);
                            break;
                        }
                        Object[] nodes = cmd.getAffectedNodes();
                        boolean matchingThread = Thread.currentThread() == this._batchThread;
                        boolean bl = affectedNodes = nodes != null && nodes.length > 0;
                        if (matchingThread && !affectedNodes) {
                            status = this._batchCommand.add(cmd);
                            break;
                        }
                        String batchCommandName = this._batchCommand.getName();
                        if (affectedNodes) {
                            this._masterStack.disable("Command " + cmd + " has affected nodes: " + Arrays.toString(nodes) + ". Current batch command: " + batchCommandName);
                        } else {
                            this._masterStack.disable("Command " + cmd + " invoked on thread " + Thread.currentThread() + ". Does not match batch thread " + this._batchThread + ". Current batch command: " + batchCommandName);
                        }
                        status = cmd.doit();
                        break;
                    }
                }
                case 2: {
                    UndoStack stack = this.findUndoStack(context);
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    if (this._batchLevel > 0) {
                        this._masterStack.disable();
                    }
                    if ((status = cmd.doit()) != 0) break;
                    if (stack != null) {
                        stack.flush();
                    }
                    this.flush(cmd.getAffectedNodes());
                    break;
                }
                case 3: {
                    if (this._batchLevel == 0) {
                        cmd = new CompoundCommand(cmd);
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                        status = this._masterStack.doit(cmd, null);
                        break;
                    }
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    if (Thread.currentThread() == this._batchThread) {
                        status = this._batchCommand.add(cmd);
                        break;
                    }
                    this._masterStack.disable();
                    status = cmd.doit();
                    break;
                }
                case 1: {
                    if (cmd instanceof HistoryGeneratingCommand) {
                        this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                    }
                    status = cmd.doit();
                    break;
                }
                default: {
                    throw new Exception("Unrecognized Command type");
                }
            }
            if (status == 0) {
                if (cmd instanceof HistoryGeneratingCommand) {
                    this.persistHistoricalEvent((HistoryGeneratingCommand)((Object)cmd));
                }
                NavigationManager mgr = NavigationManager.getNavigationManager();
                Context ctx = cmd.getContext();
                if (mgr != null) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new 2(this, mgr, ctx));
                    } else {
                        mgr.setLastEdit(ctx);
                    }
                }
            }
            int n = status;
            return n;
        }
        catch (Exception e) {
            FeedbackManager.reportException("Exception while processing command " + cmd.getName(), e);
            throw e;
            catch (Error e2) {
                FeedbackManager.reportException("Error while processing command " + cmd.getName(), e2);
                throw e2;
            }
        }
        finally {
            IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_ACTION_PERFORMED);
        }
    }

    public final int undo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            FeedbackManager.reportException(new IllegalStateException("Attempting to undo while still in batch mode!"));
            return 1;
        }
        if (context == null) {
            return this._masterStack.undo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && this._batchLevel == 0 ? stack.undo() : 1;
    }

    public final int redo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            IllegalStateException e = new IllegalStateException("Attempting to redo while still in batch mode!");
            e.printStackTrace();
            return 1;
        }
        if (context == null) {
            return this._masterStack.redo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null && this._batchLevel == 0 ? stack.redo() : 1;
    }

    public boolean canUndo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canUndo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canUndo(null) : false;
    }

    public String getUndoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getUndoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getUndoLabel() : "";
    }

    public Command getCommand(Context context) {
        try {
            UndoStack stack = this.findUndoStack(context);
            Command command = stack != null ? stack.peek(0) : null;
            return command;
        }
        catch (Exception e) {
            Command command = null;
            return command;
        }
    }

    public boolean canRedo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canRedo();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.canRedo(null) : false;
    }

    public String getRedoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getRedoLabel();
        }
        UndoStack stack = this.findUndoStack(context);
        return stack != null ? stack.getRedoLabel() : "";
    }

    public void flush(Object object) {
        UndoStack undoStack = (UndoStack)this._undoStacks.get(object);
        if (undoStack != null) {
            undoStack.flush();
        }
        this._undoStacks.remove(object);
    }

    public void flush(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            this.flush(objects[i]);
            ++i;
        }
    }

    public void beginTrans(String label) {
        ++this._batchLevel;
        this.diagnostic("Started CommandProcessor transaction: " + label + " on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 1) {
            this._batchCommand = new BatchCommand(label);
            this._batchThread = Thread.currentThread();
        }
    }

    public void endTrans() {
        --this._batchLevel;
        this.diagnostic("Finished CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 0) {
            this._batchThread = null;
            if (this._masterStack.isEnabled()) {
                try {
                    this._masterStack.doit(this._batchCommand, null);
                    this._batchCommand = null;
                }
                catch (Exception e) {
                    FeedbackManager.reportException(e);
                }
            } else {
                this._masterStack.enable();
            }
        }
    }

    public void abortTrans() {
        --this._batchLevel;
        this.diagnostic("Aborted CommandProcessor transaction on thread " + Thread.currentThread().getName() + " at batch level " + this._batchLevel);
        if (this._batchLevel == 0) {
            this._batchCommand.abort();
            this._batchCommand = null;
            this._batchThread = null;
            this._aborted = false;
        } else {
            this._aborted = true;
        }
    }

    public boolean isTransactionActive() {
        return this._batchLevel > 0;
    }

    public void update(Object observed, UpdateMessage change) {
        UndoStack stack;
        if (change != null && change.getMessageID() == NodeFactory.NODE_UNCACHED && (stack = (UndoStack)this._undoStacks.get(observed)) != null) {
            stack.release();
            this._undoStacks.remove(observed);
        }
    }

    private UndoStack findUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return (UndoStack)this._undoStacks.get(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return this.getUndoStack(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Node key) {
        if (key == null) {
            return null;
        }
        UndoStack undoStack = (UndoStack)this._undoStacks.get(key);
        if (undoStack == null) {
            undoStack = new UndoStack(key);
            undoStack.addUndoStackListener(this._masterStack);
            this._undoStacks.put(key, undoStack);
            NodeFactory.attach(this, key.getClass());
        }
        return undoStack;
    }

    private void preprocessHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                urls[i] = nodes[i].getURL();
                ++i;
            }
            try {
                mgr.persistInitialState(urls);
                if (cmd.isGeneratePrecedingState()) {
                    ArrayList<URL> list = new ArrayList<URL>();
                    int i2 = 0;
                    while (i2 < nodes.length) {
                        if (nodes[i2].isDirty()) {
                            list.add(nodes[i2].getURL());
                        }
                        ++i2;
                    }
                    int size = list.size();
                    if (size > 0) {
                        urls = new URL[size];
                        list.toArray(urls);
                        mgr.persist(urls, null);
                    }
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void persistHistoricalEvent(HistoryGeneratingCommand cmd) {
        Node[] nodes = cmd.getHistoriedNodes();
        HistoryManager mgr = HistoryManager.getHistoryManager();
        if (mgr != null) {
            URL[] urls = new URL[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                urls[i] = nodes[i].getURL();
                ++i;
            }
            try {
                mgr.persist(urls, cmd.getName());
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void whenUndoStackChanges(EnvironOptions environOptions) {
        this._masterStack.setStackSize(environOptions.getUndoLevel());
    }

    public static Command createCommand(String cmd, Context context) {
        Command newCmd = null;
        if (cmd != null) {
            try {
                Class<?> cls = Class.forName(cmd);
                newCmd = (Command)cls.newInstance();
                newCmd.setContext(context);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        return newCmd;
    }

    private static Node getSingleNodeOrNull(Context context) {
        if (!CommandProcessor.areMultipleNodesSelected(context)) {
            return context.getNode();
        }
        return null;
    }

    private static boolean areMultipleNodesSelected(Context context) {
        int n;
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 1 && (n = selection.length) > 1) {
            int cnt = 0;
            int i = 0;
            while (i < n) {
                if (selection[i] instanceof Node && ++cnt > 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static UndoStack mav$getUndoStack(CommandProcessor commandProcessor, Context context) {
        return commandProcessor.getUndoStack(context);
    }

    static UndoStack mav$findUndoStack(CommandProcessor commandProcessor, Context context) {
        return commandProcessor.findUndoStack(context);
    }

    static UndoStack mav$getUndoStack(CommandProcessor commandProcessor, Node node) {
        return commandProcessor.getUndoStack(node);
    }

    static int ra$_COMPOUND_COMMAND_ID() {
        return _COMPOUND_COMMAND_ID;
    }

    static int ra$_COMMAND_PART_ID() {
        return _COMMAND_PART_ID;
    }

    static void mav$whenUndoStackChanges(CommandProcessor commandProcessor, EnvironOptions environOptions) {
        commandProcessor.whenUndoStackChanges(environOptions);
    }

    final class oracle.ide.controller.CommandProcessor$1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            EventQueue.invokeLater(new 1(this, e));
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ ChangeEvent v$e;
            final /* synthetic */ oracle.ide.controller.CommandProcessor$1 this$0;

            public void run() {
                CommandProcessor.mav$whenUndoStackChanges(this.this$0.CommandProcessor.this, (EnvironOptions)((Object)this.v$e.getSource()));
            }

            public 1(oracle.ide.controller.CommandProcessor$1 var1_1, ChangeEvent changeEvent) {
                this.v$e = changeEvent;
                this.this$0 = var1_1;
            }
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ NavigationManager v$mgr;
        private final /* synthetic */ Context v$ctx;
        final /* synthetic */ CommandProcessor this$0;

        public void run() {
            this.v$mgr.setLastEdit(this.v$ctx);
        }

        public 2(CommandProcessor commandProcessor, NavigationManager navigationManager, Context context) {
            this.v$ctx = context;
            this.v$mgr = navigationManager;
            this.this$0 = commandProcessor;
        }
    }

    private static final class UndoStack
    extends NodeListener {
        static final int DONE = 0;
        static final int UNDONE = 1;
        private Stack _doneStack;
        private Stack _undoneStack;
        private List _listeners;
        private Node _node;
        private int _timestamp;

        UndoStack(Node node) {
            this._node = node;
            node.addNodeListener(this);
            this._doneStack = new Stack();
            this._undoneStack = new Stack();
            this._listeners = new ArrayList();
        }

        int doit(Command cmd) throws Exception {
            int status;
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                this.checkTimestamp();
            }
            if ((status = this.executeCommand(cmd)) == 0) {
                this._doneStack.push(cmd);
                this.trim(1, 0);
            }
            return status;
        }

        boolean canUndo(Command cmd) {
            if (!this._doneStack.isEmpty()) {
                return cmd == null || this._doneStack.get(this._doneStack.size() - 1) == cmd;
            }
            return false;
        }

        String getUndoLabel() {
            Command cmd = !this._doneStack.isEmpty() ? (Command)this._doneStack.get(this._doneStack.size() - 1) : null;
            return cmd != null ? cmd.getName() : "";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int undo() throws Exception {
            int n;
            block10: {
                boolean alreadyInProgress = Ide.isQuitting();
                Command cmd = null;
                int status = 1;
                try {
                    try {
                        cmd = this.peek(0);
                        if (cmd != null) {
                            alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                            status = cmd.undo();
                            if (status == 0 && this._undoneStack != null && this._doneStack != null) {
                                this._undoneStack.push(this._doneStack.pop());
                            }
                        }
                        n = status;
                        return n;
                    }
                    finally {
                        if (cmd == null) break block10;
                        IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                    }
                }
                catch (ExternalModificationException e) {
                    int n2;
                    block11: {
                        n2 = status;
                        if (cmd == null) break block11;
                        IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                    }
                    return n2;
                }
            }
            return n;
        }

        boolean canRedo(Command cmd) {
            if (!this._undoneStack.isEmpty()) {
                return cmd == null || this._undoneStack.get(this._undoneStack.size() - 1) == cmd;
            }
            return false;
        }

        String getRedoLabel() {
            Command cmd = !this._undoneStack.isEmpty() ? (Command)this._undoneStack.get(this._undoneStack.size() - 1) : null;
            return cmd != null ? cmd.getName() : null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int redo() throws Exception {
            int n;
            block10: {
                boolean alreadyInProgress = Ide.isQuitting();
                Command cmd = null;
                int status = 1;
                try {
                    try {
                        cmd = this.peek(1);
                        if (cmd != null) {
                            alreadyInProgress = alreadyInProgress || IdeAction.handlerStarting();
                            status = this.executeCommand(cmd);
                            if (status == 0) {
                                this._doneStack.push(this._undoneStack.pop());
                            }
                        }
                        n = status;
                        return n;
                    }
                    finally {
                        if (cmd == null) break block10;
                        IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                    }
                }
                catch (ExternalModificationException e) {
                    int n2;
                    block11: {
                        n2 = status;
                        if (cmd == null) break block11;
                        IdeAction.handlerFinished(alreadyInProgress, Controller.UPDATE_FROM_UNDO);
                    }
                    return n2;
                }
            }
            return n;
        }

        int executeCommand(Command cmd) throws Exception {
            int status = cmd.doit();
            if (status == 0) {
                CommandProcessor.getInstance().flush(cmd.getAffectedNodes());
            }
            return status;
        }

        boolean isDone(Command cmd) {
            if (!this._doneStack.isEmpty()) {
                return this._doneStack.contains(cmd);
            }
            return false;
        }

        boolean isUndone(Command cmd) {
            if (!this._undoneStack.isEmpty()) {
                return this._undoneStack.contains(cmd);
            }
            return false;
        }

        Command peek(int state) throws Exception {
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                this.checkTimestamp();
            }
            Stack stack = state == 0 ? this._doneStack : this._undoneStack;
            return !stack.isEmpty() ? (Command)stack.lastElement() : null;
        }

        void flush() {
            this.trim(0, 0);
            this.trim(1, 0);
        }

        void flush(Command cmd) {
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                try {
                    this.checkTimestamp();
                }
                catch (ExternalModificationException e) {
                    return;
                }
                catch (Exception e) {
                    this.flush();
                }
                int index = this._undoneStack.indexOf(cmd);
                if (index >= 0) {
                    this.trim(1, this._undoneStack.size() - ++index);
                } else {
                    index = this._doneStack.indexOf(cmd);
                    if (index >= 0) {
                        this.trim(0, this._doneStack.size() - ++index);
                    }
                }
            }
        }

        void trim(int state, int size) {
            Stack stack;
            Stack stack2 = stack = state == 0 ? this._doneStack : this._undoneStack;
            if (stack != null && stack.size() > size) {
                List sublist = stack.subList(0, stack.size() - size);
                Command[] commands = new Command[sublist.size()];
                sublist.toArray(commands);
                int i = 0;
                while (i < commands.length) {
                    stack.remove(commands[i]);
                    ++i;
                }
                this.fireCommandsDropped(new UndoStackEvent(this, commands));
            }
        }

        void release() {
            this.flush();
            this._doneStack = null;
            this._undoneStack = null;
            this._listeners.clear();
            this._listeners = null;
            this._node = null;
            this._timestamp = -1;
        }

        void addUndoStackListener(UndoStackListener listener) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }

        void removeUndoStackListener(UndoStackListener listener) {
            this._listeners.remove(listener);
        }

        void fireCommandsDropped(UndoStackEvent e) {
            UndoStackListener[] listeners = new UndoStackListener[this._listeners.size()];
            this._listeners.toArray(listeners);
            if (listeners != null) {
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].commandsDropped(e);
                    ++i;
                }
            }
        }

        public void nodeOpened(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof TextNode) {
                int timestamp;
                TextBuffer buffer = ((TextNode)node).acquireTextBuffer();
                int n = timestamp = buffer != null ? buffer.getChangeId() : -1;
                if (this._timestamp != timestamp) {
                    this._timestamp = timestamp;
                    this.flush();
                }
            }
        }

        public void nodeClosing(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof TextNode) {
                TextBuffer buffer = ((TextNode)node).acquireTextBuffer();
                this._timestamp = buffer != null ? buffer.getChangeId() : -1;
            } else {
                this.flush();
            }
        }

        void checkTimestamp() throws Exception {
            if (this._node instanceof TextNode && !this._node.isOpen() && (this._doneStack.size() > 0 || this._undoneStack.size() > 0)) {
                int timestamp = this._timestamp;
                this._node.ensureOpen();
                if (timestamp != this._timestamp) {
                    throw new ExternalModificationException();
                }
            }
        }

        static Stack ra$_undoneStack(UndoStack undoStack) {
            return undoStack._undoneStack;
        }

        static Stack ra$_doneStack(UndoStack undoStack) {
            return undoStack._doneStack;
        }
    }

    private static interface UndoStackListener {
        public void commandsDropped(UndoStackEvent var1);
    }

    private static final class UndoStackEvent
    extends EventObject {
        private Command[] _commands;

        public UndoStackEvent(Object source, Command[] commands) {
            super(source);
            this._commands = commands;
        }

        public Command[] getCommands() {
            return this._commands;
        }
    }

    private static final class MasterStack
    implements UndoStackListener {
        private int _maxSize;
        @GuardedBy(value="this")
        private boolean _enabled;
        private ArrayList _commandStackPairs;

        private void $init$() {
            this._enabled = true;
            this._commandStackPairs = new ArrayList();
        }

        int doit(Command cmd, UndoStack stack) throws Exception {
            int status;
            int n = status = stack != null ? stack.doit(cmd) : cmd.doit();
            if (status == 0) {
                this._commandStackPairs.add(cmd);
                this._commandStackPairs.add(stack);
                this.trim();
            }
            return status;
        }

        boolean canUndo() {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) {
                            return true;
                        }
                    } else if (stack.isDone(cmd)) {
                        return stack.canUndo(cmd);
                    }
                }
                i -= 2;
            }
            return false;
        }

        String getUndoLabel() {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) {
                            return cmd.getName();
                        }
                    } else if (stack.isDone(cmd)) {
                        return stack.canUndo(cmd) ? cmd.getName() : "";
                    }
                }
                i -= 2;
            }
            return "";
        }

        int undo() throws Exception {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (((CompoundCommand)cmd).isDone()) {
                            return cmd.undo();
                        }
                    } else if (stack.isDone(cmd)) {
                        boolean confirmed = Ide.getIdeArgs().getCreateUI() ^ true;
                        if (!confirmed) {
                            confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(327, new String[]{cmd.getName()}), (String)IdeArb.getString(469), null);
                        }
                        if (confirmed) {
                            return stack.canUndo(cmd) ? stack.undo() : 1;
                        }
                        return 1;
                    }
                }
                i -= 2;
            }
            return 1;
        }

        boolean canRedo() {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) {
                            return true;
                        }
                    } else if (stack.isUndone(cmd)) {
                        return stack.canRedo(cmd);
                    }
                }
                i -= 2;
            }
            return false;
        }

        String getRedoLabel() {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) {
                            return cmd.getName();
                        }
                    } else if (stack.isUndone(cmd)) {
                        return stack.canRedo(cmd) ? cmd.getName() : "";
                    }
                }
                i -= 2;
            }
            return "";
        }

        int redo() throws Exception {
            int i = this._commandStackPairs.size() - 2;
            while (i >= 0) {
                Command cmd = (Command)this._commandStackPairs.get(i);
                if (cmd.isGlobal()) {
                    UndoStack stack = (UndoStack)this._commandStackPairs.get(i + 1);
                    if (stack == null) {
                        if (!((CompoundCommand)cmd).isDone()) {
                            return cmd.doit();
                        }
                    } else if (stack.isUndone(cmd)) {
                        boolean confirmed = Ide.getIdeArgs().getCreateUI() ^ true;
                        if (!confirmed) {
                            confirmed = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(233, new String[]{cmd.getName()}), (String)IdeArb.getString(371), null);
                        }
                        if (confirmed) {
                            return stack.canRedo(cmd) ? stack.redo() : 1;
                        }
                        return 1;
                    }
                }
                i -= 2;
            }
            return 1;
        }

        int getStackSize() {
            return this._maxSize;
        }

        void setStackSize(int size) {
            if (!this.isEnabled()) {
                return;
            }
            if (size >= 0) {
                this._maxSize = size;
                this.trim();
                IdeAction action = IdeAction.find(5);
                if (action != null) {
                    Ide.getIdeController().update(action, null);
                }
                if ((action = IdeAction.find(6)) != null) {
                    Ide.getIdeController().update(action, null);
                }
            }
        }

        synchronized void enable() {
            if (this._enabled) {
                return;
            }
            this._enabled = true;
            this.showEnabledDialog(true);
            this.setStackSize(EnvironOptions.getInstance(Preferences.getPreferences()).getUndoLevel());
        }

        synchronized void disable(String reason) {
            if (!this._enabled) {
                return;
            }
            this._enabled = false;
            FeedbackManager.reportException(new IllegalStateException(reason));
            this.showEnabledDialog(false);
            this.setStackSize(0);
        }

        synchronized void disable() {
            this.disable("Cannot invoke Command from other thread, or with non undoable side effects, while in batch mode\nDisabling Undo support until batch completed.");
        }

        synchronized boolean isEnabled() {
            return this._enabled;
        }

        void showEnabledDialog(boolean enabled) {
            try {
                new 1(this, enabled).run();
            }
            catch (ClosureException closureException) {
                // empty catch block
            }
        }

        void trim() {
            int currentSize = this._commandStackPairs.size();
            while (currentSize / 2 > this._maxSize) {
                Command cmd = (Command)this._commandStackPairs.get(0);
                UndoStack stack = (UndoStack)this._commandStackPairs.get(1);
                if (stack == null) {
                    CompoundCommand wrapper = (CompoundCommand)cmd;
                    boolean isDone = wrapper.isDone();
                    Collection<CommandPart> parts = wrapper.getParts();
                    Iterator<CommandPart> i = parts.iterator();
                    while (stack == null && i.hasNext()) {
                        CommandPart part = i.next();
                        if (part.isDeletion()) {
                            if (isDone || (stack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), part.getContext())) == null) continue;
                            cmd = part;
                            continue;
                        }
                        if (part.isAddition()) {
                            if (!isDone || (stack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), part.getContext())) == null) continue;
                            cmd = part;
                            continue;
                        }
                        stack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), part.getContext());
                        if (stack == null) continue;
                        cmd = part;
                    }
                }
                if (stack != null) {
                    stack.flush(cmd);
                } else {
                    this.commandsDropped(new UndoStackEvent(this, new Command[]{cmd}));
                }
                currentSize = this._commandStackPairs.size();
            }
        }

        public void commandsDropped(UndoStackEvent e) {
            Command[] cmds;
            Command[] commandArray = cmds = e != null ? e.getCommands() : null;
            if (cmds != null) {
                int i = 0;
                while (i < cmds.length) {
                    Command cmd = cmds[i];
                    int index = this._commandStackPairs.indexOf(cmd);
                    if (index < 0 && cmd instanceof CommandPart) {
                        cmd = CommandPart.ra$_owner((CommandPart)cmd);
                        index = this._commandStackPairs.indexOf(cmd);
                    }
                    if (index >= 0) {
                        this._commandStackPairs.remove(index);
                        this._commandStackPairs.remove(index);
                    }
                    ++i;
                }
            }
        }

        private MasterStack() {
            this.$init$();
        }

        MasterStack(1 var1_1) {
            this();
        }

        final class 1
        extends SwingClosure {
            private final /* synthetic */ boolean v$enabled;
            final /* synthetic */ MasterStack this$0;

            protected void runImpl() {
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)(this.v$enabled ? IdeArb.getString(61) : IdeArb.getString(221)), (String)IdeArb.format(469, ""), null);
            }

            public 1(MasterStack masterStack, boolean bl) {
                this.v$enabled = bl;
                this.this$0 = masterStack;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundCommand
    extends Command
    implements HistoryGeneratingCommand,
    UndoStackListener {
        private List _historied;
        private boolean _working;
        private boolean _adjusted;
        protected boolean _firstTime;
        protected boolean _done;
        protected Map<Node, CommandPart> _parts;
        protected Command[] _commands;

        private void $init$() {
            this._firstTime = true;
        }

        CompoundCommand(Command cmd) {
            super(CommandProcessor.ra$_COMPOUND_COMMAND_ID(), 1, cmd.getName());
            this.$init$();
            this.setContext(cmd.getContext());
            this._commands = new Command[]{cmd};
        }

        protected CompoundCommand(String name) {
            super(CommandProcessor.ra$_COMPOUND_COMMAND_ID(), 1, name);
            this.$init$();
            this._commands = new Command[0];
        }

        boolean isWorking() {
            return this._working;
        }

        boolean isDone() {
            return this._done;
        }

        @Override
        public boolean isGlobal() {
            return this.getParts().size() > 1;
        }

        @Override
        public int doit() throws Exception {
            return this.doit(null);
        }

        int doit(CommandPart srcPart) throws Exception {
            if (!this.canDo()) {
                CompoundCommand.showErrorMessage(false);
                return 1;
            }
            boolean isRedo = this._firstTime ^ true;
            if (isRedo && Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.redoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(233, new String[]{this.getName()}), (String)IdeArb.format(371, new String[]{""}), (String)"f1_javaappdevgeneric_redo_html")) {
                return 1;
            }
            int status = this.doCommands();
            if (status == 0) {
                try {
                    this._working = true;
                    this.adjustParts();
                    CommandProcessor cp = CommandProcessor.getInstance();
                    ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
                    for (CommandPart part : list) {
                        if (part == srcPart || part.isDeletion()) continue;
                        try {
                            Context ctx = part.getContext();
                            UndoStack undoStack = CommandProcessor.mav$getUndoStack(cp, ctx);
                            if (isRedo) {
                                if (part.isAddition()) {
                                    undoStack.flush();
                                    UndoStack.ra$_doneStack(undoStack).add(part);
                                    continue;
                                }
                                undoStack.redo();
                                continue;
                            }
                            undoStack.doit(part);
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return status;
        }

        protected boolean canDo() {
            ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
            for (CommandPart part : list) {
                if (CompoundCommand.canDo(part)) continue;
                return false;
            }
            return true;
        }

        private static boolean canDo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isAddition()) {
                return true;
            }
            UndoStack stack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), cmd.getContext());
            if (stack != null) {
                if (stack.isUndone(cmd)) {
                    try {
                        stack.checkTimestamp();
                    }
                    catch (Exception e) {
                        boolean bl = false;
                        return bl;
                    }
                    return stack.canRedo(cmd);
                }
                return stack.isDone(cmd) ^ true;
            }
            return false;
        }

        @Override
        public int undo() throws Exception {
            return this.undo(null);
        }

        int undo(CommandPart srcPart) throws Exception {
            ArrayList<CommandPart> list = new ArrayList<CommandPart>(this.getParts());
            for (CommandPart part : list) {
                if (CompoundCommand.canUndo(part)) continue;
                CompoundCommand.showErrorMessage(true);
                return 1;
            }
            if (Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.undoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(327, new String[]{this.getName()}), (String)IdeArb.format(469, new String[]{""}), (String)"f1_javaappdevgeneric_undo_html")) {
                return 1;
            }
            int status = this.undoCommands();
            if (status == 0) {
                try {
                    this._working = true;
                    list = new ArrayList<CommandPart>(this.getParts());
                    CommandProcessor cp = CommandProcessor.getInstance();
                    for (CommandPart part : list) {
                        if (part == srcPart || part.isAddition()) continue;
                        try {
                            UndoStack undoStack = CommandProcessor.mav$getUndoStack(cp, part.getContext());
                            if (part.isDeletion()) {
                                undoStack.flush();
                                UndoStack.ra$_undoneStack(undoStack).add(part);
                                continue;
                            }
                            undoStack.undo();
                        }
                        catch (Exception e) {
                            status = 1;
                        }
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return status;
        }

        private static boolean canUndo(CommandPart cmd) {
            if (cmd == null) {
                return false;
            }
            if (cmd.isDeletion()) {
                return true;
            }
            UndoStack stack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), cmd.getContext());
            if (stack != null) {
                try {
                    stack.checkTimestamp();
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
            }
            return stack != null && stack.canUndo(cmd);
        }

        /*
         * Unable to fully structure code
         */
        protected int doCommands() throws Exception {
            i = 0;
            while (i < this._commands.length) {
                block10: {
                    try {
                        if (this._commands[i].doit() != 0) {
                            while (--i >= 0) {
                                try {
                                    this._commands[i].undo();
                                }
                                catch (Exception var2_2) {
                                    // empty catch block
                                }
                            }
                            var5_3 = 1;
                            return var5_3;
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        ** while (--i >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._commands[i].undo();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        continue;
                    }
lbl25:
                    // 1 sources

                    throw e;
                }
                ++i;
            }
            this._firstTime = false;
            this._done = true;
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        protected int undoCommands() throws Exception {
            i = this._commands.length - 1;
            while (i >= 0) {
                block10: {
                    try {
                        if (this._commands[i].undo() != 0) {
                            while (++i < this._commands.length) {
                                try {
                                    this._commands[i].doit();
                                }
                                catch (Exception var2_2) {
                                    // empty catch block
                                }
                            }
                            var5_3 = 1;
                            return var5_3;
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        ** while (++i < this._commands.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._commands[i].doit();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        continue;
                    }
lbl25:
                    // 1 sources

                    throw e;
                }
                --i;
            }
            this._done = false;
            return 0;
        }

        @Override
        public Node[] getHistoriedNodes() {
            if (this._historied == null) {
                this._historied = new ArrayList();
                int i = 0;
                while (i < this._commands.length) {
                    Context ctx = this._commands[i].getContext();
                    Node node = ctx.getNode();
                    Node[] nodes = this._commands[i].getAffectedNodes();
                    if (node != null && !this._historied.contains(node)) {
                        this._historied.add(node);
                    }
                    if (nodes != null) {
                        int j = 0;
                        while (j < nodes.length) {
                            if (nodes[j] != null && !this._historied.contains(nodes[j])) {
                                this._historied.add(nodes[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            Node[] result = new Node[this._historied.size()];
            this._historied.toArray(result);
            return result;
        }

        @Override
        public boolean isGeneratePrecedingState() {
            return true;
        }

        protected Collection<CommandPart> getParts() {
            if (this._parts == null) {
                this._parts = new LinkedHashMap<Node, CommandPart>();
                int i = 0;
                while (i < this._commands.length) {
                    Node[] nodes = this._commands[i].getAffectedNodes();
                    Context ctx = this._commands[i].getContext();
                    ctx = new Context(ctx);
                    this.addPart(ctx);
                    if (nodes != null) {
                        int j = 0;
                        while (j < nodes.length) {
                            ctx = new Context(ctx);
                            ctx.setNode(nodes[j]);
                            this.addPart(ctx);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return this._parts.values();
        }

        protected CommandPart addPart(Context ctx) {
            Node node = ctx != null ? ctx.getNode() : null;
            CommandPart part = this.getPart(node);
            if (part == null && (part = this.createPart(ctx)) != null) {
                this._parts.put(node, part);
            }
            return part;
        }

        protected CommandPart getPart(Node node) {
            return this._parts.get(node);
        }

        protected CommandPart createPart(Context ctx) {
            Node node = ctx != null ? ctx.getNode() : null;
            UndoStack undoStack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), node);
            if (undoStack == null) {
                return null;
            }
            CommandPart part = new CommandPart(this);
            ctx.setNode(node);
            ctx.setSelection(null);
            part.setContext(ctx);
            undoStack.addUndoStackListener(this);
            return part;
        }

        protected void adjustParts() {
            if (this._adjusted) {
                return;
            }
            this._adjusted = true;
            ArrayList<Node> additions = new ArrayList<Node>();
            int i = 0;
            while (i < this._commands.length) {
                Context ctx = this._commands[i].getContext();
                Node[] nodes = this._commands[i].getAffectedNodes();
                Node node = ctx.getNode();
                if (node != null && !additions.contains(node)) {
                    additions.add(node);
                }
                if (nodes != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        if (nodes[j] != null && !additions.contains(nodes[j])) {
                            additions.add(nodes[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            for (CommandPart cmd : this.getParts()) {
                Context ctx = cmd.getContext();
                Node node = ctx.getNode();
                if (!additions.contains(node)) {
                    cmd.setDeletion(true);
                    continue;
                }
                additions.remove(node);
            }
            int i2 = additions.size() - 1;
            while (i2 >= 0) {
                CommandPart part = this.addPart(new Context((Node)additions.get(i2)));
                part.setAddition(true);
                --i2;
            }
            additions.clear();
        }

        @Override
        public void commandsDropped(UndoStackEvent e) {
            Command[] commands = e.getCommands();
            int i = 0;
            while (i < commands.length) {
                Command dropped = commands[i];
                if (this.getParts().contains(dropped)) {
                    UndoStack undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), dropped.getContext());
                    this.getParts().remove(dropped);
                    if (undoStack != null) {
                        undoStack.removeUndoStackListener(this);
                    }
                    while (this.getParts().size() > 0) {
                        Command part = this.getParts().iterator().next();
                        Context ctx = part != null ? part.getContext() : null;
                        undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), ctx);
                        this.getParts().remove(part);
                        if (undoStack == null) continue;
                        undoStack.removeUndoStackListener(this);
                        undoStack.flush(part);
                    }
                    break;
                }
                ++i;
            }
        }

        private static void showErrorMessage(boolean isUndo) {
            String errorMsg;
            String string = errorMsg = isUndo ? IdeArb.getString(226) : IdeArb.getString(236);
            if (Ide.getIdeArgs().getCreateUI()) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)errorMsg, (String)IdeArb.getString(110), null);
            } else {
                System.err.println(errorMsg);
            }
        }
    }

    private static final class BatchCommand
    extends CompoundCommand {
        BatchCommand(String name) {
            super(name);
            Context ctx = Context.newIdeContext();
            ctx.setView(null);
            ctx.setNode(null);
            ctx.setSelection(null);
            this.setContext(ctx);
            this._parts = new LinkedHashMap();
        }

        protected boolean canDo() {
            return this._firstTime ? true : super.canDo();
        }

        protected int doCommands() throws Exception {
            if (this._firstTime) {
                this._firstTime = false;
                this._done = true;
                return 0;
            }
            return super.doCommands();
        }

        int add(Command cmd) throws Exception {
            int result;
            Context ctx = new Context(cmd.getContext());
            Node[] nodes = cmd.getAffectedNodes();
            this.addPart(ctx);
            if (nodes != null) {
                int j = 0;
                while (j < nodes.length) {
                    ctx = new Context(ctx);
                    ctx.setNode(nodes[j]);
                    this.addPart(ctx);
                    ++j;
                }
            }
            if ((result = cmd.doit()) == 0) {
                Command[] temp = new Command[this._commands.length + 1];
                System.arraycopy(this._commands, 0, temp, 0, this._commands.length);
                temp[temp.length - 1] = cmd;
                this._commands = temp;
            }
            return result;
        }

        void abort() {
            if (this._commands != null) {
                int i = this._commands.length - 1;
                while (i >= 0) {
                    try {
                        this._commands[i].undo();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --i;
                }
                this._commands = null;
            }
        }
    }

    private static final class CommandPart
    extends Command {
        private CompoundCommand _owner;
        private boolean _isAddition;
        private boolean _isDeletion;
        private URL _url;

        CommandPart(CompoundCommand owner) {
            super(CommandProcessor.ra$_COMMAND_PART_ID(), 0, owner.getName());
            this._owner = owner;
        }

        public int doit() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.doit(this);
        }

        public int undo() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.undo(this);
        }

        public Context getContext() {
            if (this._url != null) {
                Context ctx = new Context(this.context);
                try {
                    ctx.setNode(NodeFactory.findOrCreate(this._url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ctx;
            }
            return super.getContext();
        }

        void setAddition(boolean isAddition) {
            this._isAddition = isAddition;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isAddition() {
            return this._isAddition;
        }

        void setDeletion(boolean isDeletion) {
            this._isDeletion = isDeletion;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isDeletion() {
            return this._isDeletion;
        }

        static CompoundCommand ra$_owner(CommandPart commandPart) {
            return commandPart._owner;
        }
    }

    private static final class ExternalModificationException
    extends RuntimeException {
    }
}

