/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.Ide;

public final class SplashScreenOptions {
    private static final String IS_SPLASH_FILE = ".issplash";
    private static final int DEFAULT_STEPS = 153;

    private SplashScreenOptions() {
    }

    public static boolean getShowSplashScreen() {
        return SplashScreenOptions.splashFileExists();
    }

    public static void setShowSplashScreen(boolean showSplashScreen) {
        if (showSplashScreen) {
            if (!SplashScreenOptions.splashFileExists()) {
                SplashScreenOptions.createSplashFile(-1);
            }
        } else {
            SplashScreenOptions.deleteSplashFile();
        }
    }

    public static void setSplashScreenCounter(int cnt) {
        if (SplashScreenOptions.getShowSplashScreen()) {
            SplashScreenOptions.createSplashFile(cnt);
        }
    }

    public static int getSplashScreenCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            return SplashScreenOptions.readSplashCounter();
        }
        return -1;
    }

    private static File getSplashFile() {
        return new File(Ide.getSystemDirectory(), IS_SPLASH_FILE);
    }

    private static boolean splashFileExists() {
        File splashFile = SplashScreenOptions.getSplashFile();
        if (splashFile.exists()) {
            return true;
        }
        if (SplashScreenOptions.checkSplashFileDirectory()) {
            SplashScreenOptions.createSplashFile(153);
            return true;
        }
        return false;
    }

    private static int readSplashCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            File splashFile = SplashScreenOptions.getSplashFile();
            try {
                DataInputStream is = new DataInputStream(new FileInputStream(splashFile));
                int res = is.readInt();
                is.close();
                if (res > 0) {
                    int n = res;
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean checkSplashFileDirectory() {
        File splashFileDirectory = SplashScreenOptions.getSplashFile().getParentFile();
        if (splashFileDirectory.exists()) {
            return false;
        }
        return splashFileDirectory.mkdirs();
    }

    private static boolean createSplashFile(int cnt) {
        File splashFile = SplashScreenOptions.getSplashFile();
        try {
            DataOutputStream ds = new DataOutputStream(new FileOutputStream(splashFile));
            ds.writeInt(cnt);
            ds.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean deleteSplashFile() {
        File splashFile = SplashScreenOptions.getSplashFile();
        return splashFile.delete();
    }
}

