/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.IOException;
import java.net.URL;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ProductInformation;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class Preferences
extends HashStructureAdapter
implements PropertyStorage {
    public static final String DATA_KEY = "Preferences";
    private static Preferences _prefs;
    private static HashStructure _customizedDefaults;
    private final URL _url;

    private Preferences(HashStructure hash) {
        this(hash, null);
    }

    private Preferences(HashStructure hash, URL url) {
        super(hash);
        this._url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preferences getPreferences() {
        Class<Preferences> clazz = Preferences.class;
        synchronized (Preferences.class) {
            if (_prefs == null) {
                URL dir = Preferences.getPreferenceDirectory();
                URL url = URLFactory.newURL((URL)dir, (String)"product-preferences.xml");
                HashStructure prefsHash = HashStructure.newInstance();
                if (_customizedDefaults != null) {
                    _customizedDefaults.copyTo(prefsHash);
                }
                _prefs = new Preferences(prefsHash, url);
                try {
                    _prefs.open();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var4] (shouldn't be in output)
            return _prefs;
        }
    }

    private static URL getPreferenceDirectory() {
        try {
            ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
            URL uRL = reg.getSystemDirectory(ProductInformation.getProductID());
            return uRL;
        }
        catch (IllegalStateException e) {
            System.err.println("WARNING: No extension registry present. Loading preferences from user.home");
            URL uRL = URLFactory.newDirURL((String)System.getProperty("user.home"));
            return uRL;
        }
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    public boolean isDirty() {
        return this._hash.isDirty();
    }

    public void clearDirty() {
        this._hash.markDirty(false);
    }

    public void save() throws IOException {
        if (this._url == null) {
            throw new IllegalStateException("Can only save the original Preferences object, not a clone.");
        }
        if (this._hash.isDirty()) {
            HashStructureIO io = Preferences.getIO();
            io.save(this._url, (Object)this._hash);
            this._hash.markDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCustomizedDefaults(HashStructure hash) {
        Class<Preferences> clazz = Preferences.class;
        synchronized (Preferences.class) {
            if (_customizedDefaults != null) {
                throw new IllegalStateException("Preferences customized defaults are already initialized");
            }
            _customizedDefaults = hash;
            if (_prefs != null) {
                _prefs = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void open() throws IOException {
        if (this._url == null) {
            throw new IllegalStateException("Can only load the original Preferences object, not a clone.");
        }
        HashStructureIO io = Preferences.getIO();
        if (URLFileSystem.exists((URL)this._url)) {
            io.open(this._url, (Object)this._hash);
        }
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:preferences");
    }
}

