/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.javatools.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileAssociations {
    public static final String ENABLED_PROPERTY = "ide.shell.enableFileTypeAssociation";
    private static String exePathName;
    private static final String APPLICATION_NAME = "OracleIde";

    static {
        String fnameW;
        int fnameLen;
        exePathName = System.getProperty(ENABLED_PROPERTY);
        if (exePathName != null && (fnameLen = exePathName.length()) >= 5 && exePathName.charAt(fnameLen - 5) != 'w' && exePathName.charAt(fnameLen - 5) != 'W' && new File(fnameW = exePathName.substring(0, fnameLen - 4) + "W.exe").exists()) {
            exePathName = fnameW;
        }
    }

    public static boolean isAssociated(String ext) {
        boolean result;
        RegistryKey regKey;
        RegistryKey hiveKey;
        block16: {
            Registry reg;
            if (PlatformUtils.isAtLeastWindowsVista()) {
                return FileAssociations.isAssociatedOnVista(ext);
            }
            String value = null;
            hiveKey = null;
            regKey = null;
            result = false;
            try {
                reg = NativeHandler.getRegistry();
                hiveKey = reg.getCurrentUserKey();
            }
            catch (RegistryException rEx) {
                boolean bl = result;
                return bl;
            }
            String exePathName = FileAssociations.getExePathName();
            String relExePath = exePathName.substring(Ide.getOracleHomeDirectory().length());
            String productName = FileAssociations.getProductName();
            String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
            regKey = FileAssociations.openKey(hiveKey, key);
            if (regKey != null) {
                try {
                    String exeName = new File(exePathName).getName();
                    value = regKey.getStringValue("Application");
                    if (!value.equalsIgnoreCase(exeName)) break block16;
                    regKey.close();
                    regKey = null;
                    hiveKey.close();
                    hiveKey = null;
                    hiveKey = reg.getClassesRootKey();
                    key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
                    regKey = hiveKey.openKey(key, 131097L);
                    value = regKey.getStringValue(null);
                    if (value.indexOf(relExePath) >= 0) {
                        result = true;
                    }
                }
                catch (RegistryException rEx) {}
            } else {
                try {
                    hiveKey.close();
                    hiveKey = null;
                    hiveKey = reg.getClassesRootKey();
                    regKey = FileAssociations.openKey(hiveKey, ext);
                    if (regKey != null && (value = regKey.getStringValue(null)).equalsIgnoreCase(productName + ext + "File")) {
                        regKey.close();
                        regKey = null;
                        key = productName + ext + "File\\Shell\\Open\\Command";
                        regKey = hiveKey.openKey(key, 131097L);
                        value = regKey.getStringValue(null);
                        if (value.indexOf(relExePath) >= 0) {
                            result = true;
                        }
                    }
                }
                catch (RegistryException rEx) {
                    // empty catch block
                }
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
        return result;
    }

    private static boolean isAssociatedOnVista(String ext) {
        String productName = ProductInformation.getProductInformation().getShortName();
        String keyName = productName + ext + "File";
        try {
            Process proc = Runtime.getRuntime().exec("cmd /c assoc " + ext);
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = reader.readLine();
            boolean bl = line != null && line.endsWith(keyName);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setAssociated(String ext, boolean associated) {
        if (associated) {
            FileAssociations.addAssociation(ext);
        } else {
            FileAssociations.removeAssociation(ext);
        }
    }

    public static void setAssociations(Map<String, Boolean> associations) {
        if (PlatformUtils.isAtLeastWindowsVista()) {
            FileAssociations.setAssociationsOnVista(associations);
        } else {
            for (Map.Entry<String, Boolean> entry : associations.entrySet()) {
                String ext = entry.getKey();
                boolean toAssociate = entry.getValue();
                FileAssociations.setAssociated(ext, toAssociate);
            }
        }
    }

    private static void setAssociationsOnVista(Map<String, Boolean> associations) {
        try {
            String productName = ProductInformation.getProductInformation().getShortName();
            File batch = File.createTempFile("batch", ".bat");
            batch.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(batch));
            for (Map.Entry<String, Boolean> entry : associations.entrySet()) {
                String ext = entry.getKey();
                String productKey = productName + ext + "File";
                boolean toAssociate = entry.getValue();
                if (toAssociate) {
                    out.write("assoc " + ext + "=" + productKey + "\n");
                    String exePathName = FileAssociations.getExePathName();
                    out.write("ftype " + productKey + "=\"" + exePathName + "\" \"%1\" %*\n");
                    continue;
                }
                out.write("assoc " + ext + "=\n");
                out.write("ftype " + productKey + "=\n");
            }
            out.close();
            NativeHandler.runAsAdmin("cmd.exe", "/c " + batch.getCanonicalPath());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getExePathName() {
        return exePathName;
    }

    private static String getProductName() {
        ProductInformation productInfo = ProductInformation.getProductInformation();
        return productInfo.getShortName();
    }

    public static boolean shouldMigrate(String ext) {
        Registry reg;
        String value = null;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        boolean result = false;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getCurrentUserKey();
        }
        catch (RegistryException rEx) {
            boolean bl = result;
            return bl;
        }
        String exePathName = FileAssociations.getExePathName();
        String exeName = new File(exePathName).getName();
        String productName = FileAssociations.getProductName();
        String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
        regKey = FileAssociations.openKey(hiveKey, key);
        if (regKey != null) {
            try {
                value = regKey.getStringValue("Application");
                if (value.equalsIgnoreCase(exeName)) {
                    result = true;
                }
            }
            catch (RegistryException rEx) {}
        } else {
            try {
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getClassesRootKey();
                regKey = hiveKey.openKey(ext, 131097L);
                value = regKey.getStringValue(null);
                if (value.equalsIgnoreCase(productName + ext + "File")) {
                    result = true;
                }
            }
            catch (RegistryException rEx) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
        return result;
    }

    protected static void setProxyPath() {
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            Registry reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
            String exePathName = FileAssociations.getExePathName();
            String exeName = new File(exePathName).getName();
            String productName = FileAssociations.getProductName();
            String key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
            String value = "\"" + exePathName + "\"";
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec";
            value = "Open(\"%1\")";
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec\\Application";
            value = APPLICATION_NAME;
            regKey = hiveKey.createKey(key, false, 131078L);
            regKey.setExpandedStringValue(null, value);
            regKey.close();
            regKey = null;
            key = "Applications\\" + exeName + "\\Shell\\Open";
            regKey = hiveKey.openKey(key, 131078L);
            regKey.setStringValue("FriendlyAppName", productName);
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
    }

    protected static void setExtensionPath(String ext) {
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            Registry reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String exePathName = FileAssociations.getExePathName();
        String productName = FileAssociations.getProductName();
        regKey = FileAssociations.openKey(hiveKey, productName + ext + "File");
        if (regKey != null) {
            try {
                String key = productName + ext + "File\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
            }
            catch (RegistryException rEx) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
    }

    private static void addAssociation(String ext) {
        Registry reg;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getClassesRootKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String exePathName = FileAssociations.getExePathName();
        String productName = FileAssociations.getProductName();
        regKey = FileAssociations.openKey(hiveKey, ext);
        if (regKey == null) {
            try {
                String key = productName + ext + "File\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = productName + ext + "File\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                regKey = null;
                regKey = hiveKey.createKey(ext, false, 131078L);
                regKey.setStringValue(null, productName + ext + "File");
            }
            catch (RegistryException rEx) {
                rEx.printStackTrace();
            }
        } else {
            try {
                String exeName = new File(exePathName).getName();
                String key = "Applications\\" + exeName + "\\Shell\\Open\\Command";
                String value = "\"" + exePathName + "\"";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec";
                value = "Open(\"%1\")";
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                key = "Applications\\" + exeName + "\\Shell\\Open\\ddeexec\\Application";
                value = APPLICATION_NAME;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setExpandedStringValue(null, value);
                regKey.close();
                regKey = null;
                key = "Applications\\" + exeName + "\\Shell\\Open";
                regKey = hiveKey.openKey(key, 131078L);
                regKey.setStringValue("FriendlyAppName", productName);
                regKey.close();
                regKey = null;
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getCurrentUserKey();
                key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
                regKey = hiveKey.createKey(key, false, 131078L);
                regKey.setStringValue("Application", exeName);
            }
            catch (RegistryException rEx) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
    }

    private static void removeAssociation(String ext) {
        Registry reg;
        RegistryKey hiveKey = null;
        RegistryKey regKey = null;
        try {
            reg = NativeHandler.getRegistry();
            hiveKey = reg.getCurrentUserKey();
        }
        catch (RegistryException rEx) {
            return;
        }
        String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext;
        regKey = FileAssociations.openKey(hiveKey, key);
        if (regKey != null) {
            try {
                regKey.setStringValue("Application", "");
            }
            catch (RegistryException rEx) {}
        } else {
            try {
                hiveKey.close();
                hiveKey = null;
                hiveKey = reg.getClassesRootKey();
                regKey = hiveKey.openKey(ext, 2);
                hiveKey.deleteKey(ext);
            }
            catch (RegistryException rEx) {
                // empty catch block
            }
        }
        try {
            if (regKey != null) {
                regKey.close();
            }
            if (hiveKey != null) {
                hiveKey.close();
            }
        }
        catch (RegistryException rEx) {
            // empty catch block
        }
    }

    private static RegistryKey openKey(RegistryKey hiveKey, String key) {
        RegistryKey regKey = null;
        try {
            regKey = hiveKey.openKey(key, 3);
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return regKey;
    }
}

