/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.Copyable;

public final class DTCache
implements Copyable {
    static final String FILENAME = "dtcache.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"dt-cache");
    static final String ROOT_TAG = "dt-cache";
    private HashMap cacheMap = new HashMap();

    public Object getData(String dataKey) {
        return this.cacheMap.get(dataKey);
    }

    public String getString(String dataKey) {
        return (String)this.getData(dataKey);
    }

    public int getInteger(String dataKey, int defaultVal) {
        Object data = this.getData(dataKey);
        return data instanceof Integer ? (Integer)data : defaultVal;
    }

    public boolean getBoolean(String dataKey, boolean defaultVal) {
        Object data = this.getData(dataKey);
        return data instanceof Boolean ? (Boolean)data : defaultVal;
    }

    public URL getURL(String dataKey) {
        return (URL)this.getData(dataKey);
    }

    public void putData(String dataKey, Copyable data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.cacheMap.put(dataKey, data);
    }

    public void putData(String dataKey, List copyableList) {
        if (copyableList == null) {
            throw new IllegalArgumentException();
        }
        this.cacheMap.put(dataKey, copyableList);
    }

    public void putString(String dataKey, String string) {
        this.cacheMap.put(dataKey, string);
    }

    public void putBoolean(String dataKey, boolean b) {
        this.putBoolean(dataKey, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putBoolean(String dataKey, Boolean b) {
        this.cacheMap.put(dataKey, b);
    }

    public void putURL(String dataKey, URL url) {
        this.cacheMap.put(dataKey, url);
    }

    public void putInteger(String dataKey, int i) {
        this.putInteger(dataKey, (Integer)i);
    }

    public void putInteger(String dataKey, Integer i) {
        this.cacheMap.put(dataKey, i);
    }

    public Object remove(String dataKey) {
        return this.cacheMap.remove(dataKey);
    }

    public void removeAll() {
        this.cacheMap.clear();
    }

    public boolean save() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".save");
        boolean bRet = false;
        try {
            URL url = DTCache.getConfigURL();
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            o2d.toDocument((Object)this.cacheMap, ROOT_TAG, url);
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".save", "DTCache.save()");
        return bRet;
    }

    public boolean load() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".load");
        boolean bRet = false;
        try {
            URL url = DTCache.getConfigURL();
            Object2Dom o2d = Object2Dom.newInstance();
            HashMap loadedData = (HashMap)o2d.toObject(url);
            this.cacheMap.clear();
            this.cacheMap.putAll(loadedData);
            bRet = true;
        }
        catch (FileNotFoundException fnf) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".load", "DTCache.load()");
        return bRet;
    }

    public Object copyTo(Object target) {
        DTCache copy = target != null ? (DTCache)target : new DTCache();
        ModelUtil.deepCopy((Map)this.cacheMap, (Map)copy.cacheMap);
        return copy;
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName((URL)DTCache.getConfigURL());
    }

    private static URL getConfigURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        return URLFactory.newURL((URL)er.getSystemDirectory("oracle.ide"), (String)FILENAME);
    }
}

