/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class ClientSetting
implements Copyable {
    public static final String ROOT_TAG = "client-settings";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"client-preferences");
    public static final String FILENAME = "preferences.xml";
    private final HashMap _clientData;
    private URL _url;
    private String _extensionID;
    private transient Object2Dom _objectStore;
    private transient boolean _isOpen;

    private void $init$() {
        this._clientData = new HashMap();
        this._isOpen = false;
    }

    ClientSetting() {
        this.$init$();
    }

    public boolean hasData(String dataKey) {
        if (this.isOpen()) {
            return this._clientData.containsKey(dataKey);
        }
        return URLFileSystem.exists((URL)this.getURL());
    }

    public Copyable getData(String key) throws TransientMarker {
        try {
            this.ensureOpen();
            Copyable copyable = (Copyable)this._clientData.get(key);
            return copyable;
        }
        catch (Throwable e) {
            Logger.getLogger(ROOT_TAG).log(Level.INFO, "exception getting data at key " + key + " for extension " + this._extensionID, e);
            Copyable copyable = null;
            return copyable;
        }
    }

    public void putData(String key, Copyable data) {
        try {
            this.ensureOpen();
            this._clientData.put(key, data);
            Ide.getSettings().setData(key, this);
        }
        catch (Throwable e) {
            Logger.getLogger(ROOT_TAG).log(Level.INFO, "exception putting data at key " + key + " for extension " + this._extensionID, e);
        }
    }

    public void save() throws IOException {
        if (this.isOpen()) {
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            URL targetURL = this.getURL();
            URL targetDirectory = URLFileSystem.getParent((URL)targetURL);
            URL tmpURL = null;
            try {
                tmpURL = URLFileSystem.createTempFile((String)"pref", null, (URL)targetDirectory);
                o2d.toDocument((Object)this._clientData, ROOT_TAG, tmpURL);
            }
            catch (IOException e) {
                return;
            }
            URLFileSystem.copy((URL)tmpURL, (URL)targetURL);
            URLFileSystem.delete((URL)tmpURL);
        }
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            if (!this.isNew()) {
                Object2Dom o2d;
                Object obj;
                this._clientData.clear();
                if (URLFileSystem.getLength((URL)this.getURL()) != 0L && (obj = (o2d = Object2Dom.newInstance()).toObject(this.getURL())) instanceof Map) {
                    this._clientData.putAll((Map)obj);
                }
                Ide.getSettings().addClientSetting(this);
            }
            this._isOpen = true;
        }
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public boolean isNew() {
        return URLFileSystem.exists((URL)this.getURL()) ^ true;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public String getExtensionID() {
        return this._extensionID;
    }

    public void putExtensionID(String extensionID) {
        this._extensionID = extensionID;
    }

    public Object copyTo(Object object) {
        ClientSetting copy = object != null ? (ClientSetting)object : new ClientSetting();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ClientSetting copy) {
        ModelUtil.deepCopy((Map)this._clientData, (Map)copy._clientData);
        copy._url = this._url;
        copy._isOpen = this._isOpen;
        copy._extensionID = this._extensionID;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ClientSetting)o);
    }

    public int hashCode() {
        return this._url.toString().hashCode() + 1234;
    }

    public static void registerUI(Navigable ui) {
        IdeSettings.registerUI(ui);
    }

    public static void deregisterUI(Navigable ui) {
        IdeSettings.deregisterUI(ui);
    }

    public static ClientSetting findOrCreate(String extensionID) {
        return ClientSetting.findOrCreate(extensionID, FILENAME);
    }

    public static ClientSetting findOrCreate(String extensionID, String filename) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = URLFactory.newURL((URL)er.getSystemDirectory(extensionID), (String)filename);
        ClientSetting setting = Ide.getSettings().findClientSetting(url);
        if (setting == null) {
            setting = new ClientSetting(url);
            setting.putExtensionID(extensionID);
        }
        return setting;
    }

    protected final boolean equalsImpl(ClientSetting setting) {
        return ModelUtil.areEqual((Object)this._url, (Object)setting._url) && ModelUtil.areEqual((Object)this._clientData, (Object)setting._clientData) && ModelUtil.areEqual((Object)this._extensionID, (Object)setting._extensionID);
    }

    protected ObjectStore getObjectStore() {
        if (this._objectStore == null) {
            this._objectStore = Object2Dom.newInstance();
            this._objectStore.setNamespaceURI(NAMESPACE_URI);
        }
        return this._objectStore;
    }

    protected void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
    }

    protected Map getClientData() {
        try {
            this.ensureOpen();
        }
        catch (Throwable e) {
            Logger.getLogger(ROOT_TAG).log(Level.SEVERE, "exception getting client data for extension " + this._extensionID, e);
        }
        return this._clientData;
    }

    protected ClientSetting(URL url) {
        this.$init$();
        this._url = url;
    }
}

