/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.component.URLPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;

public class URLPathEditPanel
extends JPanel
implements ActionListener {
    private URL defDir;
    private DefaultListModel pathModel;
    GridBagLayout layMain;
    JScrollPane scrList;
    JPanel pnlOrder;
    GridBagLayout layOrder;
    JButton butUp;
    JButton butDown;
    JButton butAddEntry;
    JButton butEditEntry;
    JButton butAddURL;
    JButton butRemove;
    JPanel pnlButtons;
    GridLayout gridLayout1;
    JLabel listPathsLabel;
    JList listPaths;
    Border bdrList;
    Icon iconUp;
    Icon iconUpDisabled;
    Icon iconDown;
    Icon iconDownDisabled;
    ListCellRenderer urlRenderer;
    private boolean _supportsArbitraryURLs;
    private boolean _allowJars;
    private boolean _pathLocked;

    private void $init$() {
        this.defDir = URLFactory.newDirURL((String)Ide.getWorkDirectory());
        this.pathModel = new DefaultListModel();
        this.layMain = new GridBagLayout();
        this.scrList = new JScrollPane();
        this.pnlOrder = new JPanel();
        this.layOrder = new GridBagLayout();
        this.butUp = new JButton();
        this.butDown = new JButton();
        this.butAddEntry = new JButton();
        this.butEditEntry = new JButton();
        this.butAddURL = new JButton();
        this.butRemove = new JButton();
        this.pnlButtons = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.listPathsLabel = new JLabel();
        this.listPaths = new JList();
        this.bdrList = BorderFactory.createEmptyBorder();
        this.iconUp = ComponentArb.getIcon(3);
        this.iconUpDisabled = ComponentArb.getIcon(23);
        this.iconDown = ComponentArb.getIcon(9);
        this.iconDownDisabled = ComponentArb.getIcon(0);
        this.urlRenderer = new URLRenderer(null);
        this._supportsArbitraryURLs = false;
        this._allowJars = true;
    }

    public URLPathEditPanel(URLPath path) {
        this();
        this.setPath(path);
    }

    public URLPathEditPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static URLPath editPath(Component parent, String title, URLPath path, boolean supportAnyURL, boolean allowJars, String helpID) {
        URLPathEditPanel panel = new URLPathEditPanel(path);
        panel.setSupportsArbitraryURLs(supportAnyURL);
        panel.setJarPathsAllowed(allowJars);
        if (helpID != null) {
            HelpSystem.getHelpSystem().registerTopic(panel, helpID);
        }
        return OnePageWizardDialogFactory.runDialog(parent, panel, panel.getInitialFocus(), title, 7, null) ? panel.getPath() : null;
    }

    public static void viewPath(Component parent, String title, URLPath path, String helpID) {
        URLPathEditPanel panel = new URLPathEditPanel(path);
        panel.setPathLocked(true);
        if (helpID != null) {
            HelpSystem.getHelpSystem().registerTopic(panel, helpID);
        }
        OnePageWizardDialogFactory.runDialog(parent, panel, panel.getInitialFocus(), title, 6, null);
    }

    public void setPath(URLPath path) {
        this.pathModel.clear();
        URL[] urls = path.getEntries();
        int i = 0;
        while (i < urls.length) {
            this.pathModel.addElement(urls[i]);
            ++i;
        }
        if (!this.pathModel.isEmpty()) {
            this.listPaths.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    public URLPath getPath() {
        URLPath newPath = new URLPath();
        int entries = this.pathModel.getSize();
        int i = 0;
        while (i < entries) {
            newPath.add((URL)this.pathModel.elementAt(i));
            ++i;
        }
        return newPath;
    }

    public void setDefaultArchiveDirectory(String dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.defDir = URLFactory.newDirURL((String)dir);
    }

    public String getDefaultArchiveDirectory() {
        return URLFileSystem.getPlatformPathName((URL)this.defDir);
    }

    public void setPathLocked(boolean locked) {
        this._pathLocked = locked;
        this.pnlOrder.setVisible(locked ^ true);
        this.pnlButtons.setVisible(locked ^ true);
    }

    public boolean isPathLocked() {
        return this._pathLocked;
    }

    public void setSupportsArbitraryURLs(boolean supportsArbitraryURLs) {
        if (this._supportsArbitraryURLs != supportsArbitraryURLs) {
            this._supportsArbitraryURLs = supportsArbitraryURLs;
            this.pnlButtons.removeAll();
            if (this._supportsArbitraryURLs) {
                this.pnlButtons.add((Component)this.butAddEntry, null);
                this.pnlButtons.add((Component)this.butAddURL, null);
                this.pnlButtons.add((Component)this.butRemove, null);
            } else {
                this.pnlButtons.add((Component)this.butAddEntry, null);
                this.pnlButtons.add((Component)this.butEditEntry, null);
                this.pnlButtons.add((Component)this.butRemove, null);
            }
        }
    }

    public boolean isSupportsArbitraryURLs() {
        return this._supportsArbitraryURLs;
    }

    public void setJarPathsAllowed(boolean val) {
        this._allowJars = val;
    }

    public boolean isJarPathsAllowed() {
        return this._allowJars;
    }

    public Component getInitialFocus() {
        if (this.pathModel.isEmpty()) {
            return this.butAddEntry;
        }
        return this.listPaths;
    }

    public void setPathLabel(String label) {
        if (label != null) {
            ResourceUtils.resLabel((JLabel)this.listPathsLabel, (Component)this.listPaths, (String)label);
            this.listPathsLabel.setVisible(true);
        } else {
            this.listPathsLabel.setVisible(false);
        }
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        this.pnlOrder.setLayout(this.layOrder);
        this.listPaths.setBorder(this.bdrList);
        this.butUp.setIcon(this.iconUp);
        this.butUp.setDisabledIcon(this.iconUpDisabled);
        this.butUp.setMargin(new Insets(2, 2, 2, 2));
        this.butUp.addActionListener(this);
        this.butUp.setToolTipText(ComponentArb.getString(17));
        this.butDown.setIcon(this.iconDown);
        this.butDown.setDisabledIcon(this.iconDownDisabled);
        this.butDown.setMargin(new Insets(2, 2, 2, 2));
        this.butDown.addActionListener(this);
        this.butDown.setToolTipText(ComponentArb.getString(1));
        ResourceUtils.resButton((AbstractButton)this.butAddEntry, (String)ComponentArb.getString(31));
        this.butAddEntry.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butEditEntry, (String)ComponentArb.getString(7));
        this.butEditEntry.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butAddURL, (String)ComponentArb.getString(40));
        this.butAddURL.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butRemove, (String)ComponentArb.getString(12));
        this.butRemove.addActionListener(this);
        this.gridLayout1.setColumns(3);
        this.gridLayout1.setHgap(8);
        this.listPaths.setSelectionMode(0);
        this.listPaths.setModel(this.pathModel);
        this.listPaths.setCellRenderer(this.urlRenderer);
        this.listPaths.addListSelectionListener(new 1());
        this.listPathsLabel.setVisible(false);
        this.pnlButtons.setLayout(this.gridLayout1);
        int SPACE = 8;
        this.add((Component)this.listPathsLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.scrList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrList.getViewport().add((Component)this.listPaths, null);
        this.pnlOrder.add((Component)this.butUp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.pnlOrder.add((Component)this.butDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlOrder, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 13, 1, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.pnlButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.butAddEntry, null);
        this.pnlButtons.add((Component)this.butEditEntry, null);
        this.pnlButtons.add((Component)this.butRemove, null);
    }

    private void updateButtons() {
        int sel = this.listPaths.getSelectedIndex();
        this.butUp.setEnabled(sel > 0);
        this.butDown.setEnabled(sel != -1 && sel != this.pathModel.size() - 1);
        this.butRemove.setEnabled(sel != -1);
        this.butEditEntry.setEnabled(sel != -1);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.butAddEntry) {
            this._browseEntry();
        } else if (src == this.butEditEntry) {
            this._editEntry();
        } else if (src == this.butAddURL) {
            URL entry = new URLPanel().promptForURL(this);
            if (entry != null) {
                this.pathModel.addElement(entry);
                this.listPaths.setSelectedIndex(this.pathModel.getSize() - 1);
            }
        } else if (src == this.butRemove) {
            this._removeEntry();
        } else if (src == this.butUp) {
            this._moveUp();
        } else if (src == this.butDown) {
            this._moveDown();
        }
    }

    private void _browseEntry() {
        URLChooser chooser = DialogUtil.newURLChooser(this.defDir);
        chooser.setSelectionMode(2);
        chooser.setSelectionScope(1);
        chooser.setShowJarsAsDirs(this._allowJars);
        int result = chooser.showOpenDialog(this, ComponentArb.getString(28));
        if (result == 0) {
            URL[] dirs = chooser.getSelectedURLs();
            URL dir = null;
            int n = dirs.length;
            int i = 0;
            while (i < n) {
                dir = dirs[i];
                this.pathModel.addElement(dir);
                ++i;
            }
            this.defDir = dir;
            int idx = this.pathModel.getSize() - 1;
            this.listPaths.setSelectedIndex(idx);
            this.listPaths.ensureIndexIsVisible(idx);
        }
    }

    private void _editEntry() {
        URL url = (URL)this.listPaths.getSelectedValue();
        if (url != null) {
            URL[] dirs;
            URLChooser chooser = DialogUtil.newURLChooser(url);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(1);
            chooser.setShowJarsAsDirs(this._allowJars);
            int result = chooser.showOpenDialog(this, ComponentArb.getString(28));
            if (result == 0 && (dirs = chooser.getSelectedURLs()).length > 0) {
                this.defDir = dirs[0];
                this.pathModel.setElementAt(dirs[0], this.listPaths.getSelectedIndex());
            }
        }
    }

    private void _removeEntry() {
        int sel = this.listPaths.getSelectedIndex();
        if (sel != -1) {
            this.pathModel.removeElementAt(sel);
            int count = this.pathModel.getSize();
            int newSel = sel < count ? sel : count - 1;
            this.listPaths.setSelectedIndex(newSel);
            if (newSel == -1) {
                this.butRemove.setEnabled(false);
            } else {
                this.listPaths.ensureIndexIsVisible(newSel);
            }
        }
    }

    void _moveUp() {
        int sel = this.listPaths.getSelectedIndex();
        if (sel > 0) {
            this._moveElement(sel, sel - 1);
        }
    }

    void _moveDown() {
        int sel = this.listPaths.getSelectedIndex();
        if (sel >= 0 && sel < this.pathModel.size() - 1) {
            this._moveElement(sel, sel + 1);
        }
    }

    private void _moveElement(int oldIdx, int newIdx) {
        Object o = this.pathModel.elementAt(oldIdx);
        this.pathModel.removeElementAt(oldIdx);
        this.pathModel.insertElementAt(o, newIdx);
        this.listPaths.setSelectedIndex(newIdx);
        this.listPaths.ensureIndexIsVisible(newIdx);
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        return new Dimension(Math.min(prefSize.width, 500), Math.min(prefSize.height, 300));
    }

    static void mav$updateButtons(URLPathEditPanel uRLPathEditPanel) {
        uRLPathEditPanel.updateButtons();
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            URLPathEditPanel.mav$updateButtons(URLPathEditPanel.this);
        }
    }

    private static class URLRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof URL) {
                URL url = (URL)value;
                value = URLFileSystem.getPlatformPathName((URL)url);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }

        private URLRenderer() {
        }

        URLRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

