/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.NewFileValidator;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.StringUtil;

public class NewFilePanel
extends JPanel
implements VetoableChangeListener {
    private URL _url;
    private URL _rootUrl;
    private String _ext;
    private String _type;
    private boolean _canOverwriteOpenNodes;
    private boolean _showExtension;
    private boolean _isInteractive;
    private boolean _supportsAutoFill;
    private boolean _enforceFileExtension;
    private NewFileValidator _validator;
    private JEWTDialog _dlg;
    private int _layoutOrientation;
    GridBagLayout gridBagLayout1;
    JLabel lblDirectory;
    URLTextField fldDirectory;
    JButton btnDirBrowse;
    JLabel lblFile;
    JTextField fldFile;

    private void $init$() {
        this._ext = "";
        this._type = "file";
        this._canOverwriteOpenNodes = true;
        this._showExtension = true;
        this._isInteractive = true;
        this._supportsAutoFill = true;
        this._enforceFileExtension = true;
        this._layoutOrientation = 1;
        this.gridBagLayout1 = new GridBagLayout();
        this.lblDirectory = new JLabel();
        this.fldDirectory = new DirURLTextField();
        this.btnDirBrowse = new JButton();
        this.lblFile = new JLabel();
        this.fldFile = new JTextField();
    }

    public NewFilePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fldFile.setName("new-file-panel#file-field");
        this.fldDirectory.setName("new-file-panel#directory-field");
        this.btnDirBrowse.setName("new-file-panel#directory-browse-button");
    }

    public final void setLayoutOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("layout orientation must be SwingConstants.HORIZONTAL or SwingConstants.VERTICAL");
        }
        if (this._layoutOrientation != orientation) {
            int old = this._layoutOrientation;
            this._layoutOrientation = orientation;
            this.layoutComponents();
            this.firePropertyChange("layoutOrientation", old, orientation);
        }
    }

    public final int getLayoutOrientation() {
        return this._layoutOrientation;
    }

    protected DialogHeader createDialogHeader() {
        return null;
    }

    private void registerDialogHeader() {
        DialogHeader h = this.createDialogHeader();
        if (h != null) {
            OnePageWizardDialogFactory.setDialogHeader(this, h);
        }
    }

    public void setSupportsAutoFill(boolean supportsAutoFill) {
        this._supportsAutoFill = supportsAutoFill;
    }

    public boolean isSupportsAutoFill() {
        return this._supportsAutoFill;
    }

    public void setInteractiveMode(boolean isInteractive) {
        this._isInteractive = isInteractive;
    }

    public void setFileExtension(String ext) {
        this._ext = ext;
    }

    public void setEnforceFileExtension(boolean enforce) {
        this._enforceFileExtension = enforce;
    }

    public void setFileType(String type) {
        this._type = type;
    }

    public void setNewFileURLValidator(NewFileValidator validator) {
        this._validator = validator;
    }

    public NewFileValidator getNewFileURLValidator() {
        return this._validator;
    }

    public void setCanOverwriteOpenNodes(boolean canOverwriteOpenNodes) {
        this._canOverwriteOpenNodes = canOverwriteOpenNodes;
    }

    public URL runDialog(String title) {
        URL result = null;
        this.registerDialogHeader();
        if (OnePageWizardDialogFactory.runDialog(this, this.fldFile, title, 7, this)) {
            try {
                result = this.getFileURL();
            }
            catch (TraversalException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public URL runDialog(String title, Runnable runnable) {
        if (runnable == null) {
            return this.runDialog(title);
        }
        URL result = null;
        this.registerDialogHeader();
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog(this, this.fldFile, title, 7);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)new 1(this, runnable));
        if (this._dlg.runDialog()) {
            try {
                result = this.getFileURL(false);
            }
            catch (TraversalException ex) {
                ex.printStackTrace();
            }
        }
        this._dlg.dispose();
        this._dlg = null;
        return result;
    }

    public void resetURLCache() {
        this._url = null;
    }

    public URL getFileURL() throws TraversalException {
        return this.getFileURL(true);
    }

    public URL getFileURL(boolean validateURL) throws TraversalException {
        if (this._url == null) {
            URL dir;
            block13: {
                dir = null;
                try {
                    dir = this.getDirectoryURL();
                }
                catch (TraversalException ex) {
                    if (!this._isInteractive) break block13;
                    throw ex;
                }
            }
            if (dir != null) {
                String fName = this.fldFile.getText().trim();
                int fNameLen = fName.length();
                if (this._enforceFileExtension && fName.endsWith(".")) {
                    fName = fName.substring(0, fNameLen - 1);
                    --fNameLen;
                }
                if (this._ext != null && !fName.endsWith(this._ext) && (0 > fName.indexOf(".") || this._enforceFileExtension)) {
                    fName = fName + this._ext;
                }
                URL tmpURL = URLFactory.newURL((URL)dir, (String)fName);
                if (this._isInteractive) {
                    String fNameOnly;
                    int lastDotPos = fName.lastIndexOf(46);
                    if (lastDotPos != -1 && (fNameOnly = fName.substring(0, lastDotPos)).length() == 0) {
                        fNameLen = 0;
                    }
                    if (fNameLen <= 0) {
                        throw new TraversalException(ComponentArb.getString(24), ComponentArb.getString(15), null);
                    }
                    if (fName.indexOf(File.separatorChar) != -1 || fName.indexOf(47) != -1) {
                        throw new TraversalException(ComponentArb.getString(11), ComponentArb.getString(15), null);
                    }
                    if (this._validator != null) {
                        tmpURL = this._validator.validateNewFileURL(tmpURL);
                    }
                    if (validateURL) {
                        this._url = NewFilePanel.validateURL(this, tmpURL, this._type, this._canOverwriteOpenNodes);
                    }
                } else {
                    this._url = tmpURL;
                }
            }
        }
        return this._url;
    }

    public static URL validateURL(Component parent, URL tmpURL, String type, boolean canOverwriteOpenNodes) throws TraversalException {
        if (URLFileSystem.canCreate((URL)tmpURL)) {
            Node node = NodeFactory.find(tmpURL);
            boolean nodeExists = node != null;
            boolean fileExists = URLFileSystem.exists((URL)tmpURL);
            if (fileExists && !URLFileSystem.canWrite((URL)tmpURL)) {
                throw new TraversalException(ComponentArb.format(19, type, URLFileSystem.getPlatformPathName((URL)tmpURL)), ComponentArb.getString(15), null);
            }
            if (nodeExists && node.isOpen()) {
                if (canOverwriteOpenNodes) {
                    if (NewFilePanel._checkForOverwrite(parent, URLFileSystem.getPlatformPathName((URL)tmpURL), type)) {
                        return tmpURL;
                    }
                    throw new TraversalException(null);
                }
                throw new TraversalException(ComponentArb.format(37, type, URLFileSystem.getPlatformPathName((URL)tmpURL)), ComponentArb.getString(15), null);
            }
            if (!fileExists || NewFilePanel._checkForOverwrite(parent, URLFileSystem.getPlatformPathName((URL)tmpURL), type)) {
                return tmpURL;
            }
            throw new TraversalException(null);
        }
        String fileName = URLFileSystem.getPlatformPathName((URL)tmpURL);
        if (fileName.length() > 80) {
            fileName = StringUtil.truncateFileNameForMessage((String)fileName);
        }
        throw new TraversalException(ComponentArb.format(14, type, fileName), ComponentArb.getString(15), null);
    }

    public void setDirectoryURL(URL dir) {
        this.fldDirectory.setURL(dir);
        this.resetURLCache();
    }

    public void setDefaultDirectoryName(URL rootFolderURL) {
        String name = this.getFileNameWithoutExtension();
        this.fldDirectory.setURL(URLFactory.newURL((URL)rootFolderURL, (String)name));
    }

    public void setFileName(String fName) {
        if (this.isShowExtension()) {
            if (ModelUtil.hasLength((String)this._ext) && ModelUtil.hasLength((String)fName) && !fName.endsWith(this._ext)) {
                fName = fName + this._ext;
            }
        } else if (fName.endsWith(this._ext)) {
            fName = fName.substring(0, fName.length() - this._ext.length());
        }
        this.fldFile.setText(fName);
        this.resetURLCache();
    }

    public void setShowExtension(boolean show) {
        this._showExtension = show;
    }

    public void setDirectoryPrompt(String prompt) {
        ResourceUtils.resLabel((JLabel)this.lblDirectory, (Component)((Object)this.fldDirectory), (String)prompt);
    }

    public void setFilePrompt(String prompt) {
        ResourceUtils.resLabel((JLabel)this.lblFile, (Component)this.fldFile, (String)prompt);
    }

    public void setBrowseButtonLabel(String label) {
        ResourceUtils.resButton((AbstractButton)this.btnDirBrowse, (String)label);
    }

    public JComponent getDefaultFocusComponent() {
        return this.fldFile;
    }

    public void requestFocus() {
        this.fldFile.requestFocus();
    }

    public JTextField getDirectoryField() {
        return this.fldDirectory;
    }

    public JTextField getFileField() {
        return this.fldFile;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.getFileURL();
            }
            catch (TraversalException ex) {
                throw new PropertyVetoException("no", evt);
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblDirectory, (Component)((Object)this.fldDirectory), (String)ComponentArb.getString(13));
        ResourceUtils.resButton((AbstractButton)this.btnDirBrowse, (String)ComponentArb.getString(27));
        this.btnDirBrowse.addActionListener(this.fldDirectory);
        ResourceUtils.resLabel((JLabel)this.lblFile, (Component)this.fldFile, (String)ComponentArb.getString(39));
        FileNameListener nameListener = new FileNameListener(null);
        this.fldFile.getDocument().addDocumentListener(nameListener);
        this.fldFile.addKeyListener(nameListener);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(this.gridBagLayout1);
        this.remove(this.lblFile);
        this.remove(this.fldFile);
        this.remove(this.lblDirectory);
        this.remove((Component)((Object)this.fldDirectory));
        this.remove(this.btnDirBrowse);
        if (this._layoutOrientation == 1) {
            this.add((Component)this.lblFile, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add((Component)this.fldFile, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.lblDirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
            this.add((Component)((Object)this.fldDirectory), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 10, 0));
            this.add((Component)this.btnDirBrowse, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        } else {
            this.add((Component)this.lblFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this.fldFile, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.lblDirectory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)((Object)this.fldDirectory), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 10, 0));
            this.add((Component)this.btnDirBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private static boolean _checkForOverwrite(Component parent, String path, String type) {
        return MessageDialog.confirm((Component)parent, (Object)ComponentArb.format(22, type, path), (String)ComponentArb.getString(18), null, (boolean)true);
    }

    private boolean isShowExtension() {
        return this._showExtension;
    }

    private URL getDirectoryURL() throws TraversalException {
        if (!ModelUtil.hasLength((String)this.fldDirectory.getText())) {
            throw new TraversalException(ComponentArb.getString(4), ComponentArb.getString(16), null);
        }
        URL result = this.fldDirectory.getURL();
        if (result == null) {
            throw new TraversalException(ComponentArb.format(35, this.fldDirectory.getText().trim()), ComponentArb.getString(16), null);
        }
        if (!URLFileSystem.isValid((URL)result)) {
            String fileName = URLFileSystem.getPlatformPathName((URL)result);
            if (fileName.length() > 80) {
                fileName = StringUtil.truncateFileNameForMessage((String)fileName);
                throw new TraversalException(ComponentArb.format(14, ComponentArb.getString(36), fileName), ComponentArb.getString(16), null);
            }
            throw new TraversalException(ComponentArb.format(35, this.fldDirectory.getText().trim()), ComponentArb.getString(16), null);
        }
        return result;
    }

    private void setRootURL(URL rootUrl) {
        if (!rootUrl.equals(this._rootUrl)) {
            this._rootUrl = rootUrl;
        }
    }

    private String getFileNameWithoutExtension() {
        String name = this.fldFile.getText();
        if (this._ext != null && this._ext.length() > 0) {
            name = name.endsWith(this._ext) ? name.substring(0, name.length() - this._ext.length()) : name;
        }
        return name;
    }

    private void enableOK() {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(this.fldFile.getText().trim().length() > 0 && this.fldDirectory.getText().trim().length() > 0);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lblDirectory.setEnabled(enabled);
        this.fldDirectory.setEnabled(enabled);
        this.fldDirectory.setEditable(enabled);
        this.lblFile.setEnabled(enabled);
        this.fldFile.setEnabled(enabled);
        this.fldFile.setEditable(enabled);
        this.btnDirBrowse.setEnabled(enabled);
    }

    static String mav$getFileNameWithoutExtension(NewFilePanel newFilePanel) {
        return newFilePanel.getFileNameWithoutExtension();
    }

    static URL ra$_rootUrl(NewFilePanel newFilePanel) {
        return newFilePanel._rootUrl;
    }

    static void mav$enableOK(NewFilePanel newFilePanel) {
        newFilePanel.enableOK();
    }

    static void wa$_supportsAutoFill(NewFilePanel newFilePanel, boolean bl) {
        newFilePanel._supportsAutoFill = bl;
    }

    static void mav$setRootURL(NewFilePanel newFilePanel, URL uRL) {
        newFilePanel.setRootURL(uRL);
    }

    static void wa$_rootUrl(NewFilePanel newFilePanel, URL uRL) {
        newFilePanel._rootUrl = uRL;
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ Runnable v$runnable;
        final /* synthetic */ NewFilePanel this$0;

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            this.v$runnable.run();
        }

        public 1(NewFilePanel newFilePanel, Runnable runnable) {
            this.v$runnable = runnable;
            this.this$0 = newFilePanel;
        }
    }

    private class FileNameListener
    implements DocumentListener,
    KeyListener {
        private String lastFileName;

        private void $init$() {
            this.lastFileName = "";
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateDir();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateDir();
        }

        private void updateDir() {
            if (NewFilePanel.this.isSupportsAutoFill()) {
                String filename = NewFilePanel.this.fldFile.getText();
                URL dirUR = URLFactory.newDirURL((URL)NewFilePanel.ra$_rootUrl(NewFilePanel.this), (String)filename);
                URL fileURL = URLFactory.newURL((URL)dirUR, (String)filename);
                if (URLFileSystem.canCreate((URL)fileURL) && this.isAutoFill()) {
                    NewFilePanel.this.fldDirectory.setText(URLFileSystem.getPlatformPathName((URL)dirUR));
                }
            }
        }

        private boolean isAutoFill() {
            if (!NewFilePanel.this.isSupportsAutoFill()) {
                return false;
            }
            String name = this.lastFileName;
            String fName = NewFilePanel.mav$getFileNameWithoutExtension(NewFilePanel.this);
            if (!this.lastFileName.equals(fName)) {
                this.lastFileName = fName;
            }
            return NewFilePanel.this.fldDirectory.getText().endsWith(name);
        }

        public void keyTyped(KeyEvent e) {
            char typed = e.getKeyChar();
            if (File.separatorChar == typed || '*' == typed || ':' == typed || '|' == typed) {
                e.consume();
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        private FileNameListener() {
            this.$init$();
        }

        FileNameListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DirURLTextField
    extends URLTextField
    implements DocumentListener,
    FocusListener {
        private String dir;

        DirURLTextField() {
            this.addFocusListener(this);
            this.getDocument().addDocumentListener(this);
        }

        public void setURL(URL url) {
            super.setURL(url);
            if (url != null) {
                String nameMinusExtension = NewFilePanel.mav$getFileNameWithoutExtension(NewFilePanel.this);
                if (nameMinusExtension.length() > 0 && NewFilePanel.this.fldDirectory.getText().endsWith(nameMinusExtension)) {
                    NewFilePanel.mav$setRootURL(NewFilePanel.this, URLFileSystem.getParent((URL)url));
                } else {
                    NewFilePanel.wa$_rootUrl(NewFilePanel.this, url);
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.dir = this.getText();
        }

        public void focusLost(FocusEvent e) {
            if (!this.dir.equals(this.getText())) {
                NewFilePanel.wa$_supportsAutoFill(NewFilePanel.this, false);
                URL u = this.getURL();
                if (u != null) {
                    NewFilePanel.mav$setRootURL(NewFilePanel.this, u);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }

        public void changedUpdate(DocumentEvent e) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }

        public void removeUpdate(DocumentEvent e) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }
    }
}

