/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RevertNodeCommand
extends Command {
    private boolean _confirm;

    public RevertNodeCommand() {
        this(false);
    }

    public RevertNodeCommand(boolean confirm) {
        super(52, 2);
        this.setNeedConfirm(confirm);
    }

    public int doit() throws Exception {
        Node node = this.getNode();
        if (node != null && this.getConfirmation()) {
            if (!node.mayHaveChildren()) {
                node.revert();
            } else {
                CloseNodeCommand clsCmd = new CloseNodeCommand();
                clsCmd.setContext(this.getContext());
                node.markDirty(false);
                clsCmd.close(node);
                UpdateMessage.fireObjectReloaded(node);
            }
            return 0;
        }
        return 1;
    }

    public boolean isNeedConfirm() {
        return this._confirm;
    }

    public void setNeedConfirm(boolean confirm) {
        this._confirm = confirm;
    }

    public static int reload(Node node) {
        return RevertNodeCommand.reload(node, false);
    }

    public static int reload(Node node, boolean confirm) {
        return RevertNodeCommand.reload(Context.newIdeContext(node), confirm);
    }

    public static int reload(Context context) {
        return RevertNodeCommand.reload(context, true);
    }

    public static int reload(Context context, boolean confirm) {
        int ret;
        RevertNodeCommand command = new RevertNodeCommand(confirm);
        command.setContext(context);
        try {
            ret = CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception ex) {
            ret = 1;
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)ex);
        }
        return ret;
    }

    private Node getNode() {
        Context context = this.getContext();
        if (context != null) {
            return context.getNode();
        }
        return null;
    }

    private boolean getConfirmation() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if (!this.isNeedConfirm()) {
            return true;
        }
        Node node = this.getNode();
        String filename = URLFileSystem.getPlatformPathName((URL)node.getURL());
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.format(365, filename), (String)IdeArb.getString(202), null);
    }
}

