/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class OpenCommand
extends Command {
    private Project project;
    private Workspace workspace;
    private Workspaces workspaces;
    private List addFiles;
    private List addToWorkspace;
    private List addToWorkspaces;

    private void $init$() {
        this.addFiles = new ArrayList();
        this.addToWorkspace = new ArrayList();
        this.addToWorkspaces = new ArrayList();
    }

    public OpenCommand() {
        super(9);
        this.$init$();
    }

    public final int openURL(URL url) throws Exception {
        return this.open(URLFileSystem.canonicalize((URL)url));
    }

    public final int doit() throws Exception {
        return this.open(null);
    }

    private int open(URL optionalURL) throws Exception {
        block14: {
            block13: {
                int returnVal;
                Context context = this.getContext();
                this.project = context.getProject();
                if (this.project == null && optionalURL == null) {
                    this.project = Ide.getActiveProject();
                }
                OpenCommandData data = (OpenCommandData)this.getData();
                this.workspace = context.getWorkspace();
                this.workspaces = Ide.getWorkspaces();
                String dialogTitle = IdeArb.getString(386);
                if (optionalURL != null) {
                    if (this.checkAddURL(optionalURL) != 0) {
                        return 0;
                    }
                    returnVal = 0;
                } else {
                    OpenURLChooser chooser = new OpenURLChooser();
                    DialogUtil.initURLChooser(chooser, context);
                    chooser.setSelectionScope(0);
                    if (data != null) {
                        dialogTitle = data.dialogTitle;
                        chooser.clearChooseableURLFilters();
                        chooser.setURLFilter(data.urlFilter);
                    }
                    OpenURLChooser content = chooser;
                    returnVal = chooser.showOpenDialog((Component)((Object)Ide.getMainWindow()), (Traversable)content, dialogTitle);
                    context.setProperty("selected-urls", chooser.getSelectedURLs());
                }
                if (returnVal != 0) break block13;
                ArrayList childrenAdded = new ArrayList(1);
                for (AddInfo info : this.addToWorkspaces) {
                    if (this.workspaces.containsChild(info.node)) continue;
                    this.checkWorkspaceOpen(info, this.workspaces, childrenAdded);
                }
                if (childrenAdded.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspaces, childrenAdded);
                }
                childrenAdded.clear();
                for (AddInfo info : this.addToWorkspace) {
                    if (this.workspace.containsChild(info.node)) continue;
                    this.checkProjectOpen(info, this.workspace, childrenAdded);
                }
                if (childrenAdded.size() > 0) {
                    UpdateMessage.fireChildrenAdded(this.workspace, childrenAdded);
                }
                AddInfo info2 = null;
                if (data != null) break block14;
                for (AddInfo info2 : this.addFiles) {
                    Node node = info2.node;
                    FileOpenHistory.getInstance().updateFileHistory(node.getURL());
                    SwingUtilities.invokeLater(new 1(this, node));
                }
                break block14;
            }
            Iterator iter = this.addToWorkspaces.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
            iter = this.addToWorkspace.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
            iter = this.addFiles.iterator();
            while (iter.hasNext()) {
                this.remove((AddInfo)iter.next());
            }
        }
        return 0;
    }

    private void openWithNoProject(Node node) {
        URL url = node.getURL();
        try {
            Node newNode = NodeFactory.findOrCreate(url);
            Context context = Context.newIdeContext(newNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
        }
        catch (Exception e) {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            ExceptionDialog.showExceptionDialog((Window)((Object)mainWindow), (Exception)e);
        }
    }

    private void remove(AddInfo info) {
        if (info.newNode) {
            NodeFactory.uncache(info.node.getURL());
        }
    }

    /*
     * Unable to fully structure code
     */
    private int checkAddURL(URL url) {
        fileName = URLFileSystem.getPlatformPathName((URL)url);
        newNode = false;
        node = NodeFactory.find(url);
        if (node == null) {
            newNode = true;
            try {
                node = NodeFactory.findOrCreate(url);
                node = this.checkOpenAsText(node, newNode);
                if (node == null) {
                    var9_5 = 1;
                    return var9_5;
                }
                if (!node.isNew()) ** GOTO lbl22
                node.markDirty(true);
            }
            catch (Exception e) {
                msg = IdeArb.format(474, fileName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString(397), 0);
                var10_8 = 1;
                return var10_8;
            }
        } else if ((node = this.checkOpenAsText(node, newNode)) == null) {
            return 1;
        }
lbl22:
        // 4 sources

        info = new AddInfo(node, newNode);
        status = 0;
        if (this.workspace != null && this.workspace.canAdd(node)) {
            this.addToWorkspace.add(info);
        } else if (this.workspaces != null && this.workspaces.canAdd(node)) {
            this.addToWorkspaces.add(info);
        } else if (node instanceof Project) {
            status = this.createWorkspaceForProject(node, info, newNode);
        } else {
            this.addFiles.add(info);
        }
        return status;
    }

    private String generateApplicationName(Node projectNode) {
        URL parent = URLFileSystem.getParent((URL)projectNode.getURL());
        String applicationName = URLFileSystem.getName((URL)projectNode.getURL()) + "Application";
        URL applicationURL = URLFactory.newURL((URL)parent, (String)(applicationName + ".jws"));
        int i = 0;
        while (URLFileSystem.exists((URL)applicationURL)) {
            applicationURL = URLFactory.newURL((URL)parent, (String)(applicationName + ++i + ".jws"));
        }
        return URLFileSystem.getFileName((URL)applicationURL);
    }

    private int createWorkspaceForProject(Node projectNode, AddInfo info, boolean newNode) {
        int status = 0;
        NewWorkspacePanel wspPanel = new NewWorkspacePanel(false, false, true);
        wspPanel.setSupportsAutoFill(false);
        wspPanel.setDirectoryURL(URLFileSystem.getParent((URL)projectNode.getURL()));
        wspPanel.setFileName(this.generateApplicationName(projectNode));
        if (wspPanel.runDialog(IdeArb.getString(446))) {
            URL workspaceURL = wspPanel.getFileURL();
            try {
                this.workspace = NewWorkspaceCommand.createEmptyWorkspace(this.getContext(), workspaceURL);
                if (this.workspace != null && this.workspace.canAdd(projectNode)) {
                    this.addToWorkspace.add(info);
                }
            }
            catch (Exception e) {
                status = 1;
            }
        } else {
            status = 1;
        }
        if (status == 1) {
            if (newNode) {
                NodeFactory.uncache(projectNode.getURL());
            }
            status = 0;
        }
        return status;
    }

    private Node checkOpenAsText(Node node, boolean newNode) {
        if (node.getAttributes().isSet(ElementAttributes.OPEN_AS_TEXT)) {
            URL url = node.getURL();
            try {
                URL newURL = URLFactory.newIdeURL((String)"ide.text", (URL)url);
                node = NodeFactory.find(newURL);
                if (node == null) {
                    node = new TextNode();
                    node.setURL(newURL);
                }
                if (newNode) {
                    NodeFactory.uncache(url);
                }
            }
            catch (Exception e) {
                String msg = IdeArb.format(474, URLFileSystem.getPlatformPathName((URL)url));
                JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(397), 0);
                Node node2 = null;
                return node2;
            }
        }
        return node;
    }

    private void checkProjectOpen(AddInfo info, Workspace workspace, List childrenAdded) {
        MigrationInfo migInfo;
        NodeMigrator migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(info.node));
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration && migrator != null && (migInfo = migrator.getMigrationInfo(info.node)).getVersionStatus() != MigrationInfo.VERSION_CURRENT && migrator.migrate(migInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
            this.remove(info);
            return;
        }
        workspace.add(info.node);
        childrenAdded.add(info.node);
        FileOpenHistory.getInstance().updateProjectHistory(info.node.getURL());
    }

    private void checkWorkspaceOpen(AddInfo info, Workspaces workspaces, List childrenAdded) {
        NodeMigrator migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(info.node));
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration && migrator != null) {
            MigrationInfo minfo = migrator.getMigrationInfo(info.node);
            MigrationInfo.Status nodeMigrationInfoStatus = minfo.getVersionStatus();
            if (!MigrationInfo.VERSION_CURRENT.toString().equals(nodeMigrationInfoStatus.toString()) && migrator.migrate(minfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
                this.remove(info);
                return;
            }
        }
        workspaces.add(info.node);
        childrenAdded.add(info.node);
        FileOpenHistory.getInstance().updateWorkspaceHistory(info.node.getURL());
    }

    static List ra$addFiles(OpenCommand openCommand) {
        return openCommand.addFiles;
    }

    static List ra$addToWorkspace(OpenCommand openCommand) {
        return openCommand.addToWorkspace;
    }

    static List ra$addToWorkspaces(OpenCommand openCommand) {
        return openCommand.addToWorkspaces;
    }

    static int mav$checkAddURL(OpenCommand openCommand, URL uRL) {
        return openCommand.checkAddURL(uRL);
    }

    static Project ra$project(OpenCommand openCommand) {
        return openCommand.project;
    }

    static void mav$openWithNoProject(OpenCommand openCommand, Node node) {
        openCommand.openWithNoProject(node);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ OpenCommand this$0;

        public void run() {
            if (OpenCommand.ra$project(this.this$0) == null || !OpenCommand.ra$project(this.this$0).containsChild(this.v$node)) {
                OpenCommand.mav$openWithNoProject(this.this$0, this.v$node);
            } else {
                EditorUtil.openExplicitDefaultEditorInFrame(this.v$node);
            }
            if (this.v$node.isNew()) {
                try {
                    this.v$node.save();
                    if (OpenCommand.ra$project(this.this$0) != null && OpenCommand.ra$project(this.this$0).isOpen()) {
                        UpdateMessage.fireChildAdded(OpenCommand.ra$project(this.this$0), this.v$node);
                    }
                }
                catch (IOException ex) {
                    String fileName = URLFileSystem.getPlatformPathName((URL)this.v$node.getURL());
                    String msg = IdeArb.format(231, fileName);
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(170), 0);
                }
            }
        }

        public 1(OpenCommand openCommand, Node node) {
            this.v$node = node;
            this.this$0 = openCommand;
        }
    }

    private static class AddInfo {
        final Node node;
        final boolean newNode;

        AddInfo(Node node, boolean newNode) {
            this.node = node;
            this.newNode = newNode;
        }
    }

    private class OpenURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC_OPEN = "f1_idedopenorcreatefile_html";

        OpenURLChooser() {
            this.setSelectionScope(2);
            this.setHelpID(HELP_TOPIC_OPEN);
        }

        public boolean approveSelection() {
            if (!super.approveSelection()) {
                return false;
            }
            OpenCommand.ra$addFiles(OpenCommand.this).clear();
            OpenCommand.ra$addToWorkspace(OpenCommand.this).clear();
            OpenCommand.ra$addToWorkspaces(OpenCommand.this).clear();
            URL[] selectedURLs = this.getSelectedURLs();
            int addCtr = 0;
            if (selectedURLs != null && selectedURLs.length > 0) {
                URL url;
                if (selectedURLs.length == 1 && !URLFileSystem.isBound((URL)(url = selectedURLs[0]))) {
                    String filename = URLFileSystem.getPlatformPathName((URL)url);
                    String msg = IdeArb.format(262, filename);
                    if (!MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.getString(204), null)) {
                        return false;
                    }
                }
                int i = 0;
                while (i < selectedURLs.length) {
                    if (OpenCommand.mav$checkAddURL(OpenCommand.this, selectedURLs[i]) == 0) {
                        ++addCtr;
                    }
                    ++i;
                }
            }
            return addCtr > 0;
        }
    }
}

