/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.HistoryList;

public final class FileOpenHistory
implements Controller {
    public static final String OPENED_FILES_NAME = "OpenedFiles";
    public static final String OPENED_PROJECTS_NAME = "OpenedProjects";
    public static final String OPENED_WORKSPACES_NAME = "OpenedWorkspaces";
    private static FileOpenHistory instance = new FileOpenHistory();
    private HistoryList openedFiles;
    private HistoryList openedProjects;
    private HistoryList openedWorkspaces;
    private JMenu reopenMenu;
    private JMenuItem EMPTY_ITEM;
    private int historyCount;
    private Map menuCache;
    private static IdeAction GLOBAL_REOPEN_ACTION;

    private void $init$() {
        this.historyCount = 4;
        this.menuCache = new HashMap();
    }

    private FileOpenHistory() {
        this.$init$();
        this.initialize();
    }

    public static FileOpenHistory getInstance() {
        return instance;
    }

    public void updateFileHistory(URL url) {
        this.getOpenedFiles().update(URL2String.toString(url));
    }

    public void updateProjectHistory(URL url) {
        this.getOpenedProjects().update(URL2String.toString(url));
    }

    public void updateWorkspaceHistory(URL url) {
        this.getOpenedWorkspaces().update(URL2String.toString(url));
    }

    public void updateHistory(Node node) {
        if (node instanceof Workspace) {
            this.getOpenedWorkspaces().update(URL2String.toString(node.getURL()));
        } else if (node instanceof Project) {
            this.getOpenedProjects().update(URL2String.toString(node.getURL()));
        } else {
            this.getOpenedFiles().update(URL2String.toString(node.getURL()));
        }
    }

    public void removeHistory(Node node) {
        if (node instanceof Workspace) {
            this.getOpenedWorkspaces().remove(URL2String.toString(node.getURL()));
        } else if (node instanceof Project) {
            this.getOpenedProjects().remove(URL2String.toString(node.getURL()));
        } else {
            this.getOpenedFiles().remove(URL2String.toString(node.getURL()));
        }
    }

    public String[] getFileHistory() {
        return this.getOpenedFiles().getHistory();
    }

    public String[] getProjectHistory() {
        return this.getOpenedProjects().getHistory();
    }

    public String[] getWorkspaceHistory() {
        return this.getOpenedWorkspaces().getHistory();
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int count) {
        this.historyCount = count;
    }

    public void save() {
        if (this.openedFiles != null) {
            this.openedFiles.save();
        }
        if (this.openedProjects != null) {
            this.openedProjects.save();
        }
        if (this.openedWorkspaces != null) {
            this.openedWorkspaces.save();
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 10) {
            this.reopen(action, context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    protected void initialize() {
        String historyCountProp = Ide.getProperty("Ide.DefaultReopenHistoryCount");
        if (historyCountProp != null) {
            try {
                this.historyCount = Integer.parseInt(historyCountProp);
                this.setHistoryCount(this.historyCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.reopenMenu = MenuManager.getJMenu("FileReopen");
        if (this.reopenMenu != null) {
            this.reopenMenu.add(this.getEmptyItem());
            this.reopenMenu.getPopupMenu().addPopupMenuListener(new 1());
        }
    }

    protected HistoryList getOpenedFiles() {
        if (this.openedFiles == null) {
            this.openedFiles = Ide.loadHistoryList(OPENED_FILES_NAME);
            this.openedFiles.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedFiles;
    }

    protected HistoryList getOpenedProjects() {
        if (this.openedProjects == null) {
            this.openedProjects = Ide.loadHistoryList(OPENED_PROJECTS_NAME);
            this.openedProjects.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedProjects;
    }

    protected HistoryList getOpenedWorkspaces() {
        if (this.openedWorkspaces == null) {
            this.openedWorkspaces = Ide.loadHistoryList(OPENED_WORKSPACES_NAME);
            this.openedWorkspaces.setMaxHistorySize(this.getHistoryCount());
        }
        return this.openedWorkspaces;
    }

    private void callPoppingUp() {
        String[] files = this.getFileHistory();
        String[] projects = this.getProjectHistory();
        String[] workspaces = this.getWorkspaceHistory();
        this.reopenMenu.removeAll();
        if (files.length == 0 && projects.length == 0 && workspaces.length == 0) {
            this.reopenMenu.add(this.getEmptyItem());
            return;
        }
        int count = 0;
        count = this.addMenuItems(files, count);
        count = this.addMenuItems(projects, count);
        this.addMenuItems(workspaces, count);
    }

    private int addMenuItems(String[] items, int count) {
        if (items.length > 0) {
            if (count > 0) {
                this.reopenMenu.add(new JSeparator());
            }
            count = 0;
            int i = 0;
            while (i < items.length) {
                JMenuItem menuItem = this.getMenuItem(items[i]);
                if (menuItem != null) {
                    this.reopenMenu.add(menuItem);
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    private JMenuItem getEmptyItem() {
        if (this.EMPTY_ITEM == null) {
            this.EMPTY_ITEM = new JMenuItem(IdeArb.getString(368));
            this.EMPTY_ITEM.setEnabled(false);
        }
        return this.EMPTY_ITEM;
    }

    private JMenuItem getMenuItem(String urlString) {
        JMenuItem menuItem = (JMenuItem)this.menuCache.get(urlString);
        if (menuItem != null) {
            try {
                URL url = URL2String.toURL(urlString);
                if (!URLFileSystem.exists((URL)url)) {
                    this.menuCache.remove(urlString);
                    JMenuItem jMenuItem = null;
                    return jMenuItem;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return menuItem;
        }
        try {
            URL url = URL2String.toURL(urlString);
            if (url == null || !URLFileSystem.exists((URL)url)) {
                JMenuItem jMenuItem = null;
                return jMenuItem;
            }
            IdeAction action = FileOpenHistory.getNewReopenAction(url);
            menuItem = Ide.getMenubar().createMenuItem(action);
            this.menuCache.put(urlString, menuItem);
            JMenuItem jMenuItem = menuItem;
            return jMenuItem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IdeAction getNewReopenAction(URL url) {
        Icon icon = null;
        try {
            Node node = NodeFactory.findOrCreate(url);
            icon = node.getIcon();
        }
        catch (Exception e) {
            icon = IdeArb.getIcon(352);
        }
        IdeAction localAction = FileOpenHistory.getGlobalReopenAction().newLocalAction(null);
        localAction.putValue("Name", URLFileSystem.getPlatformPathName((URL)url));
        localAction.putValue("SmallIcon", icon);
        localAction.putValue("UserData", url);
        return localAction;
    }

    public static IdeAction getGlobalReopenAction() {
        if (GLOBAL_REOPEN_ACTION == null) {
            GLOBAL_REOPEN_ACTION = IdeAction.get(10, AddinManager.getAddinManager().getCommand(10, "oracle.ide.cmd.NotImplementedCommand"), null, IdeMainWindow.ACTION_CATEGORY_FILE, null, null, null, true);
            GLOBAL_REOPEN_ACTION.addController(FileOpenHistory.getInstance());
        }
        return GLOBAL_REOPEN_ACTION;
    }

    private void reopen(IdeAction action, Context context) {
        URL url = (URL)action.getValue("UserData");
        try {
            Node node = NodeFactory.findOrCreate(url);
            if (this.tryWorkspacesFolder(Ide.getWorkspaces(), node)) {
                return;
            }
            if (this.tryWorkspaceFolder(context.getWorkspace(), node)) {
                return;
            }
            if (this.tryProjectFolder(context.getProject(), node)) {
                return;
            }
            if (node instanceof Project) {
                NewWorkspacePanel workspacePanel = new NewWorkspacePanel(false, false, true);
                if (!workspacePanel.runDialog()) {
                    return;
                }
                URL workspaceURL = workspacePanel.getFileURL();
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace(context, workspaceURL);
                Ide.setActiveWorkspace(workspace);
                if (this.tryWorkspaceFolder(workspace, node)) {
                    return;
                }
            }
            if (URLFileSystem.exists((URL)url)) {
                this.openEditor(node, false);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showErrorDialog(url);
    }

    private boolean tryWorkspacesFolder(Workspaces folder, Node node) {
        if (folder == null) {
            return false;
        }
        if (folder.canAdd(node)) {
            if (folder.containsChild(node)) {
                if (node instanceof Workspace) {
                    Workspace workspace = (Workspace)node;
                    Context newContext = Context.newIdeContext(workspace);
                    newContext.setWorkspace(workspace);
                    newContext.setProject(workspace.currentActiveProject());
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(newContext);
                }
                return true;
            }
            if (folder.add(node)) {
                UpdateMessage.fireChildAdded(folder, node);
                return true;
            }
        }
        return false;
    }

    private boolean tryWorkspaceFolder(Workspace folder, Node node) {
        if (folder == null) {
            return false;
        }
        if (folder.canAdd(node)) {
            if (folder.containsChild(node)) {
                if (node instanceof Project) {
                    Project project = (Project)node;
                    Context newContext = Context.newIdeContext(project);
                    newContext.setWorkspace(folder);
                    newContext.setProject(project);
                    NavigatorManager.getWorkspaceNavigatorManager().openNavigator(newContext);
                }
                return true;
            }
            if (folder.add(node)) {
                UpdateMessage.fireChildAdded(folder, node);
                return true;
            }
        }
        return false;
    }

    private boolean tryProjectFolder(Project folder, Node node) {
        if (folder != null && folder.canAdd(node)) {
            boolean updateHistory = folder.containsChild(node) ^ true;
            this.openEditor(node, updateHistory);
            return true;
        }
        return false;
    }

    private void openEditor(Node node, boolean updateHistory) {
        if (updateHistory) {
            this.updateFileHistory(node.getURL());
        }
        SwingUtilities.invokeLater(new 2(this, node));
    }

    private void showErrorDialog(URL url) {
        String name = URLFileSystem.getPlatformPathName((URL)url);
        String msg = IdeArb.format(474, name);
        JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(397), 0);
    }

    static void mav$callPoppingUp(FileOpenHistory fileOpenHistory) {
        fileOpenHistory.callPoppingUp();
    }

    final class 1
    implements PopupMenuListener {
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            FileOpenHistory.mav$callPoppingUp(FileOpenHistory.this);
        }

        public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public final void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ FileOpenHistory this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame(this.v$node);
        }

        public 2(FileOpenHistory fileOpenHistory, Node node) {
            this.v$node = node;
            this.this$0 = fileOpenHistory;
        }
    }
}

