/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import javax.ide.util.Version;
import oracle.javatools.util.PlatformUtils;

final class JavaVersion {
    String maxVersion() {
        return System.getProperty("ide.java.maxversion", "1.6.1");
    }

    String minVersion() {
        return System.getProperty("ide.java.minversion", this.defaultMinVersion());
    }

    private String defaultMinVersion() {
        return PlatformUtils.isWindows() ? "1.5.0_06" : "1.5.0";
    }

    String currentVersion() {
        return System.getProperty("java.version");
    }

    private Version normalizedMaxVersion() {
        return this.normalize(this.maxVersion());
    }

    private Version normalizedMinVersion() {
        return this.normalize(this.minVersion());
    }

    private Version normalizedCurrentVersion() {
        return this.normalize(this.currentVersion());
    }

    boolean isSupported() {
        Version minVersion = this.normalizedMinVersion();
        Version maxVersion = this.normalizedMaxVersion();
        Version curVersion = this.normalizedCurrentVersion();
        boolean atLeastMin = minVersion.compareTo(curVersion) <= 0;
        boolean belowMax = maxVersion.compareTo(curVersion) > 0;
        return atLeastMin && belowMax;
    }

    private Version normalize(String versionString) {
        versionString = versionString.trim();
        StringBuilder mainversion = new StringBuilder();
        StringBuilder subversion = null;
        boolean subversionIsNumeric = true;
        int i = 0;
        while (i < versionString.length()) {
            char c = versionString.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                if (subversion == null) {
                    mainversion.append(c);
                } else {
                    subversion.append(c);
                }
            } else if (subversion != null) {
                subversionIsNumeric = false;
            } else if (c == '_') {
                subversion = new StringBuilder();
            }
            ++i;
        }
        if (subversion != null && subversionIsNumeric) {
            mainversion.append('.');
            mainversion.append((CharSequence)subversion);
        }
        return new Version(mainversion.toString());
    }

    JavaVersion() {
    }
}

