/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.ExitNotAllowedException;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeController;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMacros;
import oracle.ide.IdeMainWindow;
import oracle.ide.JavaVersion;
import oracle.ide.Version;
import oracle.ide.boot.Launcher;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.PlatformProperties;
import oracle.ide.config.Preferences;
import oracle.ide.config.SplashScreenOptions;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.DialogWatcher;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationManager;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Reference;
import oracle.ide.model.Workspaces;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.TraceFileSystemAccess;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.internal.ui.EventThreadHangMonitor;
import oracle.javatools.jndi.Names;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;

public class IdeCore {
    private static final String APPLICATIONS_FILENAME = "applications.xml";
    private static final Logger LOG = Logger.getLogger(IdeCore.class.getName());
    private static final String INSTALL_PATH = "Ide.InstallPath";
    private final IdeArgs ideArgs;
    private final IdeController _controller;
    private final HashMap cmdTable;
    private final HashMap cmdHash;
    private WaitCursor waitCursor;
    private ActionMap anyActionMap;
    private String oracleHome;
    private String ideHome;
    private String userHome;
    private String trueUserHome;
    private String binDir;
    private String systemDirectory;
    private String productVersion;
    private IdeSettings settings;
    private DTCache dtCache;
    private KeyStrokeContextRegistry keyStrokeContextRegistry;
    private IdeProperties idePropertiesInstance;
    private IdeSystem ideSystem;
    private oracle.ide.model.Preferences preferences;
    private Workspaces workspaces;
    private ComponentVersionManager versionMgr;
    private Map _macros;
    private ArrayList _ideListeners;
    private boolean _quitting;
    private boolean _starting;
    private boolean forceInvokeLater;
    private static int nextUniqueCmd = 82;
    private String startupCaption;
    protected String productID;

    private void $init$() {
        this.cmdTable = new HashMap();
        this.cmdHash = new HashMap();
        this.versionMgr = new ComponentVersionManager();
        this.startupCaption = Version.NAME;
        this.productID = "oracle.ide";
    }

    protected IdeCore(IdeArgs ideArgs) {
        this.$init$();
        this.ideArgs = ideArgs;
        this._controller = new IdeController();
    }

    public void useInvokeLaterForAddinsLoadedEvenThoughHeadless() {
        this.forceInvokeLater = true;
    }

    protected String getSplashScreenFilename() {
        String splashImage = System.getProperty("ide.splash.screen");
        return splashImage != null ? splashImage : "splash.gif";
    }

    protected SecurityManager getSecurityManager() {
        return new 1();
    }

    protected AddinManager getAddinManager() {
        return null;
    }

    protected Addin[] createCoreModules() {
        return null;
    }

    protected void initializeLookAndFeel() {
        this.initializePlatformLookAndFeel();
    }

    private void initializePlatformLookAndFeel() {
        try {
            if (PlatformUtils.isMac()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                try {
                    Class<?> cls = Class.forName("oracle.bali.ewt.olaf2.OracleLookAndFeel");
                    UIManager.setLookAndFeel(cls.getName());
                }
                catch (Exception e) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IdeArgs getIdeArgs() {
        return this.ideArgs;
    }

    protected boolean isHeadless() {
        return this.ideArgs.getCreateUI() ^ true;
    }

    Controller getController() {
        return this._controller;
    }

    protected String getProductID() {
        return this.productID;
    }

    String getProductVersion() {
        return this.productVersion;
    }

    String getBinDirectory() {
        return this.binDir;
    }

    String getHomeDirectory() {
        return this.ideHome;
    }

    String getOracleHomeDirectory() {
        if (this.oracleHome == null) {
            this.oracleHome = Launcher.getOracleHome();
            if (this.oracleHome == null) {
                File f = new File(this.getHomeDirectory());
                this.oracleHome = f.getParent();
            }
            if (!this.oracleHome.endsWith(File.pathSeparator)) {
                this.oracleHome = this.oracleHome + File.separator;
            }
        }
        return this.oracleHome;
    }

    String getLibDirectory() {
        return this.getHomeDirectory() + "lib" + File.separator;
    }

    String getUserHomeDirectory() {
        return this.userHome;
    }

    String getTrueUserHomeDirectory() {
        return this.trueUserHome;
    }

    String getSystemDirectory() {
        return this.systemDirectory;
    }

    String getWorkDirectory() {
        Workspaces wsps = this.getWorkspaces();
        if (wsps != null) {
            URL workDirURL = wsps.getWorkDirectory();
            return URLFileSystem.getPlatformPathName((URL)workDirURL) + File.separator;
        }
        return this.getDefaultWorkDirectoryLocation();
    }

    private String getDefaultWorkDirectoryLocation() {
        String defaultLocation = System.getProperty("ide.work.dir");
        if (ModelUtil.hasLength((String)defaultLocation)) {
            if (!(defaultLocation = IdeCore.canonicalize(defaultLocation)).endsWith(File.separator)) {
                defaultLocation = defaultLocation + File.separator;
            }
            defaultLocation = defaultLocation + "mywork";
            defaultLocation = defaultLocation + File.separator;
            return defaultLocation;
        }
        return this.getHomeDirectory() + "mywork" + File.separator;
    }

    String getProgramName() {
        return IdeUtil.getProgramName();
    }

    String getProgramShortName() {
        return IdeUtil.getProgramShortName();
    }

    IdeProperties getIdeProperties() {
        return this.idePropertiesInstance;
    }

    protected String getProperty(String key, String def) {
        IdeProperties props = this.getIdeProperties();
        return props != null ? props.getProperty(key, def) : null;
    }

    String setProperty(String key, String value) {
        IdeProperties props = this.getIdeProperties();
        return (String)(props != null ? props.setProperty(key, value) : null);
    }

    IdeMainWindow getMainWindow() {
        return (IdeMainWindow)MainWindow.getMainWindow((javax.naming.Context)Names.newInitialContext(), (int)1);
    }

    WaitCursor getWaitCursor() {
        if (this.waitCursor == null) {
            this.waitCursor = new MainWindowWaitCursor((Component)((Object)this.getMainWindow()));
        }
        return this.waitCursor;
    }

    ComponentVersionManager getVersionInfo() {
        return this.versionMgr;
    }

    IdeSettings getSettings() {
        return this.loadIdeSettings();
    }

    KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        if (this.keyStrokeContextRegistry == null) {
            this.keyStrokeContextRegistry = new KeyStrokeContextRegistry();
            this.keyStrokeContextRegistry.addListener(new 2());
        }
        return this.keyStrokeContextRegistry;
    }

    EnvironOptions getEnvironOptions() {
        return EnvironOptions.getInstance(Preferences.getPreferences());
    }

    DTCache getDTCache() {
        if (this.dtCache == null) {
            this.dtCache = new DTCache();
            this.dtCache.load();
        }
        return this.dtCache;
    }

    protected URL productSystemDirectory() {
        return ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this.getProductID());
    }

    IdeSystem getSystem() {
        if (this.ideSystem == null) {
            URL systemDir = this.productSystemDirectory();
            URL url = URLFactory.newURL((URL)systemDir, (String)"System.sys");
            if (URLFileSystem.exists((URL)url)) {
                this.ideSystem = new IdeSystem(url);
            } else {
                url = URLFactory.newURL((URL)systemDir, (String)APPLICATIONS_FILENAME);
                this.ideSystem = new IdeSystem(url);
            }
        }
        return this.ideSystem;
    }

    oracle.ide.model.Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.getSystem().getPreferences();
            if (this.preferences == null) {
                this.preferences = (oracle.ide.model.Preferences)this.getSystem().getChild(oracle.ide.model.Preferences.class);
                if (this.preferences == null) {
                    this.preferences = new oracle.ide.model.Preferences();
                }
                this.getSystem().remove(this.preferences);
                this.getSystem().setPreferences(this.preferences);
            }
        }
        return this.preferences;
    }

    Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = (Workspaces)this.getSystem().getChild(Workspaces.class);
            if (this.workspaces == null) {
                this.workspaces = new Workspaces();
            }
        }
        return this.workspaces;
    }

    void addIdeListener(IdeListener l) {
        if (this._ideListeners == null) {
            this._ideListeners = new ArrayList(2);
        }
        this._ideListeners.add(l);
    }

    void removeIdeListener(IdeListener l) {
        if (this._ideListeners != null) {
            this._ideListeners.remove(l);
        }
    }

    InputMap getIdeInputMap() {
        return this.getMainWindow().getInputMap();
    }

    ActionMap getIdeActionMap() {
        IdeMainWindow mainWindow = this.getMainWindow();
        if (mainWindow == null) {
            if (this.anyActionMap == null) {
                this.anyActionMap = new ActionMap();
            }
            return this.anyActionMap;
        }
        return mainWindow.getActionMap();
    }

    boolean isQuitting() {
        return this._quitting;
    }

    boolean isStarting() {
        return this._starting;
    }

    int createCmdID(String commandName) {
        return this.createCmdID(-1, commandName);
    }

    private int createCmdID(int nCmdID, String commandName) {
        if (nCmdID == -1) {
            nCmdID = ++nextUniqueCmd;
        }
        Integer cmdID = nCmdID;
        this.cmdTable.put(cmdID, commandName);
        this.cmdHash.put(commandName, cmdID);
        return nCmdID;
    }

    int findOrCreateCmdID(String commandName) {
        return this.findOrCreateCmdID(-1, commandName);
    }

    private int findOrCreateCmdID(int nCmdID, String commandName) {
        Integer cmdID = this.findCmdID(commandName);
        if (cmdID != null) {
            return cmdID;
        }
        return this.createCmdID(nCmdID, commandName);
    }

    Integer findCmdID(String commandName) {
        return (Integer)this.cmdHash.get(commandName);
    }

    String findCmdName(int cmdId) {
        return (String)this.cmdTable.get(cmdId);
    }

    Map getMacros() {
        if (this._macros == null) {
            String mIdeHome = this.getHomeDirectory();
            String mSystem = this.getSystemDirectory();
            String mUserHome = this.getUserHomeDirectory();
            String mWorkDir = this.getWorkDirectory();
            this._macros = new IdeMacros(mIdeHome, mSystem, mUserHome, mWorkDir).getMap();
        }
        return this._macros;
    }

    int quit(IdeAction action, Context context) {
        if (this._quitting) {
            return 1;
        }
        this._quitting = true;
        Command command = CommandProcessor.createCommand(action.getCommand(), context);
        command.setData(this.getMainWindow().getIdeMainWindowView());
        int status = 1;
        try {
            try {
                status = CommandProcessor.getInstance().invoke(command);
            }
            catch (Exception e) {
                status = 1;
            }
        }
        finally {
            if (status == 1) {
                this._quitting = false;
            }
        }
        return status;
    }

    void terminate() {
        this.fireIdeEvent(3);
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.activateLayout(null, false);
        }
        SaveAllCommand.saveSystemFiles();
        VirtualFileSystemHelper.shutdownVFS();
        TraceFileSystemAccess.shutdown();
    }

    void fireIdeEvent(int nEventID) {
        if (this._ideListeners != null) {
            3 runnable = new 3(this, nEventID);
            if (this.getIdeArgs().getCreateUI() || this.forceInvokeLater) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void fireIdeEvent(IdeListener l, IdeEvent e) {
        switch (e.getID()) {
            case 1: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.addinsLoaded");
                    l.addinsLoaded(e);
                    PerformanceLogger.get().stopTiming("IdeListener.addinsLoaded", l.getClass().getName());
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing addinsLoaded to " + l, exc);
                }
                break;
            }
            case 2: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowOpened");
                    l.mainWindowOpened(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowOpened", l.getClass().getName());
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowOpened to " + l, exc);
                }
                break;
            }
            case 3: {
                try {
                    PerformanceLogger.get().startTiming("IdeListener.mainWindowClosing");
                    l.mainWindowClosing(e);
                    PerformanceLogger.get().stopTiming("IdeListener.mainWindowClosing", l.getClass().getName());
                }
                catch (Throwable exc) {
                    LOG.log(Level.SEVERE, "Exception firing mainWindowClosing to " + l, exc);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getInstallDirectory(File systemDir) {
        BufferedInputStream in = null;
        try {
            Properties ideProps = new Properties();
            File propsFile = new File(systemDir, "ide.properties");
            in = new BufferedInputStream(new FileInputStream(propsFile));
            ideProps.load(in);
            String string = ideProps.getProperty(INSTALL_PATH, null);
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load ide.properties", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static void registerStreamFactory() {
        try {
            URL.setURLStreamHandlerFactory(URLStreamHandlerFactoryQueue.getInstance());
        }
        catch (Error error) {
            // empty catch block
        }
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new 4());
    }

    protected void startupImpl() {
        if (this._starting) {
            throw new IllegalStateException("IDE is already started");
        }
        this._starting = true;
        IdeCore.registerStreamFactory();
        System.setProperty("ide.build", Version.BUILD_LABEL);
        StartupWindow startupWindow = null;
        try {
            if (Version.DEBUG_BUILD != 0 && !Boolean.valueOf(System.getProperty("ide.noassert")).booleanValue()) {
                Thread.currentThread().getContextClassLoader().setPackageAssertionStatus("oracle", true);
            }
            ToStringManager.registerCustomConverter(KeyStroke2String.class);
            Object2Dom.exemptTypeFromIdref(Reference.class);
            Object2Dom.exemptTypeFromIdref(KeyStroke.class);
            this.binDir = IdeCore.canonicalize(System.getProperty("user.dir", "."));
            if (!this.binDir.endsWith(File.separator)) {
                this.binDir = this.binDir + File.separator;
            }
            this.ideHome = IdeCore.canonicalize(System.getProperty("ide.home", null));
            if (!ModelUtil.hasLength((String)this.ideHome)) {
                File f = new File(this.binDir);
                this.ideHome = f.getParent();
            }
            if (!this.ideHome.endsWith(File.separator)) {
                this.ideHome = this.ideHome + File.separator;
            }
            String ideUserDir = System.getProperty("ide.pref.dir");
            this.userHome = IdeCore.canonicalize(ideUserDir);
            if (!ModelUtil.hasLength((String)this.userHome)) {
                ideUserDir = System.getProperty("ide.user.dir");
                this.userHome = IdeCore.canonicalize(ideUserDir);
                if (!ModelUtil.hasLength((String)this.userHome)) {
                    this.userHome = this.ideHome;
                }
            }
            if (!this.userHome.endsWith(File.separator)) {
                this.userHome = this.userHome + File.separator;
            }
            this.trueUserHome = IdeCore.canonicalize(System.getProperty("user.home", null));
            if (!ModelUtil.hasLength((String)this.trueUserHome)) {
                this.trueUserHome = this.userHome;
            } else if (!this.trueUserHome.endsWith(File.separator)) {
                this.trueUserHome = this.trueUserHome + File.separator;
            }
            this.productVersion = System.getProperty("product.version", null);
            if (!ModelUtil.hasLength((String)this.productVersion)) {
                this.productVersion = Version.VER + "." + Version.BUILD_NUM;
            }
            this.systemDirectory = this.userHome + "system" + Version.VER_FULL + File.separator;
            URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
            if (fileHelper != null) {
                URLFileSystemHelper fileSystemHelper = IdeCore.getFileSystemHelper(fileHelper);
                URLFileSystem.registerHelper((String)"file", (URLFileSystemHelper)fileSystemHelper);
            }
            VirtualFileSystemHelper.enableVFS();
            if (this.ideArgs.getCreateUI()) {
                startupWindow = new StartupWindow(this.startupCaption, null);
                IdeUtil.setStartupWindow(startupWindow);
                String splashFile = this.getSplashScreenFilename();
                if (splashFile != null && SplashScreenOptions.getShowSplashScreen() && !Ide.getIdeArgs().hasArg("-nonag")) {
                    int steps = SplashScreenOptions.getSplashScreenCounter();
                    if (steps != -1) {
                        SplashScreen.create((String)(this.binDir + splashFile), (int)steps);
                    } else {
                        SplashScreen.create((String)(this.binDir + splashFile));
                    }
                }
            }
            this.createCmdID(0, "Ide.NEW_WORKSPACE_CMD_ID");
            this.createCmdID(67, "Ide.NEW_VIEW_CMD_ID");
            this.createCmdID(68, "Ide.FREEZE_CMD_ID");
            this.createCmdID(70, "ACTIVATE_LEFT_BUTTON_CMD_ID");
            this.createCmdID(71, "ACTIVATE_RIGHT_BUTTON_CMD_ID");
            this.createCmdID(2, "Ide.NEW_PROJECT_CMD_ID");
            this.createCmdID(3, "Ide.NEW_EMPTY_PROJECT_CMD_ID");
            this.createCmdID(4, "Ide.EXIT_CMD_ID");
            this.createCmdID(5, "Ide.UNDO_CMD_ID");
            this.createCmdID(6, "Ide.REDO_CMD_ID");
            this.createCmdID(65, "Ide.SYSTEM_CMD_ID");
            this.createCmdID(64, "Ide.APPLICATIONS_CMD_ID");
            this.createCmdID(66, "Ide.CONNECTIONS_CMD_ID");
            this.createCmdID(8, "Ide.NEW_CLASS_CMD_ID");
            this.createCmdID(9, "Ide.OPEN_CMD_ID");
            this.createCmdID(10, "Ide.REOPEN_CMD_ID");
            this.createCmdID(11, "Ide.SAVE_CMD_ID");
            this.createCmdID(12, "Ide.SAVE_AS_CMD_ID");
            this.createCmdID(13, "Ide.SAVE_ALL_CMD_ID");
            this.createCmdID(52, "Ide.REVERT_CMD_ID");
            this.createCmdID(14, "Ide.RENAME_CMD_ID");
            this.createCmdID(15, "Ide.PRINTER_SETUP_CMD_ID");
            this.createCmdID(16, "Ide.PRINT_CMD_ID");
            this.createCmdID(17, "Ide.CUT_CMD_ID");
            this.createCmdID(18, "Ide.COPY_CMD_ID");
            this.createCmdID(77, "Ide.COPY_PATH_CMD_ID");
            this.createCmdID(19, "Ide.PASTE_CMD_ID");
            this.createCmdID(78, "Ide.EXTENDED_PASTE_CMD_ID");
            this.createCmdID(20, "Ide.DELETE_CMD_ID");
            this.createCmdID(48, "Ide.CLOSE_NODE_CMD_ID");
            this.createCmdID(51, "Ide.REFRESH_CMD_ID");
            this.createCmdID(21, "Ide.REMOVE_FILE_CMD_ID");
            this.createCmdID(47, "Ide.REMOVE_FROM_DISK_CMD_ID");
            this.createCmdID(22, "Ide.SELECT_ALL_CMD_ID");
            this.createCmdID(23, "Ide.FIND_CMD_ID");
            this.createCmdID(24, "Ide.REPLACE_CMD_ID");
            this.createCmdID(25, "Ide.SEARCH_AGAIN_CMD_ID");
            this.createCmdID(53, "Ide.SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(26, "Ide.INCREMENTAL_SEARCH_FORWARD_CMD_ID");
            this.createCmdID(27, "Ide.INCREMENTAL_SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(28, "Ide.SEARCH_SOURCE_PATH_CMD_ID");
            this.createCmdID(29, "Ide.GOTO_LINE_NUMBER_CMD_ID");
            this.createCmdID(30, "Ide.NEXTMSG_CMD_ID");
            this.createCmdID(31, "Ide.PREVMSG_CMD_ID");
            this.createCmdID(32, "Ide.BROWSE_SYMBOL_CMD_ID");
            this.createCmdID(33, "Ide.INSPECTOR_CMD_ID");
            this.createCmdID(34, "Ide.LOG_WINDOW_CMD_ID");
            this.createCmdID(35, "Ide.PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(36, "Ide.TOOLBAR_CMD_ID");
            this.createCmdID(69, "Ide.STATUS_BAR_CMD_ID");
            this.createCmdID(37, "Ide.DEFAULT_PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(38, "Ide.IDE_SETTINGS_CMD_ID");
            this.createCmdID(39, "Ide.CLOSE_ALL_CMD_ID");
            this.createCmdID(44, "Ide.STRUCTURE_CHANGE_CMD_ID");
            this.createCmdID(45, "Ide.PROPERTY_SET_CMD_ID");
            this.createCmdID(49, "Ide.EXPLORER_CMD_ID");
            this.createCmdID(40, "Ide.NEXT_EDITOR_CMD_ID");
            this.createCmdID(41, "Ide.PREV_EDITOR_CMD_ID");
            this.createCmdID(42, "Ide.NEXT_EDITORFRAME_CMD_ID");
            this.createCmdID(43, "Ide.PREV_EDITORFRAME_CMD_ID");
            this.createCmdID(50, "Ide.CONTEXT_MENU_CMD_ID");
            this.createCmdID(54, "Ide.EXPAND_ALL_CMD_ID");
            this.createCmdID(55, "Ide.COLLAPSE_ALL_CMD_ID");
            this.createCmdID(56, "Ide.PROPERTIES_CMD_ID");
            this.createCmdID(57, "Ide.NAVIGATE_CMD_ID");
            this.createCmdID(58, "Ide.WINDOW_TILE_HORZ_CMD_ID");
            this.createCmdID(59, "Ide.WINDOW_TILE_VERT_CMD_ID");
            this.createCmdID(60, "Ide.WINDOW_CASCADE_CMD_ID");
            this.createCmdID(61, "Ide.WINDOWS_DOT_DOT_DOT_CMD_ID");
            this.createCmdID(73, "Ide.BACK_CMD_ID");
            this.createCmdID(74, "Ide.FORWARD_CMD_ID");
            this.createCmdID(75, "Ide.LAST_EDIT_CMD_ID");
            this.createCmdID(76, "Ide.REPLACE_SOURCE_PATH_CMD_ID");
            this.createCmdID(79, "Ide.ABOUT_CMD_ID");
            String encodingsFileStr = System.getProperty("ide.encodings.file");
            String oracleHome = this.getOracleHomeDirectory();
            File ideBinDir = new File(oracleHome, "ide" + File.separatorChar + "bin");
            File encodingsFile = new File(ideBinDir, encodingsFileStr != null ? encodingsFileStr : "encodings.xml");
            Encodings.setEncodingsFile((File)encodingsFile);
            System.setProperty("java.naming.factory.initial", "oracle.javatools.jndi.LocalInitialContextFactory");
            if (this.ideArgs.getCreateUI()) {
                this.initializePlatformLookAndFeel();
            }
            PlatformProperties.setForceLoad(this.ideArgs.getPlatformFileName());
            Beans.setDesignTime(true);
            File systemDir = new File(this.getSystemDirectory() + File.separator + "o.ide");
            System.setProperty("ide.firstrun", String.valueOf(systemDir.exists() ^ true));
            boolean inAde = false;
            File dir = new File(this.oracleHome);
            while (dir != null) {
                String lowerName = dir.getName().toLowerCase();
                if ("ade".equals(lowerName) || ".ade".equals(lowerName)) {
                    inAde = true;
                    break;
                }
                dir = dir.getParentFile();
            }
            System.setProperty("ide.devbuild", String.valueOf(inAde));
            File systemDir2 = new File(this.getSystemDirectory() + File.separator + "o.ide" + File.separator + "diagnostics" + File.separator);
            Diagnostics.setDiagnosticDirectory((File)systemDir2);
            this.getAddinManager();
            PerformanceLogger.get().startTiming("init_extensionRegistry", "Initializing extensions...");
            ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
            PerformanceLogger.get().stopTiming("init_extensionRegistry", "Initialized extensions");
            if (Boolean.getBoolean("ide.awthangmonitor")) {
                EventThreadHangMonitor.initMonitoring();
            }
            PerformanceLogger.get().startTiming("init_branding", "Branding...");
            String productId = Product.getProductID();
            if (productId != null && reg.findExtension(productId) == null) {
                Extension ext = reg.findExtensionEvenIfNotLoaded(productId);
                System.err.println("Product extension " + productId + " could not be loaded. The product cannot start.");
                if (ext != null && ext instanceof DefaultExtension) {
                    DefaultExtension de = (DefaultExtension)ext;
                    System.err.println("Missing dependencies: ");
                    Collection imports = de.getAllImportedExtensions((javax.ide.extension.ExtensionRegistry)ExtensionRegistry.getExtensionRegistry());
                    for (String s : imports) {
                        if (reg.findExtension(s) != null) continue;
                        System.err.println("  " + s);
                    }
                }
                System.err.println("Disabled extensions:");
                for (String id : reg.getDisabledExtensions()) {
                    System.err.println("  " + id + ": " + reg.getNotLoadedReason(id));
                }
                System.exit(1);
            }
            if (this.ideArgs.getCreateUI()) {
                this.installAboutBox();
            }
            PerformanceLogger.get().stopTiming("init_branding", "Branded");
            SplashScreen.log((String)IdeArb.getString(9));
            this.verifyUserHome();
            this.copyExtensionUserData();
            SplashScreen.log((String)IdeArb.getString(370));
            this.loadIdeSettings();
            new NativeHandler().initialize();
            MigrationManager migrationManager = MigrationManager.getMigrationManager();
            if (migrationManager != null) {
                migrationManager.migrate();
            }
            SplashScreen.log((String)IdeArb.getString(447));
            this.loadIdeProperties();
            MessageDialog.setPersistence((MessageDialogPersistence)new 5());
            SplashScreen.log((String)IdeArb.getString(140));
            this.verifyJdkVersion();
            SecurityManager security = this.getSecurityManager();
            if (security != null) {
                System.setSecurityManager(security);
            }
            SplashScreen.log((String)IdeArb.getString(415));
            this.getPreferences();
            if (this.ideArgs.getCreateUI()) {
                this.initializeLookAndFeel();
            }
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.initializeCoreModules", "Initializing core modules...");
            SplashScreen.log((String)IdeArb.getString(45));
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.createCoreModules");
            Addin[] coreModules = this.createCoreModules();
            if (this.ideArgs.getCreateUI()) {
                IdeUtil.setMainWindow((JFrame)((Object)this.getMainWindow()));
            }
            this.brandMainWindow();
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.createCoreModules", "Created core modules");
            SplashScreen.log((String)IdeArb.getString(123));
            IdeCore.initializeModules(coreModules);
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.initializeCoreModules", "Initialized core modules");
            this.initProductAndUserAddins();
            VirtualFileSystemHelper.enableNativeWatching();
            EnvironOptions options = this.getEnvironOptions();
            boolean verify = options.getVerifyCachedFileData();
            VirtualFileSystemHelper.setVerifyPersistedData(verify);
            if (migrationManager != null) {
                migrationManager.finishMigration();
            }
            if (this.ideArgs.getCreateUI()) {
                FileOpenHistory.getInstance();
                GrabbableFocusManager.install();
                DialogWatcher.install();
                this.getMainWindow().postInitialize(this.ideArgs);
                this.fireIdeEvent(2);
            }
            this.startupCaption = this.getProductNameFromBranding();
            SwingUtils.setProgramName((String)this.startupCaption);
            String shortName = this.getProductShortNameFromBranding();
            SwingUtils.setProgramShortName((String)shortName);
            boolean showImages = Boolean.getBoolean("ide.wizard.legacyimages");
            if (!showImages) {
                BaseWizard.setImageWizardPageSupported((boolean)false);
            }
            this.defaultMyWorkDirectory();
        }
        catch (Throwable throwable) {
            this._starting = false;
            if (startupWindow != null) {
                IdeUtil.setStartupWindow(null);
                StartupWindow fStartupWindow = startupWindow;
                SwingUtilities.invokeLater(new 6(this, fStartupWindow));
            }
            throw throwable;
        }
        this._starting = false;
        if (startupWindow != null) {
            IdeUtil.setStartupWindow(null);
            StartupWindow fStartupWindow = startupWindow;
            SwingUtilities.invokeLater(new 6(this, fStartupWindow));
        }
    }

    private void defaultMyWorkDirectory() {
        Workspaces ws = this.getWorkspaces();
        if (ws == null) {
            return;
        }
        URL workDir = ws.getWorkDirectory();
        if (workDir != null) {
            return;
        }
        ws.setWorkDirectory(URLFactory.newDirURL((String)this.getDefaultWorkDirectoryLocation()));
    }

    private static URLFileSystemHelper getFileSystemHelper(URLFileSystemHelper helper) {
        String traceFileName = null;
        PrintStream printStream = null;
        IdeArgs ideArgs = Ide.getIdeArgs();
        String[] args = ideArgs.getArgs();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            String option = "-TraceFS";
            if (arg.startsWith("-TraceFS")) {
                String optionArg = arg.substring("-TraceFS".length());
                if (optionArg.length() == 0) {
                    printStream = System.err;
                    break;
                }
                if (optionArg.charAt(0) != '=') break;
                traceFileName = optionArg.substring(1);
                break;
            }
            ++i;
        }
        if (traceFileName == null && printStream == null) {
            VirtualFileSystemHelper vfsHelper = new VirtualFileSystemHelper(helper);
            return vfsHelper;
        }
        TraceFileSystemAccess traceFileSystemAccess = traceFileName != null ? TraceFileSystemAccess.start(helper, traceFileName, true) : TraceFileSystemAccess.start(helper, printStream, true);
        VirtualFileSystemHelper vfsHelper = new VirtualFileSystemHelper((URLFileSystemHelper)traceFileSystemAccess);
        return vfsHelper;
    }

    private static String canonicalize(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            return dir;
        }
        File f = new File(dir);
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f.toString();
    }

    private void verifyUserHome() {
        File userHomeFile = new File(this.userHome + File.separator).getAbsoluteFile();
        userHomeFile.mkdirs();
        if (!userHomeFile.isDirectory() || !userHomeFile.canWrite()) {
            String msg = IdeArb.format(229, userHomeFile.getAbsolutePath());
            String title = this.startupCaption;
            MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)msg, (String)title, null);
            System.exit(1);
        }
    }

    private synchronized IdeSettings loadIdeSettings() {
        if (this.settings == null) {
            this.settings = new IdeSettings();
            this.settings.load();
            this.settings.init();
            EnvironOptions opts = this.getEnvironOptions();
            IdeUtil.setIdeEncoding(opts.getEncoding());
            opts.addChangeListener(new 7());
            KeyStrokeOptions keyStrokeOptions = this.settings.getKeyStrokeOptions();
            keyStrokeOptions.setKeyboardPanelEventDispatcher(new 8());
        }
        return this.settings;
    }

    private void loadIdeProperties() {
        if (this.idePropertiesInstance == null) {
            this.idePropertiesInstance = new IdeProperties();
            this.idePropertiesInstance.ensureOpen();
            this.idePropertiesInstance.setProperty(INSTALL_PATH, this.binDir);
        }
    }

    private void verifyJdkVersion() {
        JavaVersion javaVersion;
        String showBadJdkWarningProperty = this.getProperty("showBadJdkWarning", Boolean.TRUE.toString());
        String launchedFromJDev = this.getProperty("launched.from.jdev", Boolean.FALSE.toString());
        if (Boolean.valueOf(showBadJdkWarningProperty).booleanValue() && !Boolean.valueOf(launchedFromJDev).booleanValue() && !(javaVersion = new JavaVersion()).isSupported()) {
            if (this.ideArgs.getCreateUI()) {
                if (!Ide.getIdeArgs().hasArg("-nonag")) {
                    SplashScreen.setVisible((boolean)false);
                    String msg = IdeArb.format(413, javaVersion.currentVersion(), javaVersion.minVersion(), javaVersion.maxVersion());
                    new 9(this, msg).doit();
                    SplashScreen.setVisible((boolean)true);
                }
            } else {
                String msg = IdeArb.format(240, javaVersion.minVersion(), javaVersion.currentVersion());
                System.err.println(msg);
            }
        }
    }

    private static void initializeModules(Addin[] modules) {
        if (modules != null) {
            int n = modules.length;
            int i = 0;
            while (i < n) {
                Addin module = modules[i];
                if (module != null) {
                    try {
                        try {
                            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.module." + module.getClass().getName());
                            module.initialize();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    finally {
                        PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.module." + module.getClass().getName(), module.getClass().getName());
                    }
                }
                ++i;
            }
        }
    }

    protected void initProductAndUserAddins() {
        AddinManager.getAddinManager().initProductAndUserAddins();
        this.fireIdeEvent(1);
    }

    protected void copyExtensionUserData() {
    }

    private void installAboutBox() {
        AboutBoxModel model = new AboutBoxModel();
        model.setProductName(Ide.getProgramName());
        AboutBoxFactory factory = new AboutBoxFactory();
        factory.setModel(model);
        this.installAboutBox(factory);
        AboutBoxFactory.setAboutBoxFactory(factory);
        this.initAboutBoxModel();
    }

    protected void installAboutBox(AboutBoxFactory factory) {
    }

    protected String getProductNameFromBranding() {
        return "";
    }

    protected String getProductShortNameFromBranding() {
        return "";
    }

    protected void initAboutBoxModel() {
    }

    protected void brandMainWindow() {
    }

    static String ra$startupCaption(IdeCore ideCore) {
        return ideCore.startupCaption;
    }

    static ArrayList ra$_ideListeners(IdeCore ideCore) {
        return ideCore._ideListeners;
    }

    static void mav$fireIdeEvent(IdeCore ideCore, IdeListener ideListener, IdeEvent ideEvent) {
        ideCore.fireIdeEvent(ideListener, ideEvent);
    }

    final class 1
    extends NullSecurityManager {
        public void checkExit(int status) {
            if (Beans.isDesignTime()) {
                throw new ExitNotAllowedException();
            }
        }

        public ThreadGroup getThreadGroup() {
            return super.getThreadGroup();
        }
    }

    private final class MainWindowWaitCursor
    extends WaitCursor {
        MainWindowWaitCursor(Component c) {
            this.attachSuper(this.findRootPaneContainer(c));
        }

        private void attachSuper(RootPaneContainer c) {
            super.attach(c);
        }

        @Deprecated
        public void attach(RootPaneContainer c) {
            this.complain();
            super.attach(c);
        }

        @Deprecated
        public void detach(RootPaneContainer c) {
            if (!Ide.isQuitting()) {
                this.complain();
            }
            super.detach(c);
        }

        private void complain() {
            new IllegalStateException("WARNING: attaching and detaching from the WaitCursor returned by Ide.getWaitCursor() is no longer supported. Instead, clients should create a new WaitCursor instance. The WaitCursor returned by Ide.getWaitCursor should only be used by the IDE's main window.").printStackTrace();
        }
    }

    final class 2
    implements CollectionListener {
        public void elementAdded(CollectionEvent event) {
            KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
            KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
            kso.addContext(ksc);
        }

        public void elementRemoved(CollectionEvent event) {
            KeyStrokeOptions kso = IdeCore.this.getSettings().getKeyStrokeOptions();
            KeyStrokeContext ksc = (KeyStrokeContext)event.getElement();
            kso.removeContext(ksc);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ int v$nEventID;
        final /* synthetic */ IdeCore this$0;

        public void run() {
            int n = IdeCore.ra$_ideListeners(this.this$0).size();
            if (n > 0) {
                IdeEvent e = new IdeEvent(this.v$nEventID);
                IdeListener[] l = IdeCore.ra$_ideListeners(this.this$0).toArray(new IdeListener[n]);
                int i = 0;
                while (i < n) {
                    IdeCore.mav$fireIdeEvent(this.this$0, l[i], e);
                    ++i;
                }
            }
        }

        public 3(IdeCore ideCore, int n) {
            this.v$nEventID = n;
            this.this$0 = ideCore;
        }
    }

    static final class 4
    implements URLStreamHandlerFactory {
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.startsWith("ide.")) {
                return new 1();
            }
            return null;
        }

        final class oracle.ide.IdeCore$4$1
        extends URLStreamHandler {
            protected URLConnection openConnection(URL u) {
                return new 1(u);
            }

            final class 1
            extends URLConnection {
                public void connect() {
                    this.connected = true;
                }

                public InputStream getInputStream() throws IOException {
                    return URLFileSystem.openInputStream((URL)this.url);
                }

                public OutputStream getOutputStream() throws IOException {
                    return URLFileSystem.openOutputStream((URL)this.url);
                }

                public 1(URL uRL) {
                    super(uRL);
                }
            }
        }
    }

    final class 5
    extends MessageDialogPersistence {
        protected File getUserDirectory() {
            return new File(URLFileSystem.getPlatformPathName((URL)ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.ide")));
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ JFrame v$fStartupWindow;
        final /* synthetic */ IdeCore this$0;

        public void run() {
            this.v$fStartupWindow.setVisible(false);
            this.v$fStartupWindow.dispose();
        }

        public 6(IdeCore ideCore, JFrame jFrame) {
            this.v$fStartupWindow = jFrame;
            this.this$0 = ideCore;
        }
    }

    final class 7
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            IdeUtil.setIdeEncoding(IdeCore.this.getEnvironOptions().getEncoding());
        }
    }

    final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            IdeCore.this.fireIdeEvent(4);
        }
    }

    final class 9 {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ IdeCore this$0;

        public void doit() {
            String msgId = "oracle.ide.badJdkWarning";
            String title = IdeCore.ra$startupCaption(this.this$0);
            boolean res = MessageDialog.optionalConfirm((String)"oracle.ide.badJdkWarning", (Component)SwingUtils.getToplevelWindow(), (String)this.v$msg, (String)title, null);
            if (!res) {
                MessageDialog.getPersistence().setConfirmed("oracle.ide.badJdkWarning", null);
                System.exit(1);
            }
        }

        public 9(IdeCore ideCore, String string) {
            this.v$msg = string;
            this.this$0 = ideCore;
        }
    }

    private static final class StartupWindow
    extends JFrame
    implements AWTEventListener {
        private int openChildren;

        private void $init$() {
            this.openChildren = 0;
        }

        StartupWindow(String caption, Image icon) {
            super(caption);
            this.$init$();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension size = tk.getScreenSize();
            tk.addAWTEventListener(this, 64);
            this.setIconImage(icon);
            this.setUndecorated(true);
            this.setBounds(size.width / 2, size.height / 2, 0, 0);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.dispose();
        }

        public void eventDispatched(AWTEvent event) {
            block0 : switch (event.getID()) {
                case 200: {
                    Window child = (Window)event.getSource();
                    Window[] children = this.getOwnedWindows();
                    if (children == null) break;
                    int i = children.length - 1;
                    while (i >= 0) {
                        if (child == children[i]) {
                            ++this.openChildren;
                            break block0;
                        }
                        --i;
                    }
                    break;
                }
                case 202: {
                    Window child = (Window)event.getSource();
                    Window[] children = this.getOwnedWindows();
                    if (children == null) break;
                    int i = children.length - 1;
                    while (i >= 0) {
                        if (child == children[i]) {
                            --this.openChildren;
                            break;
                        }
                        --i;
                    }
                    if (this.openChildren != 0) break;
                    this.setVisible(false);
                    break;
                }
            }
        }
    }
}

