/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.JViewport;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.util.SwingClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IdeController
implements Controller {
    private int _recursiveControllerCheck;

    IdeController() {
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        try {
            ++this._recursiveControllerCheck;
            int cmdId = action.getCommandId();
            if (cmdId == 5) {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                boolean canUndo = cmdProc.canUndo(context);
                action.setEnabled(canUndo);
                String whatToUndo = canUndo ? cmdProc.getUndoLabel(context) : "";
                action.putValue("Name", IdeArb.format(469, whatToUndo));
                boolean bl = true;
                return bl;
            }
            if (cmdId == 6) {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                boolean canRedo = cmdProc.canRedo(context);
                action.setEnabled(canRedo);
                String whatToRedo = canRedo ? cmdProc.getRedoLabel(context) : "";
                action.putValue("Name", IdeArb.format(371, whatToRedo));
                boolean bl = true;
                return bl;
            }
            if (cmdId == 73) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGoBack = mgr != null && mgr.canNavigateBack();
                action.setEnabled(canGoBack);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 74) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGoForward = mgr != null && mgr.canNavigateForward();
                action.setEnabled(canGoForward);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 75) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGotoLastEdit = mgr != null && mgr.canNavigateToLastEdit();
                action.setEnabled(canGotoLastEdit);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 49) {
                action.setEnabled(ExplorerManager.getExplorerManager() != null);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 34) {
                action.setEnabled(LogManager.getLogManager() != null);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 67) {
                action.setEnabled(false);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 68) {
                action.setEnabled(false);
                action.setState(false);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 0) {
                action.setEnabled(true);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 11) {
                boolean canSave = IdeController.canSave(context);
                action.setEnabled(canSave);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 12) {
                boolean canSaveAs = IdeController.canSaveAs(context);
                action.setEnabled(canSaveAs);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 14) {
                boolean canRename = IdeController.canRename(context);
                action.setEnabled(canRename);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 52) {
                boolean canRevert = IdeController.isRevertable(context);
                action.setEnabled(canRevert);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 57) {
                boolean canNavigate = IdeController.isLocatableInNavigator(context);
                action.setEnabled(canNavigate);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 13) {
                action.setEnabled(true);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 2 || cmdId == 3) {
                boolean enabled = context != null && context.getWorkspace() != null;
                action.setEnabled(enabled);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 8) {
                boolean enabled = context != null && context.getProject() != null;
                action.setEnabled(enabled);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 48) {
                boolean bl = this.updateCloseNode(context, action);
                return bl;
            }
            if (cmdId == 21 || cmdId == 47 || cmdId == 52) {
                action.setEnabled(false);
                boolean bl = true;
                return bl;
            }
            if (cmdId == 51) {
                action.setEnabled(false);
            } else {
                if (cmdId == 9 || cmdId == 10 || cmdId == 15 || cmdId == 4 || cmdId == 36 || cmdId == 37 || cmdId == 38) {
                    action.setEnabled(true);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 69) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    StatusBar statusbar = mainWindow.getStatusBar();
                    action.setEnabled(true);
                    action.setState(statusbar.getGUI().isVisible());
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 30 || cmdId == 31) {
                    Controller ctrl;
                    View logPageView;
                    LogPage logPage;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage = logWindow.getPage()) != null && (logPageView = logPage.getLogPageView()) != null && (ctrl = logPageView.getController()) != null && ctrl != this && ctrl.update(action, context)) {
                        boolean bl = true;
                        return bl;
                    }
                    action.setEnabled(false);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 17 || cmdId == 18 || cmdId == 19 || cmdId == 78 || cmdId == 81 || cmdId == 82 || cmdId == 22 || cmdId == 35 || cmdId == 40 || cmdId == 41 || cmdId == 42 || cmdId == 43 || cmdId == 54 || cmdId == 55) {
                    action.setEnabled(false);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 20) {
                    if (EditorManager.getEditorManager().getCurrentEditor() != null) {
                        boolean bl = EditorManager.getEditorManager().update(action, context);
                        return bl;
                    }
                    action.setEnabled(false);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 77) {
                    boolean isEnabled = this.canCopyPath(context);
                    action.setEnabled(isEnabled);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean bl = editorManager.update(action, context);
                    return bl;
                }
                if (cmdId == 72) {
                    IdeMainWindow mainwindow = Ide.getMainWindow();
                    if (mainwindow.getTimestampMap() == null) {
                        action.setEnabled(false);
                    } else {
                        action.setEnabled(true);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (cmdId == 23 || cmdId == 24 || cmdId == 25 || cmdId == 53 || cmdId == 26 || cmdId == 27 || cmdId == 28 || cmdId == 29 || cmdId == 32 || cmdId == ExplorerManager.SELECT_IN_STRUCTURE_CMD_ID || cmdId == 56 || cmdId == 57 || cmdId == 16) {
                action.setEnabled(false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            --this._recursiveControllerCheck;
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        try {
            ++this._recursiveControllerCheck;
            if (action == null) {
                boolean bl = false;
                return bl;
            }
            CommandProcessor cmdProc = CommandProcessor.getInstance();
            Command command = null;
            int cmdId = action.getCommandId();
            if (cmdId == 5) {
                try {
                    cmdProc.undo(context);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            if (cmdId == 6) {
                try {
                    cmdProc.redo(context);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            if (cmdId == 0 || cmdId == 2 || cmdId == 3 || cmdId == 8 || cmdId == 11 || cmdId == 12 || cmdId == 14 || cmdId == 13 || cmdId == 47 || cmdId == 21 || cmdId == 34 || cmdId == 48) {
                command = CommandProcessor.createCommand(action.getCommand(), context);
            } else {
                if (cmdId == 73) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateBack();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 74) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateForward();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 75) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateToLastEdit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 49) {
                    ExplorerManager.getExplorerManager().showLastView(context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 9) {
                    command = CommandProcessor.createCommand(action.getCommand(), context);
                    command.setData(action.getValue("UserData"));
                    try {
                        command.doit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 30 || cmdId == 31) {
                    Controller ctrl;
                    View logPageView;
                    LogPage logPage;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage = logWindow.getPage()) != null && (logPageView = logPage.getLogPageView()) != null && (ctrl = logPageView.getController()) != null && ctrl != this && ctrl.handleEvent(action, context)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (cmdId == 4) {
                    Ide.quit(action, context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 36) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    View mainWindowView = mainWindow.getIdeMainWindowView();
                    Toolbar toolbar = mainWindowView.getToolbar();
                    mainWindowView.setToolbarVisible(toolbar.isVisible() ^ true);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 69) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    StatusBar statusbar = mainWindow.getStatusBar();
                    mainWindow.setStatusBarVisible(statusbar.getGUI().isVisible() ^ true);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 77) {
                    this.whenCopyPath(context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean bl = editorManager.handleEvent(action, context);
                    return bl;
                }
                if (cmdId == 52) {
                    RevertNodeCommand.reload(context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 57) {
                    context.setBoolean("REFRESH_CMD_ID.promptUserWhenNotFound", true);
                    context.setBoolean("REFRESH_CMD_ID.expandAndActivateOnFind", true);
                    NavigatorWindow lastNav = Ide.getLastActiveNavigator();
                    if (lastNav == null) {
                        lastNav = NavigatorManager.getWorkspaceNavigatorManager().getNavigatorWindow();
                    }
                    lastNav.getManager().getNavigatorWindow().openContext(context);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 72) {
                    try {
                        1 closure = new 1(true);
                        closure.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 50) {
                    View active;
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    View view = active = mainWindow != null ? mainWindow.getLastActiveView() : null;
                    if (active == null) {
                        boolean bl = true;
                        return bl;
                    }
                    ContextMenu menu = active.getContextMenu();
                    if (menu == null) {
                        boolean bl = true;
                        return bl;
                    }
                    Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (comp == null && (comp = active.getGUI()) == null) {
                        boolean bl = true;
                        return bl;
                    }
                    int xPos = 0;
                    int yPos = 0;
                    if (comp instanceof JTree) {
                        JTree tree = (JTree)comp;
                        int[] selectionRows = tree.getSelectionRows();
                        if (selectionRows != null) {
                            Rectangle viewRect;
                            Container parent = tree.getParent();
                            if (parent instanceof JViewport) {
                                JViewport viewport = (JViewport)parent;
                                viewRect = viewport.getViewRect();
                            } else {
                                viewRect = tree.getVisibleRect();
                            }
                            int i = selectionRows.length - 1;
                            while (i >= 0) {
                                int selectionRow = selectionRows[i];
                                Rectangle rowBounds = tree.getRowBounds(selectionRow);
                                if (viewRect.contains(rowBounds.x, rowBounds.y)) {
                                    xPos = rowBounds.x + rowBounds.height;
                                    yPos = rowBounds.y + rowBounds.height;
                                    break;
                                }
                                --i;
                            }
                        }
                    } else if (comp instanceof JFastTreeTable) {
                        JFastTreeTable treeTable = (JFastTreeTable)comp;
                        int[] selectionRows = treeTable.getSelectedRows();
                        if (selectionRows != null) {
                            Rectangle viewRect;
                            int selectedColumn = treeTable.getSelectedColumn();
                            Container parent = treeTable.getParent();
                            if (parent instanceof JViewport) {
                                JViewport viewport = (JViewport)parent;
                                viewRect = viewport.getViewRect();
                            } else {
                                viewRect = treeTable.getVisibleRect();
                            }
                            int i = selectionRows.length - 1;
                            while (i >= 0) {
                                int selectionRow = selectionRows[i];
                                Rectangle rowBounds = treeTable.getCellRect(selectionRow, selectedColumn, true);
                                if (viewRect.contains(rowBounds.x, rowBounds.y)) {
                                    xPos = rowBounds.x;
                                    yPos = rowBounds.y + rowBounds.height;
                                    break;
                                }
                                --i;
                            }
                        }
                    } else {
                        Container parent = comp.getParent();
                        if (comp.getParent() instanceof JViewport) {
                            JViewport viewport = (JViewport)parent;
                            Point ptViewPosition = viewport.getViewPosition();
                            xPos += ptViewPosition.x;
                            yPos += ptViewPosition.y;
                        } else {
                            xPos += comp.getX();
                            yPos += comp.getY();
                        }
                    }
                    xPos = Math.max(xPos, 0);
                    yPos = Math.max(yPos, 0);
                    MouseEvent event = new MouseEvent(comp, 502, System.currentTimeMillis(), 0, xPos, yPos, 1, true);
                    Context ctxMenuContext = active.getContext(event);
                    ctxMenuContext.setEvent(event);
                    menu.show(ctxMenuContext);
                    boolean bl = true;
                    return bl;
                }
            }
            if (command != null) {
                try {
                    cmdProc.invoke(command);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            --this._recursiveControllerCheck;
        }
    }

    static void reloadNodes(Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        NodeUtil.reloadBuffers(timestampMap, silentReload, manualReload);
    }

    private boolean updateCloseNode(Context context, IdeAction action) {
        if (context != null) {
            boolean enabled = false;
            Node document = context.getNode();
            if (document == null) {
                Element elem = context.getElement();
                if (elem != null) {
                    if (elem.mayHaveChildren()) {
                        action.putValue("Name", IdeArb.format(26, IdeArb.getString(102)));
                    } else {
                        action.putValue("Name", IdeArb.format(26, IdeArb.getString(486)));
                    }
                    if (elem.getAttributes().isSet(ElementAttributes.CLOSEABLE) && elem instanceof Node && ((Node)elem).isOpen()) {
                        enabled = true;
                    }
                }
            } else if (document.getAttributes().isSet(ElementAttributes.CLOSEABLE) && document.isOpen()) {
                enabled = true;
            }
            action.setEnabled(enabled);
        }
        return true;
    }

    private static boolean isLocatableInNavigator(Context context) {
        if (context != null) {
            Node document;
            if (context.getView() instanceof NavigatorWindow) {
                return false;
            }
            NavigatorManager navigatorManager = IdeController.findNavigatorManager();
            if (navigatorManager != null && (document = context.getNode()) != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean canSave(Context context) {
        if (context != null) {
            return IdeController.canSave(context.getElement()) || IdeController.canSave(context.getNode());
        }
        return false;
    }

    private static boolean canSave(Element element) {
        Dirtyable node;
        return element != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && element instanceof Dirtyable && (node = (Dirtyable)element).isDirty();
    }

    private static boolean canSaveAs(Context context) {
        boolean ret = false;
        if (context != null) {
            Element[] selection;
            Element element;
            Node document = context.getNode();
            if (document != null && document.getAttributes().isSet(ElementAttributes.EDITOR_SAVEABLE_AS)) {
                ret = true;
            }
            if (!ret && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (selection = context.getSelection()) != null && selection.length == 1 && element.getAttributes().isSet(ElementAttributes.SAVEABLE_AS)) {
                ret = true;
            }
        }
        return ret;
    }

    private static boolean canRename(Context context) {
        Element[] selection;
        Element element;
        boolean ret = false;
        if (context != null && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (selection = context.getSelection()) != null && selection.length == 1 && element.getAttributes().isSet(ElementAttributes.RENAMEABLE)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isRevertable(Context context) {
        Attributes attributes;
        Node document;
        boolean ret = false;
        if (context != null && (document = context.getNode()) != null && !(attributes = document.getAttributes()).isSet(ElementAttributes.NON_RELOADABLE)) {
            if (document.isDirty()) {
                if (!document.isNew()) {
                    ret = true;
                }
            } else if (URLFileSystem.lastModified((URL)document.getURL()) != document.getUnmodifiedTimestamp()) {
                ret = true;
            }
        }
        return ret;
    }

    private static NavigatorManager findNavigatorManager() {
        NavigatorWindow nw = Ide.getLastActiveNavigator();
        if (nw != null) {
            return nw.getManager();
        }
        return NavigatorManager.getWorkspaceNavigatorManager();
    }

    private boolean canCopyPath(Context context) {
        boolean isEnabled = false;
        if (context != null) {
            Node document = context.getNode();
            if (document != null) {
                isEnabled = true;
            } else {
                Element[] selection = context.getSelection();
                if (selection.length > 0) {
                    isEnabled = true;
                    int i = 0;
                    while (isEnabled && i < selection.length) {
                        Element element = selection[i];
                        isEnabled = element instanceof Locatable || element instanceof RelativeDirectoryContextFolder;
                        ++i;
                    }
                }
            }
        }
        return isEnabled;
    }

    private void whenCopyPath(Context context) {
        String text;
        Node document = context.getNode();
        if (document != null) {
            URL url = document.getURL();
            text = URLFileSystem.getPlatformPathName((URL)url);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Element[] selection = context.getSelection();
            if (selection.length > 0) {
                int i = 0;
                while (i < selection.length) {
                    Element element = selection[i];
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        URL url = locatable.getURL();
                        String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                        stringBuffer.append(platformPathName);
                        stringBuffer.append('\n');
                    } else if (element instanceof RelativeDirectoryContextFolder) {
                        RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)element;
                        URLPath roots = folder.getRootDirectories();
                        String path = folder.getRelativePath();
                        for (URL root : roots) {
                            URL url = URLFactory.newDirURL((URL)root, (String)path);
                            String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(File.pathSeparatorChar);
                            }
                            stringBuffer.append(platformPathName);
                        }
                    }
                    ++i;
                }
            }
            text = stringBuffer.toString();
        }
        StringSelection ss = new StringSelection(text);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard systemClipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        systemClipboard.setContents(ss, null);
    }

    final class 1
    extends SwingClosure {
        protected void runImpl() throws Exception {
            IdeMainWindow mainWindow = Ide.getMainWindow();
            IdeController.reloadNodes(mainWindow.getTimestampMap(), false, true);
        }

        public 1(boolean bl) {
            super(bl);
        }
    }
}

