/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.utils;

import java.util.List;
import java.util.StringTokenizer;

public class OraStringUtils {
    static String BEGIN_BLOCK = "\n\nBEGIN\n";
    static String END_BLOCK = "\n   );\nEND; \n/";

    public static String trimDoubleQuotes(String doubleQuotedString) {
        if (doubleQuotedString == null) {
            return doubleQuotedString;
        }
        if (doubleQuotedString.startsWith("\"")) {
            StringTokenizer tokenizer = new StringTokenizer(doubleQuotedString, "\"");
            return tokenizer.nextToken();
        }
        return doubleQuotedString;
    }

    public static String getReplacedString(String str, String pattern, String replace) {
        try {
            int s = 0;
            int e = 0;
            StringBuffer result = new StringBuffer();
            if (pattern.length() > 0) {
                while ((e = str.indexOf(pattern, s)) >= 0) {
                    result.append(str.substring(s, e));
                    result.append(replace);
                    s = e + pattern.length();
                }
            }
            result.append(str.substring(s));
            return result.toString();
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String processQuotedName(String name) {
        String processed = OraStringUtils.trimDoubleQuotes(name);
        processed = OraStringUtils.getReplacedString(processed, "'", "''");
        return processed;
    }

    public static String getBuildTaskCall(List jobArgs) {
        StringBuffer sbOut = new StringBuffer(BEGIN_BLOCK + "   DMSYS.dbms_jdm_internal.build_task( ");
        sbOut.append(OraStringUtils.getArguments(jobArgs));
        return sbOut.toString();
    }

    public static String getTestTaskCall(List jobArgs) {
        StringBuffer sbOut = new StringBuffer(BEGIN_BLOCK + "   DMSYS.dbms_jdm_internal.test_task( ");
        sbOut.append(OraStringUtils.getArguments(jobArgs));
        return sbOut.toString();
    }

    public static String getApplyTaskCall(List jobArgs) {
        StringBuffer sbOut = new StringBuffer(BEGIN_BLOCK + "   DMSYS.dbms_jdm_internal.sql_apply_task( ");
        sbOut.append(OraStringUtils.getArguments(jobArgs));
        return sbOut.toString();
    }

    public static String getXformTaskCall(List jobArgs) {
        StringBuffer sbOut = new StringBuffer(BEGIN_BLOCK + "   DMSYS.dbms_jdm_internal.xform_task( ");
        sbOut.append(OraStringUtils.getArguments(jobArgs));
        return sbOut.toString();
    }

    private static StringBuffer getArguments(List jobArgs) {
        StringBuffer sbOut = new StringBuffer();
        for (int ni = 0; ni < jobArgs.size(); ++ni) {
            Object[] args = (Object[])jobArgs.get(ni);
            sbOut.append("\n");
            sbOut.append("      " + (args[1] != null ? "'" + OraStringUtils.getReplacedString(args[1].toString(), "'", "''") + "'" : "null"));
            if (ni >= jobArgs.size() - 1) continue;
            sbOut.append(",");
        }
        sbOut.append(END_BLOCK);
        return sbOut;
    }
}

