/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.utils;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sql.ARRAY;

public class OraSQLUtils {
    public static CallableStatement createCallableStatement(Connection dbConn, String sql, String[] paramNames, Object[] paramValues, int[] sqlTypes, boolean[] isOutType, String hardCodedParams, Logger logger) throws SQLException {
        CallableStatement cStmt;
        block32: {
            cStmt = null;
            try {
                if (paramNames != null && paramValues != null) {
                    String newSQL = OraSQLUtils.convertToCallableStatementSQL(sql, sqlTypes.length, hardCodedParams);
                    cStmt = dbConn.prepareCall(newSQL);
                    block20: for (int iParam = 0; iParam < sqlTypes.length; ++iParam) {
                        switch (sqlTypes[iParam]) {
                            case 12: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(paramNames[iParam], sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (String)paramValues[iParam];
                                cStmt.setString(paramNames[iParam], (String)value);
                                continue block20;
                            }
                            case 2: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Number)paramValues[iParam];
                                cStmt.setBigDecimal(paramNames[iParam], new BigDecimal(((Number)value).doubleValue()));
                                continue block20;
                            }
                            case 4: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Integer)paramValues[iParam];
                                cStmt.setInt(paramNames[iParam], ((Integer)value).intValue());
                                continue block20;
                            }
                            case 91: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Date)paramValues[iParam];
                                cStmt.setDate(paramNames[iParam], (Date)value);
                                continue block20;
                            }
                            case 92: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Time)paramValues[iParam];
                                cStmt.setTime(paramNames[iParam], (Time)value);
                                continue block20;
                            }
                            case 93: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Timestamp)paramValues[iParam];
                                cStmt.setTimestamp(paramNames[iParam], (Timestamp)value);
                                continue block20;
                            }
                            case 16: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Boolean)paramValues[iParam];
                                cStmt.setBoolean(paramNames[iParam], ((Boolean)value).booleanValue());
                                continue block20;
                            }
                            case 2003: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                ARRAY paramArray = null;
                                try {
                                    paramArray = (ARRAY)paramValues[iParam];
                                }
                                catch (ClassCastException notAnArray) {
                                    throw new RuntimeException("OraSQLUtils.createCallableStatement Failed: ", notAnArray);
                                }
                                cStmt.setArray(iParam + 1, (Array)paramArray);
                                continue block20;
                            }
                            case 1111: {
                                if (paramValues[iParam] == null) {
                                    cStmt.setNull(iParam + 1, sqlTypes[iParam]);
                                    continue block20;
                                }
                                Object value = (Integer)paramValues[iParam];
                                cStmt.setObject(iParam + 1, value);
                                continue block20;
                            }
                            default: {
                                throw new RuntimeException("OraSQLUtils.createCallableStatement does n't support SQL TYPE: sqlTypes[iParam]. See java.sql.Types for more details");
                            }
                        }
                    }
                    break block32;
                }
                cStmt = dbConn.prepareCall(sql);
            }
            catch (SQLException sqlExp) {
                if (cStmt != null) {
                    try {
                        cStmt.close();
                    }
                    catch (Exception anyExp2) {
                        // empty catch block
                    }
                }
                throw sqlExp;
            }
            finally {
                OraSQLUtils.logCallableStatement(sql, paramNames, paramValues, logger);
            }
        }
        return cStmt;
    }

    public static CallableStatement createCallableStatement(Connection dbConn, String sql, String[] paramNames, Object[] paramValues, int[] sqlTypes, boolean[] isOutType, Logger logger) throws SQLException {
        return OraSQLUtils.createCallableStatement(dbConn, sql, paramNames, paramValues, sqlTypes, isOutType, null, logger);
    }

    public static void executeCallableStatement(Connection dbConn, String sql, String[] paramNames, Object[] paramValues, int[] sqlTypes, boolean[] isOutType, Logger logger) throws SQLException {
        OraSQLUtils.executeCallableStatement(dbConn, sql, paramNames, paramValues, sqlTypes, isOutType, null, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCallableStatement(Connection dbConn, String sql, String[] paramNames, Object[] paramValues, int[] sqlTypes, boolean[] isOutType, String hardCodedParams, Logger logger) throws SQLException {
        Statement cStmt = null;
        try {
            cStmt = OraSQLUtils.createCallableStatement(dbConn, sql, paramNames, paramValues, sqlTypes, isOutType, hardCodedParams, logger);
            long startTime = System.currentTimeMillis();
            cStmt.execute();
            long endTime = System.currentTimeMillis();
            if (logger != null) {
                logger.finest("Execution duration: " + (endTime - startTime) / 1000L + " seconds");
            }
        }
        finally {
            if (cStmt != null) {
                cStmt.close();
            }
        }
    }

    public static void execSql(Connection dbConn, String sql, Logger logger) throws SQLException {
        try {
            if (logger != null) {
                logger.finest("Executiing: " + sql);
            }
            Statement stmt = dbConn.createStatement();
            long startTime = System.currentTimeMillis();
            stmt.execute(sql);
            long endTime = System.currentTimeMillis();
            if (logger != null) {
                logger.finest("Execution duration: " + (endTime - startTime) / 1000L + " seconds");
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            String error = "Unable to execute " + sql + "\n";
            error = error + e;
            System.out.println("ERROR : " + e);
            throw new SQLException(error);
        }
    }

    public static Vector execSqlQuery(Connection dbConn, String sql, Logger logger) throws SQLException {
        try {
            Statement stmt = dbConn.createStatement();
            long startTime = System.currentTimeMillis();
            ResultSet rset = stmt.executeQuery(sql);
            long endTime = System.currentTimeMillis();
            ResultSetMetaData meta = rset.getMetaData();
            int resultColumn = meta.getColumnCount();
            int resultRow = 0;
            Vector<Object[]> resultVector = new Vector<Object[]>();
            while (rset.next()) {
                ++resultRow;
                Object[] rowList = new Object[resultColumn];
                for (int column = 0; column < resultColumn; ++column) {
                    Object colObject;
                    rowList[column] = colObject = rset.getObject(column + 1);
                }
                resultVector.addElement(rowList);
            }
            if (logger != null) {
                logger.finest("Execution duration: " + (endTime - startTime) / 1000L + " seconds");
            }
            if (stmt != null) {
                stmt.close();
            }
            return resultVector;
        }
        catch (Exception e) {
            String error = "Unable to execute " + sql + "\n";
            error = error + e;
            System.out.println("ERROR : " + e);
            throw new SQLException(error);
        }
    }

    private static String convertToCallableStatementSQL(String sql, int noOfParams, String hardCodedParams) {
        StringBuffer strBuffer = new StringBuffer("{ call ");
        strBuffer.append(sql);
        strBuffer.append(" (");
        for (int i = 0; i < noOfParams - 1; ++i) {
            strBuffer.append(" ?,");
        }
        if (hardCodedParams == null) {
            strBuffer.append(" ? ) }");
        } else {
            strBuffer.append(" ?,");
            strBuffer.append(hardCodedParams);
            strBuffer.append(" ) }");
        }
        return strBuffer.toString();
    }

    private static void logCallableStatement(String sql, String[] paramNames, Object[] paramValues, Logger logger) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(sql);
        if (paramNames != null && paramValues != null) {
            int noOfParams = paramNames.length;
            strBuffer.append(" (");
            for (int i = 0; i < noOfParams; ++i) {
                strBuffer.append(paramNames[i]);
                strBuffer.append(" => ");
                strBuffer.append(paramValues[i]);
                strBuffer.append(", ");
            }
            strBuffer.append(" ) }");
        }
        if (logger != null) {
            logger.finest(strBuffer.toString());
        }
    }

    public static void main(String[] args) throws SQLException {
        String dbURL = "jdbc:oracle:thin:@dmt-sun08.us.oracle.com:1521:svjdm";
        String dbUser = "svjdm";
        String dbPasswd = "svjdm";
        OracleDataSource m_dataSource = new OracleDataSource();
        m_dataSource.setURL(dbURL);
        Connection dbConn = m_dataSource.getConnection(dbUser, dbPasswd);
        String sqlStr = "{ call DBMS_SCHEDULER.CREATE_JOB (?,?, auto_drop=>true, ?) }";
        CallableStatement cStmt = dbConn.prepareCall(sqlStr);
        cStmt.setString("JOB_NAME", "job1");
        cStmt.setString("PROGRAM_NAME", "build_program");
        cStmt.setString("COMMENTS", "comments");
        cStmt.execute();
        if (cStmt != null) {
            cStmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesTableOrViewExists(Connection dbConn, String tableOrViewName) throws SQLException {
        String sql = "SELECT OBJECT_NAME FROM USER_OBJECTS WHERE (OBJECT_TYPE='TABLE' OR OBJECT_TYPE='VIEW') AND OBJECT_NAME = '" + tableOrViewName + "'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTableOrView(Connection dbConn, String tableOrViewName, boolean isTable) throws SQLException {
        Statement pStmt = null;
        try {
            pStmt = isTable ? dbConn.prepareStatement("DROP TABLE " + tableOrViewName + " PURGE") : dbConn.prepareStatement("DROP VIEW " + tableOrViewName);
            pStmt.execute();
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(Connection dbConn, String tableName, String tableSpec, String comments) throws SQLException {
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            stmt = dbConn.createStatement();
            stmt.executeUpdate(tableSpec);
            dbConn.commit();
            stmt2 = dbConn.createStatement();
            stmt2.executeUpdate("COMMENT ON TABLE " + tableName + " IS '" + comments + "'");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTable(Connection dbConn, String oldtableName, String newTableName) throws SQLException {
        Statement pstmt = null;
        try {
            pstmt = dbConn.prepareStatement("ALTER TABLE " + oldtableName + " RENAME TO " + newTableName);
            pstmt.execute();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComments(Connection dbConn, String tableName) throws SQLException {
        String comments = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String qry = "SELECT COMMENTS from USER_TAB_COMMENTS WHERE TABLE_NAME = ?";
            pstmt = dbConn.prepareStatement(qry);
            pstmt.setString(1, tableName);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                comments = rs.getString(1);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
        }
        return comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComments(Connection dbConn, String tableName, String comments) throws SQLException {
        Statement pstmt = null;
        try {
            String qry = "COMMENT ON TABLE " + tableName + " IS '" + comments + "'";
            pstmt = dbConn.prepareStatement(qry);
            pstmt.execute();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

