/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform.text;

import java.sql.SQLException;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.text.OraTextTransform;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraTextTransformImpl
extends OraTransformationImpl
implements OraTextTransform {
    private String[] m_textColumns = null;
    private String m_caseId = null;
    private String[] m_featureTables = null;
    public static final String TEXT_XFORM = "TEXT";

    public OraTextTransformImpl(OraConnection dmeConn, OraFactory parentFactory, String caseId, String[] textColumns, String[] featureTables) throws JDMException {
        super(dmeConn, parentFactory, false);
        this.getValidationHandler().validateNotNull(caseId, "caseId");
        this.getValidationHandler().validateTableColumnName(caseId, "caseId");
        this.m_caseId = caseId;
        this.getValidationHandler().validateNotNull(textColumns, "textColumns");
        this.m_textColumns = textColumns;
        this.m_featureTables = featureTables;
    }

    public void setTextColumnList(String[] textColumnNames) {
        this.getValidationHandler().validateNotNull(textColumnNames, "textColumnNames");
        this.m_textColumns = textColumnNames;
    }

    public String[] getTextColumnNames() {
        return this.m_textColumns;
    }

    public void setFeatureTables(String[] featureTables) {
        this.m_featureTables = featureTables;
    }

    public String[] getFeatureTables() {
        return this.m_featureTables;
    }

    protected void populateTransformationTables(OraConnection dmeConn, String name) throws SQLException {
    }

    protected void createTransformationTable(OraConnection dmeConn, String name) throws SQLException {
        String taskName = name;
        if (this.m_featureTables == null && this.m_textColumns != null) {
            String quotes = null;
            if (taskName.startsWith("\"") && taskName.endsWith("\"")) {
                quotes = "\"";
            } else {
                taskName = name.toUpperCase();
            }
            this.m_featureTables = new String[this.m_textColumns.length];
            for (int iCol = 0; iCol < this.m_textColumns.length; ++iCol) {
                if (quotes == null) {
                    this.m_featureTables[iCol] = "DM$F" + iCol + taskName;
                    if (this.m_featureTables[iCol].length() <= 30) continue;
                    this.m_featureTables[iCol] = this.m_featureTables[iCol].substring(0, 30);
                    continue;
                }
                this.m_featureTables[iCol] = quotes + "DM$F" + iCol + OraStringUtils.trimDoubleQuotes(taskName) + quotes;
                if (this.m_featureTables[iCol].length() <= 32) continue;
                this.m_featureTables[iCol] = this.m_featureTables[iCol].substring(0, 31) + "\"";
            }
        }
    }

    protected void cleanXformSpecificObjects(OraConnection dmeConn, String name) {
    }

    public String getSettingsTable1() {
        return null;
    }

    public String getSettingsTable2() {
        return null;
    }

    public String getCaseId() {
        return this.m_caseId;
    }

    public void setCaseId(String caseId) {
        this.m_caseId = caseId;
    }

    public String getType() {
        return TEXT_XFORM;
    }
}

