/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform.binning;

import java.util.Vector;
import java.util.logging.Level;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.transform.binning.OraAttributeBins;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformFactory;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;
import oracle.dmt.jdm.transform.binning.OraCategoricalAttributeBins;
import oracle.dmt.jdm.transform.binning.OraCategoricalBinningType;
import oracle.dmt.jdm.transform.binning.OraNumericalAttributeBins;
import oracle.dmt.jdm.transform.binning.OraNumericalBinningType;

public class OraBinningTransformFactoryImpl
extends OraFactory
implements OraBinningTransformFactory {
    public OraBinningTransform create(String inputDataURI, String outputDataURI, boolean isOutputAsView) throws JDMException {
        OraBinningTransformImpl binXform = new OraBinningTransformImpl(this.m_dmeConn, this, isOutputAsView);
        binXform.setTransformInputData(inputDataURI);
        binXform.setTransformOutputData(outputDataURI);
        return binXform;
    }

    public OraBinningTransform create(String inputDataURI, String outputDataURI, boolean isOutputAsView, String inputCategoricalBinTable, String inputNumericalBinTable) throws JDMException {
        OraBinningTransformImpl binXform = new OraBinningTransformImpl(this.m_dmeConn, (OraFactory)this, inputNumericalBinTable, inputCategoricalBinTable, isOutputAsView);
        binXform.setTransformInputData(inputDataURI);
        binXform.setTransformOutputData(outputDataURI);
        return binXform;
    }

    public OraBinningTransform create(String inputDataURI, String outputDataURI, boolean isOutputAsView, OraAttributeBins[] customBins) throws JDMException {
        OraBinningTransformImpl binXform = new OraBinningTransformImpl(this.m_dmeConn, this, customBins, isOutputAsView);
        binXform.setTransformInputData(inputDataURI);
        binXform.setTransformOutputData(outputDataURI);
        return binXform;
    }

    public OraBinningTransform create(String inputDataURI, String outputDataURI, boolean isOutputAsView, String inputCategoricalBinTable, String inputNumericalBinTable, OraAttributeBins[] customBins) throws JDMException {
        OraBinningTransformImpl binXform = new OraBinningTransformImpl(this.m_dmeConn, this, inputNumericalBinTable, inputCategoricalBinTable, customBins, isOutputAsView);
        binXform.setTransformInputData(inputDataURI);
        binXform.setTransformOutputData(outputDataURI);
        return binXform;
    }

    public OraBinningTransform create(String inputDataURI, String outputDataURI, boolean isOutputAsView, Integer numberOfNumericalBins, Integer numberOfCategoricalBins, OraCategoricalBinningType catBinType, OraNumericalBinningType numBinType) throws JDMException {
        return null;
    }

    public OraAttributeBins[] computeBins(String inputDataURI, Integer numberOfNumericalBins, Integer numberOfCategoricalBins, OraCategoricalBinningType catBinType, OraNumericalBinningType numBinType, String[] excludeAttributes) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull((Object)catBinType, "catBinType");
        this.m_dmeConn.getValidationHandler().validateNotNull((Object)numBinType, "numBinType");
        OraBinningTransformImpl binXform = new OraBinningTransformImpl(this.m_dmeConn, this, numberOfNumericalBins, numberOfCategoricalBins, catBinType, numBinType, excludeAttributes);
        binXform.setTransformInputData(inputDataURI);
        return binXform.getBins();
    }

    public OraNumericalAttributeBins[] computeNumericBins(String inputDataURI, String[] numericAttributes, OraNumericalBinningType[] numBinType, Integer[] numberOfNumericalBins) throws JDMException {
        Vector<String> vQtileNames = new Vector<String>();
        Vector<Integer> vQtileBins = new Vector<Integer>();
        Vector<String> vEqWidthNames = new Vector<String>();
        Vector<Integer> vEqWidthBins = new Vector<Integer>();
        for (int ni = 0; ni < numBinType.length; ++ni) {
            if (numBinType[ni].equals((Object)OraNumericalBinningType.quantile)) {
                vQtileNames.add(numericAttributes[ni]);
                vQtileBins.add(numberOfNumericalBins[ni]);
                continue;
            }
            if (!numBinType[ni].equals((Object)OraNumericalBinningType.equi_width)) continue;
            vEqWidthNames.add(numericAttributes[ni]);
            vEqWidthBins.add(numberOfNumericalBins[ni]);
        }
        OraNumericalAttributeBins[] binnedAttr = null;
        OraNumericalAttributeBins[] qtileBinnedAttr = null;
        OraNumericalAttributeBins[] eqwBinnedAttr = null;
        try {
            qtileBinnedAttr = OraBinningTransformImpl.quantileBinning(this.m_dmeConn, inputDataURI, vQtileNames, vQtileBins);
        }
        catch (Exception ex) {
            this.m_dmeConn.getLogger().log(Level.FINEST, "OraBinningTransformFactoryImpl.computeNumericBins quantile binning failed:" + ex);
        }
        try {
            eqwBinnedAttr = OraBinningTransformImpl.equalWidthBinning(this.m_dmeConn, inputDataURI, vEqWidthNames, vEqWidthBins);
        }
        catch (Exception ex) {
            this.m_dmeConn.getLogger().log(Level.FINEST, "OraBinningTransformFactoryImpl.computeNumericBins equalWidth binning failed:" + ex);
        }
        int length = 0;
        if (qtileBinnedAttr != null) {
            length = qtileBinnedAttr.length;
        }
        if (eqwBinnedAttr != null) {
            length += eqwBinnedAttr.length;
        }
        binnedAttr = new OraNumericalAttributeBins[length];
        if (qtileBinnedAttr != null) {
            System.arraycopy(qtileBinnedAttr, 0, binnedAttr, 0, qtileBinnedAttr.length);
        }
        if (eqwBinnedAttr != null) {
            System.arraycopy(eqwBinnedAttr, 0, binnedAttr, qtileBinnedAttr.length, eqwBinnedAttr.length);
        }
        return binnedAttr;
    }

    public OraCategoricalAttributeBins[] computeCategoricBins(String inputDataURI, String[] categoricAttributes, OraCategoricalBinningType[] catBinType, Integer[] numberOfCategoricBins) throws JDMException {
        Vector<String> vNames = new Vector<String>();
        Vector<Integer> vBins = new Vector<Integer>();
        for (int ni = 0; ni < catBinType.length; ++ni) {
            if (!catBinType[ni].equals((Object)OraCategoricalBinningType.top_n)) continue;
            vNames.add(categoricAttributes[ni]);
            vBins.add(numberOfCategoricBins[ni]);
        }
        OraCategoricalAttributeBins[] topNBinnedAttr = null;
        try {
            topNBinnedAttr = OraBinningTransformImpl.topNBinning(this.m_dmeConn, inputDataURI, vNames, vBins);
        }
        catch (Exception ex) {
            this.m_dmeConn.getLogger().log(Level.FINEST, "OraBinningTransformFactoryImpl.computeCategoricBins topN binning failed:" + ex);
        }
        return topNBinnedAttr;
    }
}

