/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraNamedObject;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.transform.OraExpressionTransform;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.OraTransformationSequence;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;
import oracle.dmt.jdm.transform.binning.OraCategoricalBinningType;
import oracle.dmt.jdm.transform.binning.OraNumericalBinningType;
import oracle.dmt.jdm.transform.text.OraTextTransform;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.sql.ARRAY;

public class OraTransformationSequenceImpl
extends OraMiningObject
implements OraTransformationSequence {
    private OraDataURI m_inputDataURI = null;
    private ArrayList m_xformsList = null;
    private OraExpressionTransform m_xpressionXform = null;
    private OraDataURI m_outputDataURI = null;
    private boolean m_isOutputView = true;
    protected static final String XFORM_SEQ_COMMENTS_PREFIX = "TS_";
    protected static final String XFORM_STACK_COMMENTS_PREFIX = "TSTACK_";
    protected static final String XFORM_STACK_TABLE_SUFFIX = "_STAK";
    private static String CREATE_XFORM_SEQ_TABLE = "CREATE TABLE xform_seq_table ( MINING_TRANSFORM_SEQ_ID NUMBER, TYPE VARCHAR2(250), PROPERTY VARCHAR2(250), VALUE VARCHAR2(4000), ANYDATA_VALUE ANYDATA )";
    private static final String IN_INPUT_TABLE = "IN_INPUT_TABLE";
    private static final String IN_OUTPUT_TABLE = "IN_OUTPUT_TABLE";
    private static final String IN_INPUT_SCHEMA = "IN_INPUT_SCHEMA";
    private static final String IN_OUTPUT_SCHEMA = "IN_OUTPUT_SCHEMA";
    private static final String IN_IS_OUTPUT_VIEW = "IN_IS_OUTPUT_VIEW";

    OraTransformationSequenceImpl(OraConnection dmeConn, OraFactory parentFactory, String inputDataURI, List transformationList, String outputDataURI) throws JDMException {
        super(dmeConn, parentFactory, OraNamedObject.transformationSequence);
        this.m_inputDataURI = new OraDataURI(inputDataURI);
        this.m_outputDataURI = new OraDataURI(outputDataURI);
        this.m_xformsList = new ArrayList(transformationList);
    }

    OraTransformationSequenceImpl(OraConnection dmeConn, OraFactory parentFactory, String inputDataURI, OraExpressionTransform expressionXfrom, String outputDataURI) throws JDMException {
        super(dmeConn, parentFactory, OraNamedObject.transformationSequence);
        this.m_inputDataURI = new OraDataURI(inputDataURI);
        this.m_outputDataURI = new OraDataURI(outputDataURI);
        this.m_xpressionXform = expressionXfrom;
    }

    public List getTransformations() {
        return this.m_xformsList;
    }

    public void addTransformation(OraTransformation xform) {
        if (this.m_xformsList == null) {
            this.m_xformsList = new ArrayList();
        }
        if (xform instanceof OraTextTransform) {
            this.unsupported("OraTextTransform");
        }
        this.m_xformsList.add(xform);
    }

    public void removeTransformation(int index) {
        this.m_xformsList.remove(index);
    }

    public OraExpressionTransform getExpressionTransform() {
        return this.m_xpressionXform;
    }

    public boolean isInputObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
        Logger logger = ((OraConnection)dmeConn).getLogger();
        java.sql.Connection dbConn = ((OraConnection)dmeConn).getDatabaseConnection();
        try {
            String createXformSeqTable = CREATE_XFORM_SEQ_TABLE.replaceAll("xform_seq_table", name);
            String comments = XFORM_SEQ_COMMENTS_PREFIX + OraNamedObject.transformationSequence.name();
            String description = this.getDescription();
            if (description != null) {
                comments = comments + ";Description:" + description;
            }
            OraSQLUtils.createTable(dbConn, name, createXformSeqTable, comments);
        }
        catch (SQLException sqlExp1) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp1);
        }
        Statement pStmtStr = null;
        Statement pStmtNum = null;
        Statement pStmtArr = null;
        int xformSeqId = 1;
        try {
            String schemaName;
            String tableName;
            pStmtStr = dbConn.prepareStatement("INSERT INTO " + name + "( MINING_TRANSFORM_SEQ_ID, TYPE, PROPERTY, VALUE ) VALUES ( ?, ?, ?, ? )");
            if (this.m_inputDataURI != null) {
                tableName = this.m_inputDataURI.getTableName();
                pStmtStr.setNull(1, 2);
                pStmtStr.setNull(2, 12);
                pStmtStr.setString(3, IN_INPUT_TABLE);
                pStmtStr.setString(4, tableName);
                pStmtStr.addBatch();
                schemaName = this.m_inputDataURI.getSchemaName();
                if (schemaName != null) {
                    pStmtStr.setNull(1, 2);
                    pStmtStr.setNull(2, 12);
                    pStmtStr.setString(3, IN_INPUT_SCHEMA);
                    pStmtStr.setString(4, schemaName);
                    pStmtStr.addBatch();
                }
            }
            if (this.m_outputDataURI != null) {
                tableName = this.m_outputDataURI.getTableName();
                pStmtStr.setNull(1, 2);
                pStmtStr.setNull(2, 12);
                pStmtStr.setString(3, IN_OUTPUT_TABLE);
                pStmtStr.setString(4, tableName);
                pStmtStr.addBatch();
                schemaName = this.m_outputDataURI.getSchemaName();
                if (schemaName != null) {
                    pStmtStr.setNull(1, 2);
                    pStmtStr.setNull(2, 12);
                    pStmtStr.setString(3, IN_OUTPUT_SCHEMA);
                    pStmtStr.setString(4, schemaName);
                    pStmtStr.addBatch();
                }
            }
            pStmtStr.setNull(1, 2);
            pStmtStr.setNull(2, 12);
            pStmtStr.setString(3, IN_IS_OUTPUT_VIEW);
            pStmtStr.setString(4, this.m_isOutputView ? "Y" : "N");
            pStmtStr.addBatch();
            if (this.m_xpressionXform != null) {
                this.m_xformsList = new ArrayList();
                this.m_xformsList.add(this.m_xpressionXform);
            }
            for (int i = 0; i < this.m_xformsList.size(); ++i) {
                ++xformSeqId;
                OraTransformationImpl xformImpl = (OraTransformationImpl)this.m_xformsList.get(i);
                if (xformImpl instanceof OraExpressionTransform || xformImpl instanceof OraBinningTransformImpl && (OraNumericalBinningType.custom.equals((Object)((OraBinningTransformImpl)xformImpl).getNumericalBinningType()) || OraCategoricalBinningType.custom.equals((Object)((OraBinningTransformImpl)xformImpl).getCategoricalBinningType()))) {
                    xformImpl.saveObjectInDatabase((OraConnection)dmeConn, name);
                }
                Map xformMap = xformImpl.getSettingsMap();
                String xformType = xformImpl.getType();
                for (String key : xformMap.keySet()) {
                    Object val = xformMap.get(key);
                    if (val instanceof String) {
                        pStmtStr.setInt(1, xformSeqId);
                        pStmtStr.setString(2, xformType);
                        pStmtStr.setString(3, key);
                        pStmtStr.setString(4, (String)val);
                        pStmtStr.addBatch();
                        continue;
                    }
                    if (val instanceof Number) {
                        if (pStmtNum == null) {
                            pStmtNum = dbConn.prepareStatement("INSERT INTO " + name + "( MINING_TRANSFORM_SEQ_ID, TYPE, PROPERTY, ANYDATA_VALUE ) VALUES ( ?, ?, ?, ANYDATA.CONVERTNUMBER(?) )");
                        }
                        pStmtNum.setInt(1, xformSeqId);
                        pStmtNum.setString(2, xformType);
                        pStmtNum.setString(3, key);
                        pStmtNum.setBigDecimal(4, new BigDecimal(val.toString()));
                        pStmtNum.addBatch();
                        continue;
                    }
                    if (!(val instanceof ARRAY)) continue;
                    if (pStmtArr == null) {
                        pStmtArr = dbConn.prepareStatement("INSERT INTO " + name + "( MINING_TRANSFORM_SEQ_ID, TYPE, PROPERTY, ANYDATA_VALUE ) VALUES ( ?, ?, ?, ANYDATA.CONVERTCOLLECTION(?) )");
                    }
                    pStmtArr.setInt(1, xformSeqId);
                    pStmtArr.setString(2, xformType);
                    pStmtArr.setString(3, key);
                    pStmtArr.setArray(4, (Array)((ARRAY)val));
                    pStmtArr.addBatch();
                }
            }
            if (pStmtStr != null) {
                pStmtStr.executeBatch();
            }
            if (pStmtNum != null) {
                pStmtNum.executeBatch();
            }
            if (pStmtArr != null) {
                pStmtArr.executeBatch();
            }
            dbConn.commit();
        }
        catch (SQLException sqlExp) {
            try {
                dbConn.rollback();
                OraSQLUtils.doesTableOrViewExists(dbConn, name);
            }
            catch (SQLException i1) {
                // empty catch block
            }
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            if (pStmtStr != null) {
                try {
                    pStmtStr.close();
                }
                catch (SQLException i2) {}
            }
            if (pStmtNum != null) {
                try {
                    pStmtNum.close();
                }
                catch (SQLException i3) {}
            }
            if (pStmtArr != null) {
                try {
                    pStmtArr.close();
                }
                catch (SQLException i4) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean xssExist = dmeConn.doesObjectExist(name, NamedObject.costMatrix);
        if (!xssExist) {
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{"CostMatrix", name}, null);
        }
        StringBuffer dropXSSTables = new StringBuffer();
        dropXSSTables.append("DECLARE ").append(" TYPE varchar30_list IS TABLE OF VARCHAR2(30); ").append(" v_xform_table_list varchar30_list := varchar30_list(); ").append("BEGIN ").append(" BEGIN ").append("  EXECUTE IMMEDIATE  ").append("   'SELECT VALUE FROM ").append(name).append("    WHERE PROPERTY IN ( ''NORM_DEF_TABLE'', ''NUM_BIN_TABLE'', ''CAT_BIN_TABLE'', ''STACK_DEF_TABLE'', ''IN_EXPRESSIONS_TABLE'', ''CLIP_DEF_TABLE'' )' ").append("  BULK COLLECT INTO v_xform_table_list; ").append(" EXCEPTION WHEN OTHERS THEN NULL; ").append(" END; ").append(" v_xform_table_list.extend; v_xform_table_list(v_xform_table_list.count) := '").append(name).append("'; ").append(" BEGIN ").append("  FOR ix IN 1..v_xform_table_list.count LOOP ").append("   EXECUTE IMMEDIATE 'DROP TABLE ' || v_xform_table_list(ix); ").append("  END LOOP; ").append("  FOR ix IN 1..v_xform_table_list.count LOOP ").append("   EXECUTE IMMEDIATE 'PURGE TABLE ' || v_xform_table_list(ix); ").append("  END LOOP; ").append("  EXCEPTION WHEN OTHERS THEN  ").append("   FOR ix IN 1..v_xform_table_list.count LOOP ").append("     EXECUTE IMMEDIATE 'FLASHBACK TABLE ' || v_xform_table_list(ix) || ' TO BEFORE DROP'; ").append("     RAISE; ").append("   END LOOP; ").append("  END;  ").append(" END;");
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            stmt.execute(dropXSSTables.toString());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        if (dmeConn != null) {
            OraValidationHandler v = dmeConn.getValidationHandler();
            v.validateObjectName(oldName, "oldName", OraNamedObject.transformationSequence);
            v.validateObjectName(newName, "newName", OraNamedObject.transformationSequence);
            OraSQLUtils.renameTable(dmeConn.getDatabaseConnection(), oldName, newName);
        }
    }

    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        return OraSQLUtils.doesTableOrViewExists(dbConn, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, Date createdAfter, Date createdBefore) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT C.COMMENTS, T.TABLE_NAME from ALL_TABLES T, ALL_TAB_COMMENTS C WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like 'TS_%'";
        PreparedStatement ps = null;
        ResultSet rs = null;
        String description = null;
        String objectName = null;
        Vector<OraTransformationSequence> returnedObjects = new Vector<OraTransformationSequence>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                description = rs.getString("COMMENTS");
                objectName = rs.getString("TABLE_NAME");
                OraTransformationSequence object = null;
                try {
                    object = OraTransformationSequenceImpl.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    public static OraTransformationSequence retrieveObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean bsExist = dmeConn.doesObjectExist(name, OraNamedObject.transformationSequence);
        Object xformSeq = null;
        if (!bsExist) {
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
        }
        return null;
    }
}

