/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraExpressionTransform;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraExpressionTransformImpl
extends OraTransformationImpl
implements OraExpressionTransform {
    private TreeMap m_xformsMap = new TreeMap();
    private String m_expressionTable = null;
    private String m_modelName = null;
    private static String CREATE_XFORM_EXPR_TABLE = "CREATE TABLE xform_expr_table ( ATTRIBUTE_NAME VARCHAR2(30), ATTRIBUTE_SUBNAME VARCHAR2(4000), EXPRESSION CLOB, REVERSE_EXPRESSION CLOB, ATTRIBUTE_SPEC VARCHAR2(4000) )";
    private static String XFORM_EXPR_TABLE_SUFFIX = "_EXPR";
    private static String INSERT_XFORM_EXPR_TABLE = "INSERT INTO xform_expr_table VALUES ( ?, ?, ?, ?, ? )";
    public static String EXPRESSION_TYPE = "EXPRESSION";
    private static String IN_EXPRESSIONS_TABLE = "IN_EXPRESSIONS_TABLE";

    OraExpressionTransformImpl(OraConnection dmeConn, OraFactory factory, boolean isOutputView) throws JDMException {
        super(dmeConn, factory, isOutputView);
    }

    OraExpressionTransformImpl(OraConnection dmeConn, OraFactory factory, String expressionTable, boolean isOutputView) throws JDMException {
        super(dmeConn, factory, isOutputView);
        this.m_expressionTable = expressionTable;
    }

    public OraExpressionTransformImpl(OraConnection dmeConn, OraFactory factory, String modelName) throws JDMException {
        super(dmeConn, factory, true);
        this.m_modelName = modelName;
    }

    public void addAttributeExpression(String inputAttr, String expression, String inverseExpression) {
        String[] splitAttrs = this.splitAttribute(inputAttr, false);
        this.m_xformsMap.put(splitAttrs[2], new OraExpressionElementImpl(splitAttrs[2], expression, inverseExpression, splitAttrs, null));
    }

    public void addAttributeExpression(String inputAttr, String expression, String inverseExpression, String attrSpec) {
        String[] splitAttrs = this.splitAttribute(inputAttr, false);
        this.m_xformsMap.put(splitAttrs[2], new OraExpressionElementImpl(splitAttrs[2], expression, inverseExpression, splitAttrs, attrSpec));
    }

    public Map getAttributeExpressionMap() {
        if ((this.m_xformsMap == null || this.m_xformsMap.size() == 0) && this.m_modelName != null) {
            this.populateExpressionsFromModel();
        }
        return this.m_xformsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateExpressionsFromModel() {
        String qry = "select NVL2(t.ATTRIBUTE_SUBNAME, t.ATTRIBUTE_NAME || '.' || t.ATTRIBUTE_SUBNAME, t.ATTRIBUTE_NAME) attribute_name,        t.expression,        t.reverse_expression  from TABLE(DBMS_DATA_MINING.GET_MODEL_TRANSFORMATIONS(?)) t   where t.expression is not null  ";
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = dbConn.prepareStatement(qry);
            pStmt.setString(1, this.m_modelName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.addAttributeExpression(rs.getString(1), rs.getString(2), rs.getString(3));
            }
        }
        catch (SQLException sqlExp) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    public void removeAttributeExpression(String outputAttr) {
        String[] splitAttrs = this.splitAttribute(outputAttr, false);
        this.m_xformsMap.remove(splitAttrs[2]);
    }

    protected void populateTransformationTables(OraConnection dmeConn, String name) throws SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        Statement pStmt = null;
        try {
            pStmt = dbConn.prepareStatement(INSERT_XFORM_EXPR_TABLE.replaceAll("xform_expr_table", name + XFORM_EXPR_TABLE_SUFFIX));
            for (OraExpressionElementImpl exprElem : this.m_xformsMap.values()) {
                pStmt.setString(1, exprElem.m_plsqlAttrs[0]);
                if (exprElem.m_plsqlAttrs[1] == null) {
                    pStmt.setNull(2, 12);
                } else {
                    pStmt.setString(2, exprElem.m_plsqlAttrs[1]);
                }
                pStmt.setString(3, exprElem.m_expr);
                if (exprElem.m_revExpr == null) {
                    pStmt.setNull(4, 12);
                } else {
                    pStmt.setString(4, exprElem.m_revExpr);
                }
                if (exprElem.m_attrSpec == null) {
                    pStmt.setNull(5, 12);
                } else {
                    pStmt.setString(5, exprElem.m_attrSpec);
                }
                pStmt.addBatch();
            }
            pStmt.executeBatch();
            dbConn.commit();
        }
        catch (SQLException sqlExp) {
            dbConn.rollback();
            throw sqlExp;
        }
        finally {
            if (pStmt != null) {
                pStmt.close();
            }
        }
    }

    protected void createTransformationTable(OraConnection dmeConn, String name) throws SQLException {
        if (this.m_expressionTable == null) {
            String createTableQry = CREATE_XFORM_EXPR_TABLE.replaceAll("xform_expr_table", name + XFORM_EXPR_TABLE_SUFFIX);
            OraSQLUtils.execSql(dmeConn.getDatabaseConnection(), createTableQry, dmeConn.getLogger());
            this.m_expressionTable = name + XFORM_EXPR_TABLE_SUFFIX;
        }
        this.m_xformProperties.put(IN_EXPRESSIONS_TABLE, this.m_expressionTable);
    }

    protected void cleanXformSpecificObjects(OraConnection dmeConn, String name) {
        String tableName = null;
        tableName = name.startsWith("\"") && name.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(name) + XFORM_EXPR_TABLE_SUFFIX + "\"" : name + XFORM_EXPR_TABLE_SUFFIX;
        this.dropTable(tableName);
    }

    public String getSettingsTable1() {
        return this.m_expressionTable;
    }

    public String getSettingsTable2() {
        return null;
    }

    public String getType() {
        return EXPRESSION_TYPE;
    }

    public static class OraExpressionElementImpl
    implements OraExpressionTransform.OraExpressionElement {
        private String m_inputAttr;
        private String m_expr;
        private String m_revExpr;
        private String[] m_plsqlAttrs = null;
        private String m_attrSpec;

        private OraExpressionElementImpl(String inputAttr, String expr, String revExpr, String[] plsqlAttrs, String attrSpec) {
            this.m_inputAttr = inputAttr;
            this.m_expr = expr;
            this.m_revExpr = revExpr;
            this.m_plsqlAttrs = plsqlAttrs;
            this.m_attrSpec = attrSpec;
        }

        public String getExpression() {
            return this.m_expr;
        }

        public String getInverseExpression() {
            return this.m_revExpr;
        }

        public String getInputAttributeName() {
            return this.m_inputAttr;
        }

        public String getAttributeSpec() {
            return this.m_attrSpec;
        }
    }
}

