/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task.apply;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.clustering.ClusteringApplyContent;
import javax.datamining.clustering.ClusteringApplySettingsFactory;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeFactory;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.data.PhysicalDataSetFactory;
import javax.datamining.supervised.classification.ClassificationApplyContent;
import javax.datamining.supervised.classification.ClassificationApplySettingsFactory;
import javax.datamining.supervised.regression.RegressionApplyContent;
import javax.datamining.supervised.regression.RegressionApplySettingsFactory;
import javax.datamining.task.apply.ApplySettings;
import javax.datamining.task.apply.DataSetApplyTask;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplyContent;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplySettingsFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.regression.OraRegressionApplySettings;
import oracle.dmt.jdm.task.apply.OraApplySettings;
import oracle.dmt.jdm.task.apply.OraApplyTask;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTaskFactory;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class OraDataSetApplyTask
extends OraApplyTask
implements DataSetApplyTask {
    private OraDataURI m_applyOutputDestination = null;
    private String m_applyDataName = null;
    private String m_applyTableName = null;
    private String m_applyTableSchemaName = null;
    private String m_caseidColumnName = null;
    private String m_isViewType = "N";
    private String m_costMatrixName = null;
    protected static final int ARG_IX_MODEL_NAME = 0;
    protected static final int ARG_IX_DATA_TABLE_NAME = 1;
    protected static final int ARG_IX_CASE_ID_COLUMN_NAME = 2;
    protected static final int ARG_IX_RESULT_TABLE_NAME = 3;
    protected static final int ARG_IX_APPLY_SETTINGS_NAME = 4;
    protected static final int ARG_IX_PDS_NAME = 5;
    protected static final int ARG_IX_DATA_SCHEMA_NAME = 6;
    protected static final int ARG_IX_RANKED_APPLY_RESULT_TAB_NAME = 7;
    protected static final int ARG_IX_TOP_N = 8;
    protected static final int ARG_IX_COST_MATRIX_TABLE_NAME = 9;
    protected static final int ARG_IX_APPLY_RESULT_SCHEMA_NAME = 10;
    protected static final int ARG_IX_COST_MATRIX_SCHEMA_NAME = 11;
    protected static final int ARG_IX_APPLY_OUTPUT_TYPE = 7;
    protected static final int ARG_IX_SOURCE_ATTRS = 8;
    protected static final int ARG_IX_DESTINATION_ATTRS = 9;
    protected static final int ARG_IX_CONTENT_TYPES = 10;
    protected static final int ARG_IX_CONTENT_DEST_ATTRS = 11;
    protected static final int ARG_IX_NUM_TARGET_OR_CLUSTER_VALS = 12;
    protected static final int ARG_IX_STR_TARGET_OR_CLUSTER_VALS = 13;
    protected static final int ARG_IX_SQL_TOP_N = 14;
    protected static final int ARG_IX_USECOSTMATRIXFROMMODEL = 15;
    protected static final int ARG_IX_SQL_COST_MATRIX_TABLE_NAME = 16;
    protected static final int ARG_IX_SQL_APPLY_RESULT_SCHEMA_NAME = 17;
    protected static final int ARG_IX_SQL_COST_MATRIX_SCHEMA_NAME = 18;
    protected static final int ARG_IX_SQL_REGR_TARGET_NORM_SCALE_VALUE = 19;
    protected static final int ARG_IX_SQL_REGR_TARGET_NORM_SHIFT_VALUE = 20;
    protected static final int ARG_IX_VIEW_OUTPUT = 21;
    protected static final String ARG_MODEL_NAME = "MODEL_NAME";
    protected static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    protected static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    protected static final String ARG_RESULT_TABLE_NAME = "RESULT_TABLE_NAME";
    protected static final String ARG_APPLY_SETTINGS_NAME = "APPLY_SETTINGS_NAME";
    protected static final String ARG_PDS_NAME = "PDS_NAME";
    protected static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    protected static final String ARG_RANKED_APPLY_RESULT_TAB_NAME = "RANKED_APPLY_RESULT_TAB_NAME";
    protected static final String ARG_TOP_N = "TOP_N";
    protected static final String ARG_COST_MATRIX_TABLE_NAME = "COST_MATRIX_TABLE_NAME";
    protected static final String ARG_APPLY_RESULT_SCHEMA_NAME = "APPLY_RESULT_SCHEMA_NAME";
    protected static final String ARG_COST_MATRIX_SCHEMA_NAME = "COST_MATRIX_SCHEMA_NAME";
    protected static final String ARG_APPLY_OUTPUT_TYPE = "APPLY_OUTPUT_TYPE";
    protected static final String ARG_SOURCE_ATTRS = "SOURCE_ATTRS";
    protected static final String ARG_DESTINATION_ATTRS = "DESTINATION_ATTRS";
    protected static final String ARG_CONTENT_TYPES = "CONTENT_TYPES";
    protected static final String ARG_CONTENT_DEST_ATTRS = "CONTENT_DEST_ATTRS";
    protected static final String ARG_NUM_TARGET_OR_CLUSTER_VALS = "NUM_TARGET_OR_CLUSTER_VALS";
    protected static final String ARG_STR_TARGET_OR_CLUSTER_VALS = "STR_TARGET_OR_CLUSTER_VALS";
    protected static final String ARG_SQL_TOP_N = "TOP_N";
    protected static final String ARG_USECOSTMATRIXFROMMODEL = "USECOSTMATRIXFROMMODEL";
    protected static final String ARG_SQL_COST_MATRIX_TABLE_NAME = "COST_MATRIX_TABLE_NAME";
    protected static final String ARG_SQL_APPLY_RESULT_SCHEMA_NAME = "APPLY_RESULT_SCHEMA_NAME";
    protected static final String ARG_SQL_COST_MATRIX_SCHEMA_NAME = "COST_MATRIX_SCHEMA_NAME";
    protected static final String ARG_SQL_REGR_TARGET_NORM_SCALE_VALUE = "REGR_TARGET_NORM_SCALE_VALUE";
    protected static final String ARG_SQL_REGR_TARGET_NORM_SHIFT_VALUE = "REGR_TARGET_NORM_SHIFT_VALUE";
    protected static final String ARG_VIEW_OUTPUT = "VIEW_OUTPUT";

    public String getApplyOutputDestination() {
        return this.m_applyOutputDestination.getURI();
    }

    public void setApplyOutputDestination(String applyOutputDestinationURI) throws JDMException {
        this.getValidationHandler().validateNotNull(applyOutputDestinationURI, "applyOutputDestinationURI");
        this.m_applyOutputDestination = new OraDataURI(applyOutputDestinationURI);
    }

    public String getApplyDataName() {
        return this.m_applyDataName;
    }

    public void setApplyDataName(String applyDataName) throws JDMException {
        this.m_applyDataName = applyDataName;
    }

    public void setOutputDestinationType(boolean isViewType) {
        this.m_isViewType = isViewType ? "T" : "N";
    }

    public boolean getOutputDestinationType() {
        return this.m_isViewType == "T";
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraPhysicalDataSet applyData = (OraPhysicalDataSet)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.m_applyDataName, "'", "''"), NamedObject.physicalDataSet);
        OraApplySettings applySettingsObj = (OraApplySettings)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.m_applySettingsName, "'", "''"), NamedObject.applySettings);
        this.m_applyTableName = applyData.getTableName();
        this.m_applyTableSchemaName = applyData.getSchemaName();
        PhysicalAttribute caseIdAttr = applyData.getCaseIDAttribute();
        if (caseIdAttr != null) {
            this.m_caseidColumnName = caseIdAttr.getName();
        }
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_MODEL_NAME, this.m_modelName, new Integer(12)}, new Object[]{ARG_DATA_TABLE_NAME, this.m_applyTableName, new Integer(12)}, new Object[]{ARG_CASE_ID_COLUMN_NAME, this.m_caseidColumnName, new Integer(12)}, new Object[]{ARG_RESULT_TABLE_NAME, this.m_applyOutputDestination.getTableName(), new Integer(12)}, new Object[]{ARG_APPLY_SETTINGS_NAME, this.m_applySettingsName, new Integer(12)}, new Object[]{ARG_PDS_NAME, this.m_applyDataName, new Integer(12)}, new Object[]{ARG_DATA_SCHEMA_NAME, this.m_applyTableSchemaName, new Integer(12)}, new Object[]{ARG_RANKED_APPLY_RESULT_TAB_NAME, null, new Integer(12)}, new Object[]{"TOP_N", null, new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", this.m_costMatrixName, new Integer(12)}, new Object[]{"APPLY_RESULT_SCHEMA_NAME", this.m_applyOutputDestination.getSchemaName(), new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", null, new Integer(12)}));
        try {
            OraApplySettings aSettings = this.getApplySettings();
            BigDecimal applyOutputType = new BigDecimal(aSettings.m_applyOutputMode);
            String[] sourceAttrs = null;
            ARRAY arr_sourceAttrs = null;
            String[] destinationAttrs = null;
            ARRAY arr_destinationAttrs = null;
            ArrayDescriptor attrNamesDesc = null;
            ArrayDescriptor numValsDesc = null;
            ArrayDescriptor strValsDesc = null;
            attrNamesDesc = ArrayDescriptor.createDescriptor((String)(this.installedSchema + ".JDM_ATTR_NAMES"), (Connection)dbConn);
            numValsDesc = ArrayDescriptor.createDescriptor((String)(this.installedSchema + ".JDM_NUM_VALS"), (Connection)dbConn);
            strValsDesc = ArrayDescriptor.createDescriptor((String)(this.installedSchema + ".JDM_STR_VALS"), (Connection)dbConn);
            if (aSettings.m_SDMap != null) {
                Object[] sourceObjArray = aSettings.m_SDMap.keySet().toArray();
                sourceAttrs = new String[sourceObjArray.length];
                System.arraycopy(sourceObjArray, 0, sourceAttrs, 0, sourceObjArray.length);
                destinationAttrs = new String[sourceAttrs.length];
                for (int iSource = 0; iSource < sourceAttrs.length; ++iSource) {
                    destinationAttrs[iSource] = (String)aSettings.m_SDMap.get(sourceAttrs[iSource]);
                }
                if (sourceAttrs != null) {
                    arr_sourceAttrs = new ARRAY(attrNamesDesc, dbConn, (Object)sourceAttrs);
                }
                if (destinationAttrs != null) {
                    arr_destinationAttrs = new ARRAY(attrNamesDesc, dbConn, (Object)destinationAttrs);
                }
            }
            int[] contentTypes = null;
            ARRAY arr_contentTypes = null;
            if (aSettings.m_contents != null) {
                contentTypes = new int[aSettings.m_contents.size()];
                Iterator iterate = aSettings.m_contents.iterator();
                int i = 0;
                while (iterate.hasNext()) {
                    if (aSettings.m_function.equals((Object)MiningFunction.classification)) {
                        contentTypes[i++] = OraPLSQLMappings.getPLSQLConstant((ClassificationApplyContent)iterate.next());
                        continue;
                    }
                    if (aSettings.m_function.equals((Object)MiningFunction.regression)) {
                        contentTypes[i++] = OraPLSQLMappings.getPLSQLConstant((RegressionApplyContent)iterate.next());
                        continue;
                    }
                    if (aSettings.m_function.equals((Object)MiningFunction.clustering)) {
                        contentTypes[i++] = OraPLSQLMappings.getPLSQLConstant((ClusteringApplyContent)iterate.next());
                        continue;
                    }
                    if (!aSettings.m_function.equals((Object)OraMiningFunction.featureExtraction)) continue;
                    contentTypes[i++] = OraPLSQLMappings.getPLSQLConstant((OraFeatureExtractionApplyContent)((Object)iterate.next()));
                }
            }
            if (contentTypes != null) {
                arr_contentTypes = new ARRAY(numValsDesc, dbConn, (Object)contentTypes);
            }
            String[] contentDestAttrs = null;
            ARRAY arr_contentDestAttrs = null;
            if (aSettings.m_contentAttrNames != null) {
                Object[] contentDestAttrsArray = aSettings.m_contentAttrNames.toArray();
                contentDestAttrs = new String[contentDestAttrsArray.length];
                System.arraycopy(contentDestAttrsArray, 0, contentDestAttrs, 0, contentDestAttrsArray.length);
            }
            if (contentDestAttrs != null) {
                arr_contentDestAttrs = new ARRAY(attrNamesDesc, dbConn, (Object)contentDestAttrs);
            }
            BigDecimal[] numTargetVals = null;
            String[] strTargetVals = null;
            ARRAY arr_strTargetVals = null;
            ARRAY arr_numTargetVals = null;
            if (aSettings.m_contentAttrVals != null && aSettings.m_contentAttrVals.size() > 0) {
                Object obj = aSettings.m_contentAttrVals.elementAt(0);
                if (obj instanceof String) {
                    Object[] objArray = aSettings.m_contentAttrVals.toArray();
                    strTargetVals = new String[objArray.length];
                    System.arraycopy(objArray, 0, strTargetVals, 0, objArray.length);
                } else {
                    numTargetVals = new BigDecimal[aSettings.m_contentAttrVals.size()];
                    for (int i = 0; i < aSettings.m_contentAttrVals.size(); ++i) {
                        numTargetVals[i] = new BigDecimal(((Number)aSettings.m_contentAttrVals.elementAt(i)).doubleValue());
                    }
                }
            }
            if (strTargetVals != null) {
                arr_strTargetVals = new ARRAY(strValsDesc, dbConn, strTargetVals);
            }
            if (numTargetVals != null) {
                arr_numTargetVals = new ARRAY(numValsDesc, dbConn, numTargetVals);
            }
            BigDecimal top_N = new BigDecimal(aSettings.m_topN);
            BigDecimal useCostMatrixFromModel = new BigDecimal("0");
            String costMatrixName = aSettings.getCostMatrixName();
            String costMatrixTableName = null;
            String costMatrixSchemaName = null;
            if (costMatrixName == null) {
                useCostMatrixFromModel = new BigDecimal(aSettings.useCMFromModel());
            } else {
                OraDataURI cmURI = new OraDataURI(costMatrixName);
                costMatrixTableName = cmURI.getTableName();
                costMatrixSchemaName = cmURI.getSchemaName();
            }
            Double scaleValue = null;
            Double shiftValue = null;
            try {
                OraRegressionApplySettings regSettings = (OraRegressionApplySettings)aSettings;
                scaleValue = regSettings.getTargetNormalizationScaleValue();
                shiftValue = regSettings.getTargetNormalizationShiftValue();
            }
            catch (Exception anyExp) {
                // empty catch block
            }
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_MODEL_NAME, this.m_modelName, new Integer(12)}, new Object[]{ARG_DATA_TABLE_NAME, this.m_applyTableName, new Integer(12)}, new Object[]{ARG_CASE_ID_COLUMN_NAME, this.m_caseidColumnName, new Integer(12)}, new Object[]{ARG_RESULT_TABLE_NAME, this.m_applyOutputDestination.getTableName(), new Integer(12)}, new Object[]{ARG_APPLY_SETTINGS_NAME, this.m_applySettingsName, new Integer(12)}, new Object[]{ARG_PDS_NAME, this.m_applyDataName, new Integer(12)}, new Object[]{ARG_DATA_SCHEMA_NAME, this.m_applyTableSchemaName, new Integer(12)}, new Object[]{ARG_APPLY_OUTPUT_TYPE, applyOutputType, new Integer(3)}, new Object[]{ARG_SOURCE_ATTRS, arr_sourceAttrs, new Integer(2003)}, new Object[]{ARG_DESTINATION_ATTRS, arr_destinationAttrs, new Integer(2003)}, new Object[]{ARG_CONTENT_TYPES, arr_contentTypes, new Integer(2003)}, new Object[]{ARG_CONTENT_DEST_ATTRS, arr_contentDestAttrs, new Integer(2003)}, new Object[]{ARG_NUM_TARGET_OR_CLUSTER_VALS, arr_numTargetVals, new Integer(2003)}, new Object[]{ARG_STR_TARGET_OR_CLUSTER_VALS, arr_strTargetVals, new Integer(2003)}, new Object[]{"TOP_N", top_N, new Integer(3)}, new Object[]{ARG_USECOSTMATRIXFROMMODEL, useCostMatrixFromModel, new Integer(3)}, new Object[]{"COST_MATRIX_TABLE_NAME", costMatrixTableName, new Integer(12)}, new Object[]{"APPLY_RESULT_SCHEMA_NAME", this.m_applyOutputDestination.getSchemaName(), new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", costMatrixSchemaName, new Integer(12)}, new Object[]{ARG_SQL_REGR_TARGET_NORM_SCALE_VALUE, scaleValue, new Integer(8)}, new Object[]{ARG_SQL_REGR_TARGET_NORM_SHIFT_VALUE, shiftValue, new Integer(8)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{ARG_VIEW_OUTPUT, this.m_isViewType, new Integer(12)});
            }
        }
        catch (SQLException sqlExp) {
            this.createException("2000", new Object[]{"save"}, sqlExp);
        }
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_modelName = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_applyTableName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_caseidColumnName = (String)((Object[])this.m_jobArgs.get(2))[1];
            this.m_applyOutputDestination = new OraDataURI();
            this.m_applyOutputDestination.setTableName((String)((Object[])this.m_jobArgs.get(3))[1]);
            this.m_applyOutputDestination.setSchemaName((String)((Object[])this.m_jobArgs.get(17))[1]);
            this.m_applySettingsName = (String)((Object[])this.m_jobArgs.get(4))[1];
            this.m_applyDataName = (String)((Object[])this.m_jobArgs.get(5))[1];
            this.m_applyTableSchemaName = (String)((Object[])this.m_jobArgs.get(6))[1];
            if (!this.is102()) {
                this.m_isViewType = (String)((Object[])this.m_jobArgs.get(21))[1];
            }
        }
    }

    public PhysicalDataSet getApplyData() throws JDMException {
        if (this.m_jobArgs != null) {
            PhysicalDataSetFactory pdsFactory = (PhysicalDataSetFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalDataSet");
            PhysicalAttributeFactory paFactory = (PhysicalAttributeFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalAttribute");
            OraDataURI dataURI = new OraDataURI(this.m_applyTableName, this.m_applyTableSchemaName);
            PhysicalDataSet pds = pdsFactory.create(dataURI.getURI(), false);
            if (this.m_caseidColumnName != null) {
                PhysicalAttribute pa = paFactory.create(this.m_caseidColumnName, AttributeDataType.integerType, PhysicalAttributeRole.caseId);
                pds.addAttribute(pa);
            }
            return pds;
        }
        return null;
    }

    public ApplySettings getApplySettings(MiningFunction function) throws JDMException {
        OraApplySettings applySettings = null;
        if (MiningFunction.classification.equals((Object)function)) {
            ClassificationApplySettingsFactory clasFactory = (ClassificationApplySettingsFactory)this.getConnection().getFactory("javax.datamining.supervised.classification.ClassificationApplySettings");
            applySettings = (OraApplySettings)clasFactory.create();
        } else if (MiningFunction.regression.equals((Object)function)) {
            RegressionApplySettingsFactory regrFactory = (RegressionApplySettingsFactory)this.getConnection().getFactory("javax.datamining.supervised.regression.RegressionApplySettings");
            applySettings = (OraApplySettings)regrFactory.create();
        } else if (MiningFunction.clustering.equals((Object)function)) {
            ClusteringApplySettingsFactory cluFactory = (ClusteringApplySettingsFactory)this.getConnection().getFactory("javax.datamining.clustering.ClusteringApplySettings");
            applySettings = (OraApplySettings)cluFactory.create();
        } else if (OraMiningFunction.featureExtraction.equals((Object)function)) {
            OraFeatureExtractionApplySettingsFactory featureFactory = (OraFeatureExtractionApplySettingsFactory)this.getConnection().getFactory("oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplySettings");
            applySettings = featureFactory.create();
        }
        if (this.m_jobArgs != null) {
            String jobName = this.getJob().getName();
            jobName = OraStringUtils.trimDoubleQuotes(jobName);
            int totalNumOfArgs = this.m_jobArgs.size();
            try {
                BigDecimal top_n;
                double[] numTargetVals;
                BigDecimal applyOutputType = (BigDecimal)((Object[])this.m_jobArgs.get(7))[1];
                if (applyOutputType != null) {
                    applySettings.m_applyOutputMode = applyOutputType.intValue();
                }
                if (totalNumOfArgs > 8 && totalNumOfArgs > 9 && this.m_jobArgs.get(8) != null && this.m_jobArgs.get(9) != null) {
                    String[] sourceAttrs = this.getJDM_ATTR_NAMES(jobName, 9);
                    String[] destinationAttrs = this.getJDM_ATTR_NAMES(jobName, 10);
                    if (sourceAttrs != null && destinationAttrs != null) {
                        HashMap<String, String> srcDestMap = new HashMap<String, String>();
                        int length = Math.min(sourceAttrs.length, destinationAttrs.length);
                        for (int i = 0; i < length; ++i) {
                            srcDestMap.put(sourceAttrs[i], destinationAttrs[i]);
                        }
                        applySettings.setSourceDestinationMap(srcDestMap);
                    }
                }
                if (totalNumOfArgs > 10 && totalNumOfArgs > 11 && this.m_jobArgs.get(10) != null && this.m_jobArgs.get(11) != null) {
                    String[] contentAttrs;
                    double[] contentTypeNumbers = this.getJDM_NUM_VALS(jobName, 11);
                    if (contentTypeNumbers != null) {
                        applySettings.m_contents = new Vector();
                        for (int i = 0; i < contentTypeNumbers.length; ++i) {
                            if (applySettings.m_function.equals((Object)MiningFunction.classification)) {
                                applySettings.m_contents.add(OraPLSQLMappings.getClassificationApplyContent((int)contentTypeNumbers[i]));
                                continue;
                            }
                            if (applySettings.m_function.equals((Object)MiningFunction.regression)) {
                                applySettings.m_contents.add(OraPLSQLMappings.getRegressionApplyContent((int)contentTypeNumbers[i]));
                                continue;
                            }
                            if (applySettings.m_function.equals((Object)MiningFunction.clustering)) {
                                applySettings.m_contents.add(OraPLSQLMappings.getClusteringApplyContent((int)contentTypeNumbers[i]));
                                continue;
                            }
                            if (!applySettings.m_function.equals((Object)OraMiningFunction.featureExtraction)) continue;
                            applySettings.m_contents.add(OraPLSQLMappings.getFeatureExtractionApplyContent((int)contentTypeNumbers[i]));
                        }
                    }
                    if ((contentAttrs = this.getJDM_ATTR_NAMES(jobName, 12)) != null) {
                        applySettings.m_contentAttrNames = new Vector();
                        this.m_jobArgs.addAll(Arrays.asList(contentAttrs));
                    }
                }
                if (totalNumOfArgs > 12 && this.m_jobArgs.get(12) != null && (numTargetVals = this.getJDM_NUM_VALS(jobName, 13)) != null) {
                    applySettings.m_contentAttrVals = new Vector();
                    for (int i = 0; i < numTargetVals.length; ++i) {
                        applySettings.m_contentAttrVals.add(new BigDecimal(numTargetVals[i]));
                    }
                }
                if (totalNumOfArgs > 13 && this.m_jobArgs.get(13) != null) {
                    String[] strTargetVals = this.getJDM_STR_VALS(jobName, 14);
                    applySettings.m_contentAttrVals = new Vector<String>(Arrays.asList(strTargetVals));
                }
                if (totalNumOfArgs > 14 && this.m_jobArgs.get(14) != null && (top_n = (BigDecimal)((Object[])this.m_jobArgs.get(14))[1]) != null) {
                    applySettings.m_topN = top_n.intValue();
                }
                if (totalNumOfArgs > 16 && this.m_jobArgs.get(16) != null) {
                    String costMatrixTableName = (String)((Object[])this.m_jobArgs.get(16))[1];
                    String costMatrixSchemaName = null;
                    if (totalNumOfArgs > 18 && this.m_jobArgs.get(18) != null) {
                        costMatrixSchemaName = (String)((Object[])this.m_jobArgs.get(18))[1];
                    }
                    if (costMatrixTableName != null) {
                        OraDataURI cmURI = new OraDataURI(costMatrixTableName, costMatrixSchemaName);
                        applySettings.m_costMatrixName = cmURI.getURI();
                    }
                }
                Double shiftValue = null;
                Double scaleValue = null;
                try {
                    BigDecimal bd_shiftVal;
                    BigDecimal bd_scaleVal;
                    OraRegressionApplySettings regrApplySettings = (OraRegressionApplySettings)applySettings;
                    if (totalNumOfArgs > 19 && this.m_jobArgs.get(19) != null && (bd_scaleVal = (BigDecimal)((Object[])this.m_jobArgs.get(19))[1]) != null) {
                        scaleValue = new Double(bd_scaleVal.doubleValue());
                    }
                    if (totalNumOfArgs > 20 && this.m_jobArgs.get(20) != null && (bd_shiftVal = (BigDecimal)((Object[])this.m_jobArgs.get(20))[1]) != null) {
                        shiftValue = new Double(bd_shiftVal.doubleValue());
                    }
                    regrApplySettings.setTargetNormalizationDetails(shiftValue, scaleValue);
                }
                catch (ClassCastException ignoreIt) {}
            }
            catch (Exception anyExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, anyExp);
            }
            return applySettings;
        }
        return null;
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }

    public OraDataSetApplyTask(OraConnection dmeConn, OraDataSetApplyTaskFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, (String)null);
    }

    public OraDataSetApplyTask(OraConnection dmeConn, OraDataSetApplyTaskFactory factory, String applyDataName, String modelName, String applySettingsName, String applyOutputDestinationURI) throws JDMException {
        super(dmeConn, (OraFactory)factory, applySettingsName);
        this.getConnection().getValidationHandler().validateObjectName(applyDataName, "applyDataName", NamedObject.physicalDataSet);
        this.getConnection().getValidationHandler().validateObjectName(modelName, "modelName", NamedObject.model);
        this.getConnection().getValidationHandler().validateObjectName(applySettingsName, "applySettingsName", NamedObject.applySettings);
        this.m_applyOutputDestination = new OraDataURI(applyOutputDestinationURI);
        this.m_applyDataName = applyDataName;
        this.m_modelName = modelName;
        this.m_applySettingsName = applySettingsName;
    }
}

