/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.datamining.ImportExportFormat;
import javax.datamining.JDMException;
import javax.datamining.MiningTask;
import javax.datamining.VerificationReport;
import javax.datamining.task.ImportSummary;
import javax.datamining.task.ImportTask;
import javax.datamining.task.SettingsInclusionOption;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraImportTaskFactory;

public class OraImportTask
extends OraTask
implements ImportTask {
    private Vector m_modelNameVector = new Vector();
    private File m_importFile = null;
    private ImportExportFormat m_ieFormat = ImportExportFormat.systemDefault;
    private SettingsInclusionOption m_settingsInclusionOption = SettingsInclusionOption.settingsOnly;
    private boolean m_useOriginalCreationDates = false;
    private static final int ARG_IX_FILE_NAME = 0;
    private static final int ARG_IX_DIRECTORY_NAME = 1;
    private static final int ARG_IX_MODEL_FILTER = 2;
    private static final int ARG_IX_OPERATION = 3;
    private static final int ARG_IX_REMOTE_LINK = 4;
    private static final int ARG_IX_JOB_NAME = 5;
    private static final int ARG_IX_SCHEMA_REMAP = 6;
    private static final String ARG_FILE_NAME = "filename";
    private static final String ARG_DIRECTORY_NAME = "directory";
    private static final String ARG_MODEL_FILTER = "model_filter";
    private static final String ARG_OPERATION = "operation";
    private static final String ARG_REMOTE_LINK = "remote_link";
    private static final String ARG_JOB_NAME = "jobname";
    private static final String ARG_SCHEMA_REMAP = "SCHEMA_REMAP";
    private static final String MODEL_NAME_IN = "name IN (";

    public String getURI() {
        if (this.m_importFile == null) {
            return null;
        }
        return this.m_importFile.getAbsolutePath();
    }

    public void setURI(String uri) throws JDMException {
        this.getValidationHandler().validateNotNull(uri, "uri");
        this.m_importFile = new File(uri);
    }

    public boolean includeModelSettings() {
        return true;
    }

    public void includeModelSettings(boolean includeModelSettings) {
        if (includeModelSettings) {
            this.unsupported("includeModelSettings - false");
        }
    }

    public void useOriginalCreationDates(boolean useOriginalCreationDates) {
        this.m_useOriginalCreationDates = useOriginalCreationDates;
    }

    public boolean useOriginalCreationDates() {
        return this.m_useOriginalCreationDates;
    }

    public void populateSummary() throws JDMException {
    }

    public ImportSummary getSummary() {
        return null;
    }

    public void setObjectNamesMap(Map map) {
    }

    public Map getObjectNamesMap() {
        return null;
    }

    public VerificationReport verify() {
        return null;
    }

    public OraImportTask(OraConnection dmeConn, OraImportTaskFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, IMPORT_PROGRAM);
        this.m_taskType = MiningTask.importTask;
        this.ARG_IX_OVERWRITE_OUTPUT = 7;
        this.ARG_IX_PARENT_TASKS = 8;
        this.ARG_IX_CHILD_TASKS = 9;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        StringBuffer modelInClause = new StringBuffer();
        if (this.m_modelNameVector.size() == 0) {
            modelInClause.append("ALL");
        } else {
            modelInClause.append(MODEL_NAME_IN);
            for (int iModel = 0; iModel < this.m_modelNameVector.size(); ++iModel) {
                if (iModel == 0) {
                    modelInClause.append("'");
                } else {
                    modelInClause.append(",'");
                }
                modelInClause.append(this.m_modelNameVector.elementAt(iModel));
                modelInClause.append("'");
            }
            modelInClause.append(")");
        }
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_FILE_NAME, this.m_importFile.getName(), new Integer(12)}, new Object[]{ARG_DIRECTORY_NAME, this.m_importFile.getParent(), new Integer(12)}, new Object[]{ARG_MODEL_FILTER, modelInClause.toString(), new Integer(12)}, new Object[]{ARG_OPERATION, null, new Integer(12)}, new Object[]{ARG_REMOTE_LINK, null, new Integer(12)}, new Object[]{ARG_JOB_NAME, null, new Integer(12)}, new Object[]{ARG_SCHEMA_REMAP, null, new Integer(12)}));
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            String fileName = (String)((Object[])this.m_jobArgs.get(0))[1];
            String directoryName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_importFile = new File(directoryName, fileName);
            String modelFilter = (String)((Object[])this.m_jobArgs.get(2))[1];
            if (!modelFilter.equalsIgnoreCase("ALL")) {
                String modelList = modelFilter.substring(10);
                StringTokenizer tokenizer = new StringTokenizer(modelList, "',')");
                while (tokenizer.hasMoreTokens()) {
                    this.m_modelNameVector.add(tokenizer.nextElement());
                }
            }
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
    }
}

