/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.VerificationReport;
import javax.datamining.attributeimportance.AttributeImportanceSettings;
import javax.datamining.base.BuildSettings;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeFactory;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.data.PhysicalDataSetFactory;
import javax.datamining.supervised.SupervisedSettings;
import javax.datamining.task.BuildTask;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraNamedObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraBuildTaskFactory;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraBuildTask
extends OraTask
implements BuildTask {
    private String m_buildSettingsName = null;
    private String m_modelName = null;
    private String m_buildDataName = null;
    private String m_applicationName = null;
    private String m_modelDescription = null;
    private String m_settingsTableName = null;
    private String m_xformSeqName = null;
    private static final int ARG_IX_MODEL_NAME = 0;
    private static final int ARG_IX_MINING_FUNCTION = 1;
    private static final int ARG_IX_DATA_TABLE_NAME = 2;
    private static final int ARG_IX_CASE_ID_COLUMN_NAME = 3;
    private static final int ARG_IX_PDS_NAME = 4;
    private static final int ARG_IX_BUILD_SETTINGS_NAME = 5;
    private static final int ARG_IX_MODEL_DESCRIPTION = 6;
    private static final int ARG_IX_TARGET_COLUMN_NAME = 7;
    private static final int ARG_IX_SETTINGS_TABLE_NAME = 8;
    private static final int ARG_IX_DATA_SCHEMA_NAME = 9;
    private static final int ARG_IX_SETTINGS_SCHEMA_NAME = 10;
    private static final int ARG_IX_REMOVE_SETTINGS_TABLE = 11;
    private static final int ARG_IX_XFORM_SEQ_NAME = 12;
    private static final String ARG_MODEL_NAME = "MODEL_NAME";
    private static final String ARG_MINING_FUNCTION = "MINING_FUNCTION";
    private static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    private static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    private static final String ARG_PDS_NAME = "PDS_NAME";
    private static final String ARG_BUILD_SETTINGS_NAME = "BUILD_SETTINGS_NAME";
    private static final String ARG_MODEL_DESCRIPTION = "MODEL_DESCRIPTION";
    private static final String ARG_TARGET_COLUMN_NAME = "TARGET_COLUMN_NAME";
    private static final String ARG_SETTINGS_TABLE_NAME = "SETTINGS_TABLE_NAME";
    private static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    private static final String ARG_SETTINGS_SCHEMA_NAME = "SETTINGS_SCHEMA_NAME";
    private static final String ARG_REMOVE_SETTINGS_TABLE = "REMOVE_SETTINGS_TABLE";
    private static final String ARG_XFORM_SEQ_NAME = "XFORM_SEQ_NAME";

    protected OraBuildTask(OraConnection dmeConn, OraBuildTaskFactory factory, String buildData, String buildSettingsName, String modelName) throws JDMException {
        super(dmeConn, (OraFactory)factory, BUILD_PROGRAM);
        this.ARG_IX_OVERWRITE_OUTPUT = 13;
        this.ARG_IX_PARENT_TASKS = 14;
        this.m_buildDataName = buildData;
        this.m_buildSettingsName = this.getValidationHandler().validateObjectName(buildSettingsName, "buildSettingsName", NamedObject.buildSettings);
        this.m_modelName = this.getValidationHandler().validateObjectName(modelName, "modelName", NamedObject.model);
        this.m_settingsTableName = this.m_buildSettingsName;
        this.m_taskType = MiningTask.buildTask;
    }

    public String getTransformationSequenceName() {
        return this.m_xformSeqName;
    }

    public void setTransformationSequenceName(String name) {
        this.m_xformSeqName = this.getConnection().getValidationHandler().validateObjectName(name, "name", OraNamedObject.transformationSequence);
    }

    public String getModelName() {
        return this.m_modelName;
    }

    public void setModelName(String name) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(name, "name", NamedObject.model);
        this.m_modelName = name;
    }

    public String getBuildDataName() {
        return this.m_buildDataName;
    }

    public void setBuildDataName(String name) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(name, "name", NamedObject.physicalDataSet);
        this.m_buildDataName = name;
    }

    public String getBuildSettingsName() {
        return this.m_buildSettingsName;
    }

    public void setBuildSettingsName(String name) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(name, "name", NamedObject.buildSettings);
        this.m_buildSettingsName = name;
    }

    public String getInputModelName() {
        this.unsupported("InputModelName");
        return null;
    }

    public void setInputModelName(String modelName) throws JDMException {
        this.unsupported("InputModelName");
    }

    public void setValidationDataName(String validationDataName) throws JDMException {
        this.unsupported("ValidationDataName");
    }

    public String getValidationDataName() {
        this.unsupported("ValidationDataName");
        return null;
    }

    public String getApplicationName() {
        this.unsupported("ApplicationName");
        return this.m_applicationName;
    }

    public void setApplicationName(String name) {
        this.unsupported("ApplicationName");
    }

    public String getModelDescription() {
        this.unsupported("ModelDescription");
        return this.m_modelDescription;
    }

    public void setModelDescription(String description) {
        this.unsupported("ModelDescription");
    }

    public void setBuildDataMap(Map buildDataMap) throws JDMException {
        this.unsupported("BuildDataMap");
    }

    public Map getBuildDataMap() {
        this.unsupported("BuildDataMap");
        return null;
    }

    public void setValidationDataMap(Map validationDataMap) throws JDMException {
        this.unsupported("validationDataMap");
    }

    public Map getValidationDataMap() {
        this.unsupported("validationDataMap");
        return null;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraPhysicalDataSet buildData = (OraPhysicalDataSet)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.m_buildDataName, "'", "''"), NamedObject.physicalDataSet);
        BuildSettings buildSettings = (BuildSettings)dmeConn.retrieveObject(this.m_buildSettingsName, NamedObject.buildSettings);
        String buildTableName = buildData.getTableName();
        String buildTableSchemaName = buildData.getSchemaName();
        PhysicalAttribute caseIdAttr = buildData.getCaseIDAttribute();
        String caseIdColumnName = null;
        if (caseIdAttr != null) {
            caseIdColumnName = caseIdAttr.getName();
        }
        String plsqlFunctionName = OraPLSQLMappings.getPLSQLConstant(buildSettings.getMiningFunction());
        String targetAttrName = null;
        if (buildSettings instanceof SupervisedSettings) {
            targetAttrName = ((SupervisedSettings)buildSettings).getTargetAttributeName();
        } else if (buildSettings instanceof AttributeImportanceSettings) {
            targetAttrName = ((AttributeImportanceSettings)buildSettings).getTargetAttributeName();
        }
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_MODEL_NAME, this.m_modelName, new Integer(12)}, new Object[]{ARG_MINING_FUNCTION, plsqlFunctionName, new Integer(12)}, new Object[]{ARG_DATA_TABLE_NAME, buildTableName, new Integer(12)}, new Object[]{ARG_CASE_ID_COLUMN_NAME, caseIdColumnName, new Integer(12)}, new Object[]{ARG_PDS_NAME, this.m_buildDataName, new Integer(12)}, new Object[]{ARG_BUILD_SETTINGS_NAME, this.m_buildSettingsName, new Integer(12)}, new Object[]{ARG_MODEL_DESCRIPTION, this.m_modelDescription, new Integer(12)}, new Object[]{ARG_TARGET_COLUMN_NAME, targetAttrName, new Integer(12)}, new Object[]{ARG_SETTINGS_TABLE_NAME, this.m_settingsTableName, new Integer(12)}, new Object[]{ARG_DATA_SCHEMA_NAME, buildTableSchemaName, new Integer(12)}, new Object[]{ARG_SETTINGS_SCHEMA_NAME, null, new Integer(12)}, new Object[]{ARG_REMOVE_SETTINGS_TABLE, "N", new Integer(12)}));
        if (!this.is102()) {
            this.m_jobArgs.add(new Object[]{ARG_XFORM_SEQ_NAME, this.m_xformSeqName, new Integer(12)});
        }
        this.logTrace(OraStringUtils.getBuildTaskCall(this.m_jobArgs), (Object[])null);
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_modelName = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_buildDataName = (String)((Object[])this.m_jobArgs.get(4))[1];
            this.m_modelDescription = (String)((Object[])this.m_jobArgs.get(6))[1];
            this.m_buildSettingsName = (String)((Object[])this.m_jobArgs.get(5))[1];
            if (!this.is102() && this.m_jobArgs.get(12) != null) {
                this.m_xformSeqName = (String)((Object[])this.m_jobArgs.get(12))[1];
            }
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }

    public VerificationReport verify() {
        return null;
    }

    public PhysicalDataSet getBuildData() throws JDMException {
        if (this.m_jobArgs != null) {
            String tableName = (String)((Object[])this.m_jobArgs.get(2))[1];
            String caseId = (String)((Object[])this.m_jobArgs.get(3))[1];
            String schemaName = (String)((Object[])this.m_jobArgs.get(9))[1];
            PhysicalDataSetFactory pdsFactory = (PhysicalDataSetFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalDataSet");
            PhysicalAttributeFactory paFactory = (PhysicalAttributeFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalAttribute");
            OraDataURI dataURI = new OraDataURI(tableName, schemaName);
            PhysicalDataSet pds = pdsFactory.create(dataURI.getURI(), false);
            if (caseId != null) {
                PhysicalAttribute pa = paFactory.create(caseId, AttributeDataType.integerType, PhysicalAttributeRole.caseId);
                pds.addAttribute(pa);
            }
            return pds;
        }
        return null;
    }

    public OraBuildTask(OraConnection dmeConn, OraBuildTaskFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, BUILD_PROGRAM);
        this.m_taskType = MiningTask.buildTask;
        this.ARG_IX_OVERWRITE_OUTPUT = 13;
        this.ARG_IX_PARENT_TASKS = 14;
    }
}

