/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.regression;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.supervised.regression.RegressionTestTask;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraTestTask;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraRegressionTestTask
extends OraTestTask
implements RegressionTestTask {
    public OraRegressionTestTask(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory);
    }

    protected OraRegressionTestTask(OraConnection dmeConn, OraFactory factory, String modelName, String testDataName, String testMetricsName) throws JDMException {
        super(dmeConn, factory, modelName, testDataName, testMetricsName, true);
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_modelName = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_testTableName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_caseidColumnName = (String)((Object[])this.m_jobArgs.get(2))[1];
            this.m_testMetricsName = (String)((Object[])this.m_jobArgs.get(8))[1];
            this.m_testDataName = (String)((Object[])this.m_jobArgs.get(9))[1];
            this.m_testTableSchemaName = (String)((Object[])this.m_jobArgs.get(10))[1];
            if (this.m_jobArgs.size() >= 21 && this.m_jobArgs.get(20) != null) {
                this.m_testMetricsDescription = (String)((Object[])this.m_jobArgs.get(20))[1];
            }
        }
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraPhysicalDataSet testData = (OraPhysicalDataSet)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.getTestDataName(), "'", "''"), NamedObject.physicalDataSet);
        this.m_testTableName = testData.getTableName();
        this.m_testTableSchemaName = testData.getSchemaName();
        PhysicalAttribute caseIdAttr = testData.getCaseIDAttribute();
        this.m_caseidColumnName = caseIdAttr.getName();
        if (this.m_testMetricsDescription == null) {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", this.m_modelName, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", null, new Integer(12)}, new Object[]{"COMPUTE_LIFT", null, new Integer(12)}, new Object[]{"COMPUTE_ROC", null, new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", null, new Integer(12)}, new Object[]{"NUM_QUANTILES", null, new Integer(12)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", "PREDICTION", new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", "PROBABILITY", new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", null, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", null, new Integer(12)}, new Object[]{"MINING_FUNCTION", "REGRESSION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        } else {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", this.m_modelName, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", null, new Integer(12)}, new Object[]{"COMPUTE_LIFT", null, new Integer(12)}, new Object[]{"COMPUTE_ROC", null, new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", null, new Integer(12)}, new Object[]{"NUM_QUANTILES", null, new Integer(12)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", "PREDICTION", new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", "PROBABILITY", new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", null, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", null, new Integer(12)}, new Object[]{"MINING_FUNCTION", "REGRESSION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}, new Object[]{"TEST_METRICS_DESCRIPTION", this.m_testMetricsDescription, new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        }
        this.logTrace(OraStringUtils.getTestTaskCall(this.m_jobArgs), (Object[])null);
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }
}

