/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.regression;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.supervised.regression.RegressionCapability;
import javax.datamining.supervised.regression.RegressionSettings;
import javax.datamining.supervised.regression.RegressionSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.supervised.regression.OraRegressionSettings;

public class OraRegressionSettingsFactory
extends OraFactory
implements RegressionSettingsFactory {
    private static String[] supportedAlgorithms = new String[]{MiningAlgorithm.svmRegression.name()};
    private static final OraSupportedEnums supportedFeatures = new OraSupportedEnums(new Enum[0]);
    private static final OraSupportedEnums[] supportedFeaturesAlgo = new OraSupportedEnums[]{new OraSupportedEnums(new Enum[0])};

    public RegressionSettings create() throws JDMException {
        OraRegressionSettings regressionSettings = new OraRegressionSettings(this.m_dmeConn, this);
        return regressionSettings;
    }

    public boolean supportsCapability(RegressionCapability capability) {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedFeatures.isSupported((Enum)capability);
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, RegressionCapability capability) {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        int index = this.isSupported(algorithm);
        if (index == -1) {
            return false;
        }
        return supportedFeaturesAlgo[index].isSupported((Enum)capability);
    }

    private int isSupported(MiningAlgorithm algorithm) {
        for (int i = 0; i < supportedAlgorithms.length; ++i) {
            if (supportedAlgorithms[i].compareTo(algorithm.name()) != 0) continue;
            return i;
        }
        return -1;
    }
}

