/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.regression;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.supervised.regression.RegressionApplyContent;
import javax.datamining.supervised.regression.RegressionApplySettings;
import javax.datamining.supervised.regression.RegressionApplySettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.supervised.regression.OraRegressionApplySettings;

public class OraRegressionApplySettingsFactory
extends OraFactory
implements RegressionApplySettingsFactory {
    private static RegressionApplySettings s_defaultApplySettings = null;
    private static final OraSupportedEnums supportedApplyContents = new OraSupportedEnums(new Enum[]{RegressionApplyContent.predictedValue});

    public RegressionApplySettings create() throws JDMException {
        return new OraRegressionApplySettings(this.getConnection(), this);
    }

    public RegressionApplySettings getDefaultApplySettings() {
        return s_defaultApplySettings;
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, RegressionApplyContent content) {
        this.m_dmeConn.getValidationHandler().validateNotNull(content, "content");
        if (algorithm == null) {
            algorithm = MiningAlgorithm.svmRegression;
        }
        if (!algorithm.equals((Object)MiningAlgorithm.svmRegression)) {
            return false;
        }
        return supportedApplyContents.isSupported((Enum)content);
    }

    public RegressionApplyContent[] getSupportedApplyContents(MiningAlgorithm algorithm) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        if (!algorithm.equals((Object)MiningAlgorithm.svmRegression)) {
            return null;
        }
        Enum[] enums = supportedApplyContents.getSupportedEnums();
        RegressionApplyContent[] regressionApplyContentEnums = new RegressionApplyContent[enums.length];
        System.arraycopy(enums, 0, regressionApplyContentEnums, 0, enums.length);
        return regressionApplyContentEnums;
    }

    public OraRegressionApplySettingsFactory() throws JDMException {
        if (s_defaultApplySettings == null) {
            s_defaultApplySettings = new OraRegressionApplySettings(this.getConnection(), this);
        }
    }
}

