/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.regression;

import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.supervised.regression.RegressionApplyContent;
import javax.datamining.supervised.regression.RegressionApplySettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.regression.OraRegressionApplySettingsFactory;
import oracle.dmt.jdm.task.apply.OraApplySettings;

public class OraRegressionApplySettings
extends OraApplySettings
implements RegressionApplySettings {
    private static final String OP_PREDICTION = "PREDICTION";
    private static final String COLUMN_PREDICTION = "PREDICTION";
    private Double m_normShiftVal = null;
    private Double m_normScaleVal = null;
    private static final String[][] m_contentColumnMap = new String[][]{{RegressionApplyContent.predictedValue.name()}, {"PREDICTION"}};

    protected String getPredictionColName(String destAttrName) {
        String columnName = null;
        try {
            RegressionApplyContent content = this.getContent(destAttrName);
            String contentType = content.name();
            for (int i = 0; i < m_contentColumnMap[0].length; ++i) {
                if (contentType.compareTo(m_contentColumnMap[0][i]) != 0) continue;
                columnName = m_contentColumnMap[1][i];
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return columnName;
    }

    protected String[] toSQL(String modelName) throws JDMException {
        this.m_attrNames = new Vector();
        String[] sqlStats = new String[]{null, null};
        StringBuffer sqlStat = new StringBuffer("select ");
        RegressionApplyContent[] contents = this.getContents();
        String destAttrName = null;
        destAttrName = contents == null ? "PREDICTION" : this.getMappedDestinationAttributeName(contents[0]);
        this.m_attrMapping = 1;
        sqlStat.append("PREDICTION").append("(").append(modelName);
        sqlStat.append(" USING *) as ").append(destAttrName);
        this.m_attrNames.add(destAttrName);
        sqlStats[0] = sqlStat.toString();
        return sqlStats;
    }

    protected OraRegressionApplySettings(OraConnection dmeConn, OraRegressionApplySettingsFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, MiningFunction.regression);
    }

    public void map(RegressionApplyContent content, String destPhysAttrName) throws JDMException {
        this.getValidationHandler().validateNotNull(content, "content");
        if (!content.equals((Object)RegressionApplyContent.predictedValue)) {
            this.unsupported("RegressionApplyContent." + RegressionApplyContent.confidence.name());
        }
        super.mapTopPrediction((Enum)content, destPhysAttrName);
    }

    public RegressionApplyContent getContent(String destinationAttrName) throws JDMException {
        return (RegressionApplyContent)super.getContentEnum(destinationAttrName);
    }

    public RegressionApplyContent[] getContents() {
        Object[] objs = super.getMappedContentsEnums();
        RegressionApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new RegressionApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    public void setTargetNormalizationDetails(Double shiftValue, Double scaleValue) {
        this.m_normShiftVal = shiftValue;
        this.m_normScaleVal = scaleValue;
    }

    public Double getTargetNormalizationShiftValue() {
        return this.m_normShiftVal;
    }

    public Double getTargetNormalizationScaleValue() {
        return this.m_normScaleVal;
    }

    public String getMappedDestinationAttributeName(RegressionApplyContent content) {
        String attrName = null;
        try {
            attrName = super.getMappedDestinationAttrName((Enum)content);
        }
        catch (JDMException jdmExp) {
            System.out.println("OraRegressionApplySettings: JDMException thrown from getMappedDestinationAttributeName()");
            jdmExp.printStackTrace();
        }
        return attrName;
    }
}

