/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.util.HashMap;
import javax.datamining.JDMException;
import javax.datamining.supervised.classification.ReceiverOperatingCharacterics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraReceiverOperatingCharactericsDetail;

public class OraReceiverOperatingCharacterics
extends OraDMObject
implements ReceiverOperatingCharacterics {
    protected HashMap m_rocPair = new HashMap();
    protected Double m_area_under_curve = null;
    private int m_numThresholdCandidates = 0;

    OraReceiverOperatingCharacterics(OraConnection dmeConn, Double area_under_curve) {
        super(dmeConn, null);
        this.m_area_under_curve = area_under_curve;
    }

    protected void addEntry(String key, Object[] value) {
        OraReceiverOperatingCharactericsDetail rocDetail = new OraReceiverOperatingCharactericsDetail(Double.valueOf(value[0].toString()), Double.valueOf(value[1].toString()), Double.valueOf(value[2].toString()), Double.valueOf(value[3].toString()), Double.valueOf(value[4].toString()), Double.valueOf(value[5].toString()), Double.valueOf(value[6].toString()));
        this.setValue(key, rocDetail);
    }

    protected void setValue(String key, Object value) {
        this.m_rocPair.put(key, value);
    }

    protected Object getObjectValue(String key) {
        if (!this.m_rocPair.containsKey(key)) {
            return null;
        }
        return this.m_rocPair.get(key);
    }

    protected String getValue(String key) {
        return (String)this.getObjectValue(key);
    }

    void setNumberOfThresholdCandidates(int numThresholdCandidates) {
        this.m_numThresholdCandidates = numThresholdCandidates;
    }

    public double getAreaUnderCurve() {
        if (this.m_area_under_curve != null) {
            return this.m_area_under_curve;
        }
        return 0.0;
    }

    public int getNumberOfThresholdCandidates() {
        if (this.m_numThresholdCandidates == 0 && this.m_rocPair != null) {
            this.m_numThresholdCandidates = this.m_rocPair.size();
        }
        return this.m_numThresholdCandidates;
    }

    public double getProbabilityThreshold(int index) throws JDMException {
        double probabilityThreshold = 0.0;
        if (this.m_rocPair != null) {
            OraReceiverOperatingCharactericsDetail rocDetail = (OraReceiverOperatingCharactericsDetail)this.getObjectValue(index + "");
            probabilityThreshold = rocDetail.m_probability;
        }
        return probabilityThreshold;
    }

    public long getPositives(int index, boolean trueFalse) throws JDMException {
        long positives = 0L;
        if (this.m_rocPair != null) {
            OraReceiverOperatingCharactericsDetail rocDetail = (OraReceiverOperatingCharactericsDetail)this.getObjectValue(index + "");
            positives = trueFalse ? rocDetail.m_truePositives.longValue() : rocDetail.m_falsePositives.longValue();
        }
        return positives;
    }

    public long getNegatives(int index, boolean trueFalse) throws JDMException {
        long negatives = 0L;
        if (this.m_rocPair != null) {
            OraReceiverOperatingCharactericsDetail rocDetail = (OraReceiverOperatingCharactericsDetail)this.getObjectValue(index + "");
            negatives = trueFalse ? rocDetail.m_trueNegatives.longValue() : rocDetail.m_falseNegatives.longValue();
        }
        return negatives;
    }

    public double getHitRate(int index) throws JDMException {
        double hitRate = 0.0;
        if (this.m_rocPair != null) {
            OraReceiverOperatingCharactericsDetail rocDetail = (OraReceiverOperatingCharactericsDetail)this.getObjectValue(index + "");
            hitRate = rocDetail.m_truePositivesFraction;
        }
        return hitRate;
    }

    public double getFalseAlarmRate(int index) throws JDMException {
        double falseAlarmRate = 0.0;
        if (this.m_rocPair != null) {
            OraReceiverOperatingCharactericsDetail rocDetail = (OraReceiverOperatingCharactericsDetail)this.getObjectValue(index + "");
            falseAlarmRate = rocDetail.m_falsePositivesFraction;
        }
        return falseAlarmRate;
    }
}

