/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.math.BigDecimal;
import java.util.HashMap;
import javax.datamining.JDMException;
import javax.datamining.supervised.classification.Lift;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraLiftDetail;

public class OraLift
extends OraDMObject
implements Lift {
    protected HashMap m_liftPair = new HashMap();
    private int m_numberOfQuantiles = 0;
    private double m_totalCases = 0.0;
    private double m_totalPositiveCases = 0.0;
    private String m_targetAttrName = null;
    private Object m_positiveTargetValue = null;
    private boolean m_arraysInitialized = false;
    private double[] m_lifts = null;
    private double[] m_cases = null;
    private double[] m_positiveCases = null;
    private double[] m_negativeCases = null;
    private double[] m_percentageCases = null;
    private double[] m_targetDensities = null;
    private double[] m_probabilityOrCostThresholds = null;
    private double[] m_gains = null;
    private double[] m_liftCumulative = null;
    private double[] m_gainCumulative = null;
    private double[] m_targetDensityCumulative = null;

    OraLift(OraConnection dmeConn) {
        super(dmeConn, null);
    }

    protected void addEntry(String key, BigDecimal[] value) {
        if (!this.m_arraysInitialized) {
            this.m_lifts = new double[this.m_numberOfQuantiles];
            this.m_cases = new double[this.m_numberOfQuantiles];
            this.m_positiveCases = new double[this.m_numberOfQuantiles];
            this.m_negativeCases = new double[this.m_numberOfQuantiles];
            this.m_percentageCases = new double[this.m_numberOfQuantiles];
            this.m_targetDensities = new double[this.m_numberOfQuantiles];
            this.m_probabilityOrCostThresholds = new double[this.m_numberOfQuantiles];
            this.m_gainCumulative = new double[this.m_numberOfQuantiles];
            this.m_liftCumulative = new double[this.m_numberOfQuantiles];
            this.m_targetDensityCumulative = new double[this.m_numberOfQuantiles];
            this.m_arraysInitialized = true;
        }
        OraLiftDetail liftDetail = new OraLiftDetail(value[0], value[1], value[2], value[3], value[4], value[5], value[6], value[7], value[8], value[9], value[10], value[11]);
        this.setValue(key, liftDetail);
        int currentQuantile = value[0].intValue() - 1;
        this.m_cases[currentQuantile] = value[1].doubleValue();
        this.m_positiveCases[currentQuantile] = value[2].doubleValue();
        this.m_negativeCases[currentQuantile] = this.m_cases[currentQuantile] - this.m_positiveCases[currentQuantile];
        this.m_percentageCases[currentQuantile] = this.m_cases[currentQuantile] / this.m_totalCases * 100.0;
        this.m_targetDensities[currentQuantile] = value[9].doubleValue();
        this.m_lifts[currentQuantile] = value[8].doubleValue();
        this.m_probabilityOrCostThresholds[currentQuantile] = value[10].doubleValue();
        this.m_gainCumulative[currentQuantile] = value[11].doubleValue();
        this.m_targetDensityCumulative[currentQuantile] = value[5].doubleValue();
        this.m_liftCumulative[currentQuantile] = value[4].doubleValue();
    }

    protected void setValue(String key, Object value) {
        this.m_liftPair.put(key, value);
    }

    protected Object getObjectValue(String key) {
        if (!this.m_liftPair.containsKey(key)) {
            return null;
        }
        return this.m_liftPair.get(key);
    }

    protected String getValue(String key) {
        return (String)this.getObjectValue(key);
    }

    void setNumberOfQuantiles(int numQuantiles) {
        this.m_numberOfQuantiles = numQuantiles;
    }

    void setTotalCases(int totalCases) {
        this.m_totalCases = totalCases;
    }

    void setTotalPositiveCases(int totalPositiveCases) {
        this.m_totalPositiveCases = totalPositiveCases;
    }

    void setTargetAttributeName(String targetAttrName) {
        this.m_targetAttrName = targetAttrName;
    }

    void setPositiveTargetValue(Object positiveTargetValue) {
        this.m_positiveTargetValue = positiveTargetValue;
    }

    public Double getLift(int lowerIndex, int upperIndex) throws JDMException {
        Double lift = null;
        if (this.m_liftPair != null) {
            double liftDouble = 0.0;
            if (lowerIndex > 0 & upperIndex >= lowerIndex) {
                if (lowerIndex == 1) {
                    liftDouble = this.getCumulativeLift(upperIndex);
                } else if (lowerIndex > 1) {
                    liftDouble = this.getCumulativeLift(lowerIndex - 1) - this.getCumulativeLift(upperIndex);
                }
            }
            lift = Double.valueOf(liftDouble + "");
        }
        return lift;
    }

    public Double getCumulativeLift(int index) throws JDMException {
        Double cumulativeLift = null;
        if (this.m_liftPair != null) {
            OraLiftDetail liftDetail = (OraLiftDetail)this.getObjectValue(index + "");
            cumulativeLift = new Double(liftDetail.m_liftCumulative.doubleValue());
        }
        return cumulativeLift;
    }

    public long getCases(int lowerIndex, int upperIndex) throws JDMException {
        double cases = 0.0;
        if (this.m_liftPair != null) {
            for (OraLiftDetail liftDetail : this.m_liftPair.values()) {
                if (!(liftDetail.m_quantileNumber.intValue() >= lowerIndex & liftDetail.m_quantileNumber.intValue() <= upperIndex)) continue;
                cases += liftDetail.m_quantileTotalCount.doubleValue();
            }
        }
        return (long)cases;
    }

    public long getCumulativeCases(int index) throws JDMException {
        long cumulativeCases = 0L;
        cumulativeCases = this.getCases(1, index);
        return cumulativeCases;
    }

    public long getNumberOfPositiveCases(int lowerIndex, int upperIndex) throws JDMException {
        double numberOfPositiveCases = 0.0;
        if (this.m_liftPair != null) {
            for (OraLiftDetail liftDetail : this.m_liftPair.values()) {
                if (!(liftDetail.m_quantileNumber.intValue() >= lowerIndex & liftDetail.m_quantileNumber.intValue() <= upperIndex)) continue;
                numberOfPositiveCases += liftDetail.m_quantileTargetCount.doubleValue();
            }
        }
        return (long)numberOfPositiveCases;
    }

    public long getCumulativePositiveCases(int index) throws JDMException {
        double cumulativePositiveCases = 0.0;
        if (this.m_liftPair != null) {
            OraLiftDetail liftDetail = (OraLiftDetail)this.getObjectValue(index + "");
            cumulativePositiveCases = liftDetail.m_targetsCumulative.doubleValue();
        }
        return (long)cumulativePositiveCases;
    }

    public long getNumberOfNegativeCases(int lowerIndex, int upperIndex) throws JDMException {
        double numberOfNegativeCases = 0.0;
        if (this.m_liftPair != null) {
            for (OraLiftDetail liftDetail : this.m_liftPair.values()) {
                if (!(liftDetail.m_quantileNumber.intValue() >= lowerIndex & liftDetail.m_quantileNumber.intValue() <= upperIndex)) continue;
                numberOfNegativeCases += liftDetail.m_quantileTotalCount.doubleValue() - liftDetail.m_quantileTargetCount.doubleValue();
            }
        }
        return (long)numberOfNegativeCases;
    }

    public long getCumulativeNegativeCases(int index) throws JDMException {
        long cumulativeNegativeCases = 0L;
        if (this.m_liftPair != null) {
            OraLiftDetail liftDetail = (OraLiftDetail)this.getObjectValue(index + "");
            cumulativeNegativeCases = liftDetail.m_nontargetsCumulative.longValue();
        }
        return cumulativeNegativeCases;
    }

    public Double getPercentageSize(int lowerIndex, int upperIndex) throws JDMException {
        Double percentageSize = null;
        if (this.m_liftPair != null) {
            double percentageSizeDouble = 0.0;
            long rangeCases = this.getCases(lowerIndex, upperIndex);
            long totalCases = this.getCases(1, this.m_liftPair.size());
            if (totalCases > 0L) {
                percentageSizeDouble = rangeCases / totalCases * 100L;
            }
            percentageSize = Double.valueOf(percentageSizeDouble + "");
        }
        return percentageSize;
    }

    public Double getCumulativePercentageSize(int index) throws JDMException {
        Double cumulativePercentageSize = null;
        if (this.m_liftPair != null) {
            OraLiftDetail liftDetail = (OraLiftDetail)this.getObjectValue(index + "");
            cumulativePercentageSize = new Double(liftDetail.m_percentageRecordsCumulative.doubleValue());
        }
        return cumulativePercentageSize;
    }

    public Double getTargetDensity(int lowerIndex, int upperIndex) throws JDMException {
        Double targetDensity = null;
        if (this.m_liftPair != null) {
            double targetDensityDouble = 0.0;
            if (lowerIndex > 0 & upperIndex >= lowerIndex) {
                if (lowerIndex == 1) {
                    targetDensityDouble = this.getCumulativeTargetDensity(upperIndex);
                } else if (lowerIndex > 1) {
                    targetDensityDouble = this.getCumulativeTargetDensity(lowerIndex - 1) - this.getCumulativeTargetDensity(upperIndex);
                }
            }
            targetDensity = Double.valueOf(targetDensityDouble + "");
        }
        return targetDensity;
    }

    public Double getCumulativeTargetDensity(int index) throws JDMException {
        Double cumulativeTargetDensity = null;
        if (this.m_liftPair != null) {
            OraLiftDetail liftDetail = (OraLiftDetail)this.getObjectValue(index + "");
            cumulativeTargetDensity = new Double(liftDetail.m_targetDensityCumulative.doubleValue());
        }
        return cumulativeTargetDensity;
    }

    public int getNumberOfQuantiles() {
        if (this.m_numberOfQuantiles == 0 && this.m_liftPair != null) {
            this.m_numberOfQuantiles = this.m_liftPair.size();
        }
        return this.m_numberOfQuantiles;
    }

    public long getTotalCases() {
        if (this.m_totalCases == 0.0 && this.m_liftPair != null) {
            for (OraLiftDetail liftDetail : this.m_liftPair.values()) {
                this.m_totalCases += liftDetail.m_quantileTotalCount.doubleValue();
            }
        }
        return (long)this.m_totalCases;
    }

    public long getTotalPositiveCases() {
        if (this.m_totalPositiveCases == 0.0 && this.m_liftPair != null) {
            for (OraLiftDetail liftDetail : this.m_liftPair.values()) {
                this.m_totalPositiveCases += liftDetail.m_quantileTargetCount.doubleValue();
            }
        }
        return (long)this.m_totalPositiveCases;
    }

    public String getTargetAttributeName() {
        return this.m_targetAttrName;
    }

    public Object getPositiveTargetValue() {
        return this.m_positiveTargetValue;
    }

    public double[] getLift() {
        return this.m_lifts;
    }

    public double[] getCumulativeLift() {
        return this.m_liftCumulative;
    }

    public double[] getCases() {
        return this.m_cases;
    }

    public double[] getNumberOfPositiveCases() {
        return this.m_positiveCases;
    }

    public double[] getNumberOfNegativeCases() {
        return this.m_negativeCases;
    }

    public double[] getPercentageSize() {
        return this.m_percentageCases;
    }

    public double[] getTargetDensity() {
        return this.m_targetDensities;
    }

    public double[] getCumulativeTargetDensity() {
        return this.m_targetDensityCumulative;
    }

    public double[] getProbabilityOrCostThreshold() {
        return this.m_probabilityOrCostThresholds;
    }

    public double[] getCumulativeGain() {
        return this.m_gainCumulative;
    }
}

