/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryMatrix;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.data.OraCategorySetFactory;
import oracle.dmt.jdm.data.OraPhysicalAttribute;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.data.OraPhysicalDataSetFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.supervised.classification.OraCostMatrixFactory;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraCostMatrix
extends OraMiningObject
implements CategoryMatrix,
CostMatrix {
    private HashMap m_rowMap = new HashMap();
    private HashMap m_costMap = new HashMap();
    private HashSet m_targetSet = new HashSet();
    private boolean m_indexTypeString = true;
    private CategorySet m_categorySet = null;
    protected static final String CM_COMMENTS_PREFIX = "CM_";

    OraCostMatrix(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, NamedObject.costMatrix);
    }

    void setCategorySet(CategorySet categorySet) {
        this.m_categorySet = categorySet;
    }

    public boolean isInputObject() {
        return true;
    }

    public void setValue(Object actualTarget, Object predictedTarget, double cost) throws JDMException {
        Vector colList;
        boolean isNewPredicted;
        OraValidationHandler v = this.getValidationHandler();
        v.validateNotNull(actualTarget, "actualTarget");
        v.validateNotNull(predictedTarget, "predictedTarget");
        if (this.m_categorySet != null) {
            int i;
            Object[] values = this.m_categorySet.getValues();
            boolean found = false;
            for (i = 0; !found && i < values.length; ++i) {
                found = values[i].equals(actualTarget);
            }
            if (!found) {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"actualTarget", "CategorySet", ""}, null);
            }
            found = false;
            for (i = 0; !found && i < values.length; ++i) {
                found = values[i].equals(predictedTarget);
            }
            if (!found) {
                this.createException(OraJDMBundleKeys.JDM_ENTRY_NOT_FOUND, new String[]{"predictedTarget", "CategorySet", ""}, null);
            }
        }
        if (this.m_rowMap.size() == 0) {
            this.m_indexTypeString = actualTarget instanceof String;
        }
        this.m_targetSet.add(actualTarget);
        this.m_targetSet.add(predictedTarget);
        if (!this.m_rowMap.containsKey(actualTarget)) {
            this.m_rowMap.put(actualTarget, new Vector());
            this.m_costMap.put(actualTarget, new Vector());
        }
        boolean bl = isNewPredicted = !(colList = (Vector)this.m_rowMap.get(actualTarget)).contains(predictedTarget);
        if (isNewPredicted) {
            colList.addElement(predictedTarget);
            this.m_rowMap.put(actualTarget, colList);
        }
        int index = colList.indexOf(predictedTarget);
        Vector costList = (Vector)this.m_costMap.get(actualTarget);
        if (isNewPredicted) {
            costList.addElement(new Double(cost));
        } else {
            costList.setElementAt(new Double(cost), index);
        }
    }

    public void setCellValue(Object actualTarget, Object predictedTarget, double cost) throws JDMException {
        this.setValue(actualTarget, predictedTarget, cost);
    }

    public double getCellValue(Object actualTarget, Object predictedTarget) throws JDMException {
        Double costVal = this.getValue(actualTarget, predictedTarget);
        if (costVal == null) {
            return 0.0;
        }
        return costVal;
    }

    public Collection getCategories() {
        return this.m_targetSet;
    }

    public Double getValue(Object rowCategoryValue, Object columnCategoryValue) throws JDMException {
        OraValidationHandler v = this.getValidationHandler();
        v.validateNotNull(rowCategoryValue, "rowCategoryValue");
        v.validateNotNull(columnCategoryValue, "columnCategoryValue");
        Object local_columnCategoryValue = null;
        Object local_rowCategoryValue = null;
        if (columnCategoryValue instanceof Number && rowCategoryValue instanceof Number) {
            local_columnCategoryValue = new Double(((Number)columnCategoryValue).doubleValue());
            local_rowCategoryValue = new Double(((Number)rowCategoryValue).doubleValue());
        } else {
            local_columnCategoryValue = columnCategoryValue;
            local_rowCategoryValue = rowCategoryValue;
        }
        Vector colList = (Vector)this.m_rowMap.get(local_rowCategoryValue);
        if (colList == null && (colList = (Vector)this.m_rowMap.get(rowCategoryValue)) == null) {
            return null;
        }
        int predictedIndex = colList.indexOf(local_columnCategoryValue);
        if (predictedIndex == -1 && (predictedIndex = colList.indexOf(columnCategoryValue)) == -1) {
            return null;
        }
        Vector costList = (Vector)this.m_costMap.get(local_rowCategoryValue);
        if (costList == null && (costList = (Vector)this.m_costMap.get(rowCategoryValue)) == null) {
            return null;
        }
        return (Double)costList.get(predictedIndex);
    }

    public CategorySet getCategorySet() {
        return this.m_categorySet;
    }

    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        if (dmeConn != null) {
            OraValidationHandler v = dmeConn.getValidationHandler();
            v.validateObjectName(oldName, "oldName", NamedObject.costMatrix);
            v.validateObjectName(newName, "newName", NamedObject.costMatrix);
            OraSQLUtils.renameTable(dmeConn.getDatabaseConnection(), oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean cmExist = dmeConn.doesObjectExist(name, NamedObject.costMatrix);
        if (!cmExist) {
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{"CostMatrix", name}, null);
        }
        Statement pStmt = null;
        try {
            pStmt = dbConn.prepareStatement("DROP TABLE " + name);
            pStmt.execute();
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, java.util.Date createdAfter, java.util.Date createdBefore) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT C.COMMENTS, T.TABLE_NAME from ALL_TABLES T, ALL_TAB_COMMENTS C WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like 'CM_%'";
        PreparedStatement ps = null;
        ResultSet rs = null;
        String description = null;
        String objectName = null;
        Vector<OraCostMatrix> returnedObjects = new Vector<OraCostMatrix>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                description = rs.getString("COMMENTS");
                objectName = rs.getString("TABLE_NAME");
                OraCostMatrix object = null;
                try {
                    object = OraCostMatrix.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraCostMatrix retrieveObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean bsExist = dmeConn.doesObjectExist(name, NamedObject.costMatrix);
        OraCostMatrix costMatrix = null;
        if (bsExist) {
            String sqlSpec = "SELECT * FROM " + name;
            Statement ps1 = null;
            PreparedStatement ps2 = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            try {
                OraCostMatrixFactory cmFactory = (OraCostMatrixFactory)dmeConn.getFactory("javax.datamining.supervised.classification.CostMatrix");
                costMatrix = new OraCostMatrix(dmeConn, cmFactory);
                OraCategorySet categorySet = null;
                AttributeDataType categoryType = null;
                try {
                    OraPhysicalDataSetFactory pdsFactory = (OraPhysicalDataSetFactory)dmeConn.getFactory("javax.datamining.data.PhysicalDataSet");
                    OraPhysicalDataSet pds = (OraPhysicalDataSet)pdsFactory.create(name, true);
                    OraPhysicalAttribute pa = (OraPhysicalAttribute)pds.getAttribute("ACTUAL_TARGET_VALUE");
                    if (pa == null) {
                        dmeConn.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, null);
                    }
                    OraCategorySetFactory csFactory = (OraCategorySetFactory)dmeConn.getFactory("javax.datamining.data.CategorySet");
                    categoryType = pa.getDataType();
                    categorySet = (OraCategorySet)csFactory.create(categoryType);
                }
                catch (JDMException jdmExp) {
                    dmeConn.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, null);
                }
                ps1 = dbConn.prepareStatement(sqlSpec);
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    Object predictedCol;
                    Object actualCol;
                    if (categoryType.equals((Object)AttributeDataType.integerType)) {
                        actualCol = new Integer(rs1.getInt("ACTUAL_TARGET_VALUE"));
                        predictedCol = new Integer(rs1.getString("PREDICTED_TARGET_VALUE"));
                    } else if (categoryType.equals((Object)AttributeDataType.doubleType)) {
                        actualCol = new Double(rs1.getDouble("ACTUAL_TARGET_VALUE"));
                        predictedCol = new Double(rs1.getDouble("PREDICTED_TARGET_VALUE"));
                    } else {
                        actualCol = rs1.getString("ACTUAL_TARGET_VALUE");
                        predictedCol = rs1.getString("PREDICTED_TARGET_VALUE");
                    }
                    double cost = rs1.getDouble("COST");
                    costMatrix.setValue(actualCol, predictedCol, cost);
                    Object[] values = categorySet.getValues();
                    boolean actualFound = false;
                    boolean predictedFound = false;
                    if (values != null) {
                        int i;
                        for (i = 0; !actualFound && i < values.length; ++i) {
                            actualFound = values[i].equals(actualCol);
                        }
                        for (i = 0; !predictedFound && i < values.length; ++i) {
                            predictedFound = values[i].equals(predictedCol);
                        }
                    }
                    if (!actualFound) {
                        categorySet.addCategory(actualCol, CategoryProperty.valid);
                    }
                    if (predictedFound) continue;
                    categorySet.addCategory(predictedCol, CategoryProperty.valid);
                }
                costMatrix.setCategorySet(categorySet);
                String cleanName = OraStringUtils.processQuotedName(name);
                sqlSpec = "SELECT O.CREATED, O.OWNER,  C.COMMENTS, O.OBJECT_NAME from ALL_OBJECTS O, ALL_TAB_COMMENTS C WHERE (O.OBJECT_TYPE='TABLE' OR O.OBJECT_TYPE='VIEW') AND C.TABLE_NAME = O.OBJECT_NAME AND O.OBJECT_NAME = '" + cleanName + "'";
                Date creationDate = null;
                String creatorInfo = null;
                String description = null;
                String objectName = null;
                try {
                    ps2 = dbConn.prepareStatement(sqlSpec);
                    rs2 = ps2.executeQuery();
                    if (rs2.next()) {
                        creationDate = rs2.getDate("CREATED");
                        creatorInfo = rs2.getString("OWNER");
                        description = rs2.getString("COMMENTS");
                        objectName = rs2.getString("OBJECT_NAME");
                    }
                }
                catch (SQLException sqlExp) {
                    dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, "3502", null);
                }
                finally {
                    try {
                        if (rs2 != null) {
                            rs2.close();
                        }
                    }
                    catch (Exception e1) {}
                    try {
                        if (ps2 != null) {
                            ps2.close();
                        }
                    }
                    catch (Exception e2) {}
                }
                costMatrix.setCreationDate(creationDate);
                costMatrix.setCreatorInfo(creatorInfo);
                costMatrix.setDescription(description);
                costMatrix.setName(objectName);
            }
            catch (SQLException sqlExp) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
            }
            finally {
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                catch (Exception e2) {}
            }
        } else {
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
        }
        return costMatrix;
    }

    public static OraCostMatrix retrieveObjectFromDatabaseByID(OraConnection dmeConn, String identifier) throws JDMException, SQLException {
        return null;
    }

    protected void createCostMatrixTable(Connection dmeConn, String tableName) throws JDMException {
        java.sql.Connection dbConn = this.getDatabaseConnection();
        try {
            if (OraSQLUtils.doesTableOrViewExists(dbConn, tableName)) {
                // empty if block
            }
            String tableSpec = "CREATE TABLE " + tableName + " (ACTUAL_TARGET_VALUE NUMBER, PREDICTED_TARGET_VALUE NUMBER, COST NUMBER)";
            if (this.m_indexTypeString) {
                tableSpec = "CREATE TABLE " + tableName + " (ACTUAL_TARGET_VALUE VARCHAR2(4000), PREDICTED_TARGET_VALUE VARCHAR2(4000), COST NUMBER)";
            }
            String comments = CM_COMMENTS_PREFIX + NamedObject.costMatrix.name();
            String description = this.getDescription();
            if (description != null) {
                comments = comments + ";Description:" + description;
            }
            OraSQLUtils.createTable(dbConn, tableName, tableSpec, comments);
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraCostMatrix.createCostMatrixTable: ", sqlExp);
            super.getConnection().createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp);
        }
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
        this.storeCostMatrix(dmeConn, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeCostMatrix(Connection dmeConn, String tableName) throws JDMException {
        this.createCostMatrixTable(dmeConn, tableName);
        java.sql.Connection dbConn = ((OraConnection)dmeConn).getDatabaseConnection();
        String sqlSpec = "INSERT INTO " + tableName + " (ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, COST) VALUES (?,?,?)";
        Set keySet = this.m_rowMap.keySet();
        Iterator iKey = keySet.iterator();
        boolean autoCommitFlag = false;
        try {
            autoCommitFlag = dbConn.getAutoCommit();
            dbConn.setAutoCommit(false);
            PreparedStatement ps = dbConn.prepareStatement(sqlSpec);
            while (iKey.hasNext()) {
                Object rowValue = iKey.next();
                Vector colList = (Vector)this.m_rowMap.get(rowValue);
                Vector costList = (Vector)this.m_costMap.get(rowValue);
                for (int j = 0; j < colList.size(); ++j) {
                    Object colValue = colList.elementAt(j);
                    if (rowValue instanceof String) {
                        ps.setString(1, (String)rowValue);
                        ps.setString(2, (String)colValue);
                    } else if (rowValue instanceof Integer) {
                        ps.setInt(1, (Integer)rowValue);
                        ps.setInt(2, (Integer)colValue);
                    } else if (rowValue instanceof Double) {
                        ps.setDouble(1, (Double)rowValue);
                        ps.setDouble(2, (Double)colValue);
                    }
                    ps.setDouble(3, (Double)costList.get(j));
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            dbConn.commit();
        }
        catch (SQLException sqlExp) {
            try {
                dbConn.rollback();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            super.getConnection().createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp);
        }
        finally {
            try {
                dbConn.setAutoCommit(autoCommitFlag);
            }
            catch (SQLException ignore) {}
        }
    }

    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        return OraSQLUtils.doesTableOrViewExists(dbConn, name);
    }
}

