/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.supervised.classification.ClassificationTestMetricOption;
import javax.datamining.supervised.classification.ClassificationTestTask;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraTestTask;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraClassificationTestTask
extends OraTestTask
implements ClassificationTestTask {
    protected int m_numberOfQuantiles = 10;
    protected boolean m_computeCFM = true;
    protected boolean m_computeLift = true;
    protected boolean m_computeROC = true;
    protected Object m_positiveTargetValue = null;
    private boolean isTargetNumber;
    protected String m_costMatrixName = null;

    public void setNumberOfLiftQuantiles(int numberOfQuantiles) {
        if (numberOfQuantiles <= 1) {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"numberOfQuantiles"}, null, "3511", new String[]{"numberOfQuantiles"});
        }
        this.m_numberOfQuantiles = numberOfQuantiles;
    }

    public void computeMetric(ClassificationTestMetricOption testMetric, boolean flag) {
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            this.m_computeCFM = flag;
        } else if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            this.m_computeLift = flag;
        } else if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            this.m_computeROC = flag;
        }
    }

    public boolean computeMetric(ClassificationTestMetricOption testMetric) {
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            return this.m_computeCFM;
        }
        if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            return this.m_computeLift;
        }
        if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            return this.m_computeROC;
        }
        return false;
    }

    public int getNumberOfLiftQuantiles() {
        return this.m_numberOfQuantiles;
    }

    public Object getPositiveTargetValue() {
        return this.m_positiveTargetValue;
    }

    public void setPositiveTargetValue(Object positiveTargetValue) {
        this.getConnection().getValidationHandler().validateNotNull(positiveTargetValue, "positiveTargetValue");
        if (positiveTargetValue instanceof Number) {
            this.isTargetNumber = true;
        } else if (positiveTargetValue instanceof String) {
            this.isTargetNumber = false;
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"positiveTargetValue"}, null, "3507", new String[]{"positiveTargetValue", AttributeDataType.integerType.name() + "," + AttributeDataType.stringType.name()});
        }
        this.m_positiveTargetValue = positiveTargetValue;
    }

    public void setCostMatrixName(String costMatrixName) {
        if (costMatrixName == null) {
            this.m_costMatrixName = costMatrixName;
            if (this.m_modelName != null) {
                this.m_useModelCostMatrix = true;
            }
        } else {
            this.getConnection().getValidationHandler().validateObjectName(costMatrixName, "costMatrixName", NamedObject.costMatrix);
            this.m_costMatrixName = costMatrixName;
            this.m_useModelCostMatrix = true;
        }
    }

    public String getCostMatrixName() {
        return this.m_costMatrixName;
    }

    public OraClassificationTestTask(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory);
        this.m_useModelCostMatrix = true;
    }

    protected OraClassificationTestTask(OraConnection dmeConn, OraFactory factory, String modelName, String testDataName, String testMetricsName, boolean modelNotNull) throws JDMException {
        super(dmeConn, factory, modelName, testDataName, testMetricsName, modelNotNull);
        this.m_useModelCostMatrix = true;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraPhysicalDataSet testData = (OraPhysicalDataSet)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.getTestDataName(), "'", "''"), NamedObject.physicalDataSet);
        this.m_testTableName = testData.getTableName();
        this.m_testTableSchemaName = testData.getSchemaName();
        PhysicalAttribute caseIdAttr = testData.getCaseIDAttribute();
        this.m_caseidColumnName = caseIdAttr.getName();
        String costMatrixTableName = null;
        String costMatrixSchemaName = null;
        if (this.m_costMatrixName != null) {
            OraDataURI cmURI = new OraDataURI(this.m_costMatrixName);
            costMatrixTableName = cmURI.getTableName();
            costMatrixSchemaName = cmURI.getSchemaName();
        }
        if (this.m_testMetricsDescription == null) {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", this.m_modelName, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", this.m_computeCFM ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_LIFT", this.m_computeLift ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_ROC", this.m_computeROC ? "Y" : "N", new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", this.m_positiveTargetValue == null ? null : this.m_positiveTargetValue.toString(), new Integer(12)}, new Object[]{"NUM_QUANTILES", new Integer(this.m_numberOfQuantiles), new Integer(4)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", "PREDICTION", new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", "PROBABILITY", new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", costMatrixTableName, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", costMatrixSchemaName, new Integer(12)}, new Object[]{"ACTUAL_TARGET_COLUMN_NAME", null, new Integer(12)}, new Object[]{"MINING_FUNCTION", "CLASSIFICATION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        } else {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", this.m_modelName, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", this.m_computeCFM ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_LIFT", this.m_computeLift ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_ROC", this.m_computeROC ? "Y" : "N", new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", this.m_positiveTargetValue == null ? null : this.m_positiveTargetValue.toString(), new Integer(12)}, new Object[]{"NUM_QUANTILES", new Integer(this.m_numberOfQuantiles), new Integer(4)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", "PREDICTION", new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", "PROBABILITY", new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", costMatrixTableName, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", costMatrixSchemaName, new Integer(12)}, new Object[]{"ACTUAL_TARGET_COLUMN_NAME", null, new Integer(12)}, new Object[]{"MINING_FUNCTION", "CLASSIFICATION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}, new Object[]{"TEST_METRICS_DESCRIPTION", this.m_testMetricsDescription, new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        }
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            Object[] objs;
            this.m_modelName = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_testTableName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_caseidColumnName = (String)((Object[])this.m_jobArgs.get(2))[1];
            this.m_computeCFM = ((String)((Object[])this.m_jobArgs.get(3))[1]).equals("Y");
            if (this.m_computeCFM) {
                this.m_cfmTableName = (String)((Object[])this.m_jobArgs.get(17))[1];
            }
            this.m_computeLift = ((String)((Object[])this.m_jobArgs.get(4))[1]).equals("Y");
            if (this.m_computeLift) {
                this.m_lftTableName = (String)((Object[])this.m_jobArgs.get(18))[1];
            }
            this.m_computeROC = ((String)((Object[])this.m_jobArgs.get(5))[1]).equals("Y");
            if (this.m_computeROC) {
                this.m_rocTableName = (String)((Object[])this.m_jobArgs.get(19))[1];
            }
            this.m_positiveTargetValue = (String)((Object[])this.m_jobArgs.get(6))[1];
            Number quantiles = (Number)((Object[])this.m_jobArgs.get(7))[1];
            if (quantiles != null) {
                this.m_numberOfQuantiles = quantiles.intValue();
            }
            this.m_testMetricsName = (String)((Object[])this.m_jobArgs.get(8))[1];
            this.m_testDataName = (String)((Object[])this.m_jobArgs.get(9))[1];
            this.m_testTableSchemaName = (String)((Object[])this.m_jobArgs.get(10))[1];
            String costMatrixTableName = null;
            String costMatrixSchemaName = null;
            costMatrixTableName = (String)((Object[])this.m_jobArgs.get(13))[1];
            costMatrixSchemaName = (String)((Object[])this.m_jobArgs.get(14))[1];
            if (costMatrixTableName != null) {
                OraDataURI cmURI = new OraDataURI(costMatrixTableName, costMatrixSchemaName);
                this.m_costMatrixName = cmURI.getURI();
            }
            if (this.m_jobArgs.size() >= 21 && (objs = (Object[])this.m_jobArgs.get(20)) != null && objs.length >= 2) {
                this.m_testMetricsDescription = (String)objs[1];
            }
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }

    public void setTableName(ClassificationTestMetricOption testMetric, String tableName) {
        this.getConnection().getValidationHandler().validateNotNull(testMetric, "testMetric");
        this.getConnection().getValidationHandler().validateObjectName(tableName, "testMetric", NamedObject.testMetrics);
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            this.m_cfmTableName = tableName;
        } else if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            this.m_lftTableName = tableName;
        } else if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            this.m_rocTableName = tableName;
        }
    }

    public String getTableName(ClassificationTestMetricOption testMetric) {
        this.getConnection().getValidationHandler().validateNotNull(testMetric, "testMetric");
        String tableName = null;
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            tableName = this.m_cfmTableName;
        } else if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            tableName = this.m_lftTableName;
        } else if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            tableName = this.m_rocTableName;
        }
        return tableName;
    }
}

