/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.supervised.classification.ClassificationTestMetricOption;
import javax.datamining.supervised.classification.ClassificationTestMetricsTask;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestTask;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraClassificationTestMetricsTask
extends OraClassificationTestTask
implements ClassificationTestMetricsTask {
    private String m_actualTargetAttributeName = null;
    private String m_predictedTargetAttributeName = null;
    private String m_predictionRankingAttributeName = null;

    public OraClassificationTestMetricsTask(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory);
        this.m_useModelCostMatrix = false;
    }

    protected OraClassificationTestMetricsTask(OraConnection dmeConn, OraFactory factory, String applyOutputDataName, String actualTargetAttributeName, String predictedTargetAttributeName, String testMetricsName) throws JDMException {
        super(dmeConn, factory, null, applyOutputDataName, testMetricsName, false);
        this.m_useModelCostMatrix = false;
        this.m_actualTargetAttributeName = actualTargetAttributeName;
        this.m_predictedTargetAttributeName = predictedTargetAttributeName;
    }

    public String getApplyOutputDataName() {
        return this.getTestDataName();
    }

    public void setApplyOutputDataName(String applyOutputData) throws JDMException {
        this.setTestDataName(applyOutputData);
    }

    public String getActualTargetAttrName() {
        return this.m_actualTargetAttributeName;
    }

    public void setActualTargetAttrName(String actualTargetAttrName) throws JDMException {
        this.getConnection().getValidationHandler().validateTableColumnName(actualTargetAttrName, "actualTargetAttrName");
        this.m_actualTargetAttributeName = actualTargetAttrName;
    }

    public String getPredictedTargetAttrName() {
        return this.m_predictedTargetAttributeName;
    }

    public void setPredictedTargetAttrName(String predictedTargetAttrName) throws JDMException {
        this.getConnection().getValidationHandler().validateTableColumnName(predictedTargetAttrName, "predictedTargetAttrName");
        this.m_predictedTargetAttributeName = predictedTargetAttrName;
    }

    public String getPredictionRankingAttrName() {
        return this.m_predictionRankingAttributeName;
    }

    public void setPredictionRankingAttrName(String predictionRankingAttrName) throws JDMException {
        this.getConnection().getValidationHandler().validateTableColumnName(predictionRankingAttrName, "predictionRankingAttrName");
        this.m_predictionRankingAttributeName = predictionRankingAttrName;
    }

    public boolean computeMetrics(ClassificationTestMetricOption testMetric) {
        return this.computeMetric(testMetric);
    }

    public void computeMetrics(ClassificationTestMetricOption testMetric, boolean flag) {
        this.computeMetric(testMetric, flag);
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraPhysicalDataSet testData = (OraPhysicalDataSet)dmeConn.retrieveObject(OraStringUtils.getReplacedString(this.getTestDataName(), "'", "''"), NamedObject.physicalDataSet);
        this.m_testTableName = testData.getTableName();
        this.m_testTableSchemaName = testData.getSchemaName();
        PhysicalAttribute caseIdAttr = testData.getCaseIDAttribute();
        this.m_caseidColumnName = caseIdAttr.getName();
        String costMatrixTableName = null;
        String costMatrixSchemaName = null;
        if (this.m_costMatrixName != null) {
            OraDataURI cmURI = new OraDataURI(this.m_costMatrixName);
            costMatrixTableName = cmURI.getTableName();
            costMatrixSchemaName = cmURI.getSchemaName();
        }
        if (this.m_testMetricsDescription == null) {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", null, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", this.m_computeCFM ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_LIFT", this.m_computeLift ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_ROC", this.m_computeROC ? "Y" : "N", new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", this.m_positiveTargetValue == null ? null : this.m_positiveTargetValue.toString(), new Integer(12)}, new Object[]{"NUM_QUANTILES", Integer.toString(this.m_numberOfQuantiles), new Integer(12)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", this.m_predictedTargetAttributeName, new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", this.m_predictionRankingAttributeName, new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", costMatrixTableName, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", costMatrixSchemaName, new Integer(12)}, new Object[]{"ACTUAL_TARGET_COLUMN_NAME", this.m_actualTargetAttributeName, new Integer(12)}, new Object[]{"MINING_FUNCTION", "CLASSIFICATION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        } else {
            this.m_jobArgs = new Vector();
            this.m_jobArgs.addAll(Arrays.asList(new Object[]{"MODEL_NAME", null, new Integer(12)}, new Object[]{"DATA_TABLE_NAME", this.m_testTableName, new Integer(12)}, new Object[]{"CASE_ID_COLUMN_NAME", this.m_caseidColumnName, new Integer(12)}, new Object[]{"COMPUTE_CONFUSION_MATRIX", this.m_computeCFM ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_LIFT", this.m_computeLift ? "Y" : "N", new Integer(12)}, new Object[]{"COMPUTE_ROC", this.m_computeROC ? "Y" : "N", new Integer(12)}, new Object[]{"POSITIVE_TARGET_VALUE", this.m_positiveTargetValue == null ? null : this.m_positiveTargetValue.toString(), new Integer(12)}, new Object[]{"NUM_QUANTILES", Integer.toString(this.m_numberOfQuantiles), new Integer(12)}, new Object[]{"TEST_METRICS_NAME", this.m_testMetricsName, new Integer(12)}, new Object[]{"PDS_NAME", this.m_testDataName, new Integer(12)}, new Object[]{"DATA_SCHEMA_NAME", this.m_testTableSchemaName, new Integer(12)}, new Object[]{"SCORE_COLUMN_NAME", this.m_predictedTargetAttributeName, new Integer(12)}, new Object[]{"SCORE_CRITERION_COLUMN_NAME", this.m_predictionRankingAttributeName, new Integer(12)}, new Object[]{"COST_MATRIX_TABLE_NAME", costMatrixTableName, new Integer(12)}, new Object[]{"COST_MATRIX_SCHEMA_NAME", costMatrixSchemaName, new Integer(12)}, new Object[]{"ACTUAL_TARGET_COLUMN_NAME", this.m_actualTargetAttributeName, new Integer(12)}, new Object[]{"MINING_FUNCTION", "CLASSIFICATION", new Integer(12)}, new Object[]{"CFM_NAME", this.getCFMName(this.m_testMetricsName), new Integer(12)}, new Object[]{"LFT_NAME", this.getLFTName(this.m_testMetricsName), new Integer(12)}, new Object[]{"ROC_NAME", this.getROCName(this.m_testMetricsName), new Integer(12)}, new Object[]{"TEST_METRICS_DESCRIPTION", this.m_testMetricsDescription, new Integer(12)}));
            if (!this.is102()) {
                this.m_jobArgs.add(new Object[]{"APPLY_RESULT_NAME", null, new Integer(12)});
            }
        }
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            Object[] objs;
            this.m_modelName = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_testTableName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_caseidColumnName = (String)((Object[])this.m_jobArgs.get(2))[1];
            this.m_computeCFM = ((String)((Object[])this.m_jobArgs.get(3))[1]).equals("Y");
            if (this.m_computeCFM) {
                this.m_cfmTableName = (String)((Object[])this.m_jobArgs.get(17))[1];
            }
            this.m_computeLift = ((String)((Object[])this.m_jobArgs.get(4))[1]).equals("Y");
            if (this.m_computeLift) {
                this.m_lftTableName = (String)((Object[])this.m_jobArgs.get(18))[1];
            }
            this.m_computeROC = ((String)((Object[])this.m_jobArgs.get(5))[1]).equals("Y");
            if (this.m_computeROC) {
                this.m_rocTableName = (String)((Object[])this.m_jobArgs.get(19))[1];
            }
            this.m_positiveTargetValue = (String)((Object[])this.m_jobArgs.get(6))[1];
            Object quantiles = ((Object[])this.m_jobArgs.get(7))[1];
            if (quantiles instanceof String) {
                quantiles = new Integer((String)quantiles);
            }
            if (quantiles != null) {
                this.m_numberOfQuantiles = ((Number)quantiles).intValue();
            }
            this.m_testMetricsName = (String)((Object[])this.m_jobArgs.get(8))[1];
            this.m_testDataName = (String)((Object[])this.m_jobArgs.get(9))[1];
            this.m_testTableSchemaName = (String)((Object[])this.m_jobArgs.get(10))[1];
            this.m_actualTargetAttributeName = (String)((Object[])this.m_jobArgs.get(15))[1];
            this.m_predictedTargetAttributeName = (String)((Object[])this.m_jobArgs.get(11))[1];
            String costMatrixTableName = null;
            String costMatrixSchemaName = null;
            costMatrixTableName = (String)((Object[])this.m_jobArgs.get(13))[1];
            costMatrixSchemaName = (String)((Object[])this.m_jobArgs.get(14))[1];
            if (costMatrixTableName != null) {
                OraDataURI cmURI = new OraDataURI(costMatrixTableName, costMatrixSchemaName);
                this.m_costMatrixName = cmURI.getURI();
            }
            if (this.m_jobArgs.size() >= 21 && (objs = (Object[])this.m_jobArgs.get(20)) != null && objs.length > 2) {
                this.m_testMetricsDescription = (String)objs[1];
            }
        }
    }

    public void setTableName(ClassificationTestMetricOption testMetric, String tableName) {
        this.getConnection().getValidationHandler().validateNotNull(testMetric, "testMetric");
        this.getConnection().getValidationHandler().validateObjectName(tableName, "testMetric", NamedObject.testMetrics);
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            this.m_cfmTableName = tableName;
        } else if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            this.m_lftTableName = tableName;
        } else if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            this.m_rocTableName = tableName;
        }
    }

    public String getTableName(ClassificationTestMetricOption testMetric) {
        this.getConnection().getValidationHandler().validateNotNull(testMetric, "testMetric");
        String tableName = null;
        if (ClassificationTestMetricOption.confusionMatrix.equals((Object)testMetric)) {
            tableName = this.m_cfmTableName;
        } else if (ClassificationTestMetricOption.lift.equals((Object)testMetric)) {
            tableName = this.m_lftTableName;
        } else if (ClassificationTestMetricOption.receiverOperatingCharacteristics.equals((Object)testMetric)) {
            tableName = this.m_rocTableName;
        }
        return tableName;
    }
}

