/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.ConfusionMatrix;
import javax.datamining.supervised.classification.Lift;
import javax.datamining.supervised.classification.ReceiverOperatingCharacterics;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraTestMetrics;
import oracle.dmt.jdm.supervised.classification.OraConfusionMatrix;
import oracle.dmt.jdm.supervised.classification.OraLift;
import oracle.dmt.jdm.supervised.classification.OraReceiverOperatingCharacterics;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraClassificationTestMetrics
extends OraTestMetrics
implements ClassificationTestMetrics {
    private static String c_metric_target_attribute = "TARGET_ATTRIBUTE";
    private static String c_metric_positive_target_value = "POSITIVE_TARGET_VALUE";
    private static String c_metric_accuracy = "ACCURACY";
    private static String c_metric_cfm_table = "CONFUSION_MATRIX_TABLE";
    private static String c_metric_lft_table = "LIFT_TABLE";
    private static String c_metric_roc_table = "ROC_TABLE";
    private static String c_metric_area_under_curve = "AREA_UNDER_CURVE";
    private OraConfusionMatrix m_confusionMatrix = null;
    private OraLift m_lift = null;
    private OraReceiverOperatingCharacterics m_receiverOperatingCharacterics = null;
    private Object m_positiveTargetValue = null;

    public OraClassificationTestMetrics(OraConnection dmeConn, HashMap metricsPair) throws JDMException {
        super(dmeConn);
        this.m_metricsPair = metricsPair;
    }

    public Double getAccuracy() {
        Double retValue = null;
        if (this.m_metricsPair != null) {
            retValue = Double.valueOf((String)this.getObjectValue(c_metric_accuracy));
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfusionMatrix getConfusionMatrix() {
        block24: {
            if (this.m_confusionMatrix == null) {
                String name = (String)this.getObjectValue(c_metric_cfm_table);
                OraConnection dmeConn = this.getConnection();
                Connection dbConn = dmeConn.getDatabaseConnection();
                String sProcessedName = null;
                sProcessedName = name.startsWith("\"") && name.endsWith("\"") ? name : name.toUpperCase();
                boolean bsExist = false;
                try {
                    bsExist = OraClassificationTestMetrics.doesObjectExistInDatabase(dmeConn, OraStringUtils.processQuotedName(sProcessedName));
                    if (bsExist) {
                        String sqlSpec = "SELECT * FROM " + sProcessedName + " ORDER BY ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE";
                        PreparedStatement ps = null;
                        ResultSet rs = null;
                        try {
                            this.m_confusionMatrix = new OraConfusionMatrix(dmeConn);
                            ps = dbConn.prepareStatement(sqlSpec);
                            rs = ps.executeQuery();
                            while (rs.next()) {
                                String actual = rs.getString("ACTUAL_TARGET_VALUE");
                                String predicted = rs.getString("PREDICTED_TARGET_VALUE");
                                int value = rs.getInt("VALUE");
                                this.m_confusionMatrix.addEntry(actual, predicted, value);
                            }
                            this.m_confusionMatrix.setAccuracy(this.getAccuracy());
                            break block24;
                        }
                        catch (SQLException sqlExp) {
                            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
                            break block24;
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception e1) {}
                            try {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                    dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.m_confusionMatrix;
    }

    public synchronized Lift getLift(Object positiveTargetValue) {
        this.getConnection().getValidationHandler().validateNotNull(positiveTargetValue, "positiveTargetValue");
        boolean isTargetNumber = false;
        if (positiveTargetValue instanceof Number) {
            isTargetNumber = true;
        } else if (positiveTargetValue instanceof String) {
            isTargetNumber = false;
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"positiveTargetValue"}, null, "3507", new String[]{"positiveTargetValue", AttributeDataType.integerType.name() + "," + AttributeDataType.stringType.name()});
        }
        this.m_positiveTargetValue = positiveTargetValue;
        Lift lft = this.getLift();
        this.m_positiveTargetValue = null;
        this.m_lift = null;
        return lft;
    }

    public synchronized ReceiverOperatingCharacterics getROC(Object positiveTargetValue) {
        this.getConnection().getValidationHandler().validateNotNull(positiveTargetValue, "positiveTargetValue");
        boolean isTargetNumber = false;
        if (positiveTargetValue instanceof Number) {
            isTargetNumber = true;
        } else if (positiveTargetValue instanceof String) {
            isTargetNumber = false;
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{"positiveTargetValue"}, null, "3507", new String[]{"positiveTargetValue", AttributeDataType.integerType.name() + "," + AttributeDataType.stringType.name()});
        }
        this.m_positiveTargetValue = positiveTargetValue;
        ReceiverOperatingCharacterics roc = this.getROC();
        this.m_positiveTargetValue = null;
        this.m_receiverOperatingCharacterics = null;
        return roc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Lift getLift() {
        block32: {
            if (this.m_lift == null) {
                String name = (String)this.getObjectValue(c_metric_lft_table);
                OraConnection dmeConn = this.getConnection();
                Connection dbConn = dmeConn.getDatabaseConnection();
                String sProcessedName = null;
                sProcessedName = name.startsWith("\"") && name.endsWith("\"") ? name : name.toUpperCase();
                boolean bsExist = false;
                try {
                    bsExist = OraClassificationTestMetrics.doesObjectExistInDatabase(dmeConn, OraStringUtils.processQuotedName(sProcessedName));
                    if (bsExist) {
                        String sqlSpec = "SELECT * FROM " + sProcessedName + " ";
                        if (this.m_positiveTargetValue != null) {
                            sqlSpec = sqlSpec + " WHERE TARGET_VALUE = ?";
                        }
                        sqlSpec = sqlSpec + "ORDER BY QUANTILE_NUMBER DESC";
                        PreparedStatement ps = null;
                        ResultSet rs = null;
                        try {
                            this.m_lift = new OraLift(dmeConn);
                            ps = dbConn.prepareStatement(sqlSpec);
                            if (this.m_positiveTargetValue != null) {
                                ps.setString(1, this.m_positiveTargetValue.toString());
                            }
                            rs = ps.executeQuery();
                            boolean isTopQuantile = true;
                            while (rs.next()) {
                                BigDecimal quantileNumber = rs.getBigDecimal("QUANTILE_NUMBER");
                                BigDecimal quantileTotalCount = rs.getBigDecimal("QUANTILE_TOTAL_COUNT");
                                BigDecimal quantileTargetCount = rs.getBigDecimal("QUANTILE_TARGET_COUNT");
                                BigDecimal percentageRecordsCumulative = rs.getBigDecimal("PERCENTAGE_RECORDS_CUMULATIVE");
                                BigDecimal liftCumulative = rs.getBigDecimal("LIFT_CUMULATIVE");
                                BigDecimal targetDensityCumulative = rs.getBigDecimal("TARGET_DENSITY_CUMULATIVE");
                                BigDecimal targetsCumulative = rs.getBigDecimal("TARGETS_CUMULATIVE");
                                BigDecimal nontargetsCumulative = rs.getBigDecimal("NON_TARGETS_CUMULATIVE");
                                BigDecimal liftQuantile = rs.getBigDecimal("LIFT_QUANTILE");
                                BigDecimal targetDensity = rs.getBigDecimal("TARGET_DENSITY");
                                BigDecimal probabilityOrCostThreshold = null;
                                try {
                                    probabilityOrCostThreshold = rs.getBigDecimal("PROBABILITY_THRESHOLD");
                                }
                                catch (Exception anyExp) {
                                    probabilityOrCostThreshold = rs.getBigDecimal("COST_THRESHOLD");
                                }
                                BigDecimal gainCumulative = rs.getBigDecimal("GAIN_CUMULATIVE");
                                if (isTopQuantile) {
                                    isTopQuantile = false;
                                    this.m_lift.setNumberOfQuantiles(quantileNumber.intValue());
                                    this.m_lift.setTotalCases((int)(targetsCumulative.doubleValue() + nontargetsCumulative.doubleValue()));
                                    this.m_lift.setTotalPositiveCases((int)targetsCumulative.doubleValue());
                                }
                                String liftKey = quantileNumber.toString();
                                this.m_lift.addEntry(liftKey, new BigDecimal[]{quantileNumber, quantileTotalCount, quantileTargetCount, percentageRecordsCumulative, liftCumulative, targetDensityCumulative, targetsCumulative, nontargetsCumulative, liftQuantile, targetDensity, probabilityOrCostThreshold, gainCumulative});
                            }
                            if (this.m_lift != null) {
                                String targetAttributeName = (String)this.getObjectValue(c_metric_target_attribute);
                                this.m_lift.setTargetAttributeName(targetAttributeName);
                                if (this.m_positiveTargetValue != null) {
                                    this.m_lift.setPositiveTargetValue(this.m_positiveTargetValue);
                                } else {
                                    String positiveTargetValue = (String)this.getObjectValue(c_metric_positive_target_value);
                                    this.m_lift.setPositiveTargetValue(positiveTargetValue);
                                }
                            }
                            break block32;
                        }
                        catch (SQLException sqlExp) {
                            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
                            break block32;
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception e1) {}
                            try {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                    dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.m_lift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReceiverOperatingCharacterics getROC() {
        block47: {
            if (this.m_receiverOperatingCharacterics == null) {
                String name = (String)this.getObjectValue(c_metric_roc_table);
                OraConnection dmeConn = this.getConnection();
                Connection dbConn = dmeConn.getDatabaseConnection();
                Double area_under_curve = null;
                if (this.m_positiveTargetValue != null) {
                    Statement ps = null;
                    ResultSet rs = null;
                    try {
                        ps = dbConn.prepareStatement("SELECT METRIC_NUM_VALUE FROM " + this.getName() + " WHERE METRIC_NAME=? AND METRIC_VARCHAR_VALUE=?");
                        ps.setString(1, c_metric_area_under_curve);
                        ps.setString(2, this.m_positiveTargetValue.toString());
                        rs = ps.executeQuery();
                        rs.next();
                        area_under_curve = new Double(rs.getDouble(1));
                    }
                    catch (SQLException sqlExp) {
                        dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception e1) {}
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        catch (Exception e2) {}
                    }
                } else {
                    area_under_curve = Double.valueOf((String)this.getObjectValue(c_metric_area_under_curve));
                }
                String sProcessedName = null;
                sProcessedName = name.startsWith("\"") && name.endsWith("\"") ? name : name.toUpperCase();
                boolean bsExist = false;
                try {
                    bsExist = OraClassificationTestMetrics.doesObjectExistInDatabase(dmeConn, OraStringUtils.processQuotedName(sProcessedName));
                    if (bsExist) {
                        String sqlSpec = "SELECT * FROM " + sProcessedName + " ";
                        if (this.m_positiveTargetValue != null) {
                            sqlSpec = sqlSpec + " WHERE TARGET_VALUE = ?";
                        }
                        sqlSpec = sqlSpec + "ORDER BY PROBABILITY ASC, TRUE_POSITIVES DESC ";
                        Statement ps = null;
                        ResultSet rs = null;
                        try {
                            this.m_receiverOperatingCharacterics = new OraReceiverOperatingCharacterics(dmeConn, area_under_curve);
                            ps = dbConn.prepareStatement(sqlSpec);
                            if (this.m_positiveTargetValue != null) {
                                ps.setString(1, this.m_positiveTargetValue.toString());
                            }
                            rs = ps.executeQuery();
                            int i = 1;
                            while (rs.next()) {
                                BigDecimal probability = rs.getBigDecimal("PROBABILITY");
                                BigDecimal truePositives = rs.getBigDecimal("TRUE_POSITIVES");
                                BigDecimal falsePositives = rs.getBigDecimal("FALSE_POSITIVES");
                                BigDecimal trueNegatives = rs.getBigDecimal("TRUE_NEGATIVES");
                                BigDecimal falseNegatives = rs.getBigDecimal("FALSE_NEGATIVES");
                                BigDecimal truePositivesFraction = rs.getBigDecimal("TRUE_POSITIVE_FRACTION");
                                BigDecimal falsePositivesFraction = rs.getBigDecimal("FALSE_POSITIVE_FRACTION");
                                String rocKey = i++ + "";
                                this.m_receiverOperatingCharacterics.addEntry(rocKey, new Object[]{probability, truePositives, falsePositives, trueNegatives, falseNegatives, truePositivesFraction, falsePositivesFraction});
                            }
                            break block47;
                        }
                        catch (SQLException sqlExp) {
                            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, OraJDMBundleKeys.JDMR_INVALID_OBJECT, null);
                            break block47;
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception e1) {}
                            try {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                    dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.m_receiverOperatingCharacterics;
    }
}

