/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.supervised.classification.ClassificationCapability;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.datamining.supervised.classification.ClassificationSettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.supervised.classification.OraClassificationSettings;

public class OraClassificationSettingsFactory
extends OraFactory
implements ClassificationSettingsFactory {
    private static OraSupportedEnums supportedFeaturesAll = new OraSupportedEnums(new Enum[]{ClassificationCapability.priorProbability, ClassificationCapability.costMatrix});
    private static OraSupportedEnums supportedFeaturesOthers = new OraSupportedEnums(new Enum[]{ClassificationCapability.priorProbability});
    private static OraSupportedEnums supportedFeaturesDT = new OraSupportedEnums(new Enum[]{ClassificationCapability.costMatrix});

    public ClassificationSettings create() throws JDMException {
        OraClassificationSettings classificationSettings = new OraClassificationSettings(this.m_dmeConn, this);
        return classificationSettings;
    }

    public boolean supportsCapability(ClassificationCapability capability) {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        return supportedFeaturesAll.isSupported((Enum)capability);
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClassificationCapability capability) {
        this.m_dmeConn.getValidationHandler().validateNotNull(capability, "capability");
        if (algorithm == null) {
            return supportedFeaturesAll.isSupported((Enum)capability);
        }
        if (algorithm.equals((Object)MiningAlgorithm.decisionTree)) {
            return supportedFeaturesDT.isSupported((Enum)capability);
        }
        return supportedFeaturesOthers.isSupported((Enum)capability);
    }
}

