/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.supervised.classification.ClassificationApplyCapability;
import javax.datamining.supervised.classification.ClassificationApplyContent;
import javax.datamining.supervised.classification.ClassificationApplySettings;
import javax.datamining.supervised.classification.ClassificationApplySettingsFactory;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.supervised.classification.OraClassificationApplySettings;

public class OraClassificationApplySettingsFactory
extends OraFactory
implements ClassificationApplySettingsFactory {
    private ClassificationApplySettings s_defaultApplySettings = null;
    private static final OraSupportedEnums supportedApplyContents = new OraSupportedEnums(new Enum[]{ClassificationApplyContent.probability, ClassificationApplyContent.predictedCategory});
    private static final OraSupportedEnums supportedClassificationApplyCapabilities = new OraSupportedEnums(new Enum[]{ClassificationApplyCapability.costMatrix, ClassificationApplyCapability.topSequentialRanks, ClassificationApplyCapability.allPredictions, ClassificationApplyCapability.individualCategories, ClassificationApplyCapability.topPrediction});

    public ClassificationApplySettings create() throws JDMException {
        return new OraClassificationApplySettings(this.getConnection(), this);
    }

    public ClassificationApplySettings getDefaultApplySettings() {
        return this.s_defaultApplySettings;
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClassificationApplyContent content) {
        return supportedApplyContents.isSupported((Enum)content);
    }

    public boolean supportsCapability(MiningAlgorithm algorithm, ClassificationApplyCapability capability) {
        return supportedClassificationApplyCapabilities.isSupported((Enum)capability);
    }

    public ClassificationApplyContent[] getSupportedApplyContents(MiningAlgorithm algorithm) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(algorithm, "algorithm");
        Enum[] enums = supportedApplyContents.getSupportedEnums();
        ClassificationApplyContent[] classificationApplyContentEnums = new ClassificationApplyContent[enums.length];
        System.arraycopy(enums, 0, classificationApplyContentEnums, 0, enums.length);
        return classificationApplyContentEnums;
    }

    public OraClassificationApplySettingsFactory() throws JDMException {
        if (this.s_defaultApplySettings == null) {
            this.s_defaultApplySettings = new OraClassificationApplySettings(this.getConnection(), this);
        }
    }
}

