/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.supervised.classification.ClassificationApplyContent;
import javax.datamining.supervised.classification.ClassificationApplySettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraClassificationApplySettingsFactory;
import oracle.dmt.jdm.task.apply.OraApplySettings;

public class OraClassificationApplySettings
extends OraApplySettings
implements ClassificationApplySettings {
    private static final String[][] m_contentColumnMap = new String[][]{{ClassificationApplyContent.predictedCategory.name(), ClassificationApplyContent.probability.name(), ClassificationApplyContent.cost.name(), ClassificationApplyContent.nodeId.name()}, {"PREDICTION", "PROBABILITY", "COST", "NODE_ID"}};

    protected String getPredictionColName(String destAttrName) {
        String columnName = null;
        try {
            ClassificationApplyContent content = this.getContent(destAttrName);
            String contentType = content.name();
            for (int i = 0; i < m_contentColumnMap[0].length; ++i) {
                if (contentType.compareTo(m_contentColumnMap[0][i]) != 0) continue;
                columnName = m_contentColumnMap[1][i];
            }
        }
        catch (JDMException jDMException) {
            // empty catch block
        }
        return columnName;
    }

    public void mapByRank(ClassificationApplyContent content, String[] destPhysAttrNameArray, boolean fromTop) throws JDMException {
        super.mapByRank((Enum)content, destPhysAttrNameArray, fromTop);
    }

    public void mapByCategory(ClassificationApplyContent content, Object categoryValue, String destinationAttrName) throws JDMException {
        super.mapByCategory((Enum)content, categoryValue, destinationAttrName);
    }

    public void mapTopPrediction(ClassificationApplyContent content, String destPhysAttrName) {
        super.mapTopPrediction((Enum)content, destPhysAttrName);
    }

    public void mapPredictions(ClassificationApplyContent content, String baseDestPhysAttrName) {
        super.mapPredictions((Enum)content, baseDestPhysAttrName);
    }

    public Integer getRank(String destinationAttrName) throws JDMException {
        return super.getRank(destinationAttrName);
    }

    public Integer getRanks() {
        return super.getRanks();
    }

    public boolean isFromTop() {
        return super.isFromTop();
    }

    public Object[] getMappedCategories() {
        return super.getMappedCategories();
    }

    public String getMappedDestinationAttrName(Object categoryValue, ClassificationApplyContent contentType) throws JDMException {
        return super.getMappedDestinationAttrName(categoryValue, (Enum)contentType);
    }

    public String getMappedBaseDestinationAttributeName(ClassificationApplyContent content) {
        return super.getMappedBaseDestinationAttributeName((Enum)content);
    }

    public String[] getMappedDestinationAttributeNames(ClassificationApplyContent content) {
        return super.getMappedDestinationAttributeNames((Enum)content);
    }

    public ClassificationApplyContent getContent(String destinationAttrName) throws JDMException {
        return (ClassificationApplyContent)super.getContentEnum(destinationAttrName);
    }

    public void setCostMatrixName(String costMatrixName) throws JDMException {
        super.setCostMatrixName(costMatrixName);
    }

    public String getCostMatrixName() {
        return super.getCostMatrixName();
    }

    public boolean useCostMatrixFromModel() {
        return this.m_useCostMatrixFromModel != 0;
    }

    public void useCostMatrixFromModel(boolean useCostrMatrixFromModel) {
        this.m_useCostMatrixFromModel = useCostrMatrixFromModel ? 1 : 0;
    }

    protected OraClassificationApplySettings(OraConnection dmeConn, OraClassificationApplySettingsFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, MiningFunction.classification);
    }

    public ClassificationApplyContent[] getMappedContents() {
        Object[] objs = super.getMappedContentsEnums();
        ClassificationApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new ClassificationApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    public ClassificationApplyContent[] getContentsByCategory(Object categoryValue) throws JDMException {
        this.getValidationHandler().validateCategory(categoryValue, "categoryValue");
        Object[] objs = super.getContentsByCategoryEnums(categoryValue);
        if (objs == null || objs.length == 0) {
            this.getExceptionHandler().createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{"categoryValue"}, null);
        }
        ClassificationApplyContent[] enums = null;
        enums = new ClassificationApplyContent[objs.length];
        System.arraycopy(objs, 0, enums, 0, objs.length);
        return enums;
    }

    public ClassificationApplyContent[] getContentsByRank(int rank) throws JDMException {
        this.getValidationHandler().validateNumber(rank, 1, "rank");
        Integer ranks = super.getRanks();
        if (ranks == null) {
            this.getExceptionHandler().createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{"rank"}, null);
        }
        this.getValidationHandler().validateNumber(rank, 1, ranks, "rank");
        Object[] objs = super.getContentsByRankEnums(rank);
        ClassificationApplyContent[] enums = null;
        if (objs != null && objs.length > 0) {
            enums = new ClassificationApplyContent[objs.length];
            System.arraycopy(objs, 0, enums, 0, objs.length);
        }
        return enums;
    }

    protected String[] toSQL(String modelName) throws JDMException {
        this.m_attrNames = new Vector();
        String[] sqlStats = new String[]{null, null};
        StringBuffer sqlStat = new StringBuffer("select ");
        boolean useCost = false;
        boolean outputNode = false;
        String costModel = "";
        ClassificationApplyContent[] contents = this.getMappedContents();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (!useCost) {
                    useCost = contents[i].equals((Object)ClassificationApplyContent.cost);
                }
                if (!outputNode) {
                    outputNode = contents[i].equals((Object)ClassificationApplyContent.nodeId);
                }
                if (!useCost) continue;
                costModel = " COST MODEL";
                if (outputNode) break;
            }
        }
        switch (this.m_applyOutputMode) {
            case 2: {
                this.m_attrMapping = 1;
                Object[] categories = this.getMappedCategories();
                for (int i = 0; i < categories.length; ++i) {
                    ClassificationApplyContent[] contents2 = this.getContentsByCategory(categories[i]);
                    boolean stringCat = categories[i] instanceof String;
                    for (int j = 0; j < contents2.length; ++j) {
                        if (i + j > 0) {
                            sqlStat.append(", ");
                        }
                        String op = null;
                        if (contents2[j].equals((Object)ClassificationApplyContent.predictedCategory)) {
                            if (stringCat) {
                                sqlStat.append("'");
                            }
                            sqlStat.append(categories[i].toString());
                            if (stringCat) {
                                sqlStat.append("'");
                            }
                        } else {
                            if (contents2[j].equals((Object)ClassificationApplyContent.probability)) {
                                op = "PREDICTION_PROBABILITY";
                            } else if (contents2[j].equals((Object)ClassificationApplyContent.cost)) {
                                op = "PREDICTION_COST";
                            } else if (this._enableNodeId && contents2[j].equals((Object)ClassificationApplyContent.nodeId)) {
                                op = "EXTRACTVALUE(PREDICTION_DETAILS";
                            } else {
                                this.unsupported("ClassificationApplyContent." + contents2[j].name());
                            }
                            sqlStat.append(op).append("(").append(modelName);
                            if (!contents2[j].equals((Object)ClassificationApplyContent.nodeId)) {
                                if (stringCat) {
                                    sqlStat.append(", '").append(categories[i].toString()).append("'");
                                } else {
                                    sqlStat.append(", ").append(categories[i].toString());
                                }
                            }
                            sqlStat.append(costModel).append(" USING *)");
                            if (this._enableNodeId && contents2[j].equals((Object)ClassificationApplyContent.nodeId)) {
                                sqlStat.append(" , '/Node/@id')");
                            }
                        }
                        sqlStat.append(" as ").append(this.getMappedDestinationAttrName(categories[i], contents2[j]));
                        this.m_attrNames.add(this.getMappedDestinationAttrName(categories[i], contents2[j]));
                    }
                }
                break;
            }
            case 3: {
                if (this.m_rankContentMap != null) {
                    this.m_attrMapping = 4;
                    if (this._enableNodeId && outputNode) {
                        sqlStat = new StringBuffer(",   pset as ( SELECT * ").append("     FROM Table(SELECT prediction_set(").append(modelName).append(costModel).append(" USING *) ").append("     FROM a_record) ), ").append("   node as (SELECT extractvalue(prediction_details(").append(modelName).append(" USING *),    '/Node/@id') node_id ").append("FROM a_record) ").append("SELECT TO_NUMBER(PREDICTION) AS PREDICTION, TO_NUMBER(PROBABILITY) AS PROBABILITY, TO_CHAR(NODE_ID) AS NODE_ID ").append("FROM pset, node order by").append(useCost ? " cost asc" : " probability desc");
                    } else {
                        sqlStat.append("s.prediction prediction, s.probability probability");
                        if (useCost) {
                            sqlStat.append(", s.cost cost");
                        }
                        sqlStat.append(" from (select PREDICTION_SET(").append(modelName);
                        sqlStat.append(", ").append(this.getRanks().toString());
                        sqlStat.append(costModel).append(" USING *) pset");
                        sqlStats[1] = ") t, TABLE(t.pset) s order by" + (useCost ? " cost asc" : " probability desc");
                    }
                    Integer ranks = this.getRanks();
                    ClassificationApplyContent[] mappedContents = this.getMappedContents();
                    for (int iRank = 1; iRank < ranks + 1; ++iRank) {
                        Vector<String> attrNames = new Vector<String>();
                        for (int jj = 0; jj < mappedContents.length; ++jj) {
                            String attrName = this.getMappedDestinationAttrName(iRank, (Enum)mappedContents[jj]);
                            if (attrName == null) continue;
                            attrNames.add(attrName);
                        }
                        this.m_attrNames.add(Integer.toString(attrNames.size()));
                        for (int kk = 0; kk < attrNames.size(); ++kk) {
                            this.m_attrNames.add(attrNames.elementAt(kk));
                        }
                    }
                } else {
                    this.m_attrMapping = 1;
                    for (int i = 0; i < contents.length; ++i) {
                        if (i > 0) {
                            sqlStat.append(", ");
                        }
                        String op = null;
                        if (contents[i].equals((Object)ClassificationApplyContent.predictedCategory)) {
                            op = "PREDICTION";
                        } else if (contents[i].equals((Object)ClassificationApplyContent.probability)) {
                            op = "PREDICTION_PROBABILITY";
                        } else if (contents[i].equals((Object)ClassificationApplyContent.cost)) {
                            op = "PREDICTION_COST";
                        } else if (this._enableNodeId && contents[i].equals((Object)ClassificationApplyContent.nodeId)) {
                            op = "EXTRACTVALUE(PREDICTION_DETAILS";
                        } else {
                            this.unsupported("ClassificationApplyContent." + contents[i].name());
                        }
                        this.m_attrNames.add(this.getMappedDestinationAttrName((Enum)contents[i]));
                        sqlStat.append(op).append("(").append(modelName);
                        sqlStat.append(costModel).append(" USING *) ");
                        if (this._enableNodeId && contents[i].equals((Object)ClassificationApplyContent.nodeId)) {
                            sqlStat.append(" , '/Node/@id')");
                        }
                        sqlStat.append(" as ").append(this.getMappedDestinationAttrName((Enum)contents[i]));
                    }
                }
                break;
            }
            default: {
                String predCol = "PREDICTION";
                if (this.m_applyOutputMode == 4) {
                    this.m_attrMapping = 3;
                    predCol = this.getMappedBaseDestinationAttributeName(ClassificationApplyContent.predictedCategory);
                } else {
                    this.m_attrMapping = 2;
                }
                this.m_attrNames.add(predCol);
                String probCol = this.getMappedBaseDestinationAttributeName(ClassificationApplyContent.probability);
                if (this.m_applyOutputMode != 4) {
                    probCol = "PROBABILITY";
                }
                if (probCol != null) {
                    this.m_attrNames.add(probCol);
                }
                if (this._enableNodeId) {
                    String nodeCol = this.getMappedBaseDestinationAttributeName(ClassificationApplyContent.nodeId);
                    if (this.m_applyOutputMode != 4) {
                        nodeCol = "NODE_ID";
                    }
                    if (probCol != null) {
                        this.m_attrNames.add(nodeCol);
                    }
                    sqlStat = new StringBuffer(",   pset as ( SELECT * ").append("     FROM Table(SELECT prediction_set(").append(modelName).append(costModel).append(" USING *) ").append("     FROM a_record) ), ").append("   node as (SELECT extractvalue(prediction_details(").append(modelName).append(" USING *),    '/Node/@id') node_id ").append("   FROM a_record) ").append("SELECT TO_NUMBER(PREDICTION) AS PREDICTION, TO_NUMBER(PROBABILITY) AS PROBABILITY, TO_CHAR(NODE_ID) AS NODE_ID ").append("FROM pset, node order by").append(useCost ? " cost asc" : " probability desc");
                    break;
                }
                sqlStat.append("s.prediction prediction, s.probability probability");
                if (useCost) {
                    sqlStat.append(", s.cost cost");
                    this.m_attrNames.add(this.getMappedBaseDestinationAttributeName(ClassificationApplyContent.cost));
                }
                sqlStat.append(" from (select PREDICTION_SET(").append(modelName);
                sqlStat.append(costModel).append(" USING *) pset");
                sqlStats[1] = ") t, TABLE(t.pset) s order by probability desc";
            }
        }
        sqlStats[0] = sqlStat.toString();
        return sqlStats;
    }
}

