/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised;

import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.VerificationReport;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeFactory;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.data.PhysicalDataSetFactory;
import javax.datamining.supervised.TestTask;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.utils.OraStringUtils;

public abstract class OraTestTask
extends OraTask
implements TestTask {
    protected String m_modelName = null;
    protected String m_testDataName = null;
    protected String m_testMetricsName = null;
    protected String m_testTableName = null;
    protected String m_testTableSchemaName = null;
    protected String m_caseidColumnName = null;
    protected String m_rocTableName = null;
    protected String m_lftTableName = null;
    protected String m_cfmTableName = null;
    protected String m_testMetricsDescription = null;
    protected boolean m_useModelCostMatrix = false;
    public static final int ARG_IX_MODEL_NAME = 0;
    protected static final int ARG_IX_DATA_TABLE_NAME = 1;
    protected static final int ARG_IX_CASE_ID_COLUMN_NAME = 2;
    protected static final int ARG_IX_COMPUTE_CFM = 3;
    protected static final int ARG_IX_COMPUTE_LIFT = 4;
    protected static final int ARG_IX_COMPUTE_ROC = 5;
    protected static final int ARG_IX_POSITIVE_TARGET_VALUE = 6;
    protected static final int ARG_IX_NUM_QUANTILES = 7;
    protected static final int ARG_IX_TEST_METRICS_NAME = 8;
    protected static final int ARG_IX_PDS_NAME = 9;
    protected static final int ARG_IX_DATA_SCHEMA_NAME = 10;
    protected static final int ARG_IX_SCORE_COLUMN_NAME = 11;
    protected static final int ARG_IX_SCORE_CRITERION_COLUMN_NAME = 12;
    protected static final int ARG_IX_COST_MATRIX_TABLE_NAME = 13;
    protected static final int ARG_IX_COST_MATRIX_SCHEMA_NAME = 14;
    protected static final int ARG_IX_ACTUAL_TARGET_COLUMN_NAME = 15;
    public static final int ARG_IX_MINING_FUNCTION = 16;
    protected static final int ARG_IX_CFM_NAME = 17;
    protected static final int ARG_IX_LFT_NAME = 18;
    protected static final int ARG_IX_ROC_NAME = 19;
    protected static final int ARG_IX_TEST_METRICS_DESCRIPTION = 20;
    protected static final int ARG_IX_APPLY_RESULT_NAME = 21;
    protected static final int ARG_IX_USE_COST = 26;
    public static final String ARG_MODEL_NAME = "MODEL_NAME";
    protected static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    protected static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    protected static final String ARG_COMPUTE_CFM = "COMPUTE_CONFUSION_MATRIX";
    protected static final String ARG_COMPUTE_LIFT = "COMPUTE_LIFT";
    protected static final String ARG_COMPUTE_ROC = "COMPUTE_ROC";
    protected static final String ARG_POSITIVE_TARGET_VALUE = "POSITIVE_TARGET_VALUE";
    protected static final String ARG_NUM_QUANTILES = "NUM_QUANTILES";
    protected static final String ARG_TEST_METRICS_NAME = "TEST_METRICS_NAME";
    protected static final String ARG_CFM_NAME = "CFM_NAME";
    protected static final String ARG_LFT_NAME = "LFT_NAME";
    protected static final String ARG_ROC_NAME = "ROC_NAME";
    protected static final String ARG_PDS_NAME = "PDS_NAME";
    protected static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    protected static final String ARG_SCORE_COLUMN_NAME = "SCORE_COLUMN_NAME";
    protected static final String ARG_SCORE_CRITERION_COLUMN_NAME = "SCORE_CRITERION_COLUMN_NAME";
    protected static final String ARG_COST_MATRIX_TABLE_NAME = "COST_MATRIX_TABLE_NAME";
    protected static final String ARG_COST_MATRIX_SCHEMA_NAME = "COST_MATRIX_SCHEMA_NAME";
    protected static final String ARG_ACTUAL_TARGET_COLUMN_NAME = "ACTUAL_TARGET_COLUMN_NAME";
    protected static final String ARG_TEST_METRICS_DESCRIPTION = "TEST_METRICS_DESCRIPTION";
    protected static final String ARG_APPLY_RESULT_NAME = "APPLY_RESULT_NAME";
    public static final String ARG_MINING_FUNCTION = "MINING_FUNCTION";
    public static final String ARG_USE_COST = "USE_COST";
    private static final String c_test_metrics_cfm_suffix = "_CFM";
    private static final String c_test_metrics_lift_suffix = "_LFT";
    private static final String c_test_metrics_roc_suffix = "_ROC";

    public String getTestDataName() {
        return this.m_testDataName;
    }

    public void setTestDataName(String testDataName) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(testDataName, "testDataName", NamedObject.physicalDataSet);
        this.m_testDataName = testDataName;
    }

    public String getModelName() {
        return this.m_modelName;
    }

    public void setModelName(String modelName) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(modelName, "modelName", NamedObject.model);
        this.m_modelName = modelName;
    }

    public String getTestMetricsName() {
        return this.m_testMetricsName;
    }

    public void setTestMetricsName(String testMetricsName) throws JDMException {
        this.getConnection().getValidationHandler().validateObjectName(testMetricsName, "testMetricsName", NamedObject.testMetrics);
        this.m_testMetricsName = testMetricsName;
    }

    public Map getTestDataMap() {
        this.unsupported("testDataMap");
        return null;
    }

    public void setTestDataMap(Map testDataMap) throws JDMException {
        this.unsupported("testDataMap");
    }

    public VerificationReport verify() {
        return null;
    }

    public OraTestTask(OraConnection dmeConn, OraFactory factory) throws JDMException {
        super(dmeConn, factory, TEST_PROGRAM);
        this.ARG_IX_OVERWRITE_OUTPUT = 22;
        this.ARG_IX_PARENT_TASKS = 23;
        this.ARG_IX_CHILD_TASKS = 24;
    }

    protected OraTestTask(OraConnection dmeConn, OraFactory factory, String modelName, String testDataName, String testMetricsName, boolean modelNotNull) throws JDMException {
        super(dmeConn, factory, TEST_PROGRAM);
        this.ARG_IX_OVERWRITE_OUTPUT = 21;
        this.ARG_IX_PARENT_TASKS = 22;
        if (modelNotNull) {
            this.m_modelName = this.getConnection().getValidationHandler().validateObjectName(modelName, "modelName", NamedObject.model);
        }
        this.getConnection().getValidationHandler().validateObjectName(testDataName, "testDataName", NamedObject.physicalDataSet);
        this.m_testMetricsName = this.getConnection().getValidationHandler().validateObjectName(testMetricsName, "testMetricsName", NamedObject.testMetrics);
        this.m_testDataName = testDataName;
        this.m_taskType = MiningTask.testTask;
    }

    public PhysicalDataSet getTestData() throws JDMException {
        if (this.m_jobArgs != null) {
            PhysicalDataSetFactory pdsFactory = (PhysicalDataSetFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalDataSet");
            PhysicalAttributeFactory paFactory = (PhysicalAttributeFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalAttribute");
            OraDataURI dataURI = new OraDataURI(this.m_testTableName, this.m_testTableSchemaName);
            PhysicalDataSet pds = pdsFactory.create(dataURI.getURI(), false);
            PhysicalAttribute pa = paFactory.create(this.m_caseidColumnName, AttributeDataType.integerType, PhysicalAttributeRole.caseId);
            pds.addAttribute(pa);
            return pds;
        }
        return null;
    }

    public void useCost(boolean useCost) {
        this.m_useModelCostMatrix = useCost;
    }

    public boolean useCost() {
        return this.m_useModelCostMatrix;
    }

    public void prepareNewJobArguments(String name) {
        int patchSetVersion = this.getConnection().getPatchsetVersion("11.1.0.");
        if (patchSetVersion >= 7 || patchSetVersion == -1) {
            this.m_jobArgs.add(new Object[]{ARG_USE_COST, this.m_useModelCostMatrix ? "Y" : "N", new Integer(12)});
        }
    }

    protected String getCFMName(String name) {
        if (this.m_cfmTableName == null) {
            this.m_cfmTableName = this.getSuffuxedName(name, c_test_metrics_cfm_suffix);
        }
        return this.m_cfmTableName;
    }

    protected String getLFTName(String name) {
        if (this.m_lftTableName == null) {
            this.m_lftTableName = this.getSuffuxedName(name, c_test_metrics_lift_suffix);
        }
        return this.m_lftTableName;
    }

    protected String getROCName(String name) {
        if (this.m_rocTableName == null) {
            this.m_rocTableName = this.getSuffuxedName(name, c_test_metrics_roc_suffix);
        }
        return this.m_rocTableName;
    }

    private String getSuffuxedName(String name, String suffix) {
        String resultName = null;
        resultName = name.startsWith("\"") && name.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(name) + suffix + "\"" : name + suffix;
        return resultName;
    }

    public String getTestMetricsDescription() {
        return this.m_testMetricsDescription;
    }

    public void setTestMetricsDescription(String description) {
        this.getValidationHandler().validateDescription(description, "description");
        this.m_testMetricsDescription = OraStringUtils.processQuotedName(description);
    }
}

