/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.TestMetrics;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestMetrics;
import oracle.dmt.jdm.supervised.regression.OraRegressionTestMetrics;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraTestMetrics
extends OraMiningObject
implements TestMetrics {
    protected HashMap m_metricsPair = new HashMap();
    private static String c_metric_model_name = "MODEL_NAME";
    private static String c_metric_test_data_name = "TEST_DATA_NAME";
    private static String c_metric_mining_function = "MINING_FUNCTION";
    private static String c_metric_comments_prefix;
    protected static final String TM_COMMENTS_PREFIX;
    private String m_taskIdentifier = null;
    private static final String QRY_GET_TASK_NAME = "select j.job_name from user_scheduler_jobs j, user_scheduler_job_args a where j.job_name=a.job_name and a.argument_name='TEST_METRICS_NAME' and upper(a.value) = ? and j.PROGRAM_NAME='TEST_PROGRAM'";

    protected OraTestMetrics(OraConnection dmeConn) throws JDMException {
        super(dmeConn, null, NamedObject.testMetrics);
    }

    protected void setValue(String key, Object value) {
        this.m_metricsPair.put(key, value);
    }

    protected Object getObjectValue(String key) {
        if (!this.m_metricsPair.containsKey(key)) {
            return null;
        }
        return this.m_metricsPair.get(key);
    }

    protected String getValue(String key) {
        return (String)this.getObjectValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaskIdentifier() {
        if (this.m_taskIdentifier == null) {
            java.sql.Connection dbConn = this.getDatabaseConnection();
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = dbConn.prepareStatement(QRY_GET_TASK_NAME);
                pStmt.setString(1, this.getName());
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    this.m_taskIdentifier = rs.getString(1);
                }
            }
            catch (SQLException sqlExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException exp1) {}
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException exp2) {}
            }
        }
        return this.m_taskIdentifier;
    }

    public String getModelName() {
        if (this.m_metricsPair != null) {
            return this.getValue(c_metric_model_name);
        }
        return null;
    }

    public String getTestDataName() {
        if (this.m_metricsPair != null) {
            return this.getValue(c_metric_test_data_name);
        }
        return null;
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
    }

    public NamedObject getObjectType() {
        return NamedObject.testMetrics;
    }

    public boolean isInputObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection retrieveObjectsFromDatabase(OraConnection dmeConn, java.util.Date createdAfter, java.util.Date createdBefore) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        String sqlSpec = "SELECT C.COMMENTS, T.TABLE_NAME from ALL_TABLES T, ALL_TAB_COMMENTS C WHERE C.TABLE_NAME = T.TABLE_NAME AND C.COMMENTS like '" + TM_COMMENTS_PREFIX + "%'";
        PreparedStatement ps = null;
        ResultSet rs = null;
        String description = null;
        String objectName = null;
        Vector<OraTestMetrics> returnedObjects = new Vector<OraTestMetrics>();
        try {
            ps = dbConn.prepareStatement(sqlSpec);
            rs = ps.executeQuery();
            while (rs.next()) {
                description = rs.getString("COMMENTS");
                objectName = rs.getString("TABLE_NAME");
                OraTestMetrics object = null;
                try {
                    object = OraTestMetrics.retrieveObjectFromDatabase(dmeConn, objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean addToList = false;
                if (object != null) {
                    if (createdAfter == null & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore == null) {
                        addToList = true;
                    } else if (createdAfter == null & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    } else if (createdAfter != null && object.getCreationDate().after(createdAfter) & createdBefore != null && object.getCreationDate().before(createdBefore)) {
                        addToList = true;
                    }
                }
                if (!addToList) continue;
                returnedObjects.add(object);
            }
        }
        catch (SQLException sqlExp) {
            dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{objectName}, sqlExp, "3509", null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {}
        }
        return returnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraTestMetrics retrieveObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        boolean bsExist = dmeConn.doesObjectExist(name, NamedObject.testMetrics);
        if (bsExist) {
            String sqlSpec = "SELECT * FROM " + name;
            PreparedStatement ps = null;
            ResultSet rs = null;
            HashMap<String, String> metricsPair = new HashMap<String, String>();
            try {
                ps = dbConn.prepareStatement(sqlSpec);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String metricName = rs.getString("METRIC_NAME");
                    String metricValue = rs.getString("METRIC_VARCHAR_VALUE");
                    String metricNumValue = rs.getString("METRIC_NUM_VALUE");
                    if (metricName != null & metricValue != null) {
                        metricsPair.put(metricName, metricValue);
                        continue;
                    }
                    if (!(metricName != null & metricNumValue != null)) continue;
                    metricsPair.put(metricName, metricNumValue);
                }
            }
            catch (SQLException sqlExp) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, "3509", null);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {}
            }
            OraTestMetrics bTestMetrics = null;
            String function = null;
            if (metricsPair != null) {
                function = (String)metricsPair.get(c_metric_mining_function);
            }
            if (MiningFunction.classification.name().equalsIgnoreCase(function)) {
                bTestMetrics = new OraClassificationTestMetrics(dmeConn, metricsPair);
            } else if (MiningFunction.regression.name().equalsIgnoreCase(function)) {
                bTestMetrics = new OraRegressionTestMetrics(dmeConn, metricsPair);
            }
            if (bTestMetrics != null) {
                bTestMetrics.m_metricsPair.putAll(metricsPair);
            }
            String sPpreparedName = null;
            sPpreparedName = name.startsWith("\"") && name.endsWith("\"") ? OraStringUtils.processQuotedName(name) : name.toUpperCase();
            sqlSpec = "SELECT O.CREATED, O.OWNER,  C.COMMENTS, O.OBJECT_NAME from ALL_OBJECTS O, ALL_TAB_COMMENTS C WHERE (O.OBJECT_TYPE='TABLE' OR O.OBJECT_TYPE='VIEW') AND C.TABLE_NAME = O.OBJECT_NAME AND O.OBJECT_NAME = '" + sPpreparedName + "'";
            ps = null;
            rs = null;
            Date creationDate = null;
            String creatorInfo = null;
            String description = null;
            String objectName = null;
            try {
                ps = dbConn.prepareStatement(sqlSpec);
                rs = ps.executeQuery();
                if (rs.next()) {
                    creationDate = rs.getDate("CREATED");
                    creatorInfo = rs.getString("OWNER");
                    description = rs.getString("COMMENTS");
                    objectName = rs.getString("OBJECT_NAME");
                }
            }
            catch (SQLException sqlExp) {
                dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT, new Object[]{name}, sqlExp, "3509", null);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e2) {}
            }
            if (bTestMetrics != null) {
                bTestMetrics.setCreationDate(creationDate);
                bTestMetrics.setCreatorInfo(creatorInfo);
                bTestMetrics.setDescription(description);
                bTestMetrics.setName(objectName);
            }
            return bTestMetrics;
        }
        dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{name}, null);
        return null;
    }

    public static OraTestMetrics retrieveObjectFromDatabaseByID(OraConnection dmeConn, String identifier) throws JDMException, SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObjectFromDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        Statement pStmt = null;
        Statement pStmt2 = null;
        Statement pStmt3 = null;
        Statement pStmt4 = null;
        try {
            OraTestMetrics testMetrics = (OraTestMetrics)dmeConn.retrieveObject(name, NamedObject.testMetrics);
            pStmt = dbConn.prepareStatement("DROP TABLE " + name);
            pStmt.execute();
            if (testMetrics.getValue(c_metric_mining_function).equalsIgnoreCase("CLASSIFICATION")) {
                if (testMetrics.getValue("CONFUSION_MATRIX_TABLE") != null) {
                    pStmt2 = dbConn.prepareStatement("DROP TABLE " + testMetrics.getValue("CONFUSION_MATRIX_TABLE"));
                    pStmt2.execute();
                }
                if (testMetrics.getValue("LIFT_TABLE") != null) {
                    pStmt3 = dbConn.prepareStatement("DROP TABLE " + testMetrics.getValue("LIFT_TABLE"));
                    pStmt3.execute();
                }
                if (testMetrics.getValue("ROC_TABLE") != null) {
                    pStmt4 = dbConn.prepareStatement("DROP TABLE " + testMetrics.getValue("ROC_TABLE"));
                    pStmt4.execute();
                }
            }
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception anyExp) {}
            }
            if (pStmt2 != null) {
                try {
                    pStmt2.close();
                }
                catch (Exception anyExp) {}
            }
            if (pStmt3 != null) {
                try {
                    pStmt3.close();
                }
                catch (Exception anyExp) {}
            }
            if (pStmt4 != null) {
                try {
                    pStmt4.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static void renameObjectInDatabase(OraConnection dmeConn, String oldName, String newName) throws JDMException, SQLException {
        if (dmeConn != null) {
            OraValidationHandler v = dmeConn.getValidationHandler();
            v.validateObjectName(oldName, "oldName", NamedObject.testMetrics);
            v.validateObjectName(newName, "newName", NamedObject.testMetrics);
            OraSQLUtils.renameTable(dmeConn.getDatabaseConnection(), oldName, newName);
        }
    }

    public static boolean doesObjectExistInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        java.sql.Connection dbConn = dmeConn.getDatabaseConnection();
        return OraSQLUtils.doesTableOrViewExists(dbConn, name);
    }

    static {
        TM_COMMENTS_PREFIX = c_metric_comments_prefix = "TM_";
    }
}

