/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.statistics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.data.AttributeType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.IntervalClosure;
import javax.datamining.data.ModelSignature;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.statistics.AttributeStatisticsSet;
import javax.datamining.statistics.AttributeStatisticsSetCapability;
import javax.datamining.statistics.UnivariateStatistics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.statistics.OraUnivariateStatistics;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class OraAttributeStatisticsSet
extends OraDMObject
implements AttributeStatisticsSet {
    private static String QRY_CLUSTER_HISTOGRAM_ATTRIBUTE = "SELECT          hg.bin_id                       hist_bin_id,         hg.lower_bound                  hist_lower_bound,         hg.upper_bound                  hist_upper_bound,         hg.label                        hist_label,         hg.count                        hist_frequency FROM (SELECT *  {0}   ,TABLE(a.histogram) hg   ORDER by hist_bin_id";
    private static String DECODE_VIEW = "WITH label_view as (   SELECT col, bin,    Decode(bin,'1','[','(') || lv || ',' || val || ']' label     FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val ";
    private static String ORDER_BY_ID = "ORDER BY id";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_KM = "WITH label_view as (  SELECT NVL2( att,  col || '''.''' || att, col ) col, shift, scale     FROM {0} ) SELECT  NVL2( hg.attribute_subname, hg.attribute_name || '''.''' || hg.attribute_subname, hg.attribute_name)    hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg LEFT OUTER JOIN label_view l  ON NVL2( hg.attribute_subname, hg.attribute_name || '''.''' || hg.attribute_subname, hg.attribute_name) = l.col  ORDER by hist_bin_id";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_KM_102 = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT  hg.attribute_name                hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col (+)   ORDER by hist_bin_id";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM = "    FROM {0} ) ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,   NVL((select label from label_view l where hg.bin_id=l.bin and   l.col=hg.attribute_name), hg.label ) hist_label,  hg.count                        hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.bin_id = l.bin order by hist_attribute_name, hist_bin_id ";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT = " WITH label_view as ( SELECT col, bin, val FROM {0} ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,  NVL((select val from label_view l where hg.bin_id=l.bin and l.col=hg.attribute_name), l.col) hist_label,  hg.count                        hist_frequency   FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.bin_id = l.bin order by hist_attribute_name, hist_bin_id ";
    private static final String hist_bin_id = "hist_bin_id";
    private static final String hist_lower_bound = "hist_lower_bound";
    private static final String hist_upper_bound = "hist_upper_bound";
    private static final String hist_label = "hist_label";
    private static final String hist_frequency = "hist_frequency";
    private OraTransformation m_buildTransform;
    private Hashtable m_attrStatisticsMap = new Hashtable();
    private ModelSignature m_modelSignature;
    private int m_clusterId;
    private String m_modelName;
    private OraClusteringModel m_model;
    private Hashtable m_numAttributeMap;
    private Hashtable m_catAttributeMap;

    public OraAttributeStatisticsSet(OraConnection dmeConn, OraClusteringModel model, ModelSignature modelSignature, int clusterId, OraTransformation buildTransform) {
        super(dmeConn, null);
        this.m_modelSignature = modelSignature;
        this.m_modelName = model.getName();
        this.m_clusterId = clusterId;
        this.m_buildTransform = buildTransform;
        this.m_model = model;
    }

    public void addAttributeStatistics(String attributeName, UnivariateStatistics statistics) {
        this.m_attrStatisticsMap.put(attributeName, statistics);
    }

    private boolean isCategoricallyBinned(Connection dbConn, String attributeName) {
        if (this.m_catAttributeMap != null) {
            return null != this.m_catAttributeMap.get(attributeName);
        }
        this.m_catAttributeMap = this.isBinned(dbConn, attributeName, false);
        if (this.m_catAttributeMap == null) {
            return false;
        }
        return null != this.m_catAttributeMap.get(attributeName);
    }

    private boolean isNumericallyBinned(Connection dbConn, String attributeName) {
        if (this.m_numAttributeMap != null) {
            return null != this.m_numAttributeMap.get(attributeName);
        }
        this.m_numAttributeMap = this.isBinned(dbConn, attributeName, true);
        if (this.m_numAttributeMap == null) {
            return false;
        }
        return null != this.m_numAttributeMap.get(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable isBinned(Connection dbConn, String attributeName, boolean bNumeric) {
        Hashtable<String, String> attributeMap = null;
        String sql = "SELECT distinct COL FROM " + this.getXformTableName(bNumeric);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName = rs.getString(1);
                if (attributeMap == null) {
                    attributeMap = new Hashtable<String, String>();
                }
                attributeMap.put(colName, colName);
            }
        }
        catch (Exception e) {
            this.logTrace("Failed Operation: OraAttributeStatisticsSet.isBinned: Cluster id" + this.m_clusterId, e);
            this.getConnection().createRuntimeException("2002", new Object[]{this.m_modelName}, null);
            if (attributeMap != null) {
                attributeMap.clear();
                attributeMap = null;
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (Exception e) {}
        }
        return attributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UnivariateStatistics getStatistics(String attributeName) throws JDMException {
        UnivariateStatistics uniStats = (UnivariateStatistics)this.m_attrStatisticsMap.get(attributeName);
        if (uniStats != null) {
            return uniStats;
        }
        Vector<HistogramPoint> vHistogram = new Vector<HistogramPoint>();
        Connection dbConn = this.getDatabaseConnection();
        SignatureAttribute sa = this.m_modelSignature.getAttribute(attributeName);
        AttributeType aType = sa.getAttributeType();
        boolean bDecoded = false;
        String histogramQuery = "";
        if (this.m_buildTransform != null) {
            if (this.m_buildTransform instanceof OraNormalizeTransform) {
                Double scale = ((OraNormalizeTransformImpl)this.m_buildTransform).getScale(attributeName);
                histogramQuery = scale != null && scale != 0.0 ? this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true) : this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID);
            } else {
                if (!(this.m_buildTransform instanceof OraBinningTransform)) throw new JDMException();
                if (this.isNumericallyBinned(dbConn, attributeName)) {
                    histogramQuery = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true);
                    bDecoded = true;
                } else if (this.isCategoricallyBinned(dbConn, attributeName)) {
                    histogramQuery = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, false);
                    bDecoded = true;
                } else {
                    histogramQuery = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID);
                }
            }
        } else {
            histogramQuery = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID);
        }
        Statement pStmt = null;
        ResultSet rs = null;
        int ind = 1;
        try {
            OraDataURI attrURI = new OraDataURI(attributeName);
            String attrSubName = null;
            String attributeName2 = null;
            if (attrURI.getSchemaName() != null) {
                attributeName2 = attrURI.getSchemaName();
                attrSubName = attrURI.getTableName();
            } else {
                attributeName2 = attributeName;
            }
            pStmt = dbConn.prepareStatement(histogramQuery);
            pStmt.setString(ind++, this.m_modelName);
            pStmt.setInt(ind++, this.m_clusterId);
            pStmt.setString(ind++, attributeName2);
            pStmt.setInt(ind++, 0);
            pStmt.setInt(ind++, 1);
            pStmt.setInt(ind++, 0);
            MiningAlgorithm ma = this.m_model.getMiningAlgorithm();
            if (ma.equals((Object)MiningAlgorithm.kMeans) && !this.is102()) {
                if (attrSubName == null) {
                    pStmt.setNull(ind++, 12);
                } else {
                    pStmt.setString(ind++, attrSubName);
                }
            }
            rs = pStmt.executeQuery();
            while (rs.next()) {
                int binId = rs.getInt(hist_bin_id);
                double dValLow = rs.getDouble(hist_lower_bound);
                Double dLowerBound = rs.wasNull() ? null : new Double(dValLow);
                double dValUpr = rs.getDouble(hist_upper_bound);
                Double dUpperBound = rs.wasNull() ? null : new Double(dValUpr);
                String label = rs.getString(hist_label);
                double frequency = rs.getDouble(hist_frequency);
                HistogramPoint htPoint = new HistogramPoint(binId, dLowerBound, dUpperBound, label, frequency);
                vHistogram.add(htPoint);
            }
            if (vHistogram.isEmpty()) {
                UnivariateStatistics binId = uniStats;
                return binId;
            }
            int histSize = vHistogram.size();
            double[] frequencies = new double[histSize];
            if (aType.equals((Object)AttributeType.numerical) && !bDecoded) {
                OraInterval[] intervals = new OraInterval[histSize];
                for (int bin = 0; bin < histSize; ++bin) {
                    HistogramPoint hpoint = (HistogramPoint)vHistogram.elementAt(bin);
                    intervals[bin] = new OraInterval(this.getConnection(), hpoint.dLowerBound != null ? hpoint.dLowerBound : 0.0, hpoint.dUpperBound != null ? hpoint.dUpperBound : 0.0, IntervalClosure.closedClosed);
                    frequencies[bin] = hpoint.value;
                }
                uniStats = new OraUnivariateStatistics(this.getConnection(), attributeName, sa, intervals, frequencies, bDecoded);
            } else {
                OraCategorySet catSet = new OraCategorySet(this.getConnection(), sa.getDataType());
                for (int bin = 0; bin < histSize; ++bin) {
                    HistogramPoint hpoint = (HistogramPoint)vHistogram.elementAt(bin);
                    catSet.addCategory(hpoint.label, CategoryProperty.valid);
                    frequencies[bin] = hpoint.value;
                }
                uniStats = new OraUnivariateStatistics(this.getConnection(), attributeName, sa, catSet, frequencies, bDecoded);
            }
            if (uniStats == null) return uniStats;
            this.addAttributeStatistics(attributeName, uniStats);
            return uniStats;
        }
        catch (SQLException sqlExp) {
            this.logTrace("Failed Operation: OraAttributeStatisticsSet.getStatistics: Cluster id" + this.m_clusterId, sqlExp);
            this.getConnection().createRuntimeException("2002", new Object[]{this.m_modelName}, sqlExp);
            return uniStats;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public Collection getStatistics() throws JDMException {
        Vector v = new Vector();
        Enumeration en = this.m_attrStatisticsMap.elements();
        while (en.hasMoreElements()) {
            v.add(en.nextElement());
        }
        return v;
    }

    public long getNumberOfCases() {
        return 0L;
    }

    private String getXformTableName(boolean bNumeric) {
        if (!(this.m_buildTransform instanceof OraBinningTransform)) {
            return "";
        }
        return bNumeric ? ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable() : ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getHistogramQueryDecode(String query, String orderBy, boolean bNumeric) {
        String resultquery = null;
        MiningAlgorithm ma = this.m_model.getMiningAlgorithm();
        if (!ma.equals((Object)MiningAlgorithm.kMeans)) return (bNumeric ? DECODE_VIEW : "") + MessageFormat.format(bNumeric ? QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM : QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT, this.getXformTableName(bNumeric));
        if (!this.isEucledian()) return this.m_model.getQuery(query, orderBy);
        if (!this.is102()) return MessageFormat.format(QRY_DECODE_CLUSTER_HISTOGRAM_KM, this.getNormTableName());
        return MessageFormat.format(QRY_DECODE_CLUSTER_HISTOGRAM_KM_102, this.getNormTableName());
    }

    private boolean isEucledian() {
        OraKMeansSettings kmSettings;
        ClusteringDistanceFunction dFunction = null;
        ClusteringSettings buildSettings = (ClusteringSettings)this.m_model.getBuildSettings();
        AlgorithmSettings algSettings = buildSettings.getAlgorithmSettings();
        return algSettings instanceof OraKMeansSettings && (dFunction = (kmSettings = (OraKMeansSettings)algSettings).getDistanceFunction()).equals((Object)ClusteringDistanceFunction.euclidean);
    }

    private String getNormTableName() {
        if (this.m_buildTransform instanceof OraNormalizeTransform) {
            return ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable();
        }
        return "";
    }

    public boolean supportsCapabiltiy(AttributeStatisticsSetCapability capability) throws JDMException {
        return true;
    }

    public Date getStatisticsTimestamp() {
        return null;
    }

    class HistogramPoint {
        int binId;
        Double dLowerBound;
        Double dUpperBound;
        String label;
        double value;

        HistogramPoint(int binId, Double dLowerBound, Double dUpperBound, String label, double value) {
            this.binId = binId;
            this.dLowerBound = dLowerBound;
            this.dUpperBound = dUpperBound;
            this.label = label;
            this.value = value;
        }
    }
}

