/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.scheduler;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.jdm.scheduler.OraJob;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;

public class OraProgramJob
extends OraJob {
    private String m_programName = null;
    private String m_repeatInterval = null;
    private Timestamp m_startDate = null;
    private Timestamp m_endDate = null;
    private String m_jobClass = null;
    private Boolean m_enabled = new Boolean(false);
    private Boolean m_autoDrop = new Boolean(false);
    private Vector m_jobArgs = new Vector(25);
    protected static final String CS_SET_JOB_ARGUMENT_VALUE = "DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE";
    protected static final String QRY_GET_JOB_ARGS = "SELECT ARGUMENT_POSITION, ARGUMENT_NAME, VALUE FROM USER_SCHEDULER_JOB_ARGS WHERE JOB_NAME=? ORDER BY ARGUMENT_POSITION DESC";
    protected static final String QRY_GET_JOB_NUMBER_ARGS = "SELECT ARGUMENT_POSITION, ARGUMENT_NAME, ANYDATA.ACCESSNUMBER(anydata_value)  FROM USER_SCHEDULER_JOB_ARGS WHERE JOB_NAME=? and ARGUMENT_TYPE='NUMBER'  ORDER BY ARGUMENT_POSITION DESC";

    public OraProgramJob() {
    }

    public OraProgramJob(String jobName, String programName, String jobComments) {
        super(jobName, jobComments);
        this.m_programName = programName;
    }

    public OraProgramJob(String jobName, String programName, String jobComments, Vector jobArgs) {
        super(jobName, jobComments);
        this.m_programName = programName;
        this.m_jobArgs = jobArgs;
    }

    public void addArgument(String argName, Object argValue, int argSQLType) {
        this.m_jobArgs.add(new Object[]{argName, argValue, new Integer(argSQLType)});
    }

    public void addArgument(int argPosition, String argName, Object argValue, int argSQLType) {
        this.m_jobArgs.set(argPosition - 1, new Object[]{argName, argValue, new Integer(argSQLType)});
    }

    public void setProgramName(String programName) {
        this.m_programName = programName;
    }

    public String getProgramName() {
        if (this.m_programName == null && this.m_jobInfo != null) {
            this.m_programName = this.m_jobInfo.getProgramName();
        }
        return this.m_programName;
    }

    protected void createJob(Connection dbConn) throws SQLException {
        String[] paramNames = new String[]{"job_name", "program_name", "comments"};
        Object[] paramValues = new Object[]{this.getName(), this.m_programName, this.getComments()};
        int[] sqlTypes = new int[]{12, 12, 12};
        String hardCodedParams = "auto_drop=>" + this.m_autoDrop;
        OraSQLUtils.executeCallableStatement(dbConn, "DBMS_SCHEDULER.CREATE_JOB", paramNames, paramValues, sqlTypes, null, hardCodedParams, this.m_logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJob(Connection dbConn) throws SQLException {
        super.saveJob(dbConn);
        int size = this.m_jobArgs.size();
        for (int i = 0; i < size; ++i) {
            long endTime;
            long startTime;
            CallableStatement cStmt;
            StringBuffer sqlQuery;
            Object[] args = (Object[])this.m_jobArgs.get(i);
            String[] paramNames = new String[]{"job_name", "argument_name", "argument_value"};
            Object[] paramValues = new Object[]{this.getName(), args[0], args[1]};
            int argVal_sqlType = (Integer)args[2];
            if (args[1] == null && 12 == argVal_sqlType) {
                sqlQuery = new StringBuffer("{ call DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE(?,?, null) }");
                cStmt = null;
                try {
                    cStmt = dbConn.prepareCall(sqlQuery.toString());
                    cStmt.setString(1, this.getName());
                    cStmt.setString(2, (String)args[0]);
                    startTime = System.currentTimeMillis();
                    cStmt.execute();
                    endTime = System.currentTimeMillis();
                    continue;
                }
                finally {
                    if (cStmt != null) {
                        cStmt.close();
                    }
                }
            }
            if (12 == argVal_sqlType) {
                int[] sqlTypes = new int[]{12, 12, 12};
                OraSQLUtils.executeCallableStatement(dbConn, CS_SET_JOB_ARGUMENT_VALUE, paramNames, paramValues, sqlTypes, null, this.m_logger);
                continue;
            }
            if (args[1] == null) continue;
            sqlQuery = new StringBuffer("{ call DBMS_SCHEDULER.SET_JOB_ANYDATA_VALUE(?,?, ANYDATA.");
            cStmt = null;
            try {
                switch (argVal_sqlType) {
                    case 2003: {
                        sqlQuery.append("convertcollection(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        OracleCallableStatement ocstmt = (OracleCallableStatement)cStmt;
                        ocstmt.setString(1, this.getName());
                        ocstmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            ocstmt.setNull(3, 2003);
                            break;
                        }
                        ocstmt.setARRAY(3, (ARRAY)args[1]);
                        break;
                    }
                    case -5: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, -5);
                            break;
                        }
                        cStmt.setBigDecimal(3, (BigDecimal)args[1]);
                        break;
                    }
                    case 2004: {
                        sqlQuery.append("ConvertBlob(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 2004);
                            break;
                        }
                        cStmt.setBlob(3, (Blob)args[1]);
                        break;
                    }
                    case 2005: {
                        sqlQuery.append("ConvertClob(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 2005);
                            break;
                        }
                        cStmt.setClob(3, (Clob)args[1]);
                        break;
                    }
                    case 93: {
                        sqlQuery.append("ConvertTimestamp(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 93);
                            break;
                        }
                        cStmt.setTimestamp(3, (Timestamp)args[1]);
                        break;
                    }
                    case 3: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 3);
                            break;
                        }
                        cStmt.setBigDecimal(3, (BigDecimal)args[1]);
                        break;
                    }
                    case 8: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 8);
                            break;
                        }
                        cStmt.setBigDecimal(3, new BigDecimal(((Number)args[1]).doubleValue()));
                        break;
                    }
                    case 6: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 6);
                            break;
                        }
                        cStmt.setBigDecimal(3, new BigDecimal(((Number)args[1]).floatValue()));
                        break;
                    }
                    case 4: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 4);
                            break;
                        }
                        cStmt.setBigDecimal(3, new BigDecimal(((Number)args[1]).intValue()));
                        break;
                    }
                    case 2: {
                        sqlQuery.append("ConvertNumber(?)) }");
                        cStmt = dbConn.prepareCall(sqlQuery.toString());
                        cStmt.setString(1, this.getName());
                        cStmt.setString(2, (String)args[0]);
                        if (args[1] == null) {
                            cStmt.setNull(3, 2);
                            break;
                        }
                        cStmt.setBigDecimal(3, new BigDecimal(((Number)args[1]).doubleValue()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal Error: OraProgramJob.saveJob does n't support SQL TYPE: sqlTypes[iParam]." + argVal_sqlType);
                    }
                }
                startTime = System.currentTimeMillis();
                cStmt.execute();
                endTime = System.currentTimeMillis();
                if (this.m_logger == null) continue;
                this.m_logger.finest("Execution duration: " + (endTime - startTime) / 1000L + " seconds");
                continue;
            }
            finally {
                if (cStmt != null) {
                    cStmt.close();
                }
            }
        }
    }

    public void saveJob(Connection dbConn, String jobName) throws SQLException {
        this.setName(jobName);
        this.saveJob(dbConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraProgramJob retrieve(Connection dbConn, String jobName, Logger logger) throws SQLException {
        if (OraJob.doesJobInDatabase(dbConn, jobName, logger)) {
            OraProgramJob job = new OraProgramJob();
            job.setName(jobName);
            job.getJobInfo(dbConn);
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                String trimmedJobName = OraStringUtils.trimDoubleQuotes(jobName);
                pStmt = dbConn.prepareStatement(QRY_GET_JOB_ARGS);
                pStmt.setString(1, trimmedJobName);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    int maxArgPositionInThisJob = rs.getInt(1);
                    for (int i = 0; i < maxArgPositionInThisJob; ++i) {
                        job.m_jobArgs.add(null);
                    }
                    do {
                        job.addArgument(rs.getInt(1), rs.getString(2), rs.getObject(3), 1);
                    } while (rs.next());
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sqlExp) {}
            }
            PreparedStatement num_pStmt = null;
            ResultSet num_rs = null;
            try {
                String trimmedJobName = OraStringUtils.trimDoubleQuotes(jobName);
                num_pStmt = dbConn.prepareStatement(QRY_GET_JOB_NUMBER_ARGS);
                num_pStmt.setString(1, trimmedJobName);
                num_rs = num_pStmt.executeQuery();
                while (num_rs.next()) {
                    job.addArgument(num_rs.getInt(1), num_rs.getString(2), num_rs.getObject(3), 1);
                }
            }
            finally {
                try {
                    if (num_rs != null) {
                        num_rs.close();
                    }
                }
                catch (SQLException sqlExp) {}
                try {
                    if (num_pStmt != null) {
                        num_pStmt.close();
                    }
                }
                catch (SQLException sqlExp) {}
            }
            return job;
        }
        return null;
    }

    public Vector getJobArguments() {
        return this.m_jobArgs;
    }

    public void setAutoDrop(boolean autoDrop) {
        this.m_autoDrop = new Boolean(autoDrop);
    }
}

